/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.accessDriver.points;

import com.tridium.nrio.points.BNrioPointDeviceExt;
import com.tridiumx.accessDriver.AccessBacnetUtil;
import com.tridiumx.accessDriver.AccessDeviceUtil;
import com.tridiumx.accessDriver.BAccessAlarmSourceExt;
import com.tridiumx.accessDriver.BAccessDoor;
import com.tridiumx.accessDriver.BAccessElevator;
import com.tridiumx.accessDriver.BAccessNetwork;
import com.tridiumx.accessDriver.BAccessReader;
import com.tridiumx.accessDriver.BAccessSdi;
import com.tridiumx.accessDriver.BIAccessDevice;
import com.tridiumx.accessDriver.BOffAlarmClass;
import com.tridiumx.accessDriver.enums.BSecurityAlgorithmEnum;
import com.tridiumx.accessDriver.points.BAccessIOPoints;
import com.tridiumx.accessDriver.points.BAccessProxyExt;
import com.tridiumx.accessDriver.points.BIAccessPointDeviceExt;
import java.util.logging.Logger;
import javax.baja.alarm.BAlarmTransitionBits;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.driver.point.BPointDeviceExt;
import javax.baja.driver.point.BProxyConversion;
import javax.baja.driver.point.conv.BReversePolarityConversion;
import javax.baja.license.Feature;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BNameMap;
import javax.baja.util.Lexicon;

public abstract class AccessPointDeviceExtUtil {
    public static void added(BNrioPointDeviceExt ext, Property property, Context context) {
        BValue val = ext.get(property);
        if (val instanceof BAccessDoor) {
            ((BAccessDoor)val).init((BIAccessDevice)ext.getParent(), (BIAccessPointDeviceExt)ext);
        }
    }

    public static void renamed(BComponent parent, Property property, String oldName, Context context) {
        BValue val = parent.get(property);
        if (val instanceof BComponent) {
            AccessBacnetUtil.updateDisplayNameForBacnet((BComponent)val, oldName);
        }
    }

    public static void checkAdd(BNrioPointDeviceExt ext, String name, BValue value, int flags, BFacets facets, Context context) {
        if (!ext.isRunning()) {
            return;
        }
        if (value instanceof BAccessReader) {
            Feature accessControl;
            String readerLimit;
            BAccessReader reader = (BAccessReader)value;
            if (reader.isPendingMove() && reader.isMounted() && reader.getNrioDeviceExt() == ext) {
                return;
            }
            if (!reader.setAvailableInstance((BPointDeviceExt)ext)) {
                String message = BAccessNetwork.lex.getText("only2ReadersPerModuleAllowed");
                if (ext instanceof BAccessIOPoints) {
                    message = BAccessNetwork.lex.getText("readersOnlyAllowedUnderReaderModules");
                }
                if (context == Context.decoding) {
                    Logger.getLogger("AccessNetwork").warning(message);
                } else {
                    throw new LocalizableRuntimeException("accessDriver", message);
                }
            }
            if ((readerLimit = (accessControl = Sys.getLicenseManager().getFeature("tridium", "accessControl")).get("reader.limit")) == null) {
                if (context == Context.decoding) {
                    Logger.getLogger("AccessNetwork").warning("Readers are not licensed");
                } else {
                    throw new LocalizableRuntimeException("accessDriver", "Readers are not licensed");
                }
            }
            BAccessNetwork network = (BAccessNetwork)Sys.getService((Type)BAccessNetwork.TYPE);
            int currentReaders = (Integer)network.fw(503, "reader.limit", null, null, null);
            if (!readerLimit.equals("none") && currentReaders >= Integer.parseInt(readerLimit)) {
                if (context == Context.decoding) {
                    Logger.getLogger("AccessNetwork").warning("Reader limit (" + readerLimit + ") exceeded");
                } else {
                    throw new LocalizableRuntimeException("accessDriver", "Reader limit (" + readerLimit + ") exceeded");
                }
            }
        }
        if (value instanceof BAccessElevator) {
            Feature accessControl = Sys.getLicenseManager().getFeature("tridium", "accessControl");
            String elevatorLimit = accessControl.get("elevator.limit");
            if (elevatorLimit == null) {
                if (context == Context.decoding) {
                    Logger.getLogger("AccessNetwork").warning("Elevators are not licensed");
                } else {
                    throw new LocalizableRuntimeException("accessDriver", "Elevators are not licensed");
                }
            }
            BAccessNetwork network = (BAccessNetwork)Sys.getService((Type)BAccessNetwork.TYPE);
            int currentElevators = (Integer)network.fw(503, "elevator.limit", null, null, null);
            if (!elevatorLimit.equals("none") && currentElevators >= Integer.parseInt(elevatorLimit)) {
                if (context == Context.decoding) {
                    Logger.getLogger("AccessNetwork").warning("Elevator limit (" + elevatorLimit + ") exceeded");
                } else {
                    throw new LocalizableRuntimeException("accessDriver", "Elevator limit (" + elevatorLimit + ") exceeded");
                }
            }
        }
    }

    public static void checkRemove(BNrioPointDeviceExt ext, Property property, Context cx) {
        if (!ext.isRunning()) {
            return;
        }
        BValue oldValue = ext.get(property);
        if (oldValue instanceof BComponent) {
            String oldName = ext.getParent().getDisplayName(cx) + "." + property.getDefaultDisplayName(cx);
            AccessBacnetUtil.removeBacnetPoints(oldName);
        }
    }

    public static void removed(BNrioPointDeviceExt ext, Property property, BValue oldValue, Context cx) {
        if (oldValue instanceof BAccessDoor) {
            AccessDeviceUtil.fixGeneralUsePoints(ext.getNrioDevice());
        }
    }

    public static void initBooleanProxyExt(BBooleanPoint point, int instance, boolean isStrike, boolean isSdi, String trueText, String falseText, boolean isReverse, boolean addAlarm, boolean alarmState, boolean isEnabledOnDefault, String sourceName) {
        BAccessNetwork network = (BAccessNetwork)Sys.getService((Type)BAccessNetwork.TYPE);
        if (!(point.getProxyExt() instanceof BAccessProxyExt)) {
            BAccessProxyExt proxy = new BAccessProxyExt();
            proxy.setInstance(instance);
            proxy.setIsStrike(isStrike);
            proxy.setIsSdi(isSdi);
            proxy.setReadValue((BStatusValue)new BStatusBoolean());
            proxy.setWriteValue((BStatusValue)new BStatusBoolean());
            if (isReverse) {
                proxy.setConversion((BProxyConversion)BReversePolarityConversion.DEFAULT);
            }
            if (!isEnabledOnDefault) {
                proxy.setEnabled(false);
            }
            point.setProxyExt((BAbstractProxyExt)proxy);
            point.setFacets(BFacets.makeBoolean((String)trueText, (String)falseText));
        }
        BAccessAlarmSourceExt alarmExt = null;
        BAccessAlarmSourceExt faultExt = null;
        BAccessAlarmSourceExt doorHeldExt = null;
        BAccessAlarmSourceExt intrusionTimeoutExt = null;
        boolean isDoorSdi = point instanceof BAccessSdi;
        BAlarmSourceExt[] exts = (BAlarmSourceExt[])point.getChildren(BAlarmSourceExt.class);
        for (int i = 0; i < exts.length; ++i) {
            if (exts[i] instanceof BAccessAlarmSourceExt) {
                BAccessAlarmSourceExt ext = (BAccessAlarmSourceExt)exts[i];
                if (ext.getSecurityAlgorithm() == BSecurityAlgorithmEnum.supervisionFault && isSdi) {
                    faultExt = ext;
                    continue;
                }
                if (ext.getSecurityAlgorithm() == BSecurityAlgorithmEnum.normal && !isDoorSdi) {
                    alarmExt = ext;
                    continue;
                }
                if (ext.getSecurityAlgorithm() == BSecurityAlgorithmEnum.doorForced && isDoorSdi) {
                    alarmExt = ext;
                    continue;
                }
                if (ext.getSecurityAlgorithm() == BSecurityAlgorithmEnum.doorHeldOpen && isDoorSdi) {
                    doorHeldExt = ext;
                    continue;
                }
                if (ext.getSecurityAlgorithm() != BSecurityAlgorithmEnum.intrusionTimeout || !isDoorSdi) continue;
                intrusionTimeoutExt = ext;
                continue;
            }
            point.remove(exts[i].getName());
        }
        if (addAlarm) {
            if (alarmExt == null && !isDoorSdi) {
                alarmExt = new BAccessAlarmSourceExt();
                point.add("Alarm$20Settings?", (BValue)alarmExt);
                network.setSourceName((BComponent)alarmExt);
            }
            if (alarmExt == null && isDoorSdi) {
                alarmExt = new BAccessAlarmSourceExt();
                alarmExt.setSecurityAlgorithm(BSecurityAlgorithmEnum.doorForced);
                point.add("DoorForcedExt?", (BValue)alarmExt);
                network.setSourceName((BComponent)alarmExt);
            }
            if (doorHeldExt == null && isDoorSdi) {
                doorHeldExt = new BAccessAlarmSourceExt();
                doorHeldExt.setSecurityAlgorithm(BSecurityAlgorithmEnum.doorHeldOpen);
                point.add("DoorHeldOpenExt?", (BValue)doorHeldExt);
                doorHeldExt.setAlarmEnable(BAlarmTransitionBits.toNormal);
                network.setSourceName((BComponent)doorHeldExt);
            }
            if (intrusionTimeoutExt == null && isDoorSdi) {
                intrusionTimeoutExt = new BAccessAlarmSourceExt();
                intrusionTimeoutExt.setAlarmClass(BOffAlarmClass.getAlarmClassName());
                intrusionTimeoutExt.setSecurityAlgorithm(BSecurityAlgorithmEnum.intrusionTimeout);
                point.add("IntrusionTimeoutExt?", (BValue)intrusionTimeoutExt);
                network.setSourceName((BComponent)intrusionTimeoutExt);
            }
        }
        if (faultExt == null && isSdi) {
            faultExt = new BAccessAlarmSourceExt();
            faultExt.setSecurityAlgorithm(BSecurityAlgorithmEnum.supervisionFault);
            point.add("Supervisor$20Fault$20Settings?", (BValue)faultExt);
            network.setSourceName((BComponent)faultExt);
        }
    }

    public static void hideActions(BBooleanWritable writable) {
        writable.setFlags((Slot)BBooleanWritable.emergencyActive, writable.getFlags((Slot)BBooleanWritable.emergencyActive) | 4);
        writable.setFlags((Slot)BBooleanWritable.emergencyInactive, writable.getFlags((Slot)BBooleanWritable.emergencyInactive) | 4);
        writable.setFlags((Slot)BBooleanWritable.emergencyAuto, writable.getFlags((Slot)BBooleanWritable.emergencyAuto) | 4);
        writable.setFlags((Slot)BBooleanWritable.set, writable.getFlags((Slot)BBooleanWritable.set) | 4);
        writable.setFlags((Slot)BBooleanWritable.in15, writable.getFlags((Slot)BBooleanWritable.in15) | 0x400);
        BComponent parent = (BComponent)writable.getParent();
        BNameMap nameMap = BNameMap.NULL;
        BValue displayNames = writable.get("displayNames");
        Lexicon lex = BAccessNetwork.lex;
        if (displayNames != null && displayNames instanceof BNameMap) {
            nameMap = (BNameMap)displayNames;
            writable.set("displayNames", (BValue)BNameMap.make((BNameMap)nameMap, (String)"inactive", (String)lex.getText("ro.text.inactive")));
            nameMap = (BNameMap)writable.get("displayNames");
            writable.set("displayNames", (BValue)BNameMap.make((BNameMap)nameMap, (String)"active", (String)lex.getText("ro.text.active")));
        } else {
            writable.add("displayNames", (BValue)BNameMap.make((BNameMap)nameMap, (String)"inactive", (String)lex.getText("ro.text.inactive")));
            nameMap = (BNameMap)writable.get("displayNames");
            writable.set("displayNames", (BValue)BNameMap.make((BNameMap)nameMap, (String)"active", (String)lex.getText("ro.text.active")));
        }
        writable.getFallback().setValue(false);
        writable.getFallback().setStatusNull(false);
    }
}

