/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.accessDriver;

import com.tridiumx.accessDriver.BOffAlarmClass;
import com.tridiumx.accessDriver.BSecAlarmSourceInfo;
import com.tridiumx.accessDriver.enums.activity.BActivity;
import com.tridiumx.accessDriver.enums.activity.BIntrusionStatusEnum;
import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmSourceInfo;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.BUuid;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="activityType", type="BActivity", defaultValue="BIntrusionStatusEnum.unableToArm", flags=1), @NiagaraProperty(name="alarmInfo", type="BAlarmSourceInfo", defaultValue="initAlarmSourceInfo()"), @NiagaraProperty(name="enableLogging", type="boolean", defaultValue="true")})
@NiagaraAction(name="ackAlarm", parameterType="BAlarmRecord", defaultValue="new BAlarmRecord()", returnType="BBoolean", flags=4)
public class BActivityAlertExt
extends BComponent
implements BIAlarmSource {
    public static final BFormat OLD_SOURCE_NAME = BFormat.make((String)"%parent.parent.parent.parent.displayName%.%parent.parent.displayName%");
    public static final BFormat SOURCE_NAME = BFormat.make((String)"%deviceDisplayName%.%parent.parent.displayName%");
    public static final Property activityType = BActivityAlertExt.newProperty((int)1, (BValue)BIntrusionStatusEnum.unableToArm, null);
    public static final Property alarmInfo = BActivityAlertExt.newProperty((int)0, (BValue)BActivityAlertExt.initAlarmSourceInfo(), null);
    public static final Property enableLogging = BActivityAlertExt.newProperty((int)0, (boolean)true, null);
    public static final Action ackAlarm = BActivityAlertExt.newAction((int)4, (BValue)new BAlarmRecord(), null);
    public static final Type TYPE = Sys.loadType(BActivityAlertExt.class);
    private AlarmSupport support;
    static final Lexicon lex = Lexicon.make(BActivityAlertExt.class);
    public static final String PERSON = "person";
    private static final String BADGE = "badge";
    private static final String OWNER = "owner";
    public static String[] cols = new String[]{"badge", "msgText", "fw_BAlarmRecord_user"};
    public static String[] colsWithPersonId = new String[]{"badge", "msgText", "fw_BAlarmRecord_user", "person"};
    public static String[] basicCols = new String[]{"msgText"};

    public BActivity getActivityType() {
        return (BActivity)this.get(activityType);
    }

    public void setActivityType(BActivity v) {
        this.set(activityType, (BValue)v, null);
    }

    public BAlarmSourceInfo getAlarmInfo() {
        return (BAlarmSourceInfo)this.get(alarmInfo);
    }

    public void setAlarmInfo(BAlarmSourceInfo v) {
        this.set(alarmInfo, (BValue)v, null);
    }

    public boolean getEnableLogging() {
        return this.getBoolean(enableLogging);
    }

    public void setEnableLogging(boolean v) {
        this.setBoolean(enableLogging, v, null);
    }

    public BBoolean ackAlarm(BAlarmRecord parameter) {
        return (BBoolean)this.invoke(ackAlarm, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BActivityAlertExt() {
    }

    public BActivityAlertExt(BActivity activityType) {
        this(activityType, true);
    }

    public BActivityAlertExt(BActivity activityType, boolean displayLogging) {
        this(activityType, null, displayLogging);
    }

    public BActivityAlertExt(BActivity activityType, BSecAlarmSourceInfo info) {
        this(activityType, info, true);
    }

    public BActivityAlertExt(BActivity activityType, BSecAlarmSourceInfo info, boolean displayLogging) {
        this.setActivityType(activityType);
        if (info != null) {
            this.setAlarmInfo(info);
        }
        if (!displayLogging) {
            this.setFlags((Slot)enableLogging, this.getFlags((Slot)enableLogging) | 4);
        }
    }

    public void started() {
        if (!(this.getAlarmInfo() instanceof BSecAlarmSourceInfo)) {
            this.setAlarmInfo(BSecAlarmSourceInfo.make(this.getAlarmInfo()));
        }
        this.support = new AlarmSupport((BIAlarmSource)this, this.getAlarmInfo());
    }

    public String getDisplayName(Slot slot, Context cx) {
        if (slot.equals((Object)alarmInfo)) {
            return this.getDisplayName(cx);
        }
        return super.getDisplayName(slot, cx);
    }

    public boolean generateAlert(String badge, String owner, String activityInfo, BUuid personId) throws Exception {
        if (this.getAlarmInfo() != null && this.getAlarmInfo().getAlarmClass().equals(BOffAlarmClass.getAlarmClassName())) {
            return false;
        }
        String activity = this.getActivityType().toString();
        if (activityInfo != null && activityInfo.length() > 0) {
            activity = activity + ": " + activityInfo;
        }
        BFacets facets = BFacets.DEFAULT;
        facets = personId == null || personId.equals((Object)BUuid.DEFAULT) ? BFacets.make((String[])cols, (BIDataValue[])new BString[]{BString.make((String)badge), BString.make((String)activity), BString.make((String)owner)}) : BFacets.make((String[])colsWithPersonId, (BIDataValue[])new BString[]{BString.make((String)badge), BString.make((String)activity), BString.make((String)owner), BString.make((String)personId.encodeToString())});
        this.support.newAlert(facets);
        return true;
    }

    public boolean generateAlert(String activityInfo) throws Exception {
        if (this.getAlarmInfo() != null && this.getAlarmInfo().getAlarmClass().equals(BOffAlarmClass.getAlarmClassName())) {
            return false;
        }
        String activity = this.getActivityType().toString();
        if (activityInfo != null && activityInfo.length() > 0) {
            activity = activity + ": " + activityInfo;
        }
        BString[] data = new BString[]{BString.make((String)activity)};
        this.support.newAlert(BFacets.make((String[])basicCols, (BIDataValue[])data));
        return true;
    }

    public BBoolean doAckAlarm(BAlarmRecord ackRequest) throws Exception {
        return BBoolean.make((boolean)this.support.ackAlarm(ackRequest));
    }

    static BSecAlarmSourceInfo initAlarmSourceInfo() {
        BSecAlarmSourceInfo asi = new BSecAlarmSourceInfo();
        asi.setFlags((Slot)BAlarmSourceInfo.toFaultText, 4);
        asi.setFlags((Slot)BAlarmSourceInfo.toOffnormalText, 4);
        asi.setFlags((Slot)BAlarmSourceInfo.toNormalText, 4);
        asi.setSourceName(SOURCE_NAME);
        return asi;
    }
}

