/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.accessDriver;

import com.tridium.entsecDriver.BIAccessReader;
import com.tridium.nrio.messages.NrioMessageConst;
import com.tridium.nrio.points.BNrioPointDeviceExt;
import com.tridiumx.accessDriver.BAccessAuxOutput;
import com.tridiumx.accessDriver.BAccessDoor;
import com.tridiumx.accessDriver.BAccessElevator;
import com.tridiumx.accessDriver.BAccessNetwork;
import com.tridiumx.accessDriver.BAccessStrike;
import com.tridiumx.accessDriver.BActivityAlertExt;
import com.tridiumx.accessDriver.BDoorController;
import com.tridiumx.accessDriver.BIAccessDevice;
import com.tridiumx.accessDriver.BIAccessDriverService;
import com.tridiumx.accessDriver.BIAlarmSourceController;
import com.tridiumx.accessDriver.BIIntrusionStatusInterest;
import com.tridiumx.accessDriver.BIIntrusionValidationService;
import com.tridiumx.accessDriver.BValidationInfo;
import com.tridiumx.accessDriver.BVirtualSwipe;
import com.tridiumx.accessDriver.ValidationInvocation;
import com.tridiumx.accessDriver.components.BBadgeReaderConfig;
import com.tridiumx.accessDriver.components.BReaderOutputConfig;
import com.tridiumx.accessDriver.enums.BReaderOutputEnum;
import com.tridiumx.accessDriver.enums.BReaderTypeEnum;
import com.tridiumx.accessDriver.enums.BValidationResult;
import com.tridiumx.accessDriver.enums.activity.BBadgeActivity;
import com.tridiumx.accessDriver.enums.activity.BIntrusionStatusEnum;
import com.tridiumx.accessDriver.enums.activity.BTimeAttendEnum;
import com.tridiumx.accessDriver.messages.ReaderIOStatus;
import com.tridiumx.accessDriver.points.AccessPointDeviceExtUtil;
import com.tridiumx.accessDriver.points.BAccess2ReaderPoints;
import com.tridiumx.accessDriver.points.BAccessProxyExt;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmSourceInfo;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BControlPoint;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.driver.point.BIPointFolder;
import javax.baja.driver.point.BPointDeviceExt;
import javax.baja.driver.point.BProxyExt;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraTopics;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Knob;
import javax.baja.sys.LinkCheck;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.BUuid;
import javax.baja.util.IFuture;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="timeAttend", type="BTimeAttendEnum", defaultValue="BTimeAttendEnum.none", flags=8), @NiagaraProperty(name="green", type="BAccessAuxOutput", defaultValue="new BAccessAuxOutput(BAccessAuxOutput.VALID, BReaderOutputEnum.unlockTime)"), @NiagaraProperty(name="red", type="BAccessAuxOutput", defaultValue="new BAccessAuxOutput(BAccessAuxOutput.INVALID, BReaderOutputEnum.unlockTime)"), @NiagaraProperty(name="beeper", type="BAccessAuxOutput", defaultValue="new BAccessAuxOutput()"), @NiagaraProperty(name="instance", type="int", defaultValue="0", flags=65), @NiagaraProperty(name="alarmOnFailedValidation", type="boolean", defaultValue="true"), @NiagaraProperty(name="assignment", type="String", defaultValue="", flags=9), @NiagaraProperty(name="diagnosticMode", type="boolean", defaultValue="false", flags=66), @NiagaraProperty(name="diagnosticModeInterval", type="BRelTime", defaultValue="BRelTime.makeMinutes(20)"), @NiagaraProperty(name="alarmInfo", type="BAlarmSourceInfo", defaultValue="new BAlarmSourceInfo()", flags=8), @NiagaraProperty(name="badgeDoesNotExistAlert", type="BActivityAlertExt", defaultValue="new BActivityAlertExt(BBadgeActivity.badgeDoesNotExist)"), @NiagaraProperty(name="unknownWiegandFormatAlert", type="BActivityAlertExt", defaultValue="new BActivityAlertExt(BBadgeActivity.unknownWiegandFormat)"), @NiagaraProperty(name="badgeIsLostAlert", type="BActivityAlertExt", defaultValue="new BActivityAlertExt(BBadgeActivity.badgeIsLost)"), @NiagaraProperty(name="badgeIsDisabledAlert", type="BActivityAlertExt", defaultValue="new BActivityAlertExt(BBadgeActivity.badgeIsDisabled)"), @NiagaraProperty(name="badgeNotAssignedAlert", type="BActivityAlertExt", defaultValue="new BActivityAlertExt(BBadgeActivity.badgeNotAssigned)"), @NiagaraProperty(name="noActiveScheduleAlert", type="BActivityAlertExt", defaultValue="new BActivityAlertExt(BBadgeActivity.noActiveSchedule)"), @NiagaraProperty(name="noAccessRightAlert", type="BActivityAlertExt", defaultValue="new BActivityAlertExt(BBadgeActivity.noAccessRight)"), @NiagaraProperty(name="grantedButNotUsedAlert", type="BActivityAlertExt", defaultValue="new BActivityAlertExt(BBadgeActivity.grantedButNotUsed)"), @NiagaraProperty(name="grantedButPinDuressAlert", type="BActivityAlertExt", defaultValue="new BActivityAlertExt(BBadgeActivity.grantedButPinDuress)"), @NiagaraProperty(name="invalidPinNumberAlert", type="BActivityAlertExt", defaultValue="new BActivityAlertExt(BBadgeActivity.invalidPinNumber)"), @NiagaraProperty(name="connectionProblemAlert", type="BActivityAlertExt", defaultValue="new BActivityAlertExt(BBadgeActivity.connectionProblem)"), @NiagaraProperty(name="grantedButConnectionProblemAlert", type="BActivityAlertExt", defaultValue="new BActivityAlertExt(BBadgeActivity.grantedButConnectionProblem)"), @NiagaraProperty(name="validationTimeoutAlert", type="BActivityAlertExt", defaultValue="new BActivityAlertExt(BBadgeActivity.validationTimeoutExpired)"), @NiagaraProperty(name="traceCardAlert", type="BActivityAlertExt", defaultValue="new BActivityAlertExt(BBadgeActivity.grantedButTrace)"), @NiagaraProperty(name="inactiveThreatLevelGroupAlert", type="BActivityAlertExt", defaultValue="new BActivityAlertExt(BBadgeActivity.inactiveThreatLevelGroup)")})
@NiagaraActions(value={@NiagaraAction(name="simulateSwipe", parameterType="BVirtualSwipe", defaultValue="new BVirtualSwipe(true, false)"), @NiagaraAction(name="simulatePin", parameterType="BVirtualSwipe", defaultValue="new BVirtualSwipe(false, true)", flags=4), @NiagaraAction(name="simulateSwipeAndPin", parameterType="BVirtualSwipe", defaultValue="new BVirtualSwipe(true, true)", flags=4), @NiagaraAction(name="pinTimeout", flags=4), @NiagaraAction(name="resultsTimerExpired", flags=4), @NiagaraAction(name="validateBadge", parameterType="BValidationInfo", defaultValue="new BValidationInfo()", flags=20), @NiagaraAction(name="disableDiagnosticMode", flags=4), @NiagaraAction(name="ackAlarm", parameterType="BAlarmRecord", defaultValue="new BAlarmRecord()", returnType="BBoolean", flags=4)})
@NiagaraTopics(value={@NiagaraTopic(name="accessValidated", eventType="BValidationInfo"), @NiagaraTopic(name="accessDenied")})
public class BAccessReader
extends BDoorController
implements NrioMessageConst,
BIPointFolder,
BIIntrusionStatusInterest,
BIAlarmSource,
BIAccessReader {
    public static final Property timeAttend = BAccessReader.newProperty((int)8, (BValue)BTimeAttendEnum.none, null);
    public static final Property green = BAccessReader.newProperty((int)0, (BValue)new BAccessAuxOutput(true, BReaderOutputEnum.unlockTime), null);
    public static final Property red = BAccessReader.newProperty((int)0, (BValue)new BAccessAuxOutput(false, BReaderOutputEnum.unlockTime), null);
    public static final Property beeper = BAccessReader.newProperty((int)0, (BValue)new BAccessAuxOutput(), null);
    public static final Property instance = BAccessReader.newProperty((int)65, (int)0, null);
    public static final Property alarmOnFailedValidation = BAccessReader.newProperty((int)0, (boolean)true, null);
    public static final Property assignment = BAccessReader.newProperty((int)9, (String)"", null);
    public static final Property diagnosticMode = BAccessReader.newProperty((int)66, (boolean)false, null);
    public static final Property diagnosticModeInterval = BAccessReader.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)20), null);
    public static final Property alarmInfo = BAccessReader.newProperty((int)8, (BValue)new BAlarmSourceInfo(), null);
    public static final Property badgeDoesNotExistAlert = BAccessReader.newProperty((int)0, (BValue)new BActivityAlertExt(BBadgeActivity.badgeDoesNotExist), null);
    public static final Property unknownWiegandFormatAlert = BAccessReader.newProperty((int)0, (BValue)new BActivityAlertExt(BBadgeActivity.unknownWiegandFormat), null);
    public static final Property badgeIsLostAlert = BAccessReader.newProperty((int)0, (BValue)new BActivityAlertExt(BBadgeActivity.badgeIsLost), null);
    public static final Property badgeIsDisabledAlert = BAccessReader.newProperty((int)0, (BValue)new BActivityAlertExt(BBadgeActivity.badgeIsDisabled), null);
    public static final Property badgeNotAssignedAlert = BAccessReader.newProperty((int)0, (BValue)new BActivityAlertExt(BBadgeActivity.badgeNotAssigned), null);
    public static final Property noActiveScheduleAlert = BAccessReader.newProperty((int)0, (BValue)new BActivityAlertExt(BBadgeActivity.noActiveSchedule), null);
    public static final Property noAccessRightAlert = BAccessReader.newProperty((int)0, (BValue)new BActivityAlertExt(BBadgeActivity.noAccessRight), null);
    public static final Property grantedButNotUsedAlert = BAccessReader.newProperty((int)0, (BValue)new BActivityAlertExt(BBadgeActivity.grantedButNotUsed), null);
    public static final Property grantedButPinDuressAlert = BAccessReader.newProperty((int)0, (BValue)new BActivityAlertExt(BBadgeActivity.grantedButPinDuress), null);
    public static final Property invalidPinNumberAlert = BAccessReader.newProperty((int)0, (BValue)new BActivityAlertExt(BBadgeActivity.invalidPinNumber), null);
    public static final Property connectionProblemAlert = BAccessReader.newProperty((int)0, (BValue)new BActivityAlertExt(BBadgeActivity.connectionProblem), null);
    public static final Property grantedButConnectionProblemAlert = BAccessReader.newProperty((int)0, (BValue)new BActivityAlertExt(BBadgeActivity.grantedButConnectionProblem), null);
    public static final Property validationTimeoutAlert = BAccessReader.newProperty((int)0, (BValue)new BActivityAlertExt(BBadgeActivity.validationTimeoutExpired), null);
    public static final Property traceCardAlert = BAccessReader.newProperty((int)0, (BValue)new BActivityAlertExt(BBadgeActivity.grantedButTrace), null);
    public static final Property inactiveThreatLevelGroupAlert = BAccessReader.newProperty((int)0, (BValue)new BActivityAlertExt(BBadgeActivity.inactiveThreatLevelGroup), null);
    public static final Action simulateSwipe = BAccessReader.newAction((int)0, (BValue)new BVirtualSwipe(true, false), null);
    public static final Action simulatePin = BAccessReader.newAction((int)4, (BValue)new BVirtualSwipe(false, true), null);
    public static final Action simulateSwipeAndPin = BAccessReader.newAction((int)4, (BValue)new BVirtualSwipe(true, true), null);
    public static final Action pinTimeout = BAccessReader.newAction((int)4, null);
    public static final Action resultsTimerExpired = BAccessReader.newAction((int)4, null);
    public static final Action validateBadge = BAccessReader.newAction((int)20, (BValue)new BValidationInfo(), null);
    public static final Action disableDiagnosticMode = BAccessReader.newAction((int)4, null);
    public static final Action ackAlarm = BAccessReader.newAction((int)4, (BValue)new BAlarmRecord(), null);
    public static final Topic accessValidated = BAccessReader.newTopic((int)0, null);
    public static final Topic accessDenied = BAccessReader.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BAccessReader.class);
    private Clock.Ticket pinEntryTicket;
    private Clock.Ticket validateResultsTicket;
    private Clock.Ticket diagnosticModeTicket;
    private StringBuffer keyPadEntry = new StringBuffer();
    private long lastBadgeTicks = 0L;
    private int oldStatus = 0;
    private int doorState = 0;
    private BDeviceNetwork network;
    private AlarmSupport support;
    private static final BIcon icon = BIcon.std((String)"card.png");

    public BTimeAttendEnum getTimeAttend() {
        return (BTimeAttendEnum)this.get(timeAttend);
    }

    public void setTimeAttend(BTimeAttendEnum v) {
        this.set(timeAttend, (BValue)v, null);
    }

    public BAccessAuxOutput getGreen() {
        return (BAccessAuxOutput)this.get(green);
    }

    public void setGreen(BAccessAuxOutput v) {
        this.set(green, (BValue)v, null);
    }

    public BAccessAuxOutput getRed() {
        return (BAccessAuxOutput)this.get(red);
    }

    public void setRed(BAccessAuxOutput v) {
        this.set(red, (BValue)v, null);
    }

    public BAccessAuxOutput getBeeper() {
        return (BAccessAuxOutput)this.get(beeper);
    }

    public void setBeeper(BAccessAuxOutput v) {
        this.set(beeper, (BValue)v, null);
    }

    public int getInstance() {
        return this.getInt(instance);
    }

    public void setInstance(int v) {
        this.setInt(instance, v, null);
    }

    public boolean getAlarmOnFailedValidation() {
        return this.getBoolean(alarmOnFailedValidation);
    }

    public void setAlarmOnFailedValidation(boolean v) {
        this.setBoolean(alarmOnFailedValidation, v, null);
    }

    public String getAssignment() {
        return this.getString(assignment);
    }

    public void setAssignment(String v) {
        this.setString(assignment, v, null);
    }

    public boolean getDiagnosticMode() {
        return this.getBoolean(diagnosticMode);
    }

    public void setDiagnosticMode(boolean v) {
        this.setBoolean(diagnosticMode, v, null);
    }

    public BRelTime getDiagnosticModeInterval() {
        return (BRelTime)this.get(diagnosticModeInterval);
    }

    public void setDiagnosticModeInterval(BRelTime v) {
        this.set(diagnosticModeInterval, (BValue)v, null);
    }

    public BAlarmSourceInfo getAlarmInfo() {
        return (BAlarmSourceInfo)this.get(alarmInfo);
    }

    public void setAlarmInfo(BAlarmSourceInfo v) {
        this.set(alarmInfo, (BValue)v, null);
    }

    public BActivityAlertExt getBadgeDoesNotExistAlert() {
        return (BActivityAlertExt)this.get(badgeDoesNotExistAlert);
    }

    public void setBadgeDoesNotExistAlert(BActivityAlertExt v) {
        this.set(badgeDoesNotExistAlert, (BValue)v, null);
    }

    public BActivityAlertExt getUnknownWiegandFormatAlert() {
        return (BActivityAlertExt)this.get(unknownWiegandFormatAlert);
    }

    public void setUnknownWiegandFormatAlert(BActivityAlertExt v) {
        this.set(unknownWiegandFormatAlert, (BValue)v, null);
    }

    public BActivityAlertExt getBadgeIsLostAlert() {
        return (BActivityAlertExt)this.get(badgeIsLostAlert);
    }

    public void setBadgeIsLostAlert(BActivityAlertExt v) {
        this.set(badgeIsLostAlert, (BValue)v, null);
    }

    public BActivityAlertExt getBadgeIsDisabledAlert() {
        return (BActivityAlertExt)this.get(badgeIsDisabledAlert);
    }

    public void setBadgeIsDisabledAlert(BActivityAlertExt v) {
        this.set(badgeIsDisabledAlert, (BValue)v, null);
    }

    public BActivityAlertExt getBadgeNotAssignedAlert() {
        return (BActivityAlertExt)this.get(badgeNotAssignedAlert);
    }

    public void setBadgeNotAssignedAlert(BActivityAlertExt v) {
        this.set(badgeNotAssignedAlert, (BValue)v, null);
    }

    public BActivityAlertExt getNoActiveScheduleAlert() {
        return (BActivityAlertExt)this.get(noActiveScheduleAlert);
    }

    public void setNoActiveScheduleAlert(BActivityAlertExt v) {
        this.set(noActiveScheduleAlert, (BValue)v, null);
    }

    public BActivityAlertExt getNoAccessRightAlert() {
        return (BActivityAlertExt)this.get(noAccessRightAlert);
    }

    public void setNoAccessRightAlert(BActivityAlertExt v) {
        this.set(noAccessRightAlert, (BValue)v, null);
    }

    public BActivityAlertExt getGrantedButNotUsedAlert() {
        return (BActivityAlertExt)this.get(grantedButNotUsedAlert);
    }

    public void setGrantedButNotUsedAlert(BActivityAlertExt v) {
        this.set(grantedButNotUsedAlert, (BValue)v, null);
    }

    public BActivityAlertExt getGrantedButPinDuressAlert() {
        return (BActivityAlertExt)this.get(grantedButPinDuressAlert);
    }

    public void setGrantedButPinDuressAlert(BActivityAlertExt v) {
        this.set(grantedButPinDuressAlert, (BValue)v, null);
    }

    public BActivityAlertExt getInvalidPinNumberAlert() {
        return (BActivityAlertExt)this.get(invalidPinNumberAlert);
    }

    public void setInvalidPinNumberAlert(BActivityAlertExt v) {
        this.set(invalidPinNumberAlert, (BValue)v, null);
    }

    public BActivityAlertExt getConnectionProblemAlert() {
        return (BActivityAlertExt)this.get(connectionProblemAlert);
    }

    public void setConnectionProblemAlert(BActivityAlertExt v) {
        this.set(connectionProblemAlert, (BValue)v, null);
    }

    public BActivityAlertExt getGrantedButConnectionProblemAlert() {
        return (BActivityAlertExt)this.get(grantedButConnectionProblemAlert);
    }

    public void setGrantedButConnectionProblemAlert(BActivityAlertExt v) {
        this.set(grantedButConnectionProblemAlert, (BValue)v, null);
    }

    public BActivityAlertExt getValidationTimeoutAlert() {
        return (BActivityAlertExt)this.get(validationTimeoutAlert);
    }

    public void setValidationTimeoutAlert(BActivityAlertExt v) {
        this.set(validationTimeoutAlert, (BValue)v, null);
    }

    public BActivityAlertExt getTraceCardAlert() {
        return (BActivityAlertExt)this.get(traceCardAlert);
    }

    public void setTraceCardAlert(BActivityAlertExt v) {
        this.set(traceCardAlert, (BValue)v, null);
    }

    public BActivityAlertExt getInactiveThreatLevelGroupAlert() {
        return (BActivityAlertExt)this.get(inactiveThreatLevelGroupAlert);
    }

    public void setInactiveThreatLevelGroupAlert(BActivityAlertExt v) {
        this.set(inactiveThreatLevelGroupAlert, (BValue)v, null);
    }

    public void simulateSwipe(BVirtualSwipe parameter) {
        this.invoke(simulateSwipe, (BValue)parameter, null);
    }

    public void simulatePin(BVirtualSwipe parameter) {
        this.invoke(simulatePin, (BValue)parameter, null);
    }

    public void simulateSwipeAndPin(BVirtualSwipe parameter) {
        this.invoke(simulateSwipeAndPin, (BValue)parameter, null);
    }

    public void pinTimeout() {
        this.invoke(pinTimeout, null, null);
    }

    public void resultsTimerExpired() {
        this.invoke(resultsTimerExpired, null, null);
    }

    public void validateBadge(BValidationInfo parameter) {
        this.invoke(validateBadge, (BValue)parameter, null);
    }

    public void disableDiagnosticMode() {
        this.invoke(disableDiagnosticMode, null, null);
    }

    public BBoolean ackAlarm(BAlarmRecord parameter) {
        return (BBoolean)this.invoke(ackAlarm, (BValue)parameter, null);
    }

    public void fireAccessValidated(BValidationInfo event) {
        this.fire(accessValidated, (BValue)event, null);
    }

    public void fireAccessDenied(BValue event) {
        this.fire(accessDenied, event, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BIAccessDevice getAccessDevice() {
        return (BIAccessDevice)this.getDevice();
    }

    @Override
    public BDevice getDevice() {
        BComplex parent = this.getParent();
        while (!(parent instanceof BDevice)) {
            parent = parent.getParent();
        }
        return (BDevice)parent;
    }

    public BPointDeviceExt getDeviceExt() {
        BComplex parent = this.getParent();
        while (!(parent instanceof BPointDeviceExt)) {
            parent = parent.getParent();
        }
        return (BPointDeviceExt)parent;
    }

    public BNrioPointDeviceExt getNrioDeviceExt() {
        BComplex parent = this.getParent();
        while (!(parent instanceof BNrioPointDeviceExt)) {
            parent = parent.getParent();
        }
        return (BNrioPointDeviceExt)parent;
    }

    public BAccessNetwork getAccessNetwork() {
        return (BAccessNetwork)this.network;
    }

    public Type getProxyExtType() {
        return BAccessProxyExt.TYPE;
    }

    public Type getPointFolderType() {
        return TYPE;
    }

    public final Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 11: {
                this.fwStarted();
            }
        }
        return super.fw(x, a, b, c, d);
    }

    private void fwStarted() {
        BComplex parent;
        if (this.network != null) {
            return;
        }
        BDeviceNetwork n = null;
        for (parent = this.getParent(); !(parent instanceof BDeviceNetwork) && parent != null; parent = parent.getParent()) {
        }
        n = (BDeviceNetwork)parent;
        Object licenseFault = n.fw(501, (Object)"reader.limit", null, null, null);
        if (licenseFault != null) {
            this.setStatus(BStatus.fault);
            this.setFaultCause("Over license limit");
            return;
        }
        this.network = n;
    }

    @Override
    public void started() throws Exception {
        super.started();
        BAccessNetwork network = this.getAccessNetwork();
        this.support = new AlarmSupport((BIAlarmSource)this, this.getAlarmInfo());
        boolean instanceOK = this.setAvailableInstance(this.getDeviceExt());
        if (!instanceOK) {
            this.setStatus(BStatus.fault);
            if (this.getFaultCause().length() == 0) {
                this.setFaultCause("No available instances on this module");
            }
        }
        int readerInstance = this.getInstance();
        int greenInstance = 5;
        int redInstance = 6;
        int beepInstance = 7;
        if (readerInstance == 2) {
            greenInstance = 8;
            redInstance = 9;
            beepInstance = 10;
        }
        String axDoActive = this.getLexicon().getText("reader.auxDo.text.active");
        String axDoInactive = this.getLexicon().getText("reader.auxDo.text.inactive");
        AccessPointDeviceExtUtil.initBooleanProxyExt((BBooleanPoint)this.getGreen(), greenInstance, false, false, axDoActive, axDoInactive, false, false, false, true, "");
        AccessPointDeviceExtUtil.initBooleanProxyExt((BBooleanPoint)this.getRed(), redInstance, false, false, axDoActive, axDoInactive, false, false, false, true, "");
        AccessPointDeviceExtUtil.initBooleanProxyExt((BBooleanPoint)this.getBeeper(), beepInstance, false, false, axDoActive, axDoInactive, false, false, false, true, "");
        this.getGreen().getFallback().setValue(false);
        this.getGreen().getFallback().setStatusNull(false);
        this.getGreen().setFlags((Slot)BAccessAuxOutput.notValidConfig, this.getGreen().getFlags((Slot)BAccessAuxOutput.notValidConfig) | 4);
        this.getGreen().setFlags((Slot)BAccessAuxOutput.followDoorHeldOpenAlarm, this.getGreen().getFlags((Slot)BAccessAuxOutput.followDoorHeldOpenAlarm) | 4);
        if (this.getGreen().getProxyExt() instanceof BAccessProxyExt) {
            this.getGreen().getProxyExt().setFlags((Slot)BProxyExt.enabled, this.getGreen().getProxyExt().getFlags((Slot)BProxyExt.enabled) | 4);
        }
        this.getRed().getFallback().setValue(false);
        this.getRed().getFallback().setStatusNull(false);
        this.getRed().setFlags((Slot)BAccessAuxOutput.config, this.getRed().getFlags((Slot)BAccessAuxOutput.config) | 4);
        this.getRed().setFlags((Slot)BAccessAuxOutput.followDoorHeldOpenAlarm, this.getRed().getFlags((Slot)BAccessAuxOutput.followDoorHeldOpenAlarm) | 4);
        if (this.getRed().getProxyExt() instanceof BAccessProxyExt) {
            this.getRed().getProxyExt().setFlags((Slot)BProxyExt.enabled, this.getRed().getProxyExt().getFlags((Slot)BProxyExt.enabled) | 4);
        }
        this.getBeeper().getFallback().setValue(false);
        this.getBeeper().getFallback().setStatusNull(false);
        this.initLinks();
    }

    public void initLinks() {
        if (this.getParent() instanceof BAccessDoor) {
            LinkCheck check;
            BAccessDoor door = (BAccessDoor)this.getParent();
            BAccessStrike strike = door.getStrike();
            if (strike != null && (check = strike.checkLink(this, (Slot)accessValidated, (Slot)BAccessStrike.accessValidated, null)).isValid()) {
                BLink link = strike.makeLink(this, (Slot)accessValidated, (Slot)BAccessStrike.accessValidated, null);
                strike.add(null, (BValue)link);
            }
            this.cleanupKnobs(BIAlarmSourceController.TYPE);
        } else {
            this.cleanupKnobs(BAccessStrike.TYPE);
        }
        if (this.getParent() instanceof BAccessElevator) {
            BAccessElevator elevator = (BAccessElevator)this.getParent();
            LinkCheck check = elevator.checkLink(this, (Slot)accessValidated, (Slot)BAccessElevator.accessValidated, null);
            if (check.isValid()) {
                BLink link = elevator.makeLink(this, (Slot)accessValidated, (Slot)BAccessElevator.accessValidated, null);
                elevator.add(null, (BValue)link);
            }
            this.cleanupKnobs(BIAlarmSourceController.TYPE);
        } else {
            this.cleanupKnobs(BAccessElevator.TYPE);
        }
        this.fixAssignment();
    }

    @Override
    public void changed(Property p, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        super.changed(p, cx);
        if (p.equals(diagnosticMode)) {
            if (cx != null && cx.getUser() != null) {
                BUser user = cx.getUser();
                if (user.getPermissions().isSuperUser()) {
                    if (this.getDiagnosticMode()) {
                        try {
                            this.setKeyPadEntry("");
                            this.setFlags((Slot)BDoorController.keyPadEntry, this.getFlags((Slot)BDoorController.keyPadEntry) & 0xFFFFFFFB, cx);
                            this.support.newAlert(BFacets.make((String)"msgText", (String)Lexicon.make(BAccessReader.class).getText("diagnosticModeMsg")));
                            this.diagnosticModeTicket = Clock.schedule((BComponent)this, (BAbsTime)BAbsTime.now().add(this.getDiagnosticModeInterval()), (Action)disableDiagnosticMode, null);
                        }
                        catch (Exception e) {
                            throw new BajaRuntimeException((Throwable)e);
                        }
                    } else {
                        this.hideKeyPadEntry(this.diagnosticModeTicket, cx);
                    }
                } else if (this.getDiagnosticMode()) {
                    this.setBoolean(diagnosticMode, false, cx);
                }
            } else if (cx == null && !this.getDiagnosticMode()) {
                this.hideKeyPadEntry(this.diagnosticModeTicket, cx);
            }
        }
    }

    private void hideKeyPadEntry(Clock.Ticket ticket, Context cx) {
        this.setKeyPadEntry("");
        this.setFlags((Slot)BDoorController.keyPadEntry, this.getFlags((Slot)BDoorController.keyPadEntry) | 4, cx);
        if (ticket != null) {
            ticket.cancel();
        }
    }

    public void knobAdded(Knob knob, Context cx) {
        super.knobAdded(knob, cx);
        if (knob.getSourceSlot() == accessValidated) {
            this.fixAssignment();
        }
    }

    public void knobRemoved(Knob knob, Context cx) {
        super.knobAdded(knob, cx);
        if (knob.getSourceSlot() == accessValidated) {
            this.fixAssignment();
        }
    }

    public void cleanupKnobs(final Type type) {
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(100L);
                    BAccessReader.this.cleanupKnobsNow(type);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }

    private void cleanupKnobsNow(Type type) {
        Knob[] knobs = this.getKnobs((Slot)accessValidated);
        for (int i = 0; i < knobs.length; ++i) {
            if (!knobs[i].getTargetComponent().getType().is(type)) continue;
            knobs[i].getTargetComponent().remove(knobs[i].getLink().getPropertyInParent());
        }
    }

    public boolean isValidationReader() {
        return !(this.getParent() instanceof BPointDeviceExt);
    }

    public boolean isIntrusionReader() {
        Knob[] knobs = this.getKnobs((Slot)accessValidated);
        for (int i = 0; i < knobs.length; ++i) {
            BComponent target = knobs[i].getTargetComponent();
            if (!(target instanceof BIAlarmSourceController)) continue;
            return true;
        }
        return false;
    }

    public void fixAssignment() {
        String s = this.getAssignment();
        Knob[] knobs = this.getKnobs((Slot)accessValidated);
        boolean foundIAlarmSourceController = false;
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < knobs.length; ++i) {
            BComponent target = knobs[i].getTargetComponent();
            if (target instanceof BAccessStrike || target instanceof BAccessElevator) {
                this.setAssignment(this.getParent().getDisplayName(null));
                this.fixAssignmentForAccess();
                return;
            }
            if (!(target instanceof BIAlarmSourceController)) continue;
            if (!foundIAlarmSourceController) {
                b.append("Intrusion Zones: ");
                foundIAlarmSourceController = true;
            } else {
                b.append(", ");
            }
            b.append(target.getDisplayName(null));
        }
        if (foundIAlarmSourceController) {
            this.setAssignment(b.toString());
            this.fixAssignmentForIntrusion();
        } else {
            this.setAssignment(Lexicon.make(BAccessReader.class).getText("none"));
            this.fixAssignmentForAccess();
        }
    }

    private void fixAssignmentForAccess() {
        this.getBeeper().setFlags((Slot)BAccessAuxOutput.followDoorHeldOpenAlarm, this.getBeeper().getFlags((Slot)BAccessAuxOutput.followDoorHeldOpenAlarm) & 0xFFFFFFFB);
        if (this.getBeeper().getProxyExt() instanceof BAccessProxyExt) {
            this.getBeeper().getProxyExt().setFlags((Slot)BProxyExt.enabled, this.getBeeper().getProxyExt().getFlags((Slot)BProxyExt.enabled) | 4);
        }
    }

    private void fixAssignmentForIntrusion() {
        this.getBeeper().setFlags((Slot)BAccessAuxOutput.followDoorHeldOpenAlarm, this.getBeeper().getFlags((Slot)BAccessAuxOutput.followDoorHeldOpenAlarm) | 4);
        if (this.getBeeper().getProxyExt() instanceof BAccessProxyExt) {
            this.getBeeper().getProxyExt().setFlags((Slot)BProxyExt.enabled, this.getBeeper().getProxyExt().getFlags((Slot)BProxyExt.enabled) & 0xFFFFFFFB);
        }
    }

    @Override
    public void doBadgeValidated(BValidationInfo info) {
        this.fireAccessValidated(info);
        this.notifyValidatedOutput();
    }

    public void notifyValidatedOutput() {
        Knob[] knobs = this.getKnobs((Slot)accessValidated);
        if (knobs.length == 0 || knobs[0].getTargetComponent() instanceof BAccessStrike || knobs[0].getTargetComponent() instanceof BAccessElevator) {
            this.getRed().configStart();
            this.getGreen().configStart();
            this.getBeeper().configStart();
        }
    }

    @Override
    public void doValidateBadge(BValidationInfo info) {
        Object serv;
        if (!this.getEnabled() || this.getDiagnosticMode()) {
            return;
        }
        info.setAccessReader(this);
        long validateStart = info.getStartTicks();
        BValidationResult validated = null;
        BReaderTypeEnum readerType = this.getReaderConfig().getReaderType();
        if (readerType.equals((Object)BReaderTypeEnum.intrusionKeypad) || readerType.equals((Object)BReaderTypeEnum.readerOrIntrusionKeypad) && info.getCredential().equals("")) {
            serv = (BIIntrusionValidationService)Sys.getService((Type)BIIntrusionValidationService.TYPE);
            validated = serv.validatePin(info) ? BValidationResult.valid : BValidationResult.invalid;
        } else {
            serv = (BIAccessDriverService)Sys.getService((Type)BIAccessDriverService.TYPE);
            validated = serv.validateBadge(info);
        }
        if (validated == BValidationResult.valid) {
            this.getInvalidBadge().setFallback(new BStatusBoolean(false));
            this.getValidBadgeLatched().setValue(true);
            this.getValidBadge().setFallback(new BStatusBoolean(true));
            if (this.validateResultsTicket != null) {
                this.validateResultsTicket.cancel();
            }
            this.validateResultsTicket = Clock.schedule((BComponent)this, (BRelTime)this.getAccessNetwork().getShowResultsTime(), (Action)resultsTimerExpired, null);
        } else if (validated == BValidationResult.invalid) {
            this.fireAccessDenied(null);
            Knob[] knobs = this.getKnobs((Slot)accessValidated);
            if (knobs.length == 0 || knobs[0].getTargetComponent() instanceof BAccessStrike || knobs[0].getTargetComponent() instanceof BAccessElevator) {
                this.getRed().notValidConfigStart();
                this.getGreen().notValidConfigStart();
                this.getBeeper().notValidConfigStart();
            }
            this.getValidBadgeLatched().setValue(false);
            this.getInvalidBadge().setFallback(new BStatusBoolean(true));
            this.getValidBadge().setFallback(new BStatusBoolean(false));
            if (this.validateResultsTicket != null) {
                this.validateResultsTicket.cancel();
            }
            this.validateResultsTicket = Clock.schedule((BComponent)this, (BRelTime)this.getAccessNetwork().getShowResultsTime(), (Action)resultsTimerExpired, null);
        } else if (validated == BValidationResult.waiting) {
            return;
        }
        this.getValidateTime().setValue((double)(Clock.ticks() - validateStart) / 1000.0);
        this.setValidateTimestamp(BAbsTime.now());
    }

    @Override
    public boolean makeAlarm(BBadgeActivity activity, String owner, String badge, String activityInfo, BUuid personId) {
        boolean alarm = false;
        if (this.getAlarmOnFailedValidation()) {
            try {
                BActivityAlertExt[] alerts = (BActivityAlertExt[])this.getChildren(BActivityAlertExt.class);
                for (int i = 0; i < alerts.length; ++i) {
                    if (!alerts[i].getActivityType().equals((Object)activity)) continue;
                    return alerts[i].generateAlert(badge, owner, activityInfo, personId);
                }
            }
            catch (Exception alarmEx) {
                alarmEx.printStackTrace();
            }
        }
        return false;
    }

    public boolean enableLogging(BBadgeActivity activity) {
        try {
            BActivityAlertExt[] alerts = (BActivityAlertExt[])this.getChildren(BActivityAlertExt.class);
            for (int i = 0; i < alerts.length; ++i) {
                if (!alerts[i].getActivityType().equals((Object)activity)) continue;
                return alerts[i].getEnableLogging();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public void doPinTimeout() {
        this.keyPadEntry = new StringBuffer();
        this.setKeyPadEntry("");
        BReaderTypeEnum readerType = this.getReaderType();
        if (!readerType.equals((Object)BReaderTypeEnum.readerOrKeypad)) {
            if (this.getCurrentBadgeRead().length() > 0) {
                this.validateBadge(new BValidationInfo(this, readerType, this.getCurrentBadgeRead(), ""));
            }
            this.setCurrentBadgeRead("");
        }
    }

    public void doResultsTimerExpired() {
        this.getInvalidBadge().setFallback(new BStatusBoolean(false));
        this.getValidBadge().setFallback(new BStatusBoolean(false));
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        if (action.equals(validateBadge)) {
            this.getAccessNetwork().getValidationWorker().postAsync((Runnable)((Object)new ValidationInvocation(this, action, argument, cx)));
            return null;
        }
        return super.post(action, argument, cx);
    }

    public void doSimulateSwipe(BVirtualSwipe swipe) throws Exception {
        this.setCurrentBadgeRead(swipe.getId());
        this.setLastBadgeRead(swipe.getId());
        this.validateBadge(new BValidationInfo(this, this.getReaderType(), swipe.getId(), ""));
    }

    public void doSimulatePin(BVirtualSwipe swipe) throws Exception {
        this.setCurrentBadgeRead("");
        this.setLastBadgeRead("");
        if (this.getDiagnosticMode()) {
            this.setKeyPadEntry(swipe.getPin());
        }
        this.validateBadge(new BValidationInfo(this, this.getReaderType(), "", swipe.getPin()));
    }

    public void doSimulateSwipeAndPin(BVirtualSwipe swipe) throws Exception {
        this.setCurrentBadgeRead(swipe.getId());
        this.setLastBadgeRead(swipe.getId());
        if (this.getDiagnosticMode()) {
            this.setKeyPadEntry(swipe.getPin());
        }
        this.validateBadge(new BValidationInfo(this, this.getReaderType(), swipe.getId(), swipe.getPin()));
    }

    public void setIoStatus(ReaderIOStatus ioStatus) {
        try {
            if (ioStatus.getNewBadge()) {
                BBadgeReaderConfig readerConfig = this.getActiveReaderConfig();
                BReaderTypeEnum readerType = readerConfig.getReaderType();
                byte[] badgeData = ioStatus.getBadgeData();
                if (badgeData.length > 3) {
                    this.lastBadgeTicks = Clock.ticks();
                    if (this.getEnabled()) {
                        this.setCurrentBadgeRead(ByteArrayUtil.toHexString((byte[])ioStatus.getBadgeData()));
                        this.setLastBadgeRead(ByteArrayUtil.toHexString((byte[])ioStatus.getBadgeData()));
                    } else {
                        this.setCurrentBadgeRead("");
                        this.setLastBadgeRead("");
                    }
                    if (readerType.equals((Object)BReaderTypeEnum.readerOnly) || readerType.equals((Object)BReaderTypeEnum.readerOrKeypad)) {
                        this.validateBadge(new BValidationInfo(this, readerType, this.getCurrentBadgeRead(), ""));
                        this.setCurrentBadgeRead("");
                    } else {
                        this.pinEntryTicket = this.setTimer(this.pinEntryTicket, this.getAccessNetwork().getKeypadEntryTime(), pinTimeout);
                    }
                } else {
                    this.handleKeyPadEntry(readerConfig, readerType, badgeData);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void handleKeyPadEntry(BBadgeReaderConfig readerConfig, BReaderTypeEnum readerType, byte[] badgeData) {
        if (readerType.equals((Object)BReaderTypeEnum.readerOnly)) {
            return;
        }
        long now = Clock.ticks();
        int keyShift = readerConfig.getKeyPadDataShift();
        int keyMask = readerConfig.getKeyPadDataMask();
        int key = 0;
        boolean isAsterisk = false;
        boolean isPoundKey = false;
        if (!this.getEnabled() && this.getKeypadLog().isLoggable(Level.FINE)) {
            this.getKeypadLog().fine("keypad entry: " + ByteArrayUtil.toHexString((byte[])badgeData));
        }
        for (int i = 0; i < badgeData.length; ++i) {
            key = badgeData[i] >> keyShift & keyMask;
            if (!this.getEnabled() && this.getKeypadLog().isLoggable(Level.FINE)) {
                this.getKeypadLog().fine("  key[" + i + "] = " + Integer.toHexString(key));
            }
            isAsterisk = key == 10;
            boolean bl = isPoundKey = key == 11;
            if (isPoundKey) {
                if (this.pinEntryTicket != null) {
                    this.pinEntryTicket.cancel();
                }
                if (now - this.lastBadgeTicks > 10000L) {
                    this.setLastBadgeRead("");
                    this.setCurrentBadgeRead("");
                }
                this.validateBadge(new BValidationInfo(this, this.getReaderType(), this.getCurrentBadgeRead(), this.keyPadEntry.toString()));
                this.keyPadEntry = new StringBuffer();
                this.setKeyPadEntry(this.keyPadEntry.toString());
                this.setCurrentBadgeRead("");
                continue;
            }
            if (!isAsterisk) {
                this.keyPadEntry.append(key);
                continue;
            }
            this.keyPadEntry = new StringBuffer();
        }
        this.pinEntryTicket = this.setTimer(this.pinEntryTicket, this.getAccessNetwork().getKeypadEntryTime(), pinTimeout);
        if (this.getDiagnosticMode()) {
            this.setKeyPadEntry(this.keyPadEntry.toString());
        }
    }

    public void updateStatus() {
        this.updateStatus(false);
    }

    @Override
    public void updateStatus(boolean isLocal) {
        BStatus device;
        int newStatus = this.getStatus().getBits();
        BStatus bStatus = device = this.getDevice() == null ? BStatus.ok : this.getDevice().getStatus();
        newStatus = !this.getEnabled() || device.isDisabled() ? (newStatus |= 1) : (newStatus &= 0xFFFFFFFE);
        newStatus = device.isDown() ? (newStatus |= 4) : (newStatus &= 0xFFFFFFFB);
        newStatus = device.isFault() ? (newStatus |= 2) : (newStatus &= 0xFFFFFFFD);
        if (this.network == null) {
            newStatus |= 2;
        }
        if (this.oldStatus == newStatus) {
            return;
        }
        this.setStatus(BStatus.make((int)newStatus));
        this.oldStatus = newStatus;
        BControlPoint[] points = (BControlPoint[])this.getChildren(BControlPoint.class);
        for (int i = 0; i < points.length; ++i) {
            BAbstractProxyExt ext = points[i].getProxyExt();
            if (!(ext instanceof BAccessProxyExt)) continue;
            if (isLocal) {
                ((BAccessProxyExt)ext).updateStatus();
            }
            ((BAccessProxyExt)ext).updateReaderStatus();
        }
    }

    private Clock.Ticket setTimer(Clock.Ticket ticket, BRelTime time, Action action) {
        if (ticket != null) {
            ticket.cancel();
        }
        return Clock.schedule((BComponent)this, (BRelTime)time, (Action)action, null);
    }

    public final BDeviceNetwork getNetwork() {
        if (this.network != null) {
            return this.network;
        }
        if (!this.isRunning()) {
            throw new NotRunningException();
        }
        throw new IllegalStateException("Exceeded license limit");
    }

    public boolean setAvailableInstance(BPointDeviceExt pointDeviceExt) {
        BAccess2ReaderPoints points = null;
        if (!(pointDeviceExt instanceof BAccess2ReaderPoints)) {
            return false;
        }
        points = (BAccess2ReaderPoints)pointDeviceExt;
        if (points.getReader1() == this || points.getReader2() == this) {
            return true;
        }
        if (points.getReader1() == null) {
            this.setInstance(1);
            return true;
        }
        if (points.getReader2() == null) {
            this.setInstance(2);
            return true;
        }
        return false;
    }

    @Override
    public void changeStatus(BIntrusionStatusEnum status, BRelTime warningTime, BRelTime delayTime) {
        BReaderOutputConfig beep = new BReaderOutputConfig(BReaderOutputEnum.burstBeep);
        int beepsForWarning = (int)Math.ceil((double)warningTime.getSeconds() / 2.0);
        int beeps = (int)(Math.ceil(delayTime.getMillis() - warningTime.getMillis()) / 5000.0) + beepsForWarning + 1;
        beep.setInitialBursts(beeps);
        beep.setCustomTime(BRelTime.makeSeconds((int)1));
        beep.setBurstOffTime(warningTime);
        BReaderOutputConfig flash = new BReaderOutputConfig(BReaderOutputEnum.burstFlash);
        flash.setInitialBursts((int)delayTime.getMillis() / 1000);
        this.getRed().doAlternateStart(BReaderOutputConfig.auto);
        this.getGreen().doAlternateStart(BReaderOutputConfig.auto);
        this.getBeeper().doAlternateStart(BReaderOutputConfig.auto);
        if (status == BIntrusionStatusEnum.armed) {
            this.getRed().doAlternateStart(BReaderOutputConfig.active);
        } else if (status == BIntrusionStatusEnum.disarmed) {
            this.getGreen().doAlternateStart(BReaderOutputConfig.active);
        } else if (status == BIntrusionStatusEnum.arming || status == BIntrusionStatusEnum.allowingTimeForDisarm) {
            this.getGreen().setAllowFlash(true);
            this.getRed().setAllowFlash(true);
            this.getGreen().doAlternateStart(flash);
            this.getBeeper().doAlternateStart(beep);
        } else if (status == BIntrusionStatusEnum.unableToArm) {
            BReaderOutputConfig unableBurst = new BReaderOutputConfig(BReaderOutputEnum.burst);
            unableBurst.setCustomTime(BRelTime.makeSeconds((int)1));
            unableBurst.setBurstOffTime(BRelTime.makeSeconds((int)1));
            unableBurst.setInitialBursts((int)delayTime.getMillis() / 1000);
            this.getRed().doAlternateStart(unableBurst);
            beep.setInitialBursts(3);
            this.getBeeper().doAlternateStart(beep);
        }
    }

    public void doDisableDiagnosticMode(Context cx) {
        this.setBoolean(diagnosticMode, false, cx);
    }

    public BBoolean doAckAlarm(BAlarmRecord rec) {
        try {
            return BBoolean.make((this.support.ackAlarm(rec) || this.support.ackAlarm(rec) ? 1 : 0) != 0);
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public boolean hasSensor() {
        return this.getParent() instanceof BAccessDoor && ((BAccessDoor)this.getParent()).getSensor() != null;
    }

    public Logger getKeypadLog() {
        return Logger.getLogger(this.network.getName() + ".keypad");
    }

    public void checkSetFlags(Slot slot, int flags, Context context) {
        super.checkSetFlags(slot, flags, context);
        if (context != null && context.getUser() != null && slot.equals((Object)BDoorController.keyPadEntry)) {
            BUser user = context.getUser();
            if (!(this.getDiagnosticMode() && user.getPermissions().isSuperUser() || (4 & flags) == 4)) {
                throw new LocalizableRuntimeException("accessDriver", "cannotChangeHiddenFlag", new Object[]{slot.getName()});
            }
        }
    }

    public Property[] getSubscribedProperties() {
        return new Property[]{assignment};
    }

    public String getRemoteDeviceName() {
        return Sys.getStation() != null ? Sys.getStation().getStationName() : "";
    }

    public String getRecordDisplayName(Context cx) {
        if (this.getParent() instanceof BPointDeviceExt) {
            return this.getParent().getParent().getDisplayName(cx) + "." + this.getDisplayName(cx);
        }
        return this.getParent().getDisplayName(cx) + "." + this.getDisplayName(cx);
    }

    public void purge() {
    }

    public void readerMoved() {
    }

    @Override
    public BObject getFunction() {
        return this.getReaderConfig().getReaderType();
    }

    public BIcon getIcon() {
        return icon;
    }
}

