/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.accessDriver;

import com.tridium.nrio.messages.NrioMessageConst;
import com.tridium.nrio.points.BNrioPointDeviceExt;
import com.tridiumx.accessDriver.AccessBacnetUtil;
import com.tridiumx.accessDriver.AccessContainer;
import com.tridiumx.accessDriver.BAccessFloor;
import com.tridiumx.accessDriver.BAccessNetwork;
import com.tridiumx.accessDriver.BAccessReader;
import com.tridiumx.accessDriver.BIAccessDevice;
import com.tridiumx.accessDriver.BValidationInfo;
import com.tridiumx.accessDriver.StatusSubscriber;
import com.tridiumx.accessDriver.points.AccessPointDeviceExtUtil;
import com.tridiumx.accessDriver.points.BAccessProxyExt;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.driver.point.BIPointFolder;
import javax.baja.driver.point.BPointDeviceExt;
import javax.baja.license.Feature;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLink;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=67), @NiagaraProperty(name="floorEnabledTime", type="BRelTime", defaultValue="BRelTime.makeSeconds(5)", facets={@Facet(value="BFacets.make(BFacets.SHOW_MILLISECONDS, BBoolean.TRUE, BFacets.MIN, BRelTime.makeSeconds(0), BFacets.MAX, BRelTime.makeMinutes(59))")}), @NiagaraProperty(name="floorSelectedInput", type="BStatusBoolean", defaultValue="new BStatusBoolean()", facets={@Facet(name="BFacets.FIELD_EDITOR", value="\"entsec:PointLinkChooserFE\""), @Facet(name="BFacets.TRUE_TEXT", value="BAccessNetwork.lex.getText(\"active\")"), @Facet(name="BFacets.FALSE_TEXT", value="BAccessNetwork.lex.getText(\"inactive\")")}), @NiagaraProperty(name="logScheduleActivity", type="boolean", defaultValue="true", flags=5), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=71)})
@NiagaraActions(value={@NiagaraAction(name="accessValidated", parameterType="BValidationInfo", defaultValue="new BValidationInfo()"), @NiagaraAction(name="lockup", parameterType="BVector", defaultValue="new BVector()", flags=4)})
public class BAccessElevator
extends BComponent
implements NrioMessageConst,
AccessContainer,
BIPointFolder,
BIStatus {
    public static final Property status = BAccessElevator.newProperty((int)67, (BValue)BStatus.ok, null);
    public static final Property floorEnabledTime = BAccessElevator.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)5), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE, (String)"min", (BIDataValue)BRelTime.makeSeconds((int)0), (String)"max", (BIDataValue)BRelTime.makeMinutes((int)59)));
    public static final Property floorSelectedInput = BAccessElevator.newProperty((int)0, (BValue)new BStatusBoolean(), (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldEditor", (String)"entsec:PointLinkChooserFE"), (BFacets)BFacets.make((String)"trueText", (String)BAccessNetwork.lex.getText("active"))), (BFacets)BFacets.make((String)"falseText", (String)BAccessNetwork.lex.getText("inactive"))));
    public static final Property logScheduleActivity = BAccessElevator.newProperty((int)5, (boolean)true, null);
    public static final Property faultCause = BAccessElevator.newProperty((int)71, (String)"", null);
    public static final Action accessValidated = BAccessElevator.newAction((int)0, (BValue)new BValidationInfo(), null);
    public static final Action lockup = BAccessElevator.newAction((int)4, (BValue)new BVector(), null);
    public static final Type TYPE = Sys.loadType(BAccessElevator.class);
    public static final BIcon ICON = BIcon.std((String)"widgets/splitPane.png");
    private BDeviceNetwork network;
    private boolean scheduled = false;
    private Clock.Ticket lockUpTicket;

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public BRelTime getFloorEnabledTime() {
        return (BRelTime)this.get(floorEnabledTime);
    }

    public void setFloorEnabledTime(BRelTime v) {
        this.set(floorEnabledTime, (BValue)v, null);
    }

    public BStatusBoolean getFloorSelectedInput() {
        return (BStatusBoolean)this.get(floorSelectedInput);
    }

    public void setFloorSelectedInput(BStatusBoolean v) {
        this.set(floorSelectedInput, (BValue)v, null);
    }

    public boolean getLogScheduleActivity() {
        return this.getBoolean(logScheduleActivity);
    }

    public void setLogScheduleActivity(boolean v) {
        this.setBoolean(logScheduleActivity, v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public void accessValidated(BValidationInfo parameter) {
        this.invoke(accessValidated, (BValue)parameter, null);
    }

    public void lockup(BVector parameter) {
        this.invoke(lockup, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void initLinks() {
        if (!this.isRunning()) {
            return;
        }
        BAccessReader[] readers = (BAccessReader[])this.getChildren(BAccessReader.class);
        for (int i = 0; i < readers.length; ++i) {
            BLink link = this.makeLink(readers[i], (Slot)BAccessReader.accessValidated, (Slot)accessValidated, null);
            this.add(null, (BValue)link);
        }
    }

    public void started() throws Exception {
        if (Sys.isStationStarted()) {
            this.stationStarted();
        }
    }

    public void stationStarted() {
        StatusSubscriber.initSubscriptions(this);
    }

    public void changed(Property p, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(floorSelectedInput) && this.getFloorSelectedInput().getValue()) {
            this.finishLockUpNow();
        }
    }

    public void added(Property property, Context context) {
        super.added(property, context);
        if (!this.isRunning()) {
            return;
        }
        BValue val = this.get(property);
        if (val instanceof BComponent) {
            AccessBacnetUtil.addBacnetPoints((BComponent)val);
        }
        if (val instanceof BAccessReader) {
            ((BAccessReader)val).initLinks();
        }
    }

    public void checkAdd(String name, BValue value, int flags, BFacets facets, Context context) {
        super.checkAdd(name, value, flags, facets, context);
        if (!this.isRunning()) {
            return;
        }
        if (value instanceof BAccessReader) {
            AccessPointDeviceExtUtil.checkAdd((BNrioPointDeviceExt)this.getParent(), name, value, flags, facets, context);
        }
    }

    public void checkRemove(Property property, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        BValue oldValue = this.get(property);
        if (oldValue instanceof BComponent) {
            String oldName = this.getParent().getParent().getDisplayName(cx) + "." + this.getDisplayName(cx) + "." + property.getDefaultDisplayName(cx);
            AccessBacnetUtil.removeBacnetPoints(oldName);
        }
    }

    public void removed(Property property, BValue oldValue, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (oldValue instanceof BComponent) {
            ((BIAccessDevice)this.getDevice()).fixGeneralUsePoints();
        }
    }

    private void finishLockUpNow() {
        if (this.lockUpTicket != null) {
            BVector validatedFloors = (BVector)this.lockUpTicket.getActionArgument();
            this.lockUpTicket.cancel();
            this.lockUpTicket = null;
            this.doLockup(validatedFloors);
        }
    }

    public boolean isFloorValidated(BAccessFloor floor) {
        BVector validatedFloors;
        BString[] paths;
        return this.lockUpTicket != null && this.floorFound(paths = (BString[])(validatedFloors = (BVector)this.lockUpTicket.getActionArgument()).getChildren(BString.class), floor);
    }

    public void doAccessValidated(BValidationInfo validationInfo) {
        if (!this.isRunning()) {
            return;
        }
        this.finishLockUpNow();
        BVector validatedFloors = (BVector)validationInfo.get("floors");
        if (validatedFloors == null) {
            return;
        }
        BAccessFloor[] floors = (BAccessFloor[])this.getChildren(BAccessFloor.class);
        BString[] paths = null;
        if (validatedFloors != null) {
            paths = (BString[])validatedFloors.getChildren(BString.class);
        }
        for (int i = 0; i < floors.length; ++i) {
            if (!this.floorFound(paths, floors[i])) continue;
            floors[i].setOut(new BStatusBoolean(true));
        }
        this.lockUpTicket = Clock.schedule((BComponent)this, (BRelTime)this.getFloorEnabledTime(), (Action)lockup, (BValue)validatedFloors);
    }

    public void doLockup(BVector validatedFloors) {
        if (!this.isRunning()) {
            return;
        }
        this.lockUpTicket = null;
        if (validatedFloors == null) {
            return;
        }
        BAccessFloor[] floors = (BAccessFloor[])this.getChildren(BAccessFloor.class);
        BString[] paths = null;
        if (validatedFloors != null) {
            paths = (BString[])validatedFloors.getChildren(BString.class);
        }
        for (int i = 0; i < floors.length; ++i) {
            if (!this.floorFound(paths, floors[i]) || floors[i].isScheduled() && floors[i].getEnabledSchedule().getValue()) continue;
            floors[i].setOut(new BStatusBoolean(false));
        }
    }

    public boolean floorFound(BString[] paths, BAccessFloor floor) {
        for (int i = 0; i < paths.length; ++i) {
            String validatedSlotPath = paths[i].toString();
            if (!validatedSlotPath.equals(BAccessElevator.slotOrdToDisplayPath(floor.getSlotPath().toString()))) continue;
            return true;
        }
        return false;
    }

    public static String slotOrdToDisplayPath(String slotPath) {
        slotPath = slotPath.substring(5);
        slotPath = TextUtil.replace((String)slotPath, (String)"$2f", (String)SlotPath.escape((String)"$2f"));
        return SlotPath.unescape((String)slotPath);
    }

    public String toStatusString(Context cx) {
        StringBuffer b = new StringBuffer();
        b.append(this.getStatus());
        BAccessFloor[] floors = (BAccessFloor[])this.getChildren(BAccessFloor.class);
        for (int i = 0; i < floors.length; ++i) {
            if (!floors[i].getPermissions(cx).hasOperatorRead() || !floors[i].getOut().getValue()) continue;
            b.append(" ").append(floors[i].getDisplayName(cx));
        }
        return b.toString();
    }

    public BIcon getIcon() {
        return ICON;
    }

    public BDevice getDevice() {
        BComplex parent = this.getParent();
        while (!(parent instanceof BDevice)) {
            parent = parent.getParent();
        }
        return (BDevice)parent;
    }

    public BPointDeviceExt getDeviceExt() {
        BComplex parent = this.getParent();
        while (!(parent instanceof BPointDeviceExt)) {
            parent = parent.getParent();
        }
        return (BPointDeviceExt)parent;
    }

    public BDeviceNetwork getNetwork() {
        BComplex parent = this.getParent();
        while (!(parent instanceof BDeviceNetwork)) {
            parent = parent.getParent();
        }
        return (BDeviceNetwork)parent;
    }

    public Type getProxyExtType() {
        return BAccessProxyExt.TYPE;
    }

    public Type getPointFolderType() {
        return TYPE;
    }

    public final Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 11: {
                this.fwStarted();
            }
        }
        return super.fw(x, a, b, c, d);
    }

    private void fwStarted() {
        BComplex parent;
        if (this.network != null) {
            return;
        }
        BDeviceNetwork n = null;
        for (parent = this.getParent(); !(parent instanceof BDeviceNetwork) && parent != null; parent = parent.getParent()) {
        }
        n = (BDeviceNetwork)parent;
        Feature accessControlFeature = Sys.getLicenseManager().getFeature("tridium", "accessControl");
        String faultCause = null;
        if (accessControlFeature == null) {
            faultCause = "Feature \"accessControl\" not licensed";
            this.setFaultCause(faultCause);
            this.setFlags((Slot)status, this.getFlags((Slot)status) & 0xFFFFFFFB);
            return;
        }
        String elevatorAttribute = accessControlFeature.get("elevator.limit");
        if (elevatorAttribute == null) {
            faultCause = "Attribute \"elevator.limit\" not available on feature \"accessControl\"";
            this.setFaultCause(faultCause);
            this.setFlags((Slot)status, this.getFlags((Slot)status) & 0xFFFFFFFB);
            return;
        }
        Object licenseFault = n.fw(501, (Object)"elevator.limit", null, null, null);
        if (licenseFault != null) {
            this.setFlags((Slot)status, this.getFlags((Slot)status) & 0xFFFFFFFB);
            this.setStatus(BStatus.make((int)2, (BFacets)BFacets.make((String)"OverLicenseLimit", (boolean)true)));
            return;
        }
        this.setFlags((Slot)status, this.getFlags((Slot)status) | 4);
        this.network = n;
    }
}

