/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.accessDriver;

import com.tridiumx.accessDriver.BAccessAlarmSourceExt;
import com.tridiumx.accessDriver.BAccessDoor;
import com.tridiumx.accessDriver.BAccessElevator;
import com.tridiumx.accessDriver.BAccessReader;
import com.tridiumx.accessDriver.BAccessSdi;
import com.tridiumx.accessDriver.BAccessStrike;
import com.tridiumx.accessDriver.components.BReaderOutputConfig;
import com.tridiumx.accessDriver.enums.BReaderOutputEnum;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.alarm.ext.BAlarmState;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.control.ext.BNullProxyExt;
import javax.baja.control.util.BOverride;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusBoolean;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLink;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.LinkCheck;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="config", type="BReaderOutputConfig", defaultValue="new BReaderOutputConfig()"), @NiagaraProperty(name="notValidConfig", type="BReaderOutputConfig", defaultValue="new BReaderOutputConfig()"), @NiagaraProperty(name="followDoorHeldOpenAlarm", type="boolean", defaultValue="false", facets={@Facet(name="BFacets.FIELD_EDITOR", value="\"entsec:BeeperFE\"")}), @NiagaraProperty(name="alarmMax", type="BRelTime", defaultValue="BRelTime.makeSeconds(0)", facets={@Facet(name="BFacets.MIN", value="BRelTime.make(200)"), @Facet(name="BFacets.MAX", value="BRelTime.makeMinutes(59)")}), @NiagaraProperty(name="warningTime", type="BRelTime", defaultValue="BRelTime.makeSeconds(0)", facets={@Facet(name="BFacets.MIN", value="BRelTime.make(0)"), @Facet(name="BFacets.MAX", value="BRelTime.makeSeconds(59)")}), @NiagaraProperty(name="alarmState", type="BAlarmState", defaultValue="BAlarmState.normal")})
@NiagaraActions(value={@NiagaraAction(name="configStart"), @NiagaraAction(name="notValidConfigStart"), @NiagaraAction(name="alternateStart", parameterType="BReaderOutputConfig", defaultValue="new BReaderOutputConfig()", flags=4)})
public class BAccessAuxOutput
extends BBooleanWritable {
    public static final Property config = BAccessAuxOutput.newProperty((int)0, (BValue)new BReaderOutputConfig(), null);
    public static final Property notValidConfig = BAccessAuxOutput.newProperty((int)0, (BValue)new BReaderOutputConfig(), null);
    public static final Property followDoorHeldOpenAlarm = BAccessAuxOutput.newProperty((int)0, (boolean)false, (BFacets)BFacets.make((String)"fieldEditor", (String)"entsec:BeeperFE"));
    public static final Property alarmMax = BAccessAuxOutput.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)0), (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)200L)), (BFacets)BFacets.make((String)"max", (BIDataValue)BRelTime.makeMinutes((int)59))));
    public static final Property warningTime = BAccessAuxOutput.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)0), (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)0L)), (BFacets)BFacets.make((String)"max", (BIDataValue)BRelTime.makeSeconds((int)59))));
    public static final Property alarmState = BAccessAuxOutput.newProperty((int)0, (BValue)BAlarmState.normal, null);
    public static final Action configStart = BAccessAuxOutput.newAction((int)0, null);
    public static final Action notValidConfigStart = BAccessAuxOutput.newAction((int)0, null);
    public static final Action alternateStart = BAccessAuxOutput.newAction((int)4, (BValue)new BReaderOutputConfig(), null);
    public static final Type TYPE = Sys.loadType(BAccessAuxOutput.class);
    private Clock.Ticket burstTicket;
    private boolean allowFlash;
    public static final boolean VALID = true;
    public static final boolean INVALID = false;

    public BReaderOutputConfig getConfig() {
        return (BReaderOutputConfig)this.get(config);
    }

    public void setConfig(BReaderOutputConfig v) {
        this.set(config, (BValue)v, null);
    }

    public BReaderOutputConfig getNotValidConfig() {
        return (BReaderOutputConfig)this.get(notValidConfig);
    }

    public void setNotValidConfig(BReaderOutputConfig v) {
        this.set(notValidConfig, (BValue)v, null);
    }

    public boolean getFollowDoorHeldOpenAlarm() {
        return this.getBoolean(followDoorHeldOpenAlarm);
    }

    public void setFollowDoorHeldOpenAlarm(boolean v) {
        this.setBoolean(followDoorHeldOpenAlarm, v, null);
    }

    public BRelTime getAlarmMax() {
        return (BRelTime)this.get(alarmMax);
    }

    public void setAlarmMax(BRelTime v) {
        this.set(alarmMax, (BValue)v, null);
    }

    public BRelTime getWarningTime() {
        return (BRelTime)this.get(warningTime);
    }

    public void setWarningTime(BRelTime v) {
        this.set(warningTime, (BValue)v, null);
    }

    public BAlarmState getAlarmState() {
        return (BAlarmState)this.get(alarmState);
    }

    public void setAlarmState(BAlarmState v) {
        this.set(alarmState, (BValue)v, null);
    }

    public void configStart() {
        this.invoke(configStart, null, null);
    }

    public void notValidConfigStart() {
        this.invoke(notValidConfigStart, null, null);
    }

    public void alternateStart(BReaderOutputConfig parameter) {
        this.invoke(alternateStart, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BAccessAuxOutput() {
    }

    public BAccessAuxOutput(boolean valid, BReaderOutputEnum readerOutput) {
        BReaderOutputConfig config = new BReaderOutputConfig(readerOutput);
        if (valid) {
            this.setConfig(config);
        } else {
            this.setNotValidConfig(config);
        }
    }

    public BAccessAuxOutput(BBooleanWritable oldAux) {
        this.setFacets(oldAux.getFacets());
        BAbstractProxyExt proxyExt = oldAux.getProxyExt();
        oldAux.setProxyExt((BAbstractProxyExt)new BNullProxyExt());
        this.setProxyExt(proxyExt);
    }

    public void started() throws Exception {
        super.started();
        this.initAlarmLink();
        this.initUnlockLink();
    }

    public void changed(Property p, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(followDoorHeldOpenAlarm)) {
            this.initAlarmLink();
        } else if (p.equals(alarmState) || p.equals(alarmMax)) {
            BRelTime alarmMax = this.getAlarmMax();
            if (this.getAlarmState() == BAlarmState.offnormal && alarmMax != BRelTime.DEFAULT) {
                BOverride override = new BOverride();
                override.setDuration(alarmMax);
                this.active(override);
            } else {
                this.auto();
            }
        } else {
            super.changed(p, cx);
        }
    }

    public void initAlarmLink() {
        BAccessAlarmSourceExt ext;
        LinkCheck check;
        BAccessDoor door;
        BAccessSdi sensor;
        BAccessReader reader = (BAccessReader)this.getParent();
        if (reader.getParent() instanceof BAccessDoor && (sensor = (door = (BAccessDoor)reader.getParent()).getSensor()) != null && this.getFollowDoorHeldOpenAlarm() && sensor.getAlarmActiveLimitExt() != null && (check = this.checkLink((BComponent)(ext = sensor.getAlarmActiveLimitExt()), (Slot)BAlarmSourceExt.alarmState, (Slot)alarmState, null)).isValid()) {
            BLink link = this.makeLink((BComponent)ext, (Slot)BAlarmSourceExt.alarmState, (Slot)alarmState, null);
            this.add(null, (BValue)link);
        }
        BLink[] links = this.getLinks((Slot)alarmState);
        if (!this.getFollowDoorHeldOpenAlarm() || !(reader.getParent() instanceof BAccessDoor)) {
            for (int i = 0; i < links.length; ++i) {
                this.remove(links[i].getName());
            }
        } else {
            for (int i = 0; i < links.length; ++i) {
                BAccessDoor door2 = (BAccessDoor)reader.getParent();
                BAccessSdi sensor2 = door2.getSensor();
                if (sensor2 == null || sensor2.getAlarmActiveLimitExt() == null || !links[i].isEnabled() || links[i].getSourceComponent().getHandle().equals(sensor2.getAlarmActiveLimitExt().getHandle())) continue;
                this.remove(links[i].getName());
            }
        }
    }

    public void initUnlockLink() {
        LinkCheck check;
        BAccessDoor door;
        BAccessStrike strike;
        BAccessReader reader = (BAccessReader)this.getParent();
        if (reader.getParent() instanceof BAccessDoor && (strike = (door = (BAccessDoor)reader.getParent()).getStrike()) != null && (this.getConfig().getAuxType() == BReaderOutputEnum.followStrikeState || this.getNotValidConfig().getAuxType() == BReaderOutputEnum.followStrikeState) && (check = this.checkLink((BComponent)strike, (Slot)BAccessStrike.out, (Slot)BBooleanWritable.in15, null)).isValid()) {
            BLink link = this.makeLink((BComponent)strike, (Slot)BAccessStrike.out, (Slot)BBooleanWritable.in15, null);
            this.add(null, (BValue)link);
        }
        BLink[] links = this.getLinks((Slot)BBooleanWritable.in15);
        if (this.getConfig().getAuxType() != BReaderOutputEnum.followStrikeState && this.getNotValidConfig().getAuxType() != BReaderOutputEnum.followStrikeState || !(reader.getParent() instanceof BAccessDoor)) {
            for (int i = 0; i < links.length; ++i) {
                this.remove(links[i].getName());
            }
        } else {
            BAccessDoor door2 = (BAccessDoor)reader.getParent();
            BAccessStrike strike2 = door2.getStrike();
            for (int i = 0; i < links.length; ++i) {
                if (strike2 == null || !links[i].isEnabled() || links[i].getSourceComponent().getHandle().equals(strike2.getHandle())) continue;
                this.remove(links[i].getName());
            }
        }
    }

    public void doConfigStart() {
        this.doAlternateStart(this.getConfig());
    }

    public void doNotValidConfigStart() {
        if (this.getAlarmState() == BAlarmState.offnormal && this.getFollowDoorHeldOpenAlarm()) {
            return;
        }
        this.doAlternateStart(this.getNotValidConfig());
    }

    public void doAlternateStart(BReaderOutputConfig config) {
        if (!config.getAuxType().equals((Object)BReaderOutputEnum.burstFlash)) {
            this.allowFlash = false;
        }
        if (config.getAuxType().equals((Object)BReaderOutputEnum.customTime)) {
            BOverride override = new BOverride();
            override.setDuration(config.getDuration(true));
            this.doActive(override);
        } else if (config.getAuxType().equals((Object)BReaderOutputEnum.unlockTime)) {
            BComponent grampa = (BComponent)this.getParent().getParent();
            if (grampa instanceof BAccessDoor) {
                BAccessDoor door = (BAccessDoor)grampa;
                BOverride override = new BOverride();
                if (door.getStrike() != null) {
                    override.setDuration(door.getStrike().getAccessUnlockTime());
                } else {
                    override.setDuration(config.getDuration(true));
                }
                this.doActive(override);
            } else if (grampa instanceof BAccessElevator) {
                BAccessElevator elevator = (BAccessElevator)grampa;
                BOverride override = new BOverride();
                override.setDuration(elevator.getFloorEnabledTime());
                this.doActive(override);
            }
        } else if (config.getAuxType().equals((Object)BReaderOutputEnum.burst) || config.getAuxType().equals((Object)BReaderOutputEnum.burstBeep)) {
            BStatusBoolean input = this.getIn8();
            boolean state = !input.getBoolean();
            input.setValue(state);
            input.setStatusNull(!state);
            int currentBursts = config.getCurrentBursts();
            if (this.burstTicket == null || currentBursts == -1) {
                config.setCurrentBursts(config.getInitialBursts() - 1);
            }
            currentBursts = config.getCurrentBursts();
            if (!state && currentBursts > -1) {
                config.setCurrentBursts(currentBursts - 1);
            }
            this.burstTicket = config.getCurrentBursts() > -1 ? Clock.schedule((BComponent)this, (BRelTime)config.getDuration(state), (Action)alternateStart, (BValue)config) : null;
        } else if (config.getAuxType().equals((Object)BReaderOutputEnum.auto) || config.getAuxType().equals((Object)BReaderOutputEnum.inactive)) {
            if (this.burstTicket != null) {
                this.burstTicket.cancel();
                this.burstTicket = null;
            }
            this.doAuto();
        } else if (config.getAuxType().equals((Object)BReaderOutputEnum.active)) {
            if (this.burstTicket != null) {
                this.burstTicket.cancel();
                this.burstTicket = null;
            }
            BOverride override = new BOverride();
            this.doActive(override);
        } else if (config.getAuxType().equals((Object)BReaderOutputEnum.burstFlash) && this.allowFlash) {
            BStatusBoolean input = this.getIn8();
            boolean state = !input.getBoolean();
            input.setValue(state);
            input.setStatusNull(!state);
            int currentBursts = config.getCurrentBursts();
            if (currentBursts == -1) {
                config.setCurrentBursts(config.getInitialBursts() - 1);
            }
            currentBursts = config.getCurrentBursts();
            if (!state && currentBursts > -1) {
                config.setCurrentBursts(currentBursts - 1);
            }
            if (config.getCurrentBursts() > -1) {
                BAccessAuxOutput other = this.getName().equals("green") ? ((BAccessReader)this.getParent()).getRed() : ((BAccessReader)this.getParent()).getGreen();
                other.getIn8().setValue(!state);
                other.getIn8().setStatusNull(state);
                other.setAllowFlash(true);
                this.burstTicket = Clock.schedule((BComponent)other, (BRelTime)config.getDuration(state), (Action)alternateStart, (BValue)config);
            } else {
                this.burstTicket = null;
            }
        } else {
            if (this.burstTicket != null) {
                this.burstTicket.cancel();
                this.burstTicket = null;
            }
            this.doAuto();
        }
    }

    public void setAllowFlash(boolean allow) {
        this.allowFlash = allow;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent.getType().equals(BAccessReader.TYPE);
    }
}

