/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.accessDriver;

import com.tridiumx.accessDriver.BAccessAlarmSourceExt;
import com.tridiumx.accessDriver.BAccessDoor;
import com.tridiumx.accessDriver.BAccessNetwork;
import com.tridiumx.accessDriver.BAccessRex;
import com.tridiumx.accessDriver.BAccessStrike;
import com.tridiumx.accessDriver.BRexActivation;
import com.tridiumx.accessDriver.enums.BSecurityAlgorithmEnum;
import com.tridiumx.accessDriver.points.BAccessProxyExt;
import javax.baja.data.BIDataValue;
import javax.baja.license.Feature;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLink;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.LinkCheck;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=71), @NiagaraProperty(name="adaOutput", type="BStatusBoolean", defaultValue="new BStatusBoolean(false)", flags=-2147483646, facets={@Facet(name="BFacets.FIELD_EDITOR", value="\"entsec:PointKnobChooserFE\""), @Facet(name="BFacets.TRUE_TEXT", value="BAccessNetwork.lex.getText(\"active\")"), @Facet(name="BFacets.FALSE_TEXT", value="BAccessNetwork.lex.getText(\"inactive\")")}), @NiagaraProperty(name="adaOutputTime", type="BRelTime", defaultValue="BRelTime.makeSeconds(5)", flags=-2147483648, facets={@Facet(value="BFacets.make(BFacets.MIN, BRelTime.makeSeconds(0), BFacets.MAX, BRelTime.makeMinutes(59))")}), @NiagaraProperty(name="strikeInput", type="BStatusBoolean", defaultValue="new BStatusBoolean(false, BStatus.nullStatus)", flags=2), @NiagaraProperty(name="exitRequestTimeout", type="BRelTime", defaultValue="BRelTime.makeSeconds(30)", flags=-2147483644, facets={@Facet(name="BFacets.MIN", value="BRelTime.DEFAULT"), @Facet(name="BFacets.MAX", value="BRelTime.makeMinutes(59)"), @Facet(name="BFacets.FIELD_EDITOR", value="\"entsec:ExitRequestTimeoutFE\""), @Facet(name="BFacets.SHOW_MILLISECONDS", value="false")}, override=true), @NiagaraProperty(name="exitRequestTimeoutRelock", type="boolean", defaultValue="true", flags=-2147483644, facets={@Facet(name="BFacets.TRUE_TEXT", value="lex.getText(\"yes\")"), @Facet(name="BFacets.FALSE_TEXT", value="lex.getText(\"no\")")}, override=true), @NiagaraProperty(name="exitRequestTimeoutAlarmExt", type="BAccessAlarmSourceExt", defaultValue="new BAccessAlarmSourceExt(BSecurityAlgorithmEnum.exitRequestTimeout)", flags=-2147483644, override=true)})
@NiagaraAction(name="activeOutputStop", flags=4)
public class BAccessAda
extends BAccessRex {
    public static final Property faultCause = BAccessAda.newProperty((int)71, (String)"", null);
    public static final Property adaOutput = BAccessAda.newProperty((int)-2147483646, (BValue)new BStatusBoolean(false), (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldEditor", (String)"entsec:PointKnobChooserFE"), (BFacets)BFacets.make((String)"trueText", (String)BAccessNetwork.lex.getText("active"))), (BFacets)BFacets.make((String)"falseText", (String)BAccessNetwork.lex.getText("inactive"))));
    public static final Property adaOutputTime = BAccessAda.newProperty((int)Integer.MIN_VALUE, (BValue)BRelTime.makeSeconds((int)5), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)0), (String)"max", (BIDataValue)BRelTime.makeMinutes((int)59)));
    public static final Property strikeInput = BAccessAda.newProperty((int)2, (BValue)new BStatusBoolean(false, BStatus.nullStatus), null);
    public static final Property exitRequestTimeout = BAccessAda.newProperty((int)-2147483644, (BValue)BRelTime.makeSeconds((int)30), (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.DEFAULT), (BFacets)BFacets.make((String)"max", (BIDataValue)BRelTime.makeMinutes((int)59))), (BFacets)BFacets.make((String)"fieldEditor", (String)"entsec:ExitRequestTimeoutFE")), (BFacets)BFacets.make((String)"showMilliseconds", (boolean)false)));
    public static final Property exitRequestTimeoutRelock = BAccessAda.newProperty((int)-2147483644, (boolean)true, (BFacets)BFacets.make((BFacets)BFacets.make((String)"trueText", (String)lex.getText("yes")), (BFacets)BFacets.make((String)"falseText", (String)lex.getText("no"))));
    public static final Property exitRequestTimeoutAlarmExt = BAccessAda.newProperty((int)-2147483644, (BValue)new BAccessAlarmSourceExt(BSecurityAlgorithmEnum.exitRequestTimeout), null);
    public static final Action activeOutputStop = BAccessAda.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BAccessAda.class);
    private Clock.Ticket adaOutputStopTicket;

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public BStatusBoolean getAdaOutput() {
        return (BStatusBoolean)this.get(adaOutput);
    }

    public void setAdaOutput(BStatusBoolean v) {
        this.set(adaOutput, (BValue)v, null);
    }

    public BRelTime getAdaOutputTime() {
        return (BRelTime)this.get(adaOutputTime);
    }

    public void setAdaOutputTime(BRelTime v) {
        this.set(adaOutputTime, (BValue)v, null);
    }

    public BStatusBoolean getStrikeInput() {
        return (BStatusBoolean)this.get(strikeInput);
    }

    public void setStrikeInput(BStatusBoolean v) {
        this.set(strikeInput, (BValue)v, null);
    }

    public void activeOutputStop() {
        this.invoke(activeOutputStop, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void started() throws Exception {
        super.started();
        Feature accessControlFeature = Sys.getLicenseManager().getFeature("tridium", "accessControl");
        String faultCause = null;
        if (accessControlFeature == null) {
            faultCause = "Feature \"accessControl\" not licensed";
            this.hideAndSetFaultCause(false, faultCause);
            throw new FeatureNotLicensedException(faultCause);
        }
        String adaAttribute = accessControlFeature.get("ada");
        if (adaAttribute == null) {
            faultCause = "Attribute \"ada\" not available on feature \"accessControl\"";
            this.hideAndSetFaultCause(false, faultCause);
            throw new FeatureNotLicensedException(faultCause);
        }
        if (adaAttribute.equals("false")) {
            faultCause = "Attribute \"ada\" not licensed on feature \"accessControl\"";
            this.hideAndSetFaultCause(false, faultCause);
            throw new FeatureNotLicensedException(faultCause);
        }
        this.hideAndSetFaultCause(true, "");
    }

    private void hideAndSetFaultCause(boolean hide, String faultCauseMsg) {
        if (hide) {
            if (!Flags.isHidden((BComplex)this, (Slot)faultCause)) {
                this.setFlags((Slot)faultCause, this.getFlags((Slot)faultCause) | 4);
            }
        } else if (Flags.isHidden((BComplex)this, (Slot)faultCause)) {
            this.setFlags((Slot)faultCause, this.getFlags((Slot)faultCause) & 0xFFFFFFFB);
        }
        this.setFaultCause(faultCauseMsg);
        if (!hide) {
            ((BAccessProxyExt)this.getProxyExt()).configFatal(faultCauseMsg);
        }
    }

    @Override
    public String getDisplayName(Slot slot, Context cx) {
        if (slot == out) {
            return BAccessNetwork.lex.getText("AccessAda.out");
        }
        if (slot == proxyExt) {
            return BAccessNetwork.lex.getText("AccessAda.proxyExt");
        }
        return super.getDisplayName(slot, cx);
    }

    @Override
    public void changed(Property p, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(unlockOnExitRequest)) {
            this.initLinks();
        } else {
            super.changed(p, cx);
        }
    }

    @Override
    public void initLinks() {
        if (!this.isRunning()) {
            return;
        }
        if (!(this.getParent() instanceof BAccessDoor)) {
            return;
        }
        if (this.getUnlockOnExitRequest()) {
            super.initLinks();
            BLink[] links = this.getLinks((Slot)strikeInput);
            for (int i = 0; i < links.length; ++i) {
                this.remove(links[i].getName());
            }
        } else {
            BAccessDoor door = (BAccessDoor)this.getParent();
            BAccessStrike strike = door.getStrike();
            if (strike != null) {
                BLink[] links = strike.getLinks((Slot)BAccessStrike.exitRequest);
                for (int i = 0; i < links.length; ++i) {
                    if (links[i].getSourceComponent() != this) continue;
                    strike.remove(links[i].getName());
                }
                LinkCheck check = this.checkLink((BComponent)strike, (Slot)BAccessStrike.out, (Slot)strikeInput, null);
                if (check.isValid()) {
                    BLink link = this.makeLink((BComponent)strike, (Slot)BAccessStrike.out, (Slot)strikeInput, null);
                    this.add(null, (BValue)link);
                }
            }
        }
    }

    @Override
    public void sendRequest() {
        if (!this.isRunning()) {
            return;
        }
        if (this.getUnlockOnExitRequest()) {
            BRexActivation rA = new BRexActivation();
            rA.setUnlock(this.getUnlockOnExitRequest());
            rA.setAuthorization(this.getDisplayName(null));
            this.fireExitRequest(rA);
        } else if (!this.getUnlockOnExitRequest() && !this.getStrikeInput().getValue()) {
            return;
        }
        if (this.adaOutputStopTicket != null) {
            this.adaOutputStopTicket.cancel();
            this.adaOutputStopTicket = null;
        }
        this.getAdaOutput().setValue(true);
        this.adaOutputStopTicket = Clock.schedule((BComponent)this, (BRelTime)this.getAdaOutputTime(), (Action)activeOutputStop, null);
    }

    public void doActiveOutputStop() {
        if (!this.isRunning()) {
            return;
        }
        this.getAdaOutput().setValue(false);
    }
}

