/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.accessDriver;

import com.tridium.nrio.BNrioDevice;
import com.tridium.nrio.components.BIoStatus;
import com.tridium.nrio.enums.BNrioDeviceTypeEnum;
import com.tridium.nrio.messages.NrioMessage;
import com.tridium.nrio.messages.WriteConfigMessage;
import com.tridium.nrio.messages.WriteDOMessage;
import com.tridiumx.accessDriver.AccessDeviceUtil;
import com.tridiumx.accessDriver.BAccessNetwork;
import com.tridiumx.accessDriver.BIAccessDevice;
import com.tridiumx.accessDriver.enums.BDoorConfigureEnum;
import com.tridiumx.accessDriver.messages.TwoReaderIOStatus;
import com.tridiumx.accessDriver.points.BAccess2ReaderPoints;
import com.tridiumx.accessDriver.points.BRemote2ReaderPoints;
import java.util.logging.Logger;
import javax.baja.control.BControlPoint;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="initialDoors", type="BDoorConfigureEnum", defaultValue="BDoorConfigureEnum.twoDoors"), @NiagaraProperty(name="deviceType", type="BNrioDeviceTypeEnum", defaultValue="BNrioDeviceTypeEnum.remoteReader", flags=1, override=true)})
@NiagaraAction(name="writeConfig")
public abstract class BAccess2ReaderModule
extends BNrioDevice
implements BIAccessDevice {
    public static final Property initialDoors = BAccess2ReaderModule.newProperty((int)0, (BValue)BDoorConfigureEnum.twoDoors, null);
    public static final Property deviceType = BAccess2ReaderModule.newProperty((int)1, (BValue)BNrioDeviceTypeEnum.remoteReader, null);
    public static final Action writeConfig = BAccess2ReaderModule.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BAccess2ReaderModule.class);
    private boolean skipInit;
    private int wrDoValue;
    private int lastWriteValue;
    private static final byte[] NO_DATA = new byte[0];
    private final boolean[] test = new boolean[]{false, false};

    @Override
    public BDoorConfigureEnum getInitialDoors() {
        return (BDoorConfigureEnum)this.get(initialDoors);
    }

    @Override
    public void setInitialDoors(BDoorConfigureEnum v) {
        this.set(initialDoors, (BValue)v, null);
    }

    public void writeConfig() {
        this.invoke(writeConfig, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        AccessDeviceUtil.started(this);
    }

    @Override
    public boolean getIsRemote() {
        return AccessDeviceUtil.getIsRemote(this);
    }

    @Override
    public void fixGeneralUsePoints() {
        AccessDeviceUtil.fixGeneralUsePoints(this);
    }

    public void doDumpIoMap() {
        int i;
        BOrd[] map = this.getUsedDiArray();
        System.out.println("Digital input use map:");
        for (i = 0; i < map.length; ++i) {
            System.out.println("   di" + (i + 1) + " used = " + map[i]);
        }
        map = this.getUsedRelayArray();
        System.out.println("Relay output use map:");
        for (i = 0; i < map.length; ++i) {
            System.out.println("   ro" + (i + 1) + " used = " + map[i]);
        }
        map = this.getUsedSdiArray();
        System.out.println("Sdi use map:");
        for (i = 0; i < map.length; ++i) {
            System.out.println("   sdi" + (i + 1) + " used = " + map[i]);
        }
    }

    public void doWriteConfig() {
        this.sendWriteConfig();
    }

    public int sendWriteConfig() {
        BAccessNetwork network = (BAccessNetwork)this.getNetwork();
        WriteConfigMessage cReq = new WriteConfigMessage(this.getAddress(), 514);
        NrioMessage cRsp = network.sendNrioMessage((NrioMessage)cReq);
        return cRsp.getStatus();
    }

    public int setDoValue(boolean value, int instance) {
        int mask = 0;
        switch (instance) {
            case 1: {
                mask = 256;
                break;
            }
            case 2: {
                mask = 512;
                break;
            }
            case 3: {
                mask = 1024;
                break;
            }
            case 4: {
                mask = 2048;
                break;
            }
            case 5: {
                mask = 1;
                break;
            }
            case 6: {
                mask = 2;
                break;
            }
            case 7: {
                mask = 4;
                break;
            }
            case 8: {
                mask = 8;
                break;
            }
            case 9: {
                mask = 16;
                break;
            }
            case 10: {
                mask = 32;
                break;
            }
            default: {
                return 1;
            }
        }
        this.setWrDoValue(value, mask);
        return 0;
    }

    public synchronized void setWrDoValue(boolean value, int mask) {
        this.wrDoValue = value ? (this.wrDoValue |= mask) : (this.wrDoValue &= ~mask);
        ((BAccessNetwork)this.getNetwork()).interruptWriteThread();
    }

    public int doWriteDoValues() {
        BAccessNetwork network = (BAccessNetwork)this.getNetwork();
        if (this.isDown()) {
            this.lastWriteValue = 0;
            return 0;
        }
        int thisWrite = this.wrDoValue;
        if (thisWrite != this.lastWriteValue) {
            WriteDOMessage req = new WriteDOMessage(this.getAddress(), thisWrite);
            NrioMessage rsp = network.sendNrioMessage((NrioMessage)req);
            if (rsp != null && rsp.getStatus() == 0) {
                this.pingOk();
                this.lastWriteValue = thisWrite;
            }
            return rsp.getStatus();
        }
        return 0;
    }

    public void updateProxyValues() {
        byte[] statusBytes = ((BIoStatus)this.getIoStatus()).copyBytes();
        if (statusBytes.length < 12) {
            return;
        }
        NrioMessage statusMsg = new NrioMessage();
        statusMsg.decodeFromBytes(statusBytes, statusBytes.length);
        ((BAccess2ReaderPoints)this.getPoints()).setIoStatus(new TwoReaderIOStatus(statusMsg.getData()));
    }

    public void changed(Property p, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (this.isDown() || this.isFault() || this.isDisabled()) {
            this.lastWriteValue = 0;
        }
        super.changed(p, cx);
    }

    public void processIoStatusMessage(NrioMessage statusMessage) {
        if (statusMessage.getLength() > 15) {
            if (statusMessage.getLength() < 18) {
                this.getUnsolicitedLog().severe("Received short reader status message: length = " + statusMessage.getLength());
            }
            ((BAccess2ReaderPoints)this.getPoints()).setIoStatus(new TwoReaderIOStatus(statusMessage.getData()));
        }
    }

    public BOrd[] getUsedRelayArray() {
        int maxValue = 4;
        if (this.getIsRemote()) {
            maxValue = 2;
        }
        return this.getUsedRelayArray(maxValue);
    }

    public BOrd[] getUsedDiArray() {
        int maxValue = 3;
        if (this.getIsRemote()) {
            maxValue = 2;
        }
        return this.getUsedDiArray(maxValue);
    }

    public BOrd[] getUsedSdiArray() {
        int maxValue = 6;
        if (this.getIsRemote()) {
            maxValue = 4;
        }
        return this.getUsedSdiArray(maxValue);
    }

    public BControlPoint checkForProxyExtConflicts(BControlPoint sourcePoint) {
        return super.checkForProxyExtConflicts(sourcePoint);
    }

    @Override
    public String toStatusString(Context cx) {
        StringBuffer b = new StringBuffer();
        b.append(this.getStatus().toString()).append(" ");
        BRemote2ReaderPoints points = (BRemote2ReaderPoints)this.getPoints();
        if (points.getDi1().getBoolean()) {
            b.append("Di1 ");
        }
        if (points.getDi2().getBoolean()) {
            b.append("Di2 ");
        }
        if (points.getSdi1().getBoolean()) {
            b.append("Sdi1 ");
        }
        if (points.getSdi2().getBoolean()) {
            b.append("Sdi2 ");
        }
        if (points.getSdi3().getBoolean()) {
            b.append("Sdi3 ");
        }
        if (points.getSdi4().getBoolean()) {
            b.append("Sdi4 ");
        }
        return b.toString();
    }

    public Logger getUnsolicitedLog() {
        return Logger.getLogger(this.getNetwork().getName() + ".unsolicited");
    }

    @Override
    public void skipInit() {
        this.skipInit = true;
    }

    @Override
    public boolean isSkipInit() {
        return this.skipInit;
    }
}

