/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.ui.util;

import com.tridium.platform.ui.util.BTextOutputPane;
import com.tridium.util.ThrowableUtil;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Clock;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidgetShell;
import javax.baja.util.Lexicon;

@NiagaraType
public abstract class BInputStreamPane
extends BTextOutputPane {
    @Generated
    public static final Type TYPE = Sys.loadType(BInputStreamPane.class);
    public static final int BUFFER_TIME_MAX = 3000;
    protected int bufferTime = 3000;
    protected OutputWatcher watcher = null;
    private static final Logger log = Logger.getLogger("platform.inputStreamPane");
    private static final Lexicon lex = Lexicon.make((String)"platform");

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BInputStreamPane() {
        this(20, 80);
    }

    protected BInputStreamPane(int rows, int cols) {
        super(rows, cols);
        this.setUseAutoScroll(true);
    }

    protected abstract InputStream getInputStream();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        InputStream stream = this.getInputStream();
        BInputStreamPane bInputStreamPane = this;
        synchronized (bInputStreamPane) {
            if (stream != null) {
                this.stopUpdates();
                this.startUpdates(new OutputWatcher(this, stream));
            }
        }
    }

    public void setBufferTime(int value) {
        this.bufferTime = value;
    }

    public int getBufferTime() {
        return this.bufferTime;
    }

    protected synchronized void startUpdates(OutputWatcher value) {
        this.watcher = value;
        this.watcher.start();
    }

    public synchronized void stopUpdates() {
        if (this.watcher != null) {
            this.watcher.stopWatcher();
            this.watcher = null;
        }
    }

    public void clearValue() {
        this.stopUpdates();
        this.clear();
    }

    public synchronized void clearText() throws Exception {
        if (this.watcher == null) {
            this.clear();
        } else {
            this.watcher.clearOutput();
        }
    }

    public void deactivated() {
        this.stopUpdates();
    }

    @Override
    public void stopped() throws Exception {
        super.stopped();
        this.stopUpdates();
    }

    protected static class OutputWatcher
    extends Thread {
        private final BInputStreamPane pane;
        private final InputStream in;
        private boolean stopped = true;
        private BWidgetShell shell;
        private boolean clearBuffer = false;
        private static final Object CLEAR_SYNC = new Object();

        public OutputWatcher(BInputStreamPane pPane, InputStream pIn) {
            super("InputStreamPane:OutputWatcher");
            this.pane = pPane;
            this.in = pIn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean busyShowing = true;
            this.stopped = false;
            byte[] buf = new byte[8192];
            StringBuilder pendingDisplay = new StringBuilder();
            long startTicks = Clock.ticks();
            this.pane.setText("");
            try {
                this.shell = this.pane.getShell();
                if (this.shell != null) {
                    this.shell.enterBusy();
                }
                while (!this.stopped) {
                    int numRead;
                    long lastRead;
                    block30: {
                        Object object = CLEAR_SYNC;
                        synchronized (object) {
                            this.clearBuffer = false;
                        }
                        try {
                            lastRead = Clock.ticks();
                            numRead = this.in.read(buf, 0, 8192);
                            if (!busyShowing) break block30;
                            if (this.shell != null) {
                                this.shell.exitBusy();
                            }
                            busyShowing = false;
                        }
                        catch (NullPointerException npe) {
                            if (busyShowing) {
                                if (this.shell != null) {
                                    this.shell.exitBusy();
                                }
                                busyShowing = false;
                            }
                            throw new IOException();
                        }
                        catch (InterruptedIOException ignored) {
                            if (pendingDisplay.length() > 0) {
                                this.pane.append(pendingDisplay.toString());
                                pendingDisplay = new StringBuilder();
                            }
                            if (!busyShowing) continue;
                            if (this.shell != null) {
                                this.shell.exitBusy();
                            }
                            busyShowing = false;
                            continue;
                        }
                    }
                    Object ignored = CLEAR_SYNC;
                    synchronized (ignored) {
                        if (this.clearBuffer) {
                            numRead = 0;
                            this.clearBuffer = false;
                        }
                    }
                    if (this.stopped) continue;
                    if (numRead >= 0) {
                        if (lastRead - startTicks > (long)this.pane.bufferTime) {
                            if (pendingDisplay.length() > 0) {
                                this.pane.append(pendingDisplay.toString());
                                pendingDisplay = new StringBuilder();
                            }
                            this.pane.append(new String(buf, 0, numRead, StandardCharsets.UTF_8));
                            continue;
                        }
                        pendingDisplay.append(new String(buf, 0, numRead, StandardCharsets.UTF_8));
                        continue;
                    }
                    if (pendingDisplay.length() > 0) {
                        this.pane.append(pendingDisplay.toString());
                        pendingDisplay = new StringBuilder();
                    }
                    this.stopWatcher(false);
                }
            }
            catch (EOFException eof) {
                this.pane.append(pendingDisplay.toString());
                String message = "\n" + lex.getText("InputStreamPane.eof");
                this.pane.append(message.getBytes(), 0, message.length());
            }
            catch (IOException ioe) {
                this.pane.append(pendingDisplay.toString());
                if (!this.stopped) {
                    String message = "\n" + lex.getText("InputStreamPane.ioe", new Object[]{ThrowableUtil.dumpToString((Throwable)ioe)});
                    this.pane.append(message.getBytes(), 0, message.length());
                    log.log(Level.SEVERE, "Error occurred reading output", ioe);
                }
            }
            finally {
                if (busyShowing && this.shell != null) {
                    this.shell.exitBusy();
                }
                this.stopWatcher(false);
            }
        }

        public void stopWatcher() {
            this.stopWatcher(true);
        }

        public void stopWatcher(boolean waitForNotify) {
            if (this.stopped) {
                return;
            }
            this.clearBuffer = false;
            this.stopped = true;
            new Thread(() -> {
                try {
                    this.in.close();
                }
                catch (IOException e) {
                    log.log(Level.SEVERE, "Failed to close input stream when stopping output watcher", e);
                }
            }, "InputStreamPaneCloseThread").start();
            if (waitForNotify) {
                try {
                    this.join();
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Exception occurred while waiting for output watcher thread to stop", e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearOutput() {
            Object object = CLEAR_SYNC;
            synchronized (object) {
                this.pane.clear();
                this.clearBuffer = true;
            }
        }
    }
}

