/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.ui.syslog;

import com.tridium.nre.util.IPAddressUtil;
import com.tridium.platform.alarm.BPlatformAlarmSupport;
import com.tridium.platform.syslog.BSyslogFacilityEnum;
import com.tridium.platform.syslog.BSyslogLevelEnum;
import com.tridium.platform.syslog.BSyslogPlatformService;
import com.tridium.platform.syslog.BSyslogSettings;
import com.tridium.platform.syslog.BSyslogTransportProtocolEnum;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platform.ui.util.BLimitedFrozenEnumFE;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.util.LabelUtil;
import com.tridium.workbench.fieldeditors.BCertificateAliasFE;
import com.tridium.workbench.fieldeditors.BDefaultPasswordFE;
import com.tridium.workbench.fieldeditors.BIntegerFE;
import javax.baja.gx.BBrush;
import javax.baja.gx.BInsets;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BCertificateAliasAndPassword;
import javax.baja.security.BPassword;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BInteger;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BExpandablePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.util.BTitlePane;
import javax.baja.util.LexiconModule;
import javax.baja.util.LexiconText;
import javax.baja.workbench.BWbPlugin;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.view.BWbComponentView;

@NiagaraType(agent={@AgentOn(types={"platform:SyslogPlatformService"}, requiredPermissions="W")})
@NiagaraAction(name="setEnabledStates", flags=4)
public class BSyslogPlatformServicePlugin
extends BWbComponentView {
    @Generated
    public static final Action setEnabledStates = BSyslogPlatformServicePlugin.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BSyslogPlatformServicePlugin.class);
    private BCheckBox serviceEnabledFE;
    private BTextField serverHostFE;
    private BIntegerFE serverPortFE;
    private BTextField messageTypeFE;
    private BLimitedFrozenEnumFE transportProtocolFE;
    private BCertificateAliasFE certificateAliasFE;
    private BDefaultPasswordFE certificatePasswordFE;
    private BCheckBox platformLogFE;
    private BCheckBox stationLogFE;
    private BLimitedFrozenEnumFE logLevelFilterFE;
    private BCheckBox stationAuditFE;
    private BCheckBox securityAuditFE;
    private BLimitedFrozenEnumFE facilityFE;
    private BIntegerFE queueSizeFE;
    private BLabel stationServerStatusLabel;
    private BLabel queueFullPercentStationLabel;
    private BLabel platformServerStatusLabel;
    private BLabel queueFullPercentPlatformLabel;
    private BCheckBox syslogServerConnectionAlarmEnabled;
    private BWbFieldEditor syslogServerConnectionAlarmSupportFE;
    private BCheckBox syslogMessageQueueAlarmEnabled;
    private BWbFieldEditor syslogMessageQueueAlarmSupportFE;
    private boolean isSyslogSettingsReadonly;
    private static final int MAX_EVENTS_DEPTH = 5;
    private static final LexiconModule LEX = LexiconModule.make((String)"platform");

    @Generated
    public void setEnabledStates() {
        this.invoke(setEnabledStates, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BSyslogPlatformServicePlugin() {
        this.autoRegisterForComponentEvents = false;
    }

    protected void doLoadValue(BObject value, Context context) throws Exception {
        BSyslogPlatformService service = (BSyslogPlatformService)value;
        service.poll();
        this.registerForComponentEvents((BComponent)service, 5);
        BSyslogSettings syslogSettings = service.getSyslogSettings();
        syslogSettings.lease(5);
        BGridPane contentPane = new BGridPane(2);
        contentPane.setHalign(BHalign.left);
        contentPane.setValign(BValign.top);
        contentPane.setColumnGap(10.0);
        contentPane.setRowGap(6.0);
        contentPane.setColorRows(true);
        BButtonPane buttonPane = new BButtonPane();
        this.serviceEnabledFE = new BCheckBox(LexiconText.make((Type)TYPE, (String)"SyslogPlatformServicePlugin.enabled.label").getText(context));
        LabelUtil.addLabelWidgetPair((BPane)contentPane, (String)syslogSettings.getDisplayName((Slot)BSyslogSettings.enabled, context), (BWidget)this.serviceEnabledFE);
        this.serverHostFE = new BTextField(syslogSettings.getServerHost(), 32);
        LabelUtil.addLabelWidgetPair((BPane)contentPane, (String)syslogSettings.getDisplayName((Slot)BSyslogSettings.serverHost, context), (BWidget)this.serverHostFE);
        this.serverPortFE = new BIntegerFE();
        LabelUtil.addLabelWidgetPair((BPane)contentPane, (String)syslogSettings.getDisplayName((Slot)BSyslogSettings.serverPort, context), (BWidget)this.serverPortFE);
        this.messageTypeFE = new BTextField(syslogSettings.getMessageType().toString());
        LabelUtil.addLabelWidgetPair((BPane)contentPane, (String)syslogSettings.getDisplayName((Slot)BSyslogSettings.messageType, context), (BWidget)this.messageTypeFE);
        this.transportProtocolFE = new BLimitedFrozenEnumFE();
        LabelUtil.addLabelWidgetPair((BPane)contentPane, (String)syslogSettings.getDisplayName((Slot)BSyslogSettings.transportProtocol, context), (BWidget)this.transportProtocolFE);
        BGridPane certificatePane = new BGridPane(2);
        this.certificateAliasFE = new BCertificateAliasFE();
        LabelUtil.addLabelWidgetPair((BPane)certificatePane, (String)syslogSettings.getClientAliasAndPassword().getDisplayName((Slot)BCertificateAliasAndPassword.alias, context), (BWidget)this.certificateAliasFE);
        this.certificateAliasFE.loadValue((BObject)BString.make((String)service.getSyslogSettings().getClientAliasAndPassword().getAlias()), (Context)new BasicContext(context, BCertificateAliasAndPassword.alias.getFacets()));
        this.certificatePasswordFE = new BDefaultPasswordFE();
        LabelUtil.addLabelWidgetPair((BPane)certificatePane, (String)syslogSettings.getClientAliasAndPassword().getDisplayName((Slot)BCertificateAliasAndPassword.password, context), (BWidget)this.certificatePasswordFE);
        this.certificatePasswordFE.loadValue((BObject)service.getSyslogSettings().getClientAliasAndPassword().getPassword(), (Context)new BasicContext(context, BCertificateAliasAndPassword.password.getFacets()));
        LabelUtil.addLabelWidgetPair((BPane)contentPane, (String)syslogSettings.getDisplayName((Slot)BSyslogSettings.clientAliasAndPassword, context), (BWidget)new BExpandablePane((BWidget)new BNullWidget(), (BWidget)certificatePane));
        this.platformLogFE = new BCheckBox(LexiconText.make((Type)TYPE, (String)"SyslogPlatformServicePlugin.enabled.label").getText(context));
        LabelUtil.addLabelWidgetPair((BPane)contentPane, (String)syslogSettings.getDisplayName((Slot)BSyslogSettings.platformLogEnabled, context), (BWidget)this.platformLogFE);
        this.stationLogFE = new BCheckBox(LexiconText.make((Type)TYPE, (String)"SyslogPlatformServicePlugin.enabled.label").getText(context));
        LabelUtil.addLabelWidgetPair((BPane)contentPane, (String)syslogSettings.getDisplayName((Slot)BSyslogSettings.stationLogEnabled, context), (BWidget)this.stationLogFE);
        this.logLevelFilterFE = new BLimitedFrozenEnumFE();
        LabelUtil.addLabelWidgetPair((BPane)contentPane, (String)syslogSettings.getDisplayName((Slot)BSyslogSettings.logLevelFilter, context), (BWidget)this.logLevelFilterFE);
        this.stationAuditFE = new BCheckBox(LexiconText.make((Type)TYPE, (String)"SyslogPlatformServicePlugin.enabled.label").getText(context));
        LabelUtil.addLabelWidgetPair((BPane)contentPane, (String)syslogSettings.getDisplayName((Slot)BSyslogSettings.stationAuditEnabled, context), (BWidget)this.stationAuditFE);
        this.securityAuditFE = new BCheckBox(LexiconText.make((Type)TYPE, (String)"SyslogPlatformServicePlugin.enabled.label").getText(context));
        LabelUtil.addLabelWidgetPair((BPane)contentPane, (String)syslogSettings.getDisplayName((Slot)BSyslogSettings.securityAuditEnabled, context), (BWidget)this.securityAuditFE);
        this.facilityFE = new BLimitedFrozenEnumFE();
        LabelUtil.addLabelWidgetPair((BPane)contentPane, (String)syslogSettings.getDisplayName((Slot)BSyslogSettings.facility, context), (BWidget)this.facilityFE);
        this.queueSizeFE = new BIntegerFE();
        LabelUtil.addLabelWidgetPair((BPane)contentPane, (String)syslogSettings.getDisplayName((Slot)BSyslogSettings.queueSize, context), (BWidget)this.queueSizeFE);
        this.stationServerStatusLabel = new BLabel(BSyslogPlatformServicePlugin.makeServerStatusString(service.getStationServerStatus(), context));
        LabelUtil.addLabelWidgetPair((BPane)contentPane, (String)service.getDisplayName((Slot)BSyslogPlatformService.stationServerStatus, context), (BWidget)this.stationServerStatusLabel);
        this.queueFullPercentStationLabel = new BLabel(service.getQueueFullPercentStation() + "%");
        LabelUtil.addLabelWidgetPair((BPane)contentPane, (String)service.getDisplayName((Slot)BSyslogPlatformService.queueFullPercentStation, context), (BWidget)this.queueFullPercentStationLabel);
        this.platformServerStatusLabel = new BLabel(BSyslogPlatformServicePlugin.makeServerStatusString(service.getPlatformServerStatus(), context));
        LabelUtil.addLabelWidgetPair((BPane)contentPane, (String)service.getDisplayName((Slot)BSyslogPlatformService.platformServerStatus, context), (BWidget)this.platformServerStatusLabel);
        this.queueFullPercentPlatformLabel = new BLabel(service.getQueueFullPercentPlatform() + "%");
        LabelUtil.addLabelWidgetPair((BPane)contentPane, (String)service.getDisplayName((Slot)BSyslogPlatformService.queueFullPercentPlatform, context), (BWidget)this.queueFullPercentPlatformLabel);
        this.syslogServerConnectionAlarmEnabled = new BCheckBox(LexiconText.make((Type)TYPE, (String)"SyslogPlatformServicePlugin.enabled.label").getText(context));
        LabelUtil.addLabelWidgetPair((BPane)contentPane, (String)service.getDisplayName((Slot)BSyslogPlatformService.syslogServerConnectionAlarmEnabled, context), (BWidget)this.syslogServerConnectionAlarmEnabled);
        this.syslogServerConnectionAlarmSupportFE = BWbFieldEditor.makeFor((BObject)new BPlatformAlarmSupport());
        LabelUtil.addLabelWidgetPair((BPane)contentPane, (String)service.getDisplayName((Slot)BSyslogPlatformService.syslogServerConnectionAlarmSupport, context), (BWidget)new BExpandablePane((BWidget)new BNullWidget(), (BWidget)this.syslogServerConnectionAlarmSupportFE), (boolean)true);
        this.syslogMessageQueueAlarmEnabled = new BCheckBox(LexiconText.make((Type)TYPE, (String)"SyslogPlatformServicePlugin.enabled.label").getText(context));
        LabelUtil.addLabelWidgetPair((BPane)contentPane, (String)service.getDisplayName((Slot)BSyslogPlatformService.syslogMessageQueueAlarmEnabled, context), (BWidget)this.syslogMessageQueueAlarmEnabled);
        this.syslogMessageQueueAlarmSupportFE = BWbFieldEditor.makeFor((BObject)new BPlatformAlarmSupport());
        LabelUtil.addLabelWidgetPair((BPane)contentPane, (String)service.getDisplayName((Slot)BSyslogPlatformService.syslogMessageQueueAlarmSupport, context), (BWidget)new BExpandablePane((BWidget)new BNullWidget(), (BWidget)this.syslogMessageQueueAlarmSupportFE), (boolean)true);
        BBrush bgcolor = Theme.scrollPane().getControlBackground();
        BScrollPane scrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)contentPane));
        scrollPane.setViewportBackground(bgcolor);
        buttonPane.removeAll();
        buttonPane.addWorkbenchButtons((BWidget)this);
        this.setContent((BWidget)new BTitlePane(this.getTypeDisplayName(context), (BWidget)new BEdgePane(null, (BWidget)new BBorderPane((BWidget)buttonPane, 5.0, 0.0, 0.0, 0.0), null, null, (BWidget)new BBorderPane((BWidget)scrollPane, BBorder.inset, BInsets.DEFAULT))));
        this.isSyslogSettingsReadonly = syslogSettings.getIsReadonly();
        this.serviceEnabledFE.setEnabled(!this.isSyslogSettingsReadonly);
        this.messageTypeFE.setEnabled(false);
        this.serviceEnabledFE.setSelected(syslogSettings.getEnabled());
        this.serverPortFE.loadValue((BObject)BInteger.make((int)syslogSettings.getServerPort()), (Context)new BasicContext(context, BSyslogSettings.serverPort.getFacets()));
        this.transportProtocolFE.loadValue((BObject)syslogSettings.getTransportProtocol(), (Context)new BasicContext(context, BSyslogSettings.transportProtocol.getFacets()));
        this.platformLogFE.setSelected(syslogSettings.getPlatformLogEnabled());
        this.stationLogFE.setSelected(syslogSettings.getStationLogEnabled());
        this.logLevelFilterFE.loadValue((BObject)syslogSettings.getLogLevelFilter(), (Context)new BasicContext(context, BSyslogSettings.logLevelFilter.getFacets()));
        this.stationAuditFE.setSelected(syslogSettings.getStationAuditEnabled());
        this.securityAuditFE.setSelected(syslogSettings.getSecurityAuditEnabled());
        this.facilityFE.loadValue((BObject)syslogSettings.getFacility(), (Context)new BasicContext(context, BSyslogSettings.facility.getFacets()));
        this.queueSizeFE.loadValue((BObject)BInteger.make((int)syslogSettings.getQueueSize()), (Context)new BasicContext(context, BSyslogSettings.queueSize.getFacets()));
        this.syslogServerConnectionAlarmEnabled.setSelected(service.getSyslogServerConnectionAlarmEnabled());
        this.syslogServerConnectionAlarmSupportFE.loadValue((BObject)service.getSyslogServerConnectionAlarmSupport());
        this.syslogMessageQueueAlarmEnabled.setSelected(service.getSyslogMessageQueueAlarmEnabled());
        this.syslogMessageQueueAlarmSupportFE.loadValue((BObject)service.getSyslogMessageQueueAlarmSupport());
        this.doSetEnabledStates();
        this.linkTo(null, (BComponent)this.serviceEnabledFE, (Slot)BLabel.actionPerformed, (Slot)setModified);
        this.linkTo(null, (BComponent)this.serviceEnabledFE, (Slot)BLabel.actionPerformed, (Slot)setEnabledStates);
        this.linkTo(null, (BComponent)this.serverHostFE, (Slot)BTextEditor.textModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.serverPortFE, (Slot)BWbPlugin.pluginModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.messageTypeFE, (Slot)BTextEditor.textModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.transportProtocolFE, (Slot)BWbPlugin.pluginModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.certificateAliasFE, (Slot)BWbPlugin.pluginModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.certificatePasswordFE, (Slot)BWbPlugin.pluginModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.platformLogFE, (Slot)BLabel.actionPerformed, (Slot)setModified);
        this.linkTo(null, (BComponent)this.stationLogFE, (Slot)BLabel.actionPerformed, (Slot)setModified);
        this.linkTo(null, (BComponent)this.logLevelFilterFE, (Slot)BWbPlugin.pluginModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.stationAuditFE, (Slot)BLabel.actionPerformed, (Slot)setModified);
        this.linkTo(null, (BComponent)this.securityAuditFE, (Slot)BLabel.actionPerformed, (Slot)setModified);
        this.linkTo(null, (BComponent)this.facilityFE, (Slot)BWbPlugin.pluginModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.queueSizeFE, (Slot)BWbPlugin.pluginModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.syslogServerConnectionAlarmEnabled, (Slot)BLabel.actionPerformed, (Slot)setModified);
        this.linkTo(null, (BComponent)this.syslogServerConnectionAlarmSupportFE, (Slot)BWbPlugin.pluginModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.syslogMessageQueueAlarmEnabled, (Slot)BLabel.actionPerformed, (Slot)setModified);
        this.linkTo(null, (BComponent)this.syslogMessageQueueAlarmSupportFE, (Slot)BWbPlugin.pluginModified, (Slot)setModified);
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        BSyslogPlatformService service = (BSyslogPlatformService)value;
        BSyslogSettings settings = service.getSyslogSettings();
        if (!settings.getIsReadonly()) {
            settings.setEnabled(this.serviceEnabledFE.getSelected());
            String serverHost = this.serverHostFE.getText().trim();
            if (!IPAddressUtil.isHostname((String)serverHost) && !IPAddressUtil.isNumericAddr((String)serverHost)) {
                throw new CannotSaveException(LEX.getText("SyslogPlatformServicePlugin.invalidServerHost.error", cx, new Object[]{serverHost}));
            }
            settings.setServerHost(serverHost);
            settings.setServerPort(((BNumber)this.serverPortFE.saveValue()).getInt());
            settings.setTransportProtocol((BSyslogTransportProtocolEnum)this.transportProtocolFE.saveValue());
            settings.getClientAliasAndPassword().setAlias(String.valueOf(this.certificateAliasFE.saveValue()));
            settings.getClientAliasAndPassword().setPassword((BPassword)this.certificatePasswordFE.saveValue());
            settings.setPlatformLogEnabled(this.platformLogFE.getSelected());
            settings.setStationLogEnabled(this.stationLogFE.getSelected());
            settings.setLogLevelFilter((BSyslogLevelEnum)this.logLevelFilterFE.saveValue());
            settings.setStationAuditEnabled(this.stationAuditFE.getSelected());
            settings.setSecurityAuditEnabled(this.securityAuditFE.getSelected());
            settings.setFacility((BSyslogFacilityEnum)this.facilityFE.saveValue());
            settings.setQueueSize(((BNumber)this.queueSizeFE.saveValue()).getInt());
            service.setSyslogSettings(settings);
        }
        service.setSyslogServerConnectionAlarmEnabled(this.syslogServerConnectionAlarmEnabled.getSelected());
        service.setSyslogServerConnectionAlarmSupport((BPlatformAlarmSupport)this.syslogServerConnectionAlarmSupportFE.saveValue());
        service.setSyslogMessageQueueAlarmEnabled(this.syslogMessageQueueAlarmEnabled.getSelected());
        service.setSyslogMessageQueueAlarmSupport((BPlatformAlarmSupport)this.syslogMessageQueueAlarmSupportFE.saveValue());
        this.syslogServerConnectionAlarmSupportFE.loadValue((BObject)service.getSyslogServerConnectionAlarmSupport());
        this.syslogMessageQueueAlarmSupportFE.loadValue((BObject)service.getSyslogMessageQueueAlarmSupport());
        service.savePlatformServiceProperties();
        return value;
    }

    public void handleComponentEvent(BComponentEvent evt) {
        BValue propertyValue;
        Property property;
        boolean handled = false;
        if (evt.getSourceComponent() instanceof BSyslogSettings) {
            BSyslogSettings settings = (BSyslogSettings)evt.getSourceComponent();
            property = evt.getSlot().asProperty();
            propertyValue = settings.get(property);
            if (property == BSyslogSettings.enabled) {
                this.serviceEnabledFE.setSelected(((BIBoolean)propertyValue).getBoolean());
                this.doSetEnabledStates();
                handled = true;
            } else if (property == BSyslogSettings.serverHost) {
                this.serverHostFE.setText(propertyValue.toString());
                handled = true;
            } else if (property == BSyslogSettings.serverPort) {
                this.serverPortFE.loadValue((BObject)propertyValue, this.getCurrentContext());
                handled = true;
            } else if (property == BSyslogSettings.messageType) {
                this.messageTypeFE.setText(propertyValue.toString());
                handled = true;
            } else if (property == BSyslogSettings.transportProtocol) {
                this.transportProtocolFE.loadValue((BObject)propertyValue);
                handled = true;
            } else if (property == BSyslogSettings.clientAliasAndPassword) {
                BCertificateAliasAndPassword certificateAliasAndPassword = (BCertificateAliasAndPassword)propertyValue;
                if (this.certificateAliasFE != null) {
                    this.certificateAliasFE.loadValue((BObject)BString.make((String)certificateAliasAndPassword.getAlias()), this.getCurrentContext());
                }
                if (this.certificatePasswordFE != null) {
                    this.certificatePasswordFE.loadValue((BObject)certificateAliasAndPassword.getPassword(), this.getCurrentContext());
                }
            } else if (property == BSyslogSettings.platformLogEnabled) {
                this.platformLogFE.setSelected(((BIBoolean)propertyValue).getBoolean());
                handled = true;
            } else if (property == BSyslogSettings.stationLogEnabled) {
                this.stationLogFE.setSelected(((BIBoolean)propertyValue).getBoolean());
                handled = true;
            } else if (property == BSyslogSettings.logLevelFilter) {
                this.logLevelFilterFE.loadValue((BObject)propertyValue);
                handled = true;
            } else if (property == BSyslogSettings.stationAuditEnabled) {
                this.stationAuditFE.setSelected(((BIBoolean)propertyValue).getBoolean());
                handled = true;
            } else if (property == BSyslogSettings.securityAuditEnabled) {
                this.securityAuditFE.setSelected(((BIBoolean)propertyValue).getBoolean());
                handled = true;
            } else if (property == BSyslogSettings.facility) {
                this.facilityFE.loadValue((BObject)propertyValue);
                handled = true;
            } else if (property == BSyslogSettings.queueSize) {
                this.queueSizeFE.loadValue((BObject)propertyValue, this.getCurrentContext());
                handled = true;
            }
        }
        if (evt.getSourceComponent() instanceof BSyslogPlatformService) {
            BSyslogPlatformService syslogPlatformService = (BSyslogPlatformService)evt.getSourceComponent();
            property = evt.getSlot().asProperty();
            propertyValue = syslogPlatformService.get(property);
            if (property == BSyslogPlatformService.stationServerStatus) {
                if (this.stationServerStatusLabel != null) {
                    this.stationServerStatusLabel.setText(BSyslogPlatformServicePlugin.makeServerStatusString((BStatus)propertyValue, this.getCurrentContext()));
                    handled = true;
                }
            } else if (property == BSyslogPlatformService.queueFullPercentStation) {
                if (this.queueFullPercentStationLabel != null) {
                    this.queueFullPercentStationLabel.setText(propertyValue + "%");
                    handled = true;
                }
            } else if (property == BSyslogPlatformService.platformServerStatus) {
                if (this.platformServerStatusLabel != null) {
                    this.platformServerStatusLabel.setText(BSyslogPlatformServicePlugin.makeServerStatusString((BStatus)propertyValue, this.getCurrentContext()));
                    handled = true;
                }
            } else if (property == BSyslogPlatformService.queueFullPercentPlatform) {
                if (this.queueFullPercentPlatformLabel != null) {
                    this.queueFullPercentPlatformLabel.setText(propertyValue + "%");
                    handled = true;
                }
            } else if (property == BSyslogPlatformService.syslogServerConnectionAlarmEnabled) {
                this.syslogServerConnectionAlarmEnabled.setSelected(((BIBoolean)propertyValue).getBoolean());
                handled = true;
            } else if (property == BSyslogPlatformService.syslogServerConnectionAlarmSupport) {
                this.syslogServerConnectionAlarmSupportFE.loadValue((BObject)propertyValue);
                handled = true;
            } else if (property == BSyslogPlatformService.syslogMessageQueueAlarmEnabled) {
                this.syslogMessageQueueAlarmEnabled.setSelected(((BIBoolean)propertyValue).getBoolean());
                handled = true;
            } else if (property == BSyslogPlatformService.syslogMessageQueueAlarmSupport) {
                this.syslogMessageQueueAlarmSupportFE.loadValue((BObject)propertyValue);
                handled = true;
            }
        }
        if (handled) {
            this.getContent().relayout();
        } else {
            super.handleComponentEvent(evt);
        }
    }

    public static String makeServerStatusString(BStatus status, Context context) {
        if (status.isOk()) {
            return LEX.getText("SyslogPlatformServicePlugin.serverStatus.label.ok", context);
        }
        if (status.isDown()) {
            return LEX.getText("SyslogPlatformServicePlugin.serverStatus.label.down", context);
        }
        if (status.isDisabled()) {
            return LEX.getText("SyslogPlatformServicePlugin.serverStatus.label.disabled", context);
        }
        if (status.isNull()) {
            return LEX.getText("SyslogPlatformService.serverStatus.nullStatusReason.text", context);
        }
        return status.toString(context);
    }

    public void doSetEnabledStates() {
        boolean isEditorEnabled = this.serviceEnabledFE.getSelected() && !this.isSyslogSettingsReadonly;
        this.serverHostFE.setEnabled(isEditorEnabled);
        this.serverPortFE.setEnabled(isEditorEnabled);
        this.transportProtocolFE.setEnabled(isEditorEnabled);
        this.certificateAliasFE.setEnabled(isEditorEnabled);
        this.certificatePasswordFE.setEnabled(isEditorEnabled);
        this.platformLogFE.setEnabled(isEditorEnabled);
        this.stationLogFE.setEnabled(isEditorEnabled);
        this.logLevelFilterFE.setEnabled(isEditorEnabled);
        this.stationAuditFE.setEnabled(isEditorEnabled);
        this.securityAuditFE.setEnabled(isEditorEnabled);
        this.facilityFE.setEnabled(isEditorEnabled);
        this.queueSizeFE.setEnabled(isEditorEnabled);
        isEditorEnabled = this.serviceEnabledFE.getSelected();
        this.syslogServerConnectionAlarmEnabled.setEnabled(isEditorEnabled);
        this.syslogServerConnectionAlarmSupportFE.setEnabled(isEditorEnabled);
        this.syslogMessageQueueAlarmEnabled.setEnabled(isEditorEnabled);
        this.syslogMessageQueueAlarmSupportFE.setEnabled(isEditorEnabled);
    }
}

