/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.hx.util;

import com.tridium.platform.hx.util.HxViewHelper;
import java.util.HashMap;
import java.util.Map;
import javax.baja.hx.BHxFieldEditor;
import javax.baja.hx.BHxView;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.OrdTarget;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.util.BFormat;

public class HxBooleanHelper
extends HxViewHelper {
    private Map<?, ?> attrs;

    protected HxBooleanHelper(String fieldName, Map<?, ?> attrs, BFacets facets) {
        super(fieldName, null, facets);
        this.attrs = attrs;
    }

    protected HxBooleanHelper(String fieldName, BHxView view, BFacets facets) {
        super(fieldName, view, facets);
        this.attrs = new HashMap();
    }

    public static HxViewHelper makeFE(String fieldName, Context cx) {
        return HxBooleanHelper.makeFE(fieldName, new HashMap(), cx);
    }

    public static HxViewHelper makeFE(String fieldName, Map<?, ?> attrs, Context cx) {
        return new HxBooleanHelper(fieldName, attrs == null ? new HashMap() : attrs, cx == null ? BFacets.NULL : cx.getFacets());
    }

    public static HxBooleanHelper makeFE(String fieldName, BValue value, BFacets facets) {
        return new HxBooleanHelper(fieldName, (BHxView)BHxFieldEditor.makeFor((BObject)value, (Context)facets.getBase()), facets);
    }

    @Override
    public void write(BObject value, HxOp op) throws Exception {
        HxOp fieldOp = op.make(this.fieldName, new OrdTarget((OrdTarget)op, value));
        fieldOp.mergeFacets(this.facets);
        fieldOp.setReadonly(this.isReadonly());
        BBoolean b = (BBoolean)value;
        HtmlWriter out = fieldOp.getHtmlWriter();
        String falseText = BBoolean.toString((boolean)false, (Context)op);
        String trueText = BBoolean.toString((boolean)true, (Context)op);
        BObject t = fieldOp.getFacet("trueText");
        BObject f = fieldOp.getFacet("falseText");
        if (t != null) {
            trueText = BFormat.format((String)t.toString(), null, (Context)fieldOp);
        }
        if (f != null) {
            falseText = BFormat.format((String)f.toString(), null, (Context)fieldOp);
        }
        out.w((Object)"<select ").attr("name", fieldOp.scope("value"));
        if (!fieldOp.canWrite()) {
            out.w((Object)" disabled='disabled'");
        }
        for (Object k : this.attrs.keySet()) {
            out.w((Object)" ").attr(k.toString(), this.attrs.get(k).toString());
        }
        out.w((Object)">");
        out.w((Object)"<option value='false'");
        if (!b.getBoolean()) {
            out.w((Object)" selected='selected'");
        }
        out.w((Object)">").safe((Object)falseText).w((Object)"</option>");
        out.w((Object)"<option value='true'");
        if (b.getBoolean()) {
            out.w((Object)" selected='selected'");
        }
        out.w((Object)">").safe((Object)trueText).w((Object)"</option>");
        out.w((Object)"</select>");
    }

    @Override
    public BObject save(BObject valueIn, HxOp op) throws Exception {
        HxOp fieldOp = op.make(this.fieldName, new OrdTarget((OrdTarget)op, valueIn));
        String value = fieldOp.getFormValue("value");
        return value.equals("true") ? BBoolean.TRUE : BBoolean.FALSE;
    }

    @Override
    public boolean isFormValueAvailable(HxOp op) {
        return !this.isReadonly() && op.make(this.fieldName, (OrdTarget)op).getFormValue("value") != null;
    }
}

