/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.hx;

import com.tridium.platform.BEngineWatchdogPolicy;
import com.tridium.platform.BFilesystemAttributes;
import com.tridium.platform.BPlatformServiceContainer;
import com.tridium.platform.BSystemPlatformService;
import com.tridium.platform.daemon.BDaemonAccessLevel;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.hx.util.HxBooleanHelper;
import com.tridium.platform.hx.util.HxButtonHelper;
import com.tridium.platform.hx.util.HxMessageHelper;
import com.tridium.platform.hx.util.HxStringHelper;
import com.tridium.platform.hx.util.HxTimeZoneHelper;
import com.tridium.platform.hx.util.HxViewHelper;
import com.tridium.platform.hx.util.NotNullStringValidator;
import com.tridium.platform.hx.util.SimpleValidator;
import com.tridium.platform.npsdk.BSystemPlatformServiceNpsdk;
import com.tridium.platform.qnx.BSystemPlatformServiceQnx;
import com.tridium.platform.qnx.BSystemPlatformServiceQnxJavelina;
import com.tridium.platform.qnx.BSystemPlatformServiceQnxLegacy;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.hx.BHxView;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;

@NiagaraType(agent={@AgentOn(types={"platform:PlatformServiceContainerPlugin", "platform:SystemPlatformServicePlugin", "platform:SystemPlatformServiceQnxPlugin", "platform:SystemPlatformServiceNpsdkPlugin"}, requiredPermissions="W")})
@NiagaraSingleton
public class BHxSystemPlatformServiceEditor
extends BHxView {
    @Generated
    public static final BHxSystemPlatformServiceEditor INSTANCE = new BHxSystemPlatformServiceEditor();
    @Generated
    public static final Type TYPE = Sys.loadType(BHxSystemPlatformServiceEditor.class);
    HxViewHelper localeFE;
    HxViewHelper timeZoneFE;
    HxViewHelper engineWatchdogPolicyFE;
    HxViewHelper engineWatchdogTimeoutFE;
    HxViewHelper stationAutoSaveFrequencyFE;
    HxViewHelper stationSaveBackupCountFE;
    HxViewHelper isStationAutoSaveEnabledFE;
    HxButtonHelper refreshButton;
    HxButtonHelper saveButton;
    HxViewHelper failureRebootLimitFE;
    HxViewHelper failureRebootLimitPeriodFE;
    HxViewHelper ramDiskMinFreeFE;
    HxViewHelper javaHeapMinFreeFE;
    HxViewHelper openFileDescriptorsMinFreeFE;
    HxViewHelper freeRamMinFreeFE;
    HxViewHelper diskSpaceMinFreeFE;
    HxViewHelper minFileFreeFE;
    HxViewHelper batteryPresentFE;
    HxViewHelper tamperSwitchEnabledFE;
    private static final Lexicon lex = Lexicon.make((String)"platform");
    private static final Logger log = Logger.getLogger("platform");

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BHxSystemPlatformServiceEditor() {
        BSystemPlatformService sys;
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("onChange", "onLocaleChanged(event)");
        this.localeFE = HxStringHelper.makeFE("locale", attrs, (SimpleValidator)NotNullStringValidator.INSTANCE, (Context)BSystemPlatformService.locale.getFacets());
        attrs = new HashMap();
        attrs.put("onChange", "onTimeZoneChanged(event)");
        this.timeZoneFE = HxTimeZoneHelper.makeFE("timeZone", attrs, (Context)BSystemPlatformService.timeZone.getFacets());
        this.engineWatchdogPolicyFE = HxViewHelper.makeFE("engineWatchdogPolicy", (BObject)BEngineWatchdogPolicy.terminate, (Context)BSystemPlatformService.engineWatchdogPolicy.getFacets());
        this.engineWatchdogTimeoutFE = HxViewHelper.makeFE("engineWatchdogTimeout", (BObject)BRelTime.DEFAULT, (Context)BSystemPlatformService.engineWatchdogTimeout.getFacets());
        BFacets trueFalseFacets = BFacets.make((String[])new String[]{"trueText", "falseText"}, (BIDataValue[])new BString[]{BString.make((String)"%lexicon(platform:labels.system.isStationAutoSaveEnabled.true)%"), BString.make((String)"%lexicon(platform:labels.system.isStationAutoSaveEnabled.false)%")});
        attrs = new HashMap();
        attrs.put("onChange", "onEnableStationAutoSaveChanged(event)");
        this.isStationAutoSaveEnabledFE = HxBooleanHelper.makeFE("isStationAutoSaveEnabled", attrs, (Context)trueFalseFacets);
        this.stationAutoSaveFrequencyFE = HxViewHelper.makeFE("stationAutoSaveFrequency", (BObject)BRelTime.DEFAULT, (Context)BSystemPlatformService.stationAutoSaveFrequency.getFacets());
        this.stationSaveBackupCountFE = HxViewHelper.makeFE("stationSaveBackupCount", (BObject)BInteger.DEFAULT, (Context)BSystemPlatformService.stationSaveBackupCount.getFacets());
        this.refreshButton = HxButtonHelper.makeRefresh();
        this.saveButton = HxButtonHelper.makeSave();
        try {
            sys = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
        }
        catch (ServiceNotFoundException e) {
            if (Sys.getStation() != null && log != null) {
                log.log(Level.SEVERE, "Failed to resolve BSystemPlatformService in BHxSystemPlatformServiceEditor, service editors may be missing", e);
            }
            return;
        }
        sys.poll();
        if (sys instanceof BSystemPlatformServiceQnx || sys instanceof BSystemPlatformServiceNpsdk) {
            boolean npsdk = sys instanceof BSystemPlatformServiceNpsdk;
            this.failureRebootLimitFE = HxViewHelper.makeFE("failureRebootLimit", (BObject)BInteger.DEFAULT, (Context)(npsdk ? BSystemPlatformServiceNpsdk.failureRebootLimit.getFacets() : BSystemPlatformServiceQnx.failureRebootLimit.getFacets()));
            this.failureRebootLimitPeriodFE = HxViewHelper.makeFE("failureRebootLimitPeriod", (BObject)BRelTime.DEFAULT, (Context)(npsdk ? BSystemPlatformServiceNpsdk.failureRebootLimitPeriod.getFacets() : BSystemPlatformServiceQnx.failureRebootLimitPeriod.getFacets()));
            if (sys instanceof BSystemPlatformServiceQnx) {
                this.ramDiskMinFreeFE = HxViewHelper.makeFE("ramDiskMinFree", (BObject)BInteger.DEFAULT, (Context)BSystemPlatformServiceQnx.minFreeRamDiskPercentage.getFacets());
            }
            this.javaHeapMinFreeFE = HxViewHelper.makeFE("javaHeapMinFree", (BObject)BInteger.DEFAULT, (Context)(npsdk ? BSystemPlatformServiceNpsdk.minFreeHeap.getFacets() : BSystemPlatformServiceQnx.minFreeHeap.getFacets()));
            this.openFileDescriptorsMinFreeFE = HxViewHelper.makeFE("openFileDescriptorsMinFree", (BObject)BInteger.DEFAULT, (Context)(npsdk ? BSystemPlatformServiceNpsdk.minFreeFileDescriptors.getFacets() : BSystemPlatformServiceQnx.minFreeFileDescriptors.getFacets()));
            this.freeRamMinFreeFE = HxViewHelper.makeFE("freeRamMinFree", (BObject)BInteger.DEFAULT, (Context)(npsdk ? BSystemPlatformServiceNpsdk.minFreePhysicalMemory.getFacets() : BSystemPlatformServiceQnx.minFreePhysicalMemory.getFacets()));
            this.diskSpaceMinFreeFE = HxViewHelper.makeFE("diskSpaceMinFree", (BObject)BInteger.DEFAULT, (Context)(npsdk ? BSystemPlatformServiceNpsdk.minFreeDiskPercentage.getFacets() : BSystemPlatformServiceQnx.minFreeDiskPercentage.getFacets()));
            this.minFileFreeFE = HxViewHelper.makeFE("minFileFree", (BObject)BInteger.DEFAULT, (Context)(npsdk ? BSystemPlatformServiceNpsdk.minAvailableFiles.getFacets() : BSystemPlatformServiceQnx.minAvailableFiles.getFacets()));
            if (sys instanceof BSystemPlatformServiceQnxLegacy) {
                this.batteryPresentFE = HxBooleanHelper.makeFE("batteryPresent", (BValue)BBoolean.FALSE, trueFalseFacets);
            }
            if (sys instanceof BSystemPlatformServiceQnxJavelina) {
                this.tamperSwitchEnabledFE = HxBooleanHelper.makeFE("tamperSwitchEnabled", (BValue)BBoolean.DEFAULT, trueFalseFacets);
            }
        }
    }

    public void write(HxOp op) throws Exception {
        String fipsStatus;
        boolean showFileCount;
        BOrd ord = BOrd.make((String)"module://platform/lib/BHxSystemPlatformServiceEditor.js");
        op.addJavaScript(ord);
        BSystemPlatformService service = BHxSystemPlatformServiceEditor.getSystemPlatformService(op);
        service.checkPropertiesLoaded();
        service.poll();
        HtmlWriter out = op.getHtmlWriter();
        HxMessageHelper.writeMessage("SystemPlatformServiceEditor", op);
        boolean restricted = !op.canWrite() || service.getIsServiceReadonly();
        boolean timeReadonly = !op.canWrite() || service.getIsSystemTimeReadonly() || service.getIsServiceReadonly();
        this.timeZoneFE.setReadonly(timeReadonly);
        this.localeFE.setReadonly(!op.canWrite());
        this.engineWatchdogPolicyFE.setReadonly(!op.canWrite());
        this.engineWatchdogTimeoutFE.setReadonly(!op.canWrite());
        this.isStationAutoSaveEnabledFE.setReadonly(!op.canWrite());
        this.stationAutoSaveFrequencyFE.setReadonly(!op.canWrite());
        this.stationSaveBackupCountFE.setReadonly(!op.canWrite());
        this.saveButton.setReadonly(!op.canWrite());
        if (service instanceof BSystemPlatformServiceQnx || service instanceof BSystemPlatformServiceNpsdk) {
            this.failureRebootLimitFE.setReadonly(!op.canWrite());
            this.failureRebootLimitPeriodFE.setReadonly(!op.canWrite());
            if (service instanceof BSystemPlatformServiceQnx) {
                this.ramDiskMinFreeFE.setReadonly(!op.canWrite());
            }
            this.javaHeapMinFreeFE.setReadonly(!op.canWrite());
            this.openFileDescriptorsMinFreeFE.setReadonly(!op.canWrite());
            this.freeRamMinFreeFE.setReadonly(!op.canWrite());
            this.diskSpaceMinFreeFE.setReadonly(!op.canWrite());
            this.minFileFreeFE.setReadonly(!op.canWrite());
            if (service instanceof BSystemPlatformServiceQnxLegacy) {
                this.batteryPresentFE.setReadonly(!op.canWrite());
            }
            if (service instanceof BSystemPlatformServiceQnxJavelina) {
                this.tamperSwitchEnabledFE.setReadonly(!op.canWrite());
            }
        }
        out.w((Object)"<input type='hidden' name='").w((Object)op.scope("operatorCanWrite")).println("' value='" + op.canWrite() + "'/>");
        out.w((Object)"<input type='hidden' name='").w((Object)op.scope("systemRestart")).println("' value='false'/>");
        out.w((Object)"<input type='hidden' name='").w((Object)op.scope("systemReboot")).println("' value='false'/>");
        out.w((Object)"<input type='hidden' name='").w((Object)op.scope("restartEnabled")).w((Object)"' value='");
        if (op.canWrite() && service.getAllowStationRestart()) {
            out.w((Object)"true");
        } else {
            out.w((Object)"false");
        }
        out.println("'/>");
        out.w((Object)"<input type='hidden' name='").w((Object)op.scope("isStationAutoSaveEnabled")).w((Object)"' value='");
        out.w(service.getIsStationAutoSaveEnabled()).println("'/>");
        out.println("<table cellpadding='5'>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"labels.system.name").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
        out.w((Object)"<td>");
        out.safe((Object)service.getStationName());
        out.w((Object)"</td>");
        out.println("</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"labels.system.host").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
        out.w((Object)"<td>");
        BHost hostFromOrd = BOrd.toHost((BObject)service);
        out.safe((Object)(hostFromOrd != null ? hostFromOrd.getNavDisplayName(null) : LexiconText.make((Type)TYPE, (String)"system.unknownHost").getHtmlSafeText((Context)op)));
        out.w((Object)"</td>");
        out.println("</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"labels.system.model").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
        out.w((Object)"<td>");
        out.safe((Object)service.getModel());
        out.w((Object)"</td>");
        out.println("</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"labels.system.modelVersion").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
        out.w((Object)"<td>");
        out.safe((Object)service.getModelVersion());
        out.w((Object)"</td>");
        out.println("</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"labels.system.product").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
        out.w((Object)"<td>");
        out.safe((Object)service.getProduct());
        out.w((Object)"</td>");
        out.println("</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"labels.system.hostId").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
        out.w((Object)"<td>");
        out.safe((Object)service.getHostId());
        out.w((Object)"</td>");
        out.println("</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"labels.system.niagaraVersion").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
        out.w((Object)"<td>");
        out.safe((Object)service.getNiagaraVersion());
        out.w((Object)"</td>");
        out.println("</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"labels.system.javaVmName").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
        out.w((Object)"<td>");
        out.safe((Object)service.getJavaVmName());
        out.w((Object)"</td>");
        out.println("</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"labels.system.javaVmVendor").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
        out.w((Object)"<td>");
        out.safe((Object)service.getJavaVmVendor());
        out.w((Object)"</td>");
        out.println("</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"labels.system.javaVmVersion").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
        out.w((Object)"<td>");
        out.safe((Object)service.getJavaVmVersion());
        out.w((Object)"</td>");
        out.println("</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"labels.system.osName").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
        out.w((Object)"<td>");
        out.safe((Object)service.getOsName());
        out.w((Object)"</td>");
        out.println("</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"labels.system.osArch").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
        out.w((Object)"<td>");
        out.safe((Object)service.getOsArch());
        out.w((Object)"</td>");
        out.println("</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"labels.system.osVersion").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
        out.w((Object)"<td>");
        out.safe((Object)service.getOsVersion());
        out.w((Object)"</td>");
        out.println("</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"labels.system.daemonPort").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
        out.w((Object)"<td>");
        out.safe((Object)Integer.toString(service.getLocalDaemonPort()));
        out.w((Object)"</td>");
        out.println("</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"labels.system.locale").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
        out.w((Object)"<td>");
        this.localeFE.write((BObject)service.get(BSystemPlatformService.locale), op);
        out.w((Object)"</td>");
        out.println("</tr>");
        BTimeZone tz = service.getTimeZone();
        BAbsTime sysTime = BAbsTime.make((long)service.getSystemTime().getMillis(), (BTimeZone)tz);
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"labels.system.systemTime").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
        out.w((Object)"<td>");
        BasicContext cx = new BasicContext(null, BFacets.make((String)"timeFormat", (String)"DD-MMM-YYYY h:mm:ss a z"));
        out.safe((Object)sysTime.toString((Context)cx));
        out.w((Object)"</td>");
        out.println("</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"labels.system.systemTimeZone").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
        out.w((Object)"<td>");
        this.timeZoneFE.write((BObject)tz, op);
        out.w((Object)"</td>");
        out.println("</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"labels.system.engineWatchdogPolicy").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
        out.w((Object)"<td>");
        this.engineWatchdogPolicyFE.write((BObject)service.get(BSystemPlatformService.engineWatchdogPolicy), op);
        out.w((Object)"</td>");
        out.println("</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"labels.system.engineWatchdogTimeout").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
        out.w((Object)"<td>");
        this.engineWatchdogTimeoutFE.write((BObject)service.get(BSystemPlatformService.engineWatchdogTimeout), op);
        out.w((Object)"</td>");
        out.println("</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"labels.system.isStationAutoSaveEnabled").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
        out.w((Object)"<td>");
        this.isStationAutoSaveEnabledFE.write((BObject)service.get(BSystemPlatformService.isStationAutoSaveEnabled), op);
        out.w((Object)"</td>");
        out.println("</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"labels.system.stationAutoSaveFrequency").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
        out.w((Object)"<td>");
        this.stationAutoSaveFrequencyFE.write((BObject)service.get(BSystemPlatformService.stationAutoSaveFrequency), op);
        out.w((Object)"</td>");
        out.println("</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"labels.system.stationSaveBackupCount").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
        out.w((Object)"<td>");
        this.stationSaveBackupCountFE.write((BObject)service.get(BSystemPlatformService.stationSaveBackupCount), op);
        out.w((Object)"</td>");
        out.println("</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"labels.system.numCpus").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
        out.w((Object)"<td>");
        out.w(service.getNumCpus());
        out.w((Object)"</td>");
        out.println("</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"labels.system.currentCpuUsage").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
        out.w((Object)"<td>");
        out.w(service.getCurrentCpuUsage()).w((Object)"%");
        out.w((Object)"</td>");
        out.println("</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"labels.system.overallCpuUsage").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
        out.w((Object)"<td>");
        out.w(service.getOverallCpuUsage()).w((Object)"%");
        out.w((Object)"</td>");
        out.println("</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"labels.system.filesystem").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
        out.w((Object)"<td>");
        out.w((Object)"<table cellpadding='5'>");
        out.w((Object)"<tr>");
        out.w((Object)"<td></td>");
        out.w((Object)"<td align='left'><b>").w((Object)LexiconText.make((Type)TYPE, (String)"labels.system.totalKb").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
        out.w((Object)"<td align='left'><b>").w((Object)LexiconText.make((Type)TYPE, (String)"labels.system.freeKb").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
        boolean bl = showFileCount = service instanceof BSystemPlatformServiceQnx || service instanceof BSystemPlatformServiceNpsdk;
        if (showFileCount) {
            out.w((Object)"<td align='left'><b>").w((Object)LexiconText.make((Type)TYPE, (String)"labels.system.currentFileCount").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
            out.w((Object)"<td align='left'><b>").w((Object)LexiconText.make((Type)TYPE, (String)"labels.system.maxFileCount").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
        }
        out.w((Object)"</tr>");
        DecimalFormat kbFormat = (DecimalFormat)DaemonFileUtil.kbFormat.get();
        BVector filesystemAttributes = service.getFilesystemAttributes();
        SlotCursor attributesCursor = filesystemAttributes.loadSlots().getProperties();
        while (attributesCursor.next(BFilesystemAttributes.class)) {
            Property attributesProperty = attributesCursor.property();
            if ((filesystemAttributes.getFlags((Slot)attributesProperty) & 4) != 0) continue;
            BFilesystemAttributes attrs = (BFilesystemAttributes)attributesCursor.get();
            out.w((Object)"<tr>");
            out.w((Object)"<td>").w((Object)SlotPath.unescape((String)filesystemAttributes.getDisplayName((Slot)attributesProperty, (Context)cx))).w((Object)"</td>");
            out.w((Object)"<td align='right'>");
            out.w((Object)kbFormat.format(attrs.getTotalSpace()));
            out.w((Object)"</td>");
            out.w((Object)"<td align='right'>");
            out.w((Object)kbFormat.format(attrs.getFreeSpace()));
            out.w((Object)"</td>");
            if (showFileCount) {
                String currentFileText = attrs.getCurrentFileCount() < 0L ? this.getLexicon().getText("labels.system.fileCount.unavailable") : String.valueOf(attrs.getCurrentFileCount());
                String maxFileText = attrs.getMaxFileCount() < 0L ? this.getLexicon().getText("labels.system.fileCount.unavailable") : String.valueOf(attrs.getMaxFileCount());
                out.w((Object)"<td align='right'>");
                out.w((Object)currentFileText);
                out.w((Object)"</td>");
                out.w((Object)"<td align='right'>");
                out.w((Object)maxFileText);
                out.w((Object)"</td>");
            }
            out.w((Object)"</tr>");
        }
        out.w((Object)"</table>");
        out.w((Object)"</td>");
        out.println("</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"labels.system.physicalMemory").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
        out.w((Object)"<td>");
        out.w((Object)"<table cellpadding='5'>");
        out.w((Object)"<tr>");
        out.w((Object)"<td align='left'><b>").w((Object)LexiconText.make((Type)TYPE, (String)"labels.system.totalKb").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
        out.w((Object)"<td align='left'><b>").w((Object)LexiconText.make((Type)TYPE, (String)"labels.system.freeKb").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
        out.w((Object)"</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td align='right'>").w((Object)kbFormat.format(service.getTotalPhysicalMemory())).w((Object)"</td>");
        out.w((Object)"<td align='right'>").w((Object)kbFormat.format(service.getFreePhysicalMemory())).w((Object)"</td>");
        out.w((Object)"</tr>");
        out.w((Object)"</table>");
        out.w((Object)"</td>");
        out.println("</tr>");
        if (service instanceof BSystemPlatformServiceQnx || service instanceof BSystemPlatformServiceNpsdk) {
            BSystemPlatformServiceQnx sq;
            boolean npsdk = service instanceof BSystemPlatformServiceNpsdk;
            String platformLexiconName = npsdk ? "" : ".qnx";
            out.w((Object)"<tr>");
            out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)("labels.system" + platformLexiconName + ".serialNumber")).getHtmlSafeText((Context)op)).w((Object)"</b></td>");
            out.w((Object)"<td>");
            out.w((Object)String.valueOf(service.get("serialNumber")));
            out.w((Object)"</td>");
            out.println("</tr>");
            if (service instanceof BSystemPlatformServiceQnx) {
                sq = (BSystemPlatformServiceQnx)service;
                out.w((Object)"<tr>");
                out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)("labels.system" + platformLexiconName + ".hardwareRevision")).getHtmlSafeText((Context)op)).w((Object)"</b></td>");
                out.w((Object)"<td>");
                out.w((Object)String.valueOf(sq.getHardwareRevision()));
                out.w((Object)"</td>");
                out.println("</tr>");
            }
            if (service instanceof BSystemPlatformServiceQnxLegacy) {
                BSystemPlatformServiceQnxLegacy sql = (BSystemPlatformServiceQnxLegacy)service;
                out.w((Object)"<tr>");
                out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)("labels.system" + platformLexiconName + ".isJumperPresent")).getHtmlSafeText((Context)op)).w((Object)"</b></td>");
                out.w((Object)"<td>");
                out.w((Object)String.valueOf(sql.getIsJumperPresent()));
                out.w((Object)"</td>");
                out.println("</tr>");
                out.w((Object)"<tr>");
                out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)("labels.system" + platformLexiconName + ".isBatteryPresent")).getHtmlSafeText((Context)op)).w((Object)"</b></td>");
                out.w((Object)"<td>");
                this.batteryPresentFE.write((BObject)sql.get(BSystemPlatformServiceQnxLegacy.isBatteryPresent), op);
                out.w((Object)"</td>");
                out.println("</tr>");
            }
            out.w((Object)"<tr>");
            out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"labels.system.failureRebootLimit").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
            out.w((Object)"<td>");
            this.failureRebootLimitFE.write((BObject)service.get("failureRebootLimit"), op);
            out.w((Object)"</td>");
            out.println("</tr>");
            out.w((Object)"<tr>");
            out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"labels.system.failureRebootLimitPeriod").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
            out.w((Object)"<td>");
            this.failureRebootLimitPeriodFE.write((BObject)service.get("failureRebootLimitPeriod"), op);
            out.w((Object)"</td>");
            out.println("</tr>");
            out.w((Object)"<table>");
            if (service instanceof BSystemPlatformServiceQnx) {
                sq = (BSystemPlatformServiceQnx)service;
                out.w((Object)"<tr>");
                out.w((Object)"<td width='206'><b>").w((Object)LexiconText.make((Type)TYPE, (String)("labels.system" + platformLexiconName + ".ramDisk")).getHtmlSafeText((Context)op)).w((Object)"</b></td>");
                out.w((Object)"<td>");
                out.w((Object)"<table cellpadding='5'>");
                out.w((Object)"<tr>");
                out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)("labels.system" + platformLexiconName + ".minFree")).getHtmlSafeText((Context)op)).w((Object)"</b></td>");
                out.w((Object)"</tr>");
                out.w((Object)"<tr>");
                out.w((Object)"<td>");
                this.ramDiskMinFreeFE.write((BObject)sq.get(BSystemPlatformServiceQnx.minFreeRamDiskPercentage), op);
                out.w((Object)"</td>");
                out.w((Object)"</tr>");
                out.w((Object)"</table>");
                out.w((Object)"</td>");
                out.w((Object)"<td>");
                out.w((Object)"<table cellpadding='5'>");
                out.w((Object)"<tr>");
                out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)("labels.system" + platformLexiconName + ".max")).getHtmlSafeText((Context)op)).w((Object)"</b></td>");
                out.w((Object)"</tr>");
                out.w((Object)"<tr>");
                out.w((Object)"<td>");
                out.w((Object)String.valueOf(sq.getRamDiskSize())).w((Object)"&nbsp;").w((Object)LexiconText.make((Type)TYPE, (String)("labels.system" + platformLexiconName + ".ramDiskSizeUnits")).getHtmlSafeText((Context)op));
                out.w((Object)"</td>");
                out.w((Object)"</tr>");
                out.w((Object)"</table>");
                out.w((Object)"</td>");
                out.w((Object)"<td>");
                out.w((Object)"</td>");
                out.w((Object)"<td>");
                out.w((Object)"<table cellpadding='5'>");
                out.w((Object)"<tr>");
                out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)("labels.system" + platformLexiconName + ".status")).getHtmlSafeText((Context)op)).w((Object)"</b></td>");
                out.w((Object)"</tr>");
                out.w((Object)"<tr>");
                if (sq.getLowRamDiskSpace()) {
                    out.w((Object)"<td>").w((Object)LexiconText.make((Type)TYPE, (String)("labels.system" + platformLexiconName + ".lowRamDiskSpace")).getHtmlSafeText((Context)op)).w((Object)"</td>");
                } else {
                    out.w((Object)"<td>").w((Object)LexiconText.make((Type)TYPE, (String)("labels.system" + platformLexiconName + ".ok")).getHtmlSafeText((Context)op)).w((Object)"</td>");
                }
                out.w((Object)"</tr>");
                out.w((Object)"</table>");
                out.w((Object)"</td>");
                out.w((Object)"</tr>");
            }
            out.w((Object)"<tr>");
            out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)("labels.system" + platformLexiconName + ".javaHeap")).getHtmlSafeText((Context)op)).w((Object)"</b></td>");
            out.w((Object)"<td>");
            out.w((Object)"<table cellpadding='5'>");
            out.w((Object)"<tr>");
            out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)("labels.system" + platformLexiconName + ".minFree")).getHtmlSafeText((Context)op)).w((Object)"</b></td>");
            out.w((Object)"</tr>");
            out.w((Object)"<tr>");
            out.w((Object)"<td>");
            this.javaHeapMinFreeFE.write((BObject)service.get("minFreeHeap"), op);
            out.w((Object)"&nbsp;").w((Object)LexiconText.make((Type)TYPE, (String)("labels.system" + platformLexiconName + ".freeHeapUnits")).getHtmlSafeText((Context)op));
            out.w((Object)"</td>");
            out.w((Object)"</tr>");
            out.w((Object)"</table>");
            out.w((Object)"</td>");
            out.w((Object)"<td>");
            out.w((Object)"<table cellpadding='5'>");
            out.w((Object)"<tr>");
            out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)("labels.system" + platformLexiconName + ".max")).getHtmlSafeText((Context)op)).w((Object)"</b></td>");
            out.w((Object)"</tr>");
            out.w((Object)"<tr>");
            out.w((Object)"<td>").w((Object)String.valueOf(service.get("maxHeap"))).w((Object)"&nbsp;").w((Object)LexiconText.make((Type)TYPE, (String)("labels.system" + platformLexiconName + ".freeHeapUnits")).getHtmlSafeText((Context)op)).w((Object)"</td>");
            out.w((Object)"</tr>");
            out.w((Object)"</table>");
            out.w((Object)"</td>");
            out.w((Object)"<td>");
            out.w((Object)"<table cellpadding='5'>");
            out.w((Object)"<tr>");
            out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)("labels.system" + platformLexiconName + ".free")).getHtmlSafeText((Context)op)).w((Object)"</b></td>");
            out.w((Object)"</tr>");
            out.w((Object)"<tr>");
            out.w((Object)"<td>").w((Object)String.valueOf(service.get("freeHeap"))).w((Object)"&nbsp;").w((Object)LexiconText.make((Type)TYPE, (String)("labels.system" + platformLexiconName + ".freeHeapUnits")).getHtmlSafeText((Context)op)).w((Object)"</td>");
            out.w((Object)"</tr>");
            out.w((Object)"</table>");
            out.w((Object)"</td>");
            out.w((Object)"<td>");
            out.w((Object)"<table cellpadding='5'>");
            out.w((Object)"<tr>");
            out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)("labels.system" + platformLexiconName + ".status")).getHtmlSafeText((Context)op)).w((Object)"</b></td>");
            out.w((Object)"</tr>");
            out.w((Object)"<tr>");
            if (((BBoolean)service.get("lowHeap")).getBoolean()) {
                out.w((Object)"<td>").w((Object)LexiconText.make((Type)TYPE, (String)("labels.system" + platformLexiconName + ".lowHeap")).getHtmlSafeText((Context)op)).w((Object)"</td>");
            } else {
                out.w((Object)"<td>").w((Object)LexiconText.make((Type)TYPE, (String)("labels.system" + platformLexiconName + ".ok")).getHtmlSafeText((Context)op)).w((Object)"</td>");
            }
            out.w((Object)"</tr>");
            out.w((Object)"</table>");
            out.w((Object)"</td>");
            out.w((Object)"</tr>");
            out.w((Object)"<tr>");
            out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)("labels.system" + platformLexiconName + ".fileDescriptors")).getHtmlSafeText((Context)op)).w((Object)"</b></td>");
            out.w((Object)"<td>");
            out.w((Object)"<table cellpadding='5'>");
            out.w((Object)"<tr>");
            out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)("labels.system" + platformLexiconName + ".minFree")).getHtmlSafeText((Context)op)).w((Object)"</b></td>");
            out.w((Object)"</tr>");
            out.w((Object)"<tr>");
            out.w((Object)"<td>");
            this.openFileDescriptorsMinFreeFE.write((BObject)service.get("minFreeFileDescriptors"), op);
            out.w((Object)"</td>");
            out.w((Object)"</tr>");
            out.w((Object)"</table>");
            out.w((Object)"</td>");
            out.w((Object)"<td>");
            out.w((Object)"<table cellpadding='5'>");
            out.w((Object)"<tr>");
            out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)("labels.system" + platformLexiconName + ".maxOpen")).getHtmlSafeText((Context)op)).w((Object)"</b></td>");
            out.w((Object)"</tr>");
            out.w((Object)"<tr>");
            out.w((Object)"<td>").w((Object)String.valueOf(service.get("maxOpenFileDescriptors"))).w((Object)"</td>");
            out.w((Object)"</tr>");
            out.w((Object)"</table>");
            out.w((Object)"</td>");
            out.w((Object)"<td>");
            out.w((Object)"<table cellpadding='5'>");
            out.w((Object)"<tr>");
            out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)("labels.system" + platformLexiconName + ".free")).getHtmlSafeText((Context)op)).w((Object)"</b></td>");
            out.w((Object)"</tr>");
            out.w((Object)"<tr>");
            out.w((Object)"<td>").w((Object)String.valueOf(((BInteger)service.get("maxOpenFileDescriptors")).getInt() - ((BInteger)service.get("openFileDescriptors")).getInt())).w((Object)"</td>");
            out.w((Object)"</tr>");
            out.w((Object)"</table>");
            out.w((Object)"</td>");
            out.w((Object)"<td>");
            out.w((Object)"<table cellpadding='5'>");
            out.w((Object)"<tr>");
            out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)("labels.system" + platformLexiconName + ".status")).getHtmlSafeText((Context)op)).w((Object)"</b></td>");
            out.w((Object)"</tr>");
            out.w((Object)"<tr>");
            if (((BBoolean)service.get("tooManyOpenFiles")).getBoolean()) {
                out.w((Object)"<td>").w((Object)LexiconText.make((Type)TYPE, (String)("labels.system" + platformLexiconName + ".tooManyOpenFiles")).getHtmlSafeText((Context)op)).w((Object)"</td>");
            } else {
                out.w((Object)"<td>").w((Object)LexiconText.make((Type)TYPE, (String)("labels.system" + platformLexiconName + ".ok")).getHtmlSafeText((Context)op)).w((Object)"</td>");
            }
            out.w((Object)"</tr>");
            out.w((Object)"</table>");
            out.w((Object)"</td>");
            out.w((Object)"</tr>");
            out.w((Object)"<tr>");
            out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)("labels.system" + platformLexiconName + ".physMemoryLimits")).getHtmlSafeText((Context)op)).w((Object)"</b></td>");
            out.w((Object)"<td>");
            out.w((Object)"<table cellpadding='5'>");
            out.w((Object)"<tr>");
            out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)("labels.system" + platformLexiconName + ".minFree")).getHtmlSafeText((Context)op)).w((Object)"</b></td>");
            out.w((Object)"</tr>");
            out.w((Object)"<tr>");
            out.w((Object)"<td>");
            this.freeRamMinFreeFE.write((BObject)service.get("minFreePhysicalMemory"), op);
            out.w((Object)"&nbsp;").w((Object)LexiconText.make((Type)TYPE, (String)("labels.system" + platformLexiconName + ".freePhysUnits")).getHtmlSafeText((Context)op));
            out.w((Object)"</td>");
            out.w((Object)"</tr>");
            out.w((Object)"</table>");
            out.w((Object)"</td>");
            out.w((Object)"<td>");
            out.w((Object)"</td>");
            out.w((Object)"<td>");
            out.w((Object)"</td>");
            out.w((Object)"<td>");
            out.w((Object)"<table cellpadding='5'>");
            out.w((Object)"<tr>");
            out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)("labels.system" + platformLexiconName + ".status")).getHtmlSafeText((Context)op)).w((Object)"</b></td>");
            out.w((Object)"</tr>");
            out.w((Object)"<tr>");
            if (((BBoolean)service.get("lowMemory")).getBoolean()) {
                out.w((Object)"<td>").w((Object)LexiconText.make((Type)TYPE, (String)("labels.system" + platformLexiconName + ".lowMemory")).getHtmlSafeText((Context)op)).w((Object)"</td>");
            } else {
                out.w((Object)"<td>").w((Object)LexiconText.make((Type)TYPE, (String)("labels.system" + platformLexiconName + ".ok")).getHtmlSafeText((Context)op)).w((Object)"</td>");
            }
            out.w((Object)"</tr>");
            out.w((Object)"</table>");
            out.w((Object)"</td>");
            out.w((Object)"</tr>");
            out.w((Object)"<tr>");
            out.w((Object)"<td><b> ").w((Object)LexiconText.make((Type)TYPE, (String)("labels.system" + platformLexiconName + ".diskSpace")).getHtmlSafeText((Context)op)).w((Object)"</b></td>");
            out.w((Object)"<td>");
            out.w((Object)"<table cellpadding='5'>");
            out.w((Object)"<tr>");
            out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)("labels.system" + platformLexiconName + ".minFree")).getHtmlSafeText((Context)op)).w((Object)"</b></td>");
            out.w((Object)"</tr>");
            out.w((Object)"<tr>");
            out.w((Object)"<td>");
            this.diskSpaceMinFreeFE.write((BObject)service.get("minFreeDiskPercentage"), op);
            out.w((Object)"</td>");
            out.w((Object)"</tr>");
            out.w((Object)"</table>");
            out.w((Object)"</td>");
            out.w((Object)"<td>");
            out.w((Object)"</td>");
            out.w((Object)"<td>");
            out.w((Object)"</td>");
            out.w((Object)"<td>");
            out.w((Object)"<table cellpadding='5'>");
            out.w((Object)"<tr>");
            out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)("labels.system" + platformLexiconName + ".status")).getHtmlSafeText((Context)op)).w((Object)"</b></td>");
            out.w((Object)"</tr>");
            out.w((Object)"<tr>");
            if (((BBoolean)service.get("lowDiskSpace")).getBoolean()) {
                out.w((Object)"<td>").w((Object)LexiconText.make((Type)TYPE, (String)("labels.system" + platformLexiconName + ".lowDiskSpace")).getHtmlSafeText((Context)op)).w((Object)"</td>");
            } else {
                out.w((Object)"<td>").w((Object)LexiconText.make((Type)TYPE, (String)("labels.system" + platformLexiconName + ".ok")).getHtmlSafeText((Context)op)).w((Object)"</td>");
            }
            out.w((Object)"</tr>");
            out.w((Object)"</table>");
            out.w((Object)"</td>");
            out.w((Object)"</tr>");
            out.w((Object)"<tr>");
            out.w((Object)"<td><b> ").w((Object)LexiconText.make((Type)TYPE, (String)"labels.system.currentFileCount").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
            out.w((Object)"<td>");
            out.w((Object)"<table cellpadding='5'>");
            out.w((Object)"<tr>");
            out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)("labels.system" + platformLexiconName + ".minFree")).getHtmlSafeText((Context)op)).w((Object)"</b></td>");
            out.w((Object)"</tr>");
            out.w((Object)"<tr>");
            out.w((Object)"<td>");
            this.minFileFreeFE.write((BObject)service.get("minAvailableFiles"), op);
            out.w((Object)"</td>");
            out.w((Object)"</tr>");
            out.w((Object)"</table>");
            out.w((Object)"</td>");
            out.w((Object)"<td>");
            out.w((Object)"</td>");
            out.w((Object)"<td>");
            out.w((Object)"</td>");
            out.w((Object)"<td>");
            out.w((Object)"<table cellpadding='5'>");
            out.w((Object)"<tr>");
            out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)("labels.system" + platformLexiconName + ".status")).getHtmlSafeText((Context)op)).w((Object)"</b></td>");
            out.w((Object)"</tr>");
            out.w((Object)"<tr>");
            if (((BBoolean)service.get("lowAvailableFiles")).getBoolean()) {
                out.w((Object)"<td>").w((Object)LexiconText.make((Type)TYPE, (String)("labels.system" + platformLexiconName + ".lowFilesAvailable")).getHtmlSafeText((Context)op)).w((Object)"</td>");
            } else {
                out.w((Object)"<td>").w((Object)LexiconText.make((Type)TYPE, (String)("labels.system" + platformLexiconName + ".ok")).getHtmlSafeText((Context)op)).w((Object)"</td>");
            }
            out.w((Object)"</tr>");
            out.w((Object)"</table>");
            out.w((Object)"</td>");
            out.w((Object)"</tr>");
            out.println("</table>");
            if (service instanceof BSystemPlatformServiceQnxJavelina) {
                BSystemPlatformServiceQnxJavelina sqj = (BSystemPlatformServiceQnxJavelina)service;
                out.println("</table>");
                out.println("<table cellpadding='5'>");
                out.w((Object)"<tr>");
                out.w((Object)"<td width='201'><b>").w((Object)LexiconText.make((Type)TYPE, (String)("labels.system" + platformLexiconName + ".tamperEnabled")).getHtmlSafeText((Context)op)).w((Object)"</b></td>");
                out.w((Object)"<td>");
                this.tamperSwitchEnabledFE.write((BObject)sqj.get(BSystemPlatformServiceQnxJavelina.tamperSwitchEnabled), op);
                out.w((Object)"</td>");
                out.println("</tr>");
                out.w((Object)"<tr>");
                out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)("labels.system" + platformLexiconName + ".tamperSwitchOk")).getHtmlSafeText((Context)op)).w((Object)"</b></td>");
                out.w((Object)"<td>");
                out.w((Object)String.valueOf(((BBoolean)sqj.get(BSystemPlatformServiceQnxJavelina.tamperSwitchOk)).getBoolean()));
                out.w((Object)"</td>");
                out.println("</tr>");
            }
        }
        if ((fipsStatus = service.getFipsStatus()) != null && !fipsStatus.isEmpty()) {
            out.w((Object)"<tr>");
            out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"labels.system.fipsStatus").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
            out.w((Object)"<td>");
            out.w((Object)fipsStatus);
            out.w((Object)"</td>");
            out.println("</tr>");
        }
        out.println("</table>");
        out.println("<div style='padding:10px; text-align:center;'>");
        this.refreshButton.write(op);
        if (op.canWrite()) {
            HashMap<String, String> attrs = new HashMap<String, String>();
            if (!service.getIsServiceReadonly()) {
                attrs.put("onclick", "onSystemPlatformServiceSave(\"" + op.scope("submit") + "\",\"" + this.getLexicon().getHtmlSafeText("SystemPlatformServicePlugin.restartRequired.hxConfirmMessage") + "\",\"" + this.getLexicon().getHtmlSafeText("SystemPlatformServicePlugin.rebootRequired.hxConfirmMessage") + "\")");
            } else {
                attrs.put("onclick", "onSystemPlatformServiceSave(\"" + op.scope("submit") + "\",\"" + this.getLexicon().getHtmlSafeText("SystemPlatformServicePlugin.restartWillBeRequired.hxConfirmMessage") + "\",\"" + this.getLexicon().getHtmlSafeText("SystemPlatformServicePlugin.rebootWillBeRequired.hxConfirmMessage") + "\")");
            }
            this.saveButton.write(op, attrs);
        }
        out.println("</div>");
        String function = "executeOnload(\"" + op.getPath() + "\");";
        op.addOnload(function);
    }

    public BObject save(HxOp op) throws Exception {
        BSystemPlatformService service = BHxSystemPlatformServiceEditor.getSystemPlatformService(op);
        if (!service.getIsSystemTimeReadonly() && !service.getIsServiceReadonly()) {
            BTimeZone zone = (BTimeZone)this.timeZoneFE.save((BObject)service.getTimeZone(), op);
            service.setTimeZone(zone);
        }
        service.setLocale(this.localeFE.save((BObject)service.get(BSystemPlatformService.locale), op).toString());
        service.setEngineWatchdogPolicy((BEngineWatchdogPolicy)this.engineWatchdogPolicyFE.save((BObject)service.getEngineWatchdogPolicy(), op));
        service.setEngineWatchdogTimeout((BRelTime)this.engineWatchdogTimeoutFE.save((BObject)service.getEngineWatchdogTimeout(), op));
        service.setIsStationAutoSaveEnabled(((BBoolean)this.isStationAutoSaveEnabledFE.save((BObject)service.get(BSystemPlatformService.isStationAutoSaveEnabled), op)).getBoolean());
        if (service.getIsStationAutoSaveEnabled()) {
            service.setStationAutoSaveFrequency((BRelTime)this.stationAutoSaveFrequencyFE.save((BObject)service.getStationAutoSaveFrequency(), op));
            service.setStationSaveBackupCount(((BInteger)this.stationSaveBackupCountFE.save((BObject)service.get(BSystemPlatformService.stationSaveBackupCount), op)).getInt());
        }
        if (service instanceof BSystemPlatformServiceQnx) {
            BSystemPlatformServiceQnx sq = (BSystemPlatformServiceQnx)service;
            sq.setFailureRebootLimit(((BInteger)this.failureRebootLimitFE.save((BObject)BInteger.make((int)sq.getFailureRebootLimit()), op)).getInt());
            sq.setFailureRebootLimitPeriod((BRelTime)this.failureRebootLimitPeriodFE.save((BObject)sq.getFailureRebootLimitPeriod(), op));
            sq.setMinFreeRamDiskPercentage(((BInteger)this.ramDiskMinFreeFE.save((BObject)BInteger.make((int)sq.getMinFreeRamDiskPercentage()), op)).getInt());
            if (sq instanceof BSystemPlatformServiceQnxLegacy) {
                BSystemPlatformServiceQnxLegacy legacy = (BSystemPlatformServiceQnxLegacy)sq;
                legacy.setIsBatteryPresent(((BBoolean)this.batteryPresentFE.save((BObject)legacy.get(BSystemPlatformServiceQnxLegacy.isBatteryPresent), op)).getBoolean());
            }
            sq.setMinFreeHeap(((BInteger)this.javaHeapMinFreeFE.save((BObject)BInteger.make((int)sq.getMinFreeHeap()), op)).getInt());
            sq.setMinFreeFileDescriptors(((BInteger)this.openFileDescriptorsMinFreeFE.save((BObject)BInteger.make((int)sq.getMinFreeFileDescriptors()), op)).getInt());
            sq.setMinFreePhysicalMemory(((BInteger)this.freeRamMinFreeFE.save((BObject)BInteger.make((int)sq.getMinFreePhysicalMemory()), op)).getInt());
            sq.setMinFreeDiskPercentage(((BInteger)this.diskSpaceMinFreeFE.save((BObject)BInteger.make((int)sq.getMinFreeDiskPercentage()), op)).getInt());
            sq.setMinAvailableFiles(((BInteger)this.minFileFreeFE.save((BObject)BInteger.make((int)sq.getMinAvailableFiles()), op)).getInt());
            if (sq instanceof BSystemPlatformServiceQnxJavelina) {
                BSystemPlatformServiceQnxJavelina sqj = (BSystemPlatformServiceQnxJavelina)sq;
                sqj.setTamperSwitchEnabled(((BBoolean)this.tamperSwitchEnabledFE.save((BObject)service.get(BSystemPlatformServiceQnxJavelina.tamperSwitchEnabled), op)).getBoolean());
            }
        } else if (service instanceof BSystemPlatformServiceNpsdk) {
            BSystemPlatformServiceNpsdk sn = (BSystemPlatformServiceNpsdk)service;
            sn.setFailureRebootLimit(((BInteger)this.failureRebootLimitFE.save((BObject)BInteger.make((int)sn.getFailureRebootLimit()), op)).getInt());
            sn.setFailureRebootLimitPeriod((BRelTime)this.failureRebootLimitPeriodFE.save((BObject)sn.getFailureRebootLimitPeriod(), op));
            sn.setMinFreeHeap(((BInteger)this.javaHeapMinFreeFE.save((BObject)BInteger.make((int)sn.getMinFreeHeap()), op)).getInt());
            sn.setMinFreeFileDescriptors(((BInteger)this.openFileDescriptorsMinFreeFE.save((BObject)BInteger.make((int)sn.getMinFreeFileDescriptors()), op)).getInt());
            sn.setMinFreePhysicalMemory(((BInteger)this.freeRamMinFreeFE.save((BObject)BInteger.make((int)sn.getMinFreePhysicalMemory()), op)).getInt());
            sn.setMinFreeDiskPercentage(((BInteger)this.diskSpaceMinFreeFE.save((BObject)BInteger.make((int)sn.getMinFreeDiskPercentage()), op)).getInt());
            sn.setMinAvailableFiles(((BInteger)this.minFileFreeFE.save((BObject)BInteger.make((int)sn.getMinAvailableFiles()), op)).getInt());
        }
        service.savePlatformServiceProperties();
        if (Boolean.parseBoolean(op.getFormValue("systemReboot"))) {
            if (!service.getIsServiceReadonly()) {
                service.reboot();
                HxMessageHelper.addMessage("SystemPlatformServiceEditor", LexiconText.make((String)"platform", (String)"SystemPlatformServiceEditor.systemReboot.hxMessage"), op);
            } else {
                HxMessageHelper.addMessage("SystemPlatformServiceEditor", LexiconText.make((String)"platform", (String)"SystemPlatformServiceEditor.systemNeedsReboot.hxMessage"), op);
            }
        } else if (Boolean.parseBoolean(op.getFormValue("systemRestart"))) {
            if (service.getLocalDaemonAccess().atLeast(BDaemonAccessLevel.restricted)) {
                service.restartStation();
                HxMessageHelper.addMessage("SystemPlatformServiceEditor", LexiconText.make((String)"platform", (String)"SystemPlatformServiceEditor.systemRestart.hxMessage"), op);
            } else {
                HxMessageHelper.addMessage("SystemPlatformServiceEditor", LexiconText.make((String)"platform", (String)"SystemPlatformServiceEditor.systemNeedsRestart.hxMessage"), op);
            }
        }
        return service;
    }

    private static BSystemPlatformService getSystemPlatformService(HxOp op) {
        BObject obj = op.get();
        if (obj instanceof BSystemPlatformService) {
            return (BSystemPlatformService)obj;
        }
        if (obj instanceof BPlatformServiceContainer) {
            return ((BSystemPlatformService[])((BPlatformServiceContainer)obj).getChildren(BSystemPlatformService.class))[0];
        }
        throw new ClassCastException();
    }
}

