/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.hx;

import com.tridium.nre.util.IPAddressUtil;
import com.tridium.platform.BSystemPlatformService;
import com.tridium.platform.hx.util.HxBooleanHelper;
import com.tridium.platform.hx.util.HxButtonHelper;
import com.tridium.platform.hx.util.HxMessageHelper;
import com.tridium.platform.hx.util.HxViewHelper;
import com.tridium.platform.ntp.BNtpPlatformService;
import com.tridium.platform.posix.BNtpHostMode;
import com.tridium.platform.posix.BNtpModePosix;
import com.tridium.platform.qnx.BNtpPlatformServiceQnx;
import com.tridium.platform.qnx.BNtpServerQnx;
import com.tridium.util.ArrayUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.baja.gx.BImage;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;

@NiagaraType(agent={@AgentOn(types={"platform:NtpPlatformServiceEditorQnx"}, requiredPermissions="W")})
@NiagaraSingleton
public class BHxNtpPlatSvcQnxEditor
extends BHxView {
    @Generated
    public static final BHxNtpPlatSvcQnxEditor INSTANCE = new BHxNtpPlatSvcQnxEditor();
    @Generated
    public static final Type TYPE = Sys.loadType(BHxNtpPlatSvcQnxEditor.class);
    private final HxButtonHelper refreshButton = HxButtonHelper.makeRefresh();
    private final HxButtonHelper saveButton = HxButtonHelper.makeSave();
    private final Command handleEnabledChanged = new HandleEnabledChanged();
    private final Command handleServerModified;
    private final Command handleDeleteServer;
    private final Command handleAddServer;
    private final Command handleMoveServerUp;
    private final Command handleMoveServerDown;
    private final HxViewHelper enabledFe;
    private final HxViewHelper hostModeFe;
    private final HxViewHelper ntpFe;
    private final HxViewHelper syncAtBootFe;
    private final HxViewHelper localBackupFe;
    private final HxViewHelper statsFe;

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BHxNtpPlatSvcQnxEditor() {
        this.registerEvent((Event)this.handleEnabledChanged);
        this.handleServerModified = new HandleServerModified();
        this.registerEvent((Event)this.handleServerModified);
        this.handleAddServer = new HandleAddServer();
        this.registerEvent((Event)this.handleAddServer);
        this.handleDeleteServer = new HandleDeleteServer();
        this.registerEvent((Event)this.handleDeleteServer);
        this.handleMoveServerUp = new HandleMoveServerUp();
        this.registerEvent((Event)this.handleMoveServerUp);
        this.handleMoveServerDown = new HandleMoveServerDown();
        this.registerEvent((Event)this.handleMoveServerDown);
        this.enabledFe = HxBooleanHelper.makeFE("enabled", null);
        this.hostModeFe = HxViewHelper.makeFE("hostMode", (BObject)BNtpHostMode.server, (Context)BNtpPlatformServiceQnx.hostMode.getFacets());
        this.ntpFe = HxBooleanHelper.makeFE("ntp", BNtpPlatformServiceQnx.ntp.getDefaultValue(), BNtpPlatformServiceQnx.ntp.getFacets());
        this.syncAtBootFe = HxBooleanHelper.makeFE("syncAtBoot", BNtpPlatformServiceQnx.syncAtBoot.getDefaultValue(), BNtpPlatformServiceQnx.syncAtBoot.getFacets());
        this.localBackupFe = HxBooleanHelper.makeFE("localBackup", BNtpPlatformServiceQnx.localBackup.getDefaultValue(), BNtpPlatformServiceQnx.localBackup.getFacets());
        this.statsFe = HxBooleanHelper.makeFE("stats", BNtpPlatformServiceQnx.statistics.getDefaultValue(), BNtpPlatformServiceQnx.statistics.getFacets());
    }

    public void write(HxOp op) throws Exception {
        boolean readonly;
        BNtpPlatformServiceQnx service = (BNtpPlatformServiceQnx)op.get();
        service.poll();
        BSystemPlatformService sys = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
        sys.poll();
        if (op.canWrite()) {
            if (sys.getIsServiceReadonly()) {
                op.setReadonly(true);
                readonly = true;
            } else {
                readonly = false;
            }
        } else {
            readonly = true;
        }
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<div class='hx-PropertySheet-header'>").safe((Object)LexiconText.make((Type)TYPE, (String)"NtpPlatformService.settings.label").getText((Context)op)).w((Object)"</div>");
        out.w((Object)"<div class='window-bg hx-PropertySheet'>");
        out.w((Object)"<table cellpadding='5'>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"NtpPlatformService.enabled.label").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
        out.w((Object)"<td>");
        out.w((Object)"<select ").attr("name", op.scope("enabled.value"));
        if (readonly) {
            out.w((Object)" disabled='disabled'");
        }
        out.w((Object)" onchange='").w((Object)this.handleEnabledChanged.getInvokeCode(op)).w((Object)"' ");
        out.w((Object)">");
        out.w((Object)"<option value='false'");
        if (!service.getEnabled()) {
            out.w((Object)" selected='selected'");
        }
        out.w((Object)">").safe((Object)BBoolean.toString((boolean)false, (Context)op)).w((Object)"</option>");
        out.w((Object)"<option value='true'");
        if (service.getEnabled()) {
            out.w((Object)" selected='selected'");
        }
        out.w((Object)">").safe((Object)BBoolean.toString((boolean)true, (Context)op)).w((Object)"</option>");
        out.w((Object)"</select>");
        out.w((Object)"</td>");
        out.w((Object)"</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"NtpPlatformServicePosix.hostMode.label").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
        out.w((Object)"<td>");
        this.hostModeFe.setReadonly(readonly);
        this.hostModeFe.write((BObject)service.get(BNtpPlatformServiceQnx.hostMode), op);
        out.w((Object)"</td>");
        out.w((Object)"</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"NtpPlatformServicePosix.ntp.label").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
        out.w((Object)"<td>");
        this.ntpFe.setReadonly(readonly);
        this.ntpFe.write((BObject)service.get(BNtpPlatformServiceQnx.ntp), op);
        out.w((Object)"</td>");
        out.w((Object)"</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"NtpPlatformService.syncAtBoot.label").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
        out.w((Object)"<td>");
        this.syncAtBootFe.setReadonly(readonly);
        this.syncAtBootFe.write((BObject)service.get(BNtpPlatformServiceQnx.syncAtBoot), op);
        out.w((Object)"</td>");
        out.w((Object)"</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"NtpPlatformServicePosix.localBackup.label").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
        out.w((Object)"<td>");
        this.localBackupFe.setReadonly(readonly);
        this.localBackupFe.write((BObject)service.get(BNtpPlatformServiceQnx.localBackup), op);
        out.w((Object)"</td>");
        out.w((Object)"</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"NtpPlatformServicePosix.stats.label").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
        out.w((Object)"<td>");
        this.statsFe.setReadonly(readonly);
        this.statsFe.write((BObject)service.get(BNtpPlatformServiceQnx.statistics), op);
        out.w((Object)"</td>");
        out.w((Object)"</tr>");
        out.w((Object)"<td>");
        out.w((Object)"<input type='hidden'");
        out.w((Object)" ").attr("name", op.scope("panic"));
        out.w((Object)" ").attr("value", service.getPanic());
        out.w((Object)"/>");
        out.w((Object)"</td>");
        out.w((Object)"</table>");
        out.w((Object)"</div>");
        out.w((Object)"<div class='hx-PropertySheet-header'>").safe((Object)LexiconText.make((Type)TYPE, (String)"NtpPlatformService.timeServers.label").getText((Context)op)).w((Object)"</div>");
        out.w((Object)"<div class='window-bg hx-PropertySheet'>");
        out.w((Object)"<div id='").w((Object)op.scope("serversSection")).w((Object)"'>");
        this.writeServersTableHeader(op, out);
        int i = 0;
        SlotCursor c = service.getTimeServers().getProperties();
        while (c.next(BNtpServerQnx.class)) {
            BNtpServerQnx server = (BNtpServerQnx)c.get();
            this.writeServerRow(op, out, i++, server, false);
        }
        this.writeServersTableFooter(op, out);
        out.w((Object)"</div>");
        out.println("<div style='padding:10px; text-align:center;'>");
        this.refreshButton.write(op);
        if (!readonly) {
            HashMap<String, String> attrs = new HashMap<String, String>();
            attrs.put("onclick", "if (window.confirm(\"" + Lexicon.make((String)"platform").getHtmlSafeText("NtpPlatformService.rebootPrompt.hxConfirmMessage") + "\")) { hx.save(); }");
            this.saveButton.write(op, attrs);
        }
        out.println("</div>");
        out.println("</div>");
    }

    protected void writeServersTableHeader(HxOp op, HtmlWriter out) throws Exception {
        out.w((Object)"<table cellpadding='5'>");
        out.w((Object)"<tr>");
        if (op.canWrite()) {
            out.w((Object)"<th>");
            out.w((Object)"</th>");
        }
        out.w((Object)"<th>");
        out.w((Object)LexiconText.make((Type)TYPE, (String)"NtpPlatformService.address.label").getHtmlSafeText((Context)op));
        out.w((Object)"</th>");
        out.w((Object)"<th>");
        out.w((Object)LexiconText.make((Type)TYPE, (String)"NtpPlatformServicePosix.peerMode.label").getHtmlSafeText((Context)op));
        out.w((Object)"</th>");
        out.w((Object)"<th>");
        out.w((Object)LexiconText.make((Type)TYPE, (String)"NtpPlatformServicePosix.burst.label").getHtmlSafeText((Context)op));
        out.w((Object)"</th>");
        out.w((Object)"<th>");
        out.w((Object)LexiconText.make((Type)TYPE, (String)"NtpPlatformServicePosix.prefer.label").getHtmlSafeText((Context)op));
        out.w((Object)"</th>");
        out.w((Object)"<th>");
        out.w((Object)LexiconText.make((Type)TYPE, (String)"NtpPlatformServicePosix.minPollInterval.label").getHtmlSafeText((Context)op));
        out.w((Object)"</th>");
        out.w((Object)"<th>");
        out.w((Object)LexiconText.make((Type)TYPE, (String)"NtpPlatformServicePosix.maxPollInterval.label").getHtmlSafeText((Context)op));
        out.w((Object)"</th>");
        out.w((Object)"</tr>");
    }

    protected void writeServersTableFooter(HxOp op, HtmlWriter out) throws Exception {
        if (op.canWrite()) {
            out.w((Object)"<tr><td colspan='5' align='center'>");
            out.w((Object)"<a href='javascript:").w((Object)this.handleAddServer.getInvokeCode(op)).w((Object)"'>");
            HxUtil.makeImageJS((BImage)BImage.make((BOrd)BOrd.make((String)"module://icons/x16/add.png")), (String)"border='0'", (HxOp)op);
            out.w((Object)"</a>");
            out.w((Object)"&nbsp;");
            out.w((Object)"<a href='javascript:").w((Object)this.handleDeleteServer.getInvokeCode(op)).w((Object)"'>");
            HxUtil.makeImageJS((BImage)BImage.make((BOrd)BOrd.make((String)"module://icons/x16/delete.png")), (String)"border='0'", (HxOp)op);
            out.w((Object)"</a>");
            out.w((Object)"&nbsp;");
            out.w((Object)"<a href='javascript:").w((Object)this.handleMoveServerUp.getInvokeCode(op)).w((Object)"'>");
            HxUtil.makeImageJS((BImage)BImage.make((BOrd)BOrd.make((String)"module://icons/x16/arrowUp.png")), (String)"border='0'", (HxOp)op);
            out.w((Object)"</a>");
            out.w((Object)"&nbsp;");
            out.w((Object)"<a href='javascript:").w((Object)this.handleMoveServerDown.getInvokeCode(op)).w((Object)"'>");
            HxUtil.makeImageJS((BImage)BImage.make((BOrd)BOrd.make((String)"module://icons/x16/arrowDown.png")), (String)"border='0'", (HxOp)op);
            out.w((Object)"</a>");
            out.w((Object)"</td></tr>");
        }
        out.w((Object)"</table>");
    }

    protected void writeServerRow(HxOp op, HtmlWriter out, int idx, BNtpServerQnx server, boolean isSelected) throws Exception {
        out.w((Object)"<tr>");
        if (op.canWrite()) {
            out.w((Object)"<td>");
            out.w((Object)"<input type='checkbox' name='").w((Object)op.scope("select_" + idx)).w((Object)"'");
            if (isSelected) {
                out.w((Object)" checked='checked'");
            }
            out.w((Object)"/>");
            out.w((Object)"</td>");
            out.w((Object)"<td>");
            out.w((Object)"<input type='text' size='32'");
            out.w((Object)" ").attr("name", op.scope("address_" + idx));
            out.w((Object)" ").attr("value", server.getAddress());
            out.w((Object)"/>");
            out.w((Object)"</td>");
            out.w((Object)"<td>");
            out.w((Object)"<select ").attr("name", op.scope("peerMode_" + idx));
            out.w((Object)" onchange='").w((Object)this.handleServerModified.getInvokeCode(op)).w((Object)"'");
            out.w((Object)">");
            out.w((Object)"<option value='2'");
            if (server.getPeerMode() == BNtpModePosix.server) {
                out.w((Object)" selected='selected'");
            }
            out.w((Object)">").safe((Object)BNtpModePosix.server.toString((Context)op)).w((Object)"</option>");
            out.w((Object)"<option value='1'");
            if (server.getPeerMode() == BNtpModePosix.peer) {
                out.w((Object)" selected='selected'");
            }
            out.w((Object)">").safe((Object)BNtpModePosix.peer.toString((Context)op)).w((Object)"</option>");
            out.w((Object)"</select>");
            out.w((Object)"</td>");
            out.w((Object)"<td>");
            out.w((Object)"<select ").attr("name", op.scope("useBurst_" + idx));
            out.w((Object)">");
            out.w((Object)"<option value='false'");
            if (!server.getUseBurst()) {
                out.w((Object)" selected='selected'");
            }
            out.w((Object)">").safe((Object)BBoolean.FALSE.toString((Context)op)).w((Object)"</option>");
            out.w((Object)"<option value='true'");
            if (server.getUseBurst()) {
                out.w((Object)" selected='selected'");
            }
            out.w((Object)">").safe((Object)BBoolean.TRUE.toString((Context)op)).w((Object)"</option>");
            out.w((Object)"</select>");
            out.w((Object)"</td>");
            out.w((Object)"<td>");
            out.w((Object)"<select ").attr("name", op.scope("serverPreferred_" + idx));
            out.w((Object)">");
            out.w((Object)"<option value='false'");
            if (!server.getServerPreferred()) {
                out.w((Object)" selected='selected'");
            }
            out.w((Object)">").safe((Object)BBoolean.FALSE.toString((Context)op)).w((Object)"</option>");
            out.w((Object)"<option value='true'");
            if (server.getServerPreferred()) {
                out.w((Object)" selected='selected'");
            }
            out.w((Object)">").safe((Object)BBoolean.TRUE.toString((Context)op)).w((Object)"</option>");
            out.w((Object)"</select>");
            out.w((Object)"</td>");
            out.w((Object)"<td>");
            out.w((Object)"<input type='text' size='5'");
            out.w((Object)" ").attr("name", op.scope("minpoll_" + idx));
            out.w((Object)" ").attr("value", server.getMinPollInterval());
            out.w((Object)"/>");
            out.safe((Object)BNtpPlatformService.LOG_2_SEC_UNIT.getSymbol());
            out.w((Object)"</td>");
            out.w((Object)"<td>");
            out.w((Object)"<input type='text' size='5'");
            out.w((Object)" ").attr("name", op.scope("maxpoll_" + idx));
            out.w((Object)" ").attr("value", server.getMaxPollInterval());
            out.w((Object)"/>");
            out.safe((Object)BNtpPlatformService.LOG_2_SEC_UNIT.getSymbol());
            out.w((Object)"</td>");
            out.w((Object)"<td>");
            out.w((Object)"<input type='hidden'");
            out.w((Object)" ").attr("name", op.scope("extraArgs_" + idx));
            out.w((Object)" ").attr("value", server.getAdditionalArgs());
            out.w((Object)"/>");
            out.w((Object)"</td>");
        } else {
            out.w((Object)"<td>").safe((Object)server.getAddress()).w((Object)"</td>");
            out.w((Object)"<td>").safe((Object)server.getPeerMode().toString((Context)op)).w((Object)"</td>");
            out.w((Object)"<td>").safe((Object)server.get(BNtpServerQnx.useBurst).toString((Context)op)).w((Object)"</td>");
            out.w((Object)"<td>").safe((Object)server.get(BNtpServerQnx.serverPreferred).toString((Context)op)).w((Object)"</td>");
            out.w((Object)"<td>").safe((Object)server.get(BNtpServerQnx.minPollInterval).toString((Context)op)).w((Object)"</td>");
            out.w((Object)"<td>").safe((Object)server.get(BNtpServerQnx.maxPollInterval).toString((Context)op)).w((Object)"</td>");
        }
        out.w((Object)"</tr>");
    }

    protected BNtpServerQnx[] getTimeServers(HxOp op) throws Exception {
        ArrayList<BNtpServerQnx> result = new ArrayList<BNtpServerQnx>();
        int i = 0;
        String address = op.getUnsafeFormValue("address_" + i);
        while (address != null) {
            BNtpServerQnx server = new BNtpServerQnx();
            server.setAddress(address);
            server.setPeerMode(BNtpModePosix.make((int)Integer.parseInt(op.getFormValue("peerMode_" + i))));
            server.setUseBurst(op.getFormValue("useBurst_" + i).equals("true"));
            server.setServerPreferred(op.getFormValue("serverPreferred_" + i) != null && op.getFormValue("serverPreferred_" + i).equals("true"));
            server.setMinPollInterval(Integer.parseInt(op.getFormValue("minpoll_" + i)));
            server.setMaxPollInterval(Integer.parseInt(op.getFormValue("maxpoll_" + i)));
            server.setAdditionalArgs(op.getFormValue("extraArgs_" + i));
            result.add(server);
            address = op.getUnsafeFormValue("address_" + ++i);
        }
        return (BNtpServerQnx[])ArrayUtil.arrayFromCollection(result, BNtpServerQnx[]::new);
    }

    public BObject save(HxOp op) throws Exception {
        BNtpPlatformServiceQnx service = (BNtpPlatformServiceQnx)op.get();
        BNtpServerQnx[] servers = this.getTimeServers(op);
        String[] serverStrings = new String[servers.length];
        HashSet<String> usedProps = new HashSet<String>();
        for (int i = 0; i < servers.length; ++i) {
            String host = servers[i].getAddress();
            if (host.trim().length() == 0) {
                throw new LocalizableRuntimeException("platform", "NtpServerFE.nullAddress");
            }
            if (!IPAddressUtil.isNumericAddr((String)host) && !IPAddressUtil.isHostname((String)host)) {
                throw new LocalizableRuntimeException("platform", "NtpServerFE.invalidHost", new Object[]{host});
            }
            serverStrings[i] = servers[i].getServerString();
            String propName = servers[i].getPropertyName(serverStrings[i]);
            if (usedProps.contains(propName)) {
                throw new LocalizableRuntimeException("platform", "NtpServerVectorFE.duplicateServer");
            }
            usedProps.add(propName);
        }
        service.getTimeServers().sync(serverStrings);
        service.setEnabled(((BBoolean)this.enabledFe.save((BObject)service.get(BNtpPlatformService.enabled), op)).getBoolean());
        service.setHostMode((BNtpHostMode)this.hostModeFe.save((BObject)service.get(BNtpPlatformServiceQnx.hostMode), op));
        service.setNtp(((BBoolean)this.ntpFe.save((BObject)service.get(BNtpPlatformServiceQnx.ntp), op)).getBoolean());
        service.setSyncAtBoot(((BBoolean)this.syncAtBootFe.save((BObject)service.get(BNtpPlatformServiceQnx.syncAtBoot), op)).getBoolean());
        service.setLocalBackup(((BBoolean)this.localBackupFe.save((BObject)service.get(BNtpPlatformServiceQnx.localBackup), op)).getBoolean());
        service.setStatistics(((BBoolean)this.statsFe.save((BObject)service.get(BNtpPlatformServiceQnx.statistics), op)).getBoolean());
        service.setPanic(Integer.parseInt(op.getFormValue("panic")));
        BSystemPlatformService sys = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
        sys.poll();
        if (!sys.getIsServiceReadonly()) {
            service.savePlatformServiceProperties();
            sys.reboot();
            HxMessageHelper.addMessage("NtpPlatformQnxServiceEditor", LexiconText.make((String)"platform", (String)"NtpPlatformService.reboot.hxMessage"), op);
        }
        return service;
    }

    private class HandleDeleteServer
    extends Command {
        public HandleDeleteServer() {
            super((BHxView)BHxNtpPlatSvcQnxEditor.this);
        }

        public String getDisplayName(HxOp op) {
            return "";
        }

        public void handle(HxOp op) throws Exception {
            BNtpServerQnx[] servers = BHxNtpPlatSvcQnxEditor.this.getTimeServers(op);
            String id = op.scope("serversSection");
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"var serversSection = document.getElementById('").w((Object)id).w((Object)"');");
            out.w((Object)"serversSection.innerHTML = \"");
            BHxNtpPlatSvcQnxEditor.this.writeServersTableHeader(op, out);
            int numDeleted = 0;
            for (int i = 0; i < servers.length; ++i) {
                if (op.getFormValue("select_" + i) == null) {
                    BHxNtpPlatSvcQnxEditor.this.writeServerRow(op, out, i - numDeleted, servers[i], false);
                    continue;
                }
                ++numDeleted;
            }
            BHxNtpPlatSvcQnxEditor.this.writeServersTableFooter(op, out);
            out.w((Object)"\";");
        }
    }

    private class HandleAddServer
    extends Command {
        public HandleAddServer() {
            super((BHxView)BHxNtpPlatSvcQnxEditor.this);
        }

        public String getDisplayName(HxOp op) {
            return "";
        }

        public void handle(HxOp op) throws Exception {
            BNtpServerQnx[] servers = BHxNtpPlatSvcQnxEditor.this.getTimeServers(op);
            String id = op.scope("serversSection");
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"var serversSection = document.getElementById('").w((Object)id).w((Object)"');");
            out.w((Object)"serversSection.innerHTML = \"");
            BHxNtpPlatSvcQnxEditor.this.writeServersTableHeader(op, out);
            for (int i = 0; i < servers.length; ++i) {
                BHxNtpPlatSvcQnxEditor.this.writeServerRow(op, out, i, servers[i], false);
            }
            BHxNtpPlatSvcQnxEditor.this.writeServerRow(op, out, servers.length, new BNtpServerQnx(), false);
            BHxNtpPlatSvcQnxEditor.this.writeServersTableFooter(op, out);
            out.w((Object)"\";");
        }
    }

    private class HandleMoveServerDown
    extends Command {
        public HandleMoveServerDown() {
            super((BHxView)BHxNtpPlatSvcQnxEditor.this);
        }

        public String getDisplayName(HxOp op) {
            return "";
        }

        public void handle(HxOp op) throws Exception {
            String[] keys = op.getFormKeys();
            int sel = -1;
            for (String key : keys) {
                if (!key.startsWith("select_")) continue;
                if (sel < 0) {
                    sel = Integer.parseInt(key.substring(7));
                    continue;
                }
                return;
            }
            if (sel >= 0 && op.getFormValue("address_" + (sel + 1)) != null) {
                BNtpServerQnx[] servers = BHxNtpPlatSvcQnxEditor.this.getTimeServers(op);
                BNtpServerQnx temp = servers[sel + 1];
                servers[sel + 1] = servers[sel];
                servers[sel] = temp;
                String id = op.scope("serversSection");
                HtmlWriter out = op.getHtmlWriter();
                out.w((Object)"var serversSection = document.getElementById('").w((Object)id).w((Object)"');");
                out.w((Object)"serversSection.innerHTML = \"");
                BHxNtpPlatSvcQnxEditor.this.writeServersTableHeader(op, out);
                for (int i = 0; i < servers.length; ++i) {
                    BHxNtpPlatSvcQnxEditor.this.writeServerRow(op, out, i, servers[i], i == sel + 1);
                }
                BHxNtpPlatSvcQnxEditor.this.writeServersTableFooter(op, out);
                out.w((Object)"\";");
            }
        }
    }

    private class HandleMoveServerUp
    extends Command {
        public HandleMoveServerUp() {
            super((BHxView)BHxNtpPlatSvcQnxEditor.this);
        }

        public String getDisplayName(HxOp op) {
            return "";
        }

        public void handle(HxOp op) throws Exception {
            String[] keys = op.getFormKeys();
            int sel = -1;
            for (String key : keys) {
                if (!key.startsWith("select_")) continue;
                if (sel < 0) {
                    sel = Integer.parseInt(key.substring(7));
                    continue;
                }
                return;
            }
            if (sel > 0) {
                BNtpServerQnx[] servers = BHxNtpPlatSvcQnxEditor.this.getTimeServers(op);
                BNtpServerQnx temp = servers[sel - 1];
                servers[sel - 1] = servers[sel];
                servers[sel] = temp;
                String id = op.scope("serversSection");
                HtmlWriter out = op.getHtmlWriter();
                out.w((Object)"var serversSection = document.getElementById('").w((Object)id).w((Object)"');");
                out.w((Object)"serversSection.innerHTML = \"");
                BHxNtpPlatSvcQnxEditor.this.writeServersTableHeader(op, out);
                for (int i = 0; i < servers.length; ++i) {
                    BHxNtpPlatSvcQnxEditor.this.writeServerRow(op, out, i, servers[i], i == sel - 1);
                }
                BHxNtpPlatSvcQnxEditor.this.writeServersTableFooter(op, out);
                out.w((Object)"\";");
            }
        }
    }

    private class HandleServerModified
    extends Command {
        public HandleServerModified() {
            super((BHxView)BHxNtpPlatSvcQnxEditor.this);
        }

        public String getDisplayName(HxOp op) {
            return "";
        }

        public void handle(HxOp op) throws Exception {
            int idx;
            String[] keys = op.getFormKeys();
            BNtpServerQnx[] servers = BHxNtpPlatSvcQnxEditor.this.getTimeServers(op);
            boolean[] sel = new boolean[servers.length];
            for (idx = 0; idx < sel.length; ++idx) {
                sel[idx] = false;
            }
            for (String key : keys) {
                if (!key.startsWith("select_")) continue;
                idx = Integer.parseInt(key.substring(7));
                sel[idx] = true;
            }
            String id = op.scope("serversSection");
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"var serversSection = document.getElementById('").w((Object)id).w((Object)"');");
            out.w((Object)"serversSection.innerHTML = \"");
            BHxNtpPlatSvcQnxEditor.this.writeServersTableHeader(op, out);
            for (int i = 0; i < servers.length; ++i) {
                BHxNtpPlatSvcQnxEditor.this.writeServerRow(op, out, i, servers[i], sel[i]);
            }
            BHxNtpPlatSvcQnxEditor.this.writeServersTableFooter(op, out);
            out.w((Object)"\";");
        }
    }

    private class HandleEnabledChanged
    extends Command {
        public HandleEnabledChanged() {
            super((BHxView)BHxNtpPlatSvcQnxEditor.this);
        }

        public String getDisplayName(HxOp op) {
            return "";
        }

        public void handle(HxOp op) throws Exception {
        }
    }
}

