/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndio.conv;

import com.tridium.ndio.NdioException;
import com.tridium.ndio.point.BNdioVoltageInputProxyExt;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.driver.point.BDefaultProxyConversion;
import javax.baja.driver.point.BProxyConversion;
import javax.baja.driver.point.BProxyExt;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.UnitException;
import javax.baja.util.BTypeSpec;

@NiagaraType
public final class BShunt500OhmConversion
extends BProxyConversion {
    public static final BShunt500OhmConversion DEFAULT = BShunt500OhmConversion.make();
    public static final Type TYPE = Sys.loadType(BShunt500OhmConversion.class);
    private static BUnit VOLTS_UNIT = BUnit.getUnit((String)"volt");
    private static BUnit MA_UNIT = BUnit.getUnit((String)"milliampere");
    private BProxyConversion subConv;
    private static double[] src = new double[]{0.0, 3.912f, 9.315f};
    private static double[] dest = new double[]{0.0, 3.912f, 10.0};

    public Type getType() {
        return TYPE;
    }

    public static BShunt500OhmConversion make() {
        return new BShunt500OhmConversion();
    }

    public static BShunt500OhmConversion make(BProxyConversion subConv) {
        return new BShunt500OhmConversion(subConv);
    }

    private BShunt500OhmConversion() {
        this.subConv = BDefaultProxyConversion.DEFAULT;
    }

    private BShunt500OhmConversion(BProxyConversion subConv) {
        this.subConv = subConv;
    }

    public void convertDeviceToProxy(BProxyExt ext, BStatusValue deviceValue, BStatusValue proxyValue) throws Exception {
        if (deviceValue instanceof BStatusNumeric) {
            BUnit deviceUnit = (BUnit)ext.getDeviceFacets().get("units", (BObject)BUnit.NULL);
            if (!ext.getType().is(BNdioVoltageInputProxyExt.TYPE)) {
                throw new NdioException("500 Ohm shunt conversion can only be used with ndio voltage input");
            }
            if (deviceUnit.isConvertible(VOLTS_UNIT)) {
                double deviceVal = ((BStatusNumeric)deviceValue).getValue();
                double proxyVal = this.convertTo(deviceVal, src, dest);
                proxyValue.setStatus(deviceValue.getStatus());
                ((BStatusNumeric)proxyValue).setValue(proxyVal);
                this.subConv.convertDeviceToProxy(ext, proxyValue, proxyValue);
                return;
            }
            proxyValue.copyFrom((BComplex)deviceValue);
            throw new UnitException("Not convertible: " + deviceUnit);
        }
        proxyValue.copyFrom((BComplex)deviceValue);
        throw new NdioException("Not convertible: invalid point type");
    }

    public void convertProxyToDevice(BProxyExt ext, BStatusValue proxyValue, BStatusValue deviceValue) throws Exception {
        deviceValue.copyFrom((BComplex)proxyValue);
        throw new NdioException("Not convertible: invalid point type");
    }

    private double convertTo(double src, double[] srcArray, double[] destArray) {
        int band = 0;
        int count = srcArray.length;
        if (src < srcArray[0]) {
            return destArray[0];
        }
        if (src > srcArray[count - 1]) {
            return destArray[count - 1];
        }
        if (src == srcArray[count - 1]) {
            return destArray[count - 1];
        }
        for (int i = 0; i < count - 1; ++i) {
            if (!(src >= srcArray[i]) || !(src < srcArray[i + 1])) continue;
            band = i;
            break;
        }
        double p1 = srcArray[band];
        double p2 = srcArray[band + 1];
        double v1 = destArray[band];
        double v2 = destArray[band + 1];
        return v1 - (p1 - src) * (v1 - v2) / (p1 - p2);
    }

    public int hashCode() {
        return this.subConv.hashCode();
    }

    public boolean equals(Object obj) {
        BShunt500OhmConversion x;
        if (obj instanceof BShunt500OhmConversion && (x = (BShunt500OhmConversion)((Object)obj)).getSubConversion().getType() == this.subConv.getType()) {
            return this.hashCode() == x.hashCode();
        }
        return false;
    }

    public String toString(Context context) {
        return TYPE.getDisplayName(context);
    }

    public void encode(DataOutput out) throws IOException {
        this.subConv.getType().getTypeSpec().encode(out);
        this.subConv.encode(out);
    }

    public BObject decode(DataInput in) throws IOException {
        BTypeSpec typeSpec = (BTypeSpec)BTypeSpec.DEFAULT.decode(in);
        return BShunt500OhmConversion.make((BProxyConversion)((BProxyConversion)typeSpec.getInstance()).decode(in));
    }

    public String encodeToString() throws IOException {
        StringBuilder buf = new StringBuilder();
        buf.append(this.subConv.getType().getTypeSpec().encodeToString());
        buf.append(";");
        buf.append(this.subConv.encodeToString());
        return buf.toString();
    }

    public BObject decodeFromString(String s) throws IOException {
        int semi = s.indexOf(";");
        BTypeSpec typeSpec = (BTypeSpec)BTypeSpec.DEFAULT.decodeFromString(s.substring(0, semi));
        return BShunt500OhmConversion.make((BProxyConversion)((BProxyConversion)typeSpec.getInstance()).decodeFromString(s.substring(semi + 1)));
    }

    public BProxyConversion getSubConversion() {
        return this.subConv;
    }
}

