/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonProTransform.functions;

import java.util.List;
import java.util.Map;
import javax.baja.seriestransform.exceptions.SourceException;
import javax.baja.seriestransform.exceptions.TransformException;
import javax.baja.seriestransform.graph.BTransformFunction;
import javax.baja.sys.BComplex;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BNumber;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;

public class BSubtractFunction
extends BTransformFunction {
    public static final Type TYPE = Sys.loadType(BSubtractFunction.class);
    private static final Lexicon lex = Lexicon.make(BSubtractFunction.class);
    private static final String FUNCTION_NAME = lex.getText("functions.name.subtract");
    private static final String FUNCTION_DESC = lex.getText("functions.desc.subtract");

    public Type getType() {
        return TYPE;
    }

    public void applyFunction(Map<String, List<? extends BComplex>> series, String[] srcProps, Property dstSlot, BComplex resultRecord) throws TransformException {
        BDouble operand1 = null;
        BDouble operand2 = null;
        BDouble difference = null;
        BUnit dstUnits = BSubtractFunction.getUnits((Property)dstSlot);
        Object srcUnits = null;
        BFacets srcFacets = null;
        for (String name : srcProps) {
            String seriesName = BSubtractFunction.getSeriesName((String)name);
            String fieldName = BSubtractFunction.getFieldName((String)name);
            List records = this.getSeriesRecords(series, seriesName);
            for (BComplex record : records) {
                BNumber check;
                Property srcProp = record.getProperty(fieldName);
                srcFacets = srcProp.getFacets();
                if (srcFacets != null && srcFacets.getFacet("operand1") != null) {
                    try {
                        check = this.sumValues((BNumber)operand1, record, srcProp, dstUnits);
                        if (check.equals((Object)BDouble.NaN)) continue;
                        operand1 = check;
                    }
                    catch (SourceException e) {
                        operand1 = BDouble.NaN;
                    }
                    continue;
                }
                if (srcFacets == null || srcFacets.getFacet("operand2") == null) continue;
                try {
                    check = this.sumValues((BNumber)operand2, record, srcProp, dstUnits);
                    if (check.equals((Object)BDouble.NaN)) continue;
                    operand2 = check;
                }
                catch (SourceException e) {
                    operand2 = BDouble.NaN;
                }
            }
        }
        try {
            BNumber check = this.subtractValues((BNumber)operand1, (BNumber)operand2);
            if (!check.equals((Object)BDouble.NaN)) {
                difference = check;
            }
        }
        catch (Exception e) {
            difference = BDouble.NaN;
        }
        BSubtractFunction.setRecordValue((BComplex)resultRecord, (Property)dstSlot, (BValue)difference);
    }

    protected BNumber sumValues(BNumber curSum, BComplex source, Property field, BUnit dstUnits) throws SourceException {
        BUnit origUnits;
        BValue value = source.get(field);
        BFacets facets = field.getFacets();
        BUnit bUnit = origUnits = facets != null ? (BUnit)facets.get("units") : BUnit.NULL;
        if (value instanceof BNumber) {
            BNumber number = BSubtractFunction.convertToUnits((BNumber)((BNumber)value), (BUnit)origUnits, (BUnit)dstUnits);
            curSum = null == curSum ? number : this.addValues(number, curSum);
        }
        return curSum;
    }

    protected BNumber addValues(BNumber a, BNumber b) {
        if (null == a || null == b || Double.isNaN(a.getNumeric()) || Double.isNaN(b.getNumeric())) {
            return BDouble.NaN;
        }
        if (a instanceof BDouble) {
            return BDouble.make((double)(a.getDouble() + b.getDouble()));
        }
        if (a instanceof BFloat) {
            return BFloat.make((float)(a.getFloat() + b.getFloat()));
        }
        if (a instanceof BLong) {
            return BLong.make((long)(a.getLong() + b.getLong()));
        }
        if (a instanceof BInteger) {
            return BInteger.make((int)(a.getInt() + b.getInt()));
        }
        return BDouble.make((double)(a.getDouble() + b.getDouble()));
    }

    protected BNumber subtractValues(BNumber a, BNumber b) {
        if (null == a || null == b || Double.isNaN(a.getNumeric()) || Double.isNaN(b.getNumeric())) {
            return BDouble.NaN;
        }
        if (a instanceof BDouble) {
            return BDouble.make((double)(a.getDouble() - b.getDouble()));
        }
        if (a instanceof BFloat) {
            return BFloat.make((float)(a.getFloat() - b.getFloat()));
        }
        if (a instanceof BLong) {
            return BLong.make((long)(a.getLong() - b.getLong()));
        }
        if (a instanceof BInteger) {
            return BInteger.make((int)(a.getInt() - b.getInt()));
        }
        return BDouble.make((double)(a.getDouble() - b.getDouble()));
    }

    public String getFunctionName() {
        return FUNCTION_NAME;
    }

    public String getFunctionDesc() {
        return FUNCTION_DESC;
    }

    public Type getReturnType() {
        return BNumber.TYPE;
    }

    public Type[] getArgumentTypes() {
        return new Type[]{BNumber.TYPE};
    }
}

