/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonProTransform.functions;

import java.util.List;
import java.util.Map;
import javax.baja.seriestransform.exceptions.TransformException;
import javax.baja.seriestransform.graph.BTransformFunction;
import javax.baja.sys.BComplex;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

public class BEnumFunction
extends BTransformFunction {
    public static final Type TYPE = Sys.loadType(BEnumFunction.class);
    private static final Lexicon lex = Lexicon.make(BEnumFunction.class);
    private static final String FUNCTION_NAME = lex.getText("functions.name.enum");
    private static final String FUNCTION_DESC = lex.getText("functions.desc.enum");

    public Type getType() {
        return TYPE;
    }

    public void applyFunction(Map series, String[] srcProps, Property destProp, BComplex resultRecord) throws TransformException {
        BDynamicEnum result = null;
        for (int i = 0; i < srcProps.length; ++i) {
            String name = srcProps[i];
            int count = 0;
            List records = this.getSeriesRecords(series, BEnumFunction.getSeriesName((String)name));
            if (null == records) continue;
            for (BComplex record : records) {
                Property field = record.getProperty(BEnumFunction.getFieldName((String)name));
                BValue value = record.get(field);
                try {
                    BDynamicEnum de = (BDynamicEnum)value;
                    if (count == 0) {
                        result = de;
                    }
                    ++count;
                }
                catch (Exception e) {
                    System.out.println("Failed to determine value for field " + field);
                    e.printStackTrace();
                }
            }
        }
        BEnumFunction.setRecordValue((BComplex)resultRecord, (Property)destProp, result);
    }

    public Type[] getArgumentTypes() {
        Type[] types = new Type[]{BDynamicEnum.TYPE};
        return types;
    }

    public String getFunctionDesc() {
        return FUNCTION_DESC;
    }

    public String getFunctionName() {
        return FUNCTION_NAME;
    }

    public Type getReturnType() {
        return BDynamicEnum.TYPE;
    }
}

