/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.saml.idp;

import com.tridium.saml.BSAMLAuthenticationSchemeRankInfo;
import com.tridium.saml.BSAMLAuthenticationSchemeRankMixIn;
import com.tridium.saml.SAMLException;
import com.tridium.saml.SAMLIdPConfigurationException;
import com.tridium.saml.SAMLLoginException;
import com.tridium.saml.authnScheme.BSAMLAuthenticationScheme;
import com.tridium.saml.idp.BCircleOfTrust;
import com.tridium.saml.idp.BSAMLIdPService;
import com.tridium.saml.idp.BStationServiceProvider;
import com.tridium.saml.idp.IdPResponse;
import com.tridium.saml.idp.SAMLIdPServletUtil;
import com.tridium.saml.rp.AuthnRequest;
import com.tridium.saml.rp.servlet.SAMLUuidMap;
import com.tridium.saml.utils.SAMLUtils;
import com.tridium.web.Template;
import com.tridium.web.session.NiagaraWebSession;
import com.tridium.web.session.WebSessionUtil;
import java.io.IOException;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.authn.BAuthenticationScheme;
import javax.baja.naming.BOrd;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SAMLIdPProcessLoginServlet
extends HttpServlet {
    private static final Logger LOG = Logger.getLogger("saml");
    private static final BOrd FORM_TEMPLATE = BOrd.make((String)"module://saml/rc/processLoginForm.vm");
    private static final String PROCESS_LOGIN_URI = "/saml/idp/auth/processLogin";
    private static final long serialVersionUID = -3509669009863538101L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            if (!SAMLIdPProcessLoginServlet.isIdpServiceOperational()) {
                throw new SAMLIdPConfigurationException("SAML IdP is not enabled");
            }
            String uri = request.getRequestURI();
            if (uri.startsWith(PROCESS_LOGIN_URI)) {
                SAMLIdPProcessLoginServlet.handleProcessLogin(request, response);
            } else {
                response.sendError(404);
            }
        }
        catch (SAMLIdPConfigurationException e) {
            SAMLUtils.log(Level.WARNING, e.getGenericErrorMessage(), e);
            response.sendError(403, e.getGenericErrorMessage());
        }
        catch (SAMLException e) {
            SAMLUtils.log(Level.WARNING, e.getGenericErrorMessage(), e);
            response.sendError(400, e.getGenericErrorMessage());
        }
    }

    private static boolean isIdpServiceOperational() {
        Optional idpService = Sys.findService((Type)BSAMLIdPService.TYPE);
        return idpService.filter(biService -> ((BAbstractService)biService).isOperational()).isPresent();
    }

    private static void handleProcessLogin(HttpServletRequest request, HttpServletResponse response) throws SAMLException {
        try {
            String id = request.getParameter("id");
            if (id == null) {
                throw new SAMLException("No provided AuthnRequest id");
            }
            AuthnRequest authnRequest = AccessController.doPrivileged(() -> SAMLUuidMap.UUID_TO_AUTHN_REQUEST_MAP.get(UUID.fromString(id)));
            if (authnRequest == null || !authnRequest.getId().toString().equals(id)) {
                throw new SAMLException("Provided id does not correspond to an existing or valid AuthnRequest");
            }
            BUser user = BUser.getCurrentAuthenticatedUser();
            if (user == null) {
                throw new SAMLException("Invalid state. No authenticated user found.");
            }
            BCircleOfTrust circleOfTrust = SAMLIdPServletUtil.getCircleOfTrust(request);
            boolean success = circleOfTrust.isUserMember(user);
            if (!success) {
                throw new SAMLLoginException("Rejected SAML login request. User <" + user.getName() + "> is not part of requested Circle of Trust <" + circleOfTrust.getName() + ">.");
            }
            BStationServiceProvider serviceProvider = SAMLIdPServletUtil.getStationServiceProvider(circleOfTrust, authnRequest.getIssuerURL());
            BSAMLIdPService idpService = (BSAMLIdPService)((Object)Sys.findService((Type)BSAMLIdPService.TYPE).orElseThrow(() -> new SAMLIdPConfigurationException("No SAML IdP Service configured")));
            boolean encryptionConfigured = SAMLIdPProcessLoginServlet.encryptionConfigured(idpService, serviceProvider);
            if (encryptionConfigured && serviceProvider.getEncryptionCertificate().isNull()) {
                throw new SAMLIdPConfigurationException("The encryption certificate in the Service Provider (" + serviceProvider.getName() + ") is not correctly configured");
            }
            IdPResponse idpResponse = new IdPResponse(authnRequest, user, encryptionConfigured, serviceProvider.getEncryptionCertificate().getX509Certificate(), circleOfTrust);
            SAMLIdPProcessLoginServlet.addAuthnContextClassRefToResponse(request, user, idpResponse);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("assertionConsumerServiceURL", authnRequest.getAssertionConsumerServiceURL());
            map.put("response", SAMLUtils.encodeSAMLMessageXML(idpResponse.getXMLResponse(), false, false));
            response.setStatus(200);
            response.setContentType("text/html; charset=utf-8");
            response.getWriter().print(Template.process(map, (BOrd)FORM_TEMPLATE, (boolean)true));
        }
        catch (SAMLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SAMLException("Error writing response", e);
        }
    }

    private static boolean encryptionConfigured(BSAMLIdPService idPService, BStationServiceProvider serviceProvider) throws SAMLException {
        if (serviceProvider.getUseEncryption()) {
            if (serviceProvider.getEncryptionCertificate().isNull()) {
                throw new SAMLIdPConfigurationException("The encryption certificate in the Service Provider (" + serviceProvider.getName() + ") is not correctly configured");
            }
            if (idPService.getEncrypter() == null) {
                throw new SAMLIdPConfigurationException("an instance of BISamlXmlEncrypter needs to be present as a child of the IdP Service");
            }
            return true;
        }
        return false;
    }

    private static void addAuthnContextClassRefToResponse(HttpServletRequest request, BUser user, IdPResponse idpResponse) throws SAMLIdPConfigurationException {
        BAuthenticationScheme authenticationScheme = user.getAuthenticationScheme();
        if (!(authenticationScheme instanceof BSAMLAuthenticationScheme)) {
            BSAMLAuthenticationSchemeRankMixIn schemeRankMixIn = (BSAMLAuthenticationSchemeRankMixIn)authenticationScheme.getMixIn(BSAMLAuthenticationSchemeRankMixIn.TYPE);
            if (schemeRankMixIn == null) {
                throw new SAMLIdPConfigurationException("Authentication scheme is missing SAML rank mixin: " + authenticationScheme.getDisplayName(null));
            }
            BSAMLAuthenticationSchemeRankInfo schemeRankInfo = request.isSecure() ? schemeRankMixIn.getWithTls() : schemeRankMixIn.getWithoutTls();
            idpResponse.setAuthnContextClassRef("urn:oasis:names:tc:SAML:2.0:ac:classes:" + schemeRankInfo.getAuthnContextClassRef());
        } else {
            NiagaraWebSession session = WebSessionUtil.getSession((HttpServletRequest)request, (boolean)true);
            String authnContextClassRef = (String)session.getAttribute("AuthnContextClassRef");
            if (authnContextClassRef == null || authnContextClassRef.isEmpty()) {
                LOG.fine("SAML authentication scheme was used but no AuthnContextClassRef was found. Using unspecified");
                idpResponse.setAuthnContextClassRef("urn:oasis:names:tc:SAML:2.0:ac:classes:unspecified");
            } else if (authnContextClassRef.startsWith("urn:oasis:names:tc:SAML:2.0:ac:classes:")) {
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.finer("SAML authentication scheme was used, using authnContextClassRef returned by IdP: " + authnContextClassRef);
                }
                idpResponse.setAuthnContextClassRef(authnContextClassRef);
            } else {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("SAML authentication scheme was used, but authnContextClassRef returned by IdP is not recognized: " + authnContextClassRef + ". Using unspecified.");
                }
                idpResponse.setAuthnContextClassRef("urn:oasis:names:tc:SAML:2.0:ac:classes:unspecified");
            }
        }
    }
}

