/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.saml.idp;

import com.tridium.saml.idp.BCircleOfTrustFolder;
import com.tridium.saml.idp.BPrototypesFolder;
import com.tridium.saml.idp.BSAMLIdPService;
import com.tridium.saml.idp.BStationServiceProviderFolder;
import com.tridium.saml.utils.SAMLUtils;
import com.tridium.util.EscUtil;
import java.util.logging.Level;
import javax.baja.authn.BAuthenticationScheme;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.BUuid;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="uniqueId", type="BUuid", defaultValue="BUuid.DEFAULT", flags=69), @NiagaraProperty(name="description", type="String", defaultValue=""), @NiagaraProperty(name="httpRedirectEndpoint", type="BString", defaultValue="https://localhost:443/saml/idp/auth/httpredirect/cot/", flags=1), @NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="serviceProviders", type="BStationServiceProviderFolder", defaultValue="new BStationServiceProviderFolder()"), @NiagaraProperty(name="users", type="BString", defaultValue="", flags=4), @NiagaraProperty(name="authenticationSchemes", type="BString", defaultValue="", flags=4), @NiagaraProperty(name="prototypes", type="BPrototypesFolder", defaultValue="new BPrototypesFolder()", flags=5)})
@NiagaraAction(name="submitStationDiscoveryJob", returnType="BOrd")
public final class BCircleOfTrust
extends BComponent {
    @Generated
    public static final Property uniqueId = BCircleOfTrust.newProperty((int)69, (BValue)BUuid.DEFAULT, null);
    @Generated
    public static final Property description = BCircleOfTrust.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property httpRedirectEndpoint = BCircleOfTrust.newProperty((int)1, (String)"https://localhost:443/saml/idp/auth/httpredirect/cot/", null);
    @Generated
    public static final Property enabled = BCircleOfTrust.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property serviceProviders = BCircleOfTrust.newProperty((int)0, (BValue)new BStationServiceProviderFolder(), null);
    @Generated
    public static final Property users = BCircleOfTrust.newProperty((int)4, (String)"", null);
    @Generated
    public static final Property authenticationSchemes = BCircleOfTrust.newProperty((int)4, (String)"", null);
    @Generated
    public static final Property prototypes = BCircleOfTrust.newProperty((int)5, (BValue)new BPrototypesFolder(), null);
    @Generated
    public static final Action submitStationDiscoveryJob = BCircleOfTrust.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BCircleOfTrust.class);
    private BUuid originalUniqueId;

    @Generated
    public BUuid getUniqueId() {
        return (BUuid)this.get(uniqueId);
    }

    @Generated
    public void setUniqueId(BUuid v) {
        this.set(uniqueId, (BValue)v, null);
    }

    @Generated
    public String getDescription() {
        return this.getString(description);
    }

    @Generated
    public void setDescription(String v) {
        this.setString(description, v, null);
    }

    @Generated
    public String getHttpRedirectEndpoint() {
        return this.getString(httpRedirectEndpoint);
    }

    @Generated
    public void setHttpRedirectEndpoint(String v) {
        this.setString(httpRedirectEndpoint, v, null);
    }

    @Generated
    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    @Generated
    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    @Generated
    public BStationServiceProviderFolder getServiceProviders() {
        return (BStationServiceProviderFolder)this.get(serviceProviders);
    }

    @Generated
    public void setServiceProviders(BStationServiceProviderFolder v) {
        this.set(serviceProviders, (BValue)v, null);
    }

    @Generated
    public String getUsers() {
        return this.getString(users);
    }

    @Generated
    public void setUsers(String v) {
        this.setString(users, v, null);
    }

    @Generated
    public String getAuthenticationSchemes() {
        return this.getString(authenticationSchemes);
    }

    @Generated
    public void setAuthenticationSchemes(String v) {
        this.setString(authenticationSchemes, v, null);
    }

    @Generated
    public BPrototypesFolder getPrototypes() {
        return (BPrototypesFolder)this.get(prototypes);
    }

    @Generated
    public void setPrototypes(BPrototypesFolder v) {
        this.set(prototypes, (BValue)v, null);
    }

    @Generated
    public BOrd submitStationDiscoveryJob() {
        return (BOrd)this.invoke(submitStationDiscoveryJob, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BCircleOfTrust() {
        this.setUniqueId(BUuid.make());
    }

    public BOrd doSubmitStationDiscoveryJob(Context cx) {
        return BOrd.DEFAULT;
    }

    public void started() throws Exception {
        super.started();
        this.originalUniqueId = this.getUniqueId();
        BSAMLIdPService idPService = (BSAMLIdPService)Sys.getService((Type)BSAMLIdPService.TYPE);
        idPService.updateCircleOfTrustEndpoints();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (Sys.isStationStarted() && httpRedirectEndpoint.equals(property) && context != BSAMLIdPService.ENDPOINT_UPDATE_CONTEXT) {
            BSAMLIdPService idPService = (BSAMLIdPService)Sys.getService((Type)BSAMLIdPService.TYPE);
            idPService.updateCircleOfTrustEndpoints();
            SAMLUtils.log(Level.WARNING, "The'httpRedirectEndpoint' property is managed by the SAMLIdPService and cannot be modified");
        }
        if (this.isRunning() && uniqueId.equals(property)) {
            this.setUniqueId(this.originalUniqueId);
            SAMLUtils.log(Level.WARNING, "The 'uniqueId' cannot be modified. Reverting to original value.");
        }
    }

    public boolean isParentLegal(BComponent parent) {
        return parent.getType().is(BCircleOfTrustFolder.TYPE);
    }

    boolean isUserMember(BUser user) {
        String[] usernames;
        BAuthenticationScheme authenticationScheme = null;
        try {
            authenticationScheme = user.getAuthenticationScheme();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (authenticationScheme != null) {
            String[] authnSchemes;
            String requestedUserScheme = authenticationScheme.getHandleOrd().toString();
            for (String authnScheme : authnSchemes = this.getAuthenticationSchemes().split(",")) {
                if (!requestedUserScheme.equals(EscUtil.slot.unescape(authnScheme.trim()))) continue;
                return true;
            }
        }
        String requestedUsername = user.getHandleOrd().toString();
        for (String username : usernames = this.getUsers().split(",")) {
            if (!requestedUsername.equals(EscUtil.slot.unescape(username.trim()))) continue;
            return true;
        }
        return false;
    }
}

