/*
 * Decompiled with CFR 0.152.
 */
package com.onelogin.saml;

import com.onelogin.saml.XMLErrorHandler;
import com.tridium.saml.SAMLException;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Utils {
    private static final boolean JAXP_15_SUPPORTED = Utils.isJaxp15Supported();
    private static final Logger log = Logger.getLogger(Utils.class.getName());

    public static boolean isJaxp15Supported() {
        boolean supported = true;
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SAXParser parser = spf.newSAXParser();
            parser.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "file");
        }
        catch (SAXException ex) {
            String err = ex.getMessage();
            if (err.contains("Property 'http://javax.xml.XMLConstants/property/accessExternalDTD' is not recognized.")) {
                supported = false;
            }
        }
        catch (Exception e) {
            log.log(Level.INFO, "An exception occurred while trying to determine if JAXP 1.5 options are supported.", e);
        }
        return supported;
    }

    public static NodeList query(Document dom, String query, Node context) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(new NamespaceContext(){

            @Override
            public String getNamespaceURI(String prefix) {
                String result = null;
                switch (prefix) {
                    case "samlp": 
                    case "samlp2": {
                        result = "urn:oasis:names:tc:SAML:2.0:protocol";
                        break;
                    }
                    case "saml": 
                    case "saml2": {
                        result = "urn:oasis:names:tc:SAML:2.0:assertion";
                        break;
                    }
                    case "ds": {
                        result = "http://www.w3.org/2000/09/xmldsig#";
                        break;
                    }
                    case "xenc": {
                        result = "http://www.w3.org/2001/04/xmlenc#";
                        break;
                    }
                    case "md": {
                        result = "urn:oasis:names:tc:SAML:2.0:metadata";
                    }
                }
                return result;
            }

            @Override
            public String getPrefix(String namespaceURI) {
                return null;
            }

            public Iterator getPrefixes(String namespaceURI) {
                return null;
            }
        });
        NodeList nodeList = context == null ? (NodeList)xpath.evaluate(query, dom, XPathConstants.NODESET) : (NodeList)xpath.evaluate(query, context, XPathConstants.NODESET);
        return nodeList;
    }

    public static NodeList query(Document dom, String query) throws XPathExpressionException {
        return Utils.query(dom, query, null);
    }

    public static Map<String, String> getStatus(Document dom) throws Error {
        HashMap<String, String> status = new HashMap<String, String>();
        try {
            NodeList messageEntry;
            NodeList statusEntry = Utils.query(dom, "/samlp:Response/samlp:Status", null);
            if (statusEntry.getLength() != 1) {
                throw new Error("Missing Status on response");
            }
            NodeList codeEntry = Utils.query(dom, "/samlp:Response/samlp:Status/samlp:StatusCode", statusEntry.item(0));
            if (codeEntry.getLength() == 0) {
                throw new Error("Missing Status Code on response");
            }
            status.put("code", codeEntry.item(0).getAttributes().getNamedItem("Value").getNodeValue());
            NodeList subStatusCodeEntry = Utils.query(dom, "/samlp:Response/samlp:Status/samlp:StatusCode/samlp:StatusCode", (Element)statusEntry.item(0));
            if (subStatusCodeEntry.getLength() > 0) {
                String subStatusCode = subStatusCodeEntry.item(0).getAttributes().getNamedItem("Value").getNodeValue();
                status.put("subStatusCode", subStatusCode);
            }
            if ((messageEntry = Utils.query(dom, "/samlp:Response/samlp:Status/samlp:StatusMessage", statusEntry.item(0))).getLength() == 1) {
                status.put("msg", messageEntry.item(0).getNodeValue());
            } else {
                status.put("msg", "");
            }
        }
        catch (Error e) {
            log.severe("Error executing getStatus: " + e.getMessage());
            throw e;
        }
        catch (Exception ex) {
            log.severe("Error executing getStatus: " + ex.getMessage());
        }
        return status;
    }

    public static Document loadXML(String xml) throws SAMLException {
        try {
            if (xml.contains("<!ENTITY")) {
                throw new SAMLException("Detected use of ENTITY in XML, disabled to prevent XXE/XEE attacks");
            }
            return Utils.convertStringToDocument(xml);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Load XML error: " + e.getMessage(), log.isLoggable(Level.FINE) ? e : null);
            return null;
        }
    }

    public static void validateXML(Document xml, String schemaName) throws Exception {
        Utils.validateXML(Utils.getStringFromDocument(xml), schemaName);
    }

    public static void validateXML(String xmlString, String schemaName) throws Exception {
        try {
            String schemaFullPath = "schemas/" + schemaName;
            ClassLoader classLoader = Utils.class.getClassLoader();
            URL schemaFile = classLoader.getResource(schemaFullPath);
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(schemaFile);
            Validator validator = schema.newValidator();
            if (JAXP_15_SUPPORTED) {
                validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            }
            XMLErrorHandler errorHandler = new XMLErrorHandler();
            validator.setErrorHandler(errorHandler);
            validator.validate(new StreamSource(new StringReader(xmlString)));
            if (!errorHandler.getErrorXML().isEmpty()) {
                throw new Error("Invalid XML. See the log");
            }
        }
        catch (Exception ex) {
            log.severe("Error executing validateXML: " + ex.getMessage());
            throw ex;
        }
    }

    public static boolean validateSign(Node signatureElement, Certificate cert) throws Exception {
        boolean res;
        DOMValidateContext ctx = new DOMValidateContext(cert.getPublicKey(), signatureElement);
        XMLSignatureFactory sigF = XMLSignatureFactory.getInstance("DOM");
        try {
            try {
                res = AccessController.doPrivileged(() -> {
                    XMLSignature xmlSignature = sigF.unmarshalXMLSignature(ctx);
                    return xmlSignature.validate(ctx);
                });
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
        }
        catch (MarshalException e) {
            log.severe("Cannot locate Signature Node " + e.getMessage());
            throw e;
        }
        catch (NullPointerException e) {
            log.severe("Context can't be validated" + e.getMessage());
            throw e;
        }
        return res;
    }

    public static Document convertStringToDocument(String xmlStr) throws ParserConfigurationException, SAXException, IOException {
        return Utils.parseXML(new InputSource(new StringReader(xmlStr)));
    }

    public static Document parseXML(InputSource inputSource) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory docfactory = DocumentBuilderFactory.newInstance();
        docfactory.setNamespaceAware(true);
        docfactory.setExpandEntityReferences(false);
        docfactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        try {
            docfactory.setAttribute("http://xml.org/sax/features/external-general-entities", Boolean.FALSE);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            docfactory.setAttribute("http://xml.org/sax/features/external-parameter-entities", Boolean.FALSE);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            docfactory.setAttribute("http://apache.org/xml/features/disallow-doctype-decl", Boolean.TRUE);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            docfactory.setAttribute("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            docfactory.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", Boolean.FALSE);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            docfactory.setAttribute("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", Boolean.FALSE);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            docfactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        DocumentBuilder builder = docfactory.newDocumentBuilder();
        XMLErrorHandler errorHandler = new XMLErrorHandler();
        builder.setErrorHandler(errorHandler);
        Document doc = builder.parse(inputSource);
        XPath xpath = Utils.getXPathFactory().newXPath();
        try {
            XPathExpression expr = xpath.compile("//*[@ID]");
            NodeList nodeList = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element elem = (Element)nodeList.item(i);
                Attr attr = (Attr)elem.getAttributes().getNamedItem("ID");
                elem.setIdAttributeNode(attr, true);
            }
        }
        catch (XPathExpressionException e) {
            return null;
        }
        return doc;
    }

    private static XPathFactory getXPathFactory() {
        try {
            return XPathFactory.newInstance("http://java.sun.com/jaxp/xpath/dom", "com.sun.org.apache.xpath.internal.jaxp.XPathFactoryImpl", ClassLoader.getSystemClassLoader());
        }
        catch (XPathFactoryConfigurationException e) {
            log.log(Level.FINE, "Error generating XPathFactory instance: " + e.getMessage(), e);
            return XPathFactory.newInstance();
        }
    }

    public static String getStringFromDocument(Document doc) {
        try {
            DOMSource domSource = new DOMSource(doc);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(domSource, result);
            writer.flush();
            return writer.toString();
        }
        catch (TransformerException ex) {
            log.severe("Error executing getStringFromDocument: " + ex.getMessage());
            return null;
        }
    }

    public static Document copyDocument(Document source) throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Element originalRoot = source.getDocumentElement();
        Document copiedDocument = db.newDocument();
        Node copiedRoot = copiedDocument.importNode(originalRoot, true);
        copiedDocument.appendChild(copiedRoot);
        return copiedDocument;
    }

    public static String toStringUtf8(byte[] bytes) {
        return new String(bytes, StandardCharsets.UTF_8);
    }
}

