/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.httpClient.util;

import com.tridium.httpClient.datatypes.exception.HttpClientException;
import com.tridium.httpClient.util.HttpClientUtils;
import com.tridium.util.PrefixLogUtil;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="false", facets={@Facet(name="BFacets.SECURITY", value="BBoolean.TRUE")}), @NiagaraProperty(name="period", type="BRelTime", defaultValue="BRelTime.makeHours(1)", facets={@Facet(name="BFacets.SECURITY", value="BBoolean.TRUE")}), @NiagaraProperty(name="maxRequests", type="int", defaultValue="0", facets={@Facet(name="BFacets.MIN", value="0"), @Facet(name="BFacets.SECURITY", value="BBoolean.TRUE")}), @NiagaraProperty(name="snapToHour", type="boolean", defaultValue="true"), @NiagaraProperty(name="nextThresholdTime", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=3, facets={@Facet(name="BFacets.SECURITY", value="BBoolean.TRUE")}), @NiagaraProperty(name="currentCount", type="int", defaultValue="0", flags=65539, facets={@Facet(name="BFacets.SECURITY", value="BBoolean.TRUE")})})
@NiagaraAction(name="reset")
public class BRequestThrottle
extends BComponent {
    @Generated
    public static final Property enabled = BRequestThrottle.newProperty((int)0, (boolean)false, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property period = BRequestThrottle.newProperty((int)0, (BValue)BRelTime.makeHours((int)1), (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property maxRequests = BRequestThrottle.newProperty((int)0, (int)0, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)0), (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE)));
    @Generated
    public static final Property snapToHour = BRequestThrottle.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property nextThresholdTime = BRequestThrottle.newProperty((int)3, (BValue)BAbsTime.DEFAULT, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property currentCount = BRequestThrottle.newProperty((int)65539, (int)0, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Action reset = BRequestThrottle.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BRequestThrottle.class);
    private final Object mutex = new Object();

    @Generated
    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    @Generated
    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    @Generated
    public BRelTime getPeriod() {
        return (BRelTime)this.get(period);
    }

    @Generated
    public void setPeriod(BRelTime v) {
        this.set(period, (BValue)v, null);
    }

    @Generated
    public int getMaxRequests() {
        return this.getInt(maxRequests);
    }

    @Generated
    public void setMaxRequests(int v) {
        this.setInt(maxRequests, v, null);
    }

    @Generated
    public boolean getSnapToHour() {
        return this.getBoolean(snapToHour);
    }

    @Generated
    public void setSnapToHour(boolean v) {
        this.setBoolean(snapToHour, v, null);
    }

    @Generated
    public BAbsTime getNextThresholdTime() {
        return (BAbsTime)this.get(nextThresholdTime);
    }

    @Generated
    public void setNextThresholdTime(BAbsTime v) {
        this.set(nextThresholdTime, (BValue)v, null);
    }

    @Generated
    public int getCurrentCount() {
        return this.getInt(currentCount);
    }

    @Generated
    public void setCurrentCount(int v) {
        this.setInt(currentCount, v, null);
    }

    @Generated
    public void reset() {
        this.invoke(reset, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void changed(Property property, Context context) {
        if (this.isRunning() && property.equals(enabled) || property.equals(period) || property.equals(maxRequests) || property.equals(snapToHour)) {
            this.doReset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doReset() {
        Object object = this.mutex;
        synchronized (object) {
            this.setCurrentCount(0);
            this.setNextThresholdTime(BAbsTime.DEFAULT);
            PrefixLogUtil.logWithPrefix((Logger)HttpClientUtils.MAIN_LOGGER, (Level)Level.FINE, () -> "Request throttling threshold reset", (Object)((Object)this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void checkRequestThrottleThreshold(boolean global) throws HttpClientException {
        if (this.getEnabled() && this.getMaxRequests() > 0) {
            Object object = this.mutex;
            synchronized (object) {
                if (this.getNextThresholdTime().isBefore(BAbsTime.now())) {
                    this.setCurrentCount(0);
                    this.calculateNextThresholdTime(BAbsTime.now());
                    PrefixLogUtil.logWithPrefix((Logger)HttpClientUtils.MAIN_LOGGER, (Level)Level.FINE, () -> "Request throttling threshold resetting for next period", (Object)((Object)this));
                }
                this.setCurrentCount(this.getCurrentCount() + 1);
                if (this.getCurrentCount() > this.getMaxRequests()) {
                    StringBuilder error = new StringBuilder("Exceeded ").append(global ? "global " : "").append("client send limit");
                    throw new HttpClientException(error.toString());
                }
            }
        }
    }

    private void calculateNextThresholdTime(BAbsTime fromTime) {
        BAbsTime nxtThresholdTime = fromTime.add(this.getPeriod());
        if (this.getSnapToHour() && (this.getPeriod().getHours() >= 1 || nxtThresholdTime.getHour() > fromTime.getHour())) {
            nxtThresholdTime = BRequestThrottle.snapToEndOfHour(nxtThresholdTime);
        }
        this.setNextThresholdTime(nxtThresholdTime);
    }

    private static BAbsTime snapToEndOfHour(BAbsTime time) {
        BAbsTime adjusted = time.subtract(BRelTime.makeMinutes((int)time.getMinute()));
        adjusted = adjusted.subtract(BRelTime.makeSeconds((int)time.getSecond()));
        return adjusted;
    }
}

