/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.httpClient.util;

import com.tridium.httpClient.comm.client.BIHttpCommClientWrite;
import com.tridium.httpClient.comm.client.HttpCommResponse;
import com.tridium.httpClient.comm.transport.HttpRequestInstance;
import com.tridium.httpClient.datatypes.BHttpResponseHealth;
import com.tridium.httpClient.util.BIHttpConsumer;
import com.tridium.httpClient.util.BMetrics;
import com.tridium.httpClient.util.HttpClientUtils;
import com.tridium.httpClient.util.HttpConsumable;
import com.tridium.httpClient.util.ParentLegal;
import java.nio.charset.StandardCharsets;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLong;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="requestsTotal", type="long", defaultValue="BLong.DEFAULT", flags=73729), @NiagaraProperty(name="requestsFailed", type="long", defaultValue="BLong.DEFAULT", flags=73729), @NiagaraProperty(name="responsesReceived", type="long", defaultValue="BLong.DEFAULT", flags=73729), @NiagaraProperty(name="result200", type="long", defaultValue="BLong.DEFAULT", flags=73729), @NiagaraProperty(name="result200to299", type="long", defaultValue="BLong.DEFAULT", flags=73729), @NiagaraProperty(name="result300to399", type="long", defaultValue="BLong.DEFAULT", flags=73729), @NiagaraProperty(name="result400to499", type="long", defaultValue="BLong.DEFAULT", flags=73729), @NiagaraProperty(name="result500plus", type="long", defaultValue="BLong.DEFAULT", flags=73729), @NiagaraProperty(name="durationTotal", type="long", defaultValue="BLong.DEFAULT", flags=73729, facets={@Facet(value="createMillisUnitFacet()")}), @NiagaraProperty(name="slowestGoodResponse", type="long", defaultValue="BLong.DEFAULT", flags=73729, facets={@Facet(value="createMillisUnitFacet()")}), @NiagaraProperty(name="durationAvg", type="double", defaultValue="BDouble.DEFAULT", flags=73729, facets={@Facet(value="createMillisUnitFacet()"), @Facet(value="createPrecisionFacet(2)")}), @NiagaraProperty(name="requestBodySize", type="long", defaultValue="BLong.DEFAULT", flags=73729, facets={@Facet(value="createByteUnitFacet()")}), @NiagaraProperty(name="requestBodyBytesAvg", type="double", defaultValue="BDouble.DEFAULT", flags=73729, facets={@Facet(value="createByteUnitFacet()"), @Facet(value="createPrecisionFacet(2)")}), @NiagaraProperty(name="responseBodySize", type="long", defaultValue="BLong.DEFAULT", flags=73729, facets={@Facet(value="createByteUnitFacet()")}), @NiagaraProperty(name="responseBodySizeAvg", type="double", defaultValue="BDouble.DEFAULT", flags=73729, facets={@Facet(value="createByteUnitFacet()"), @Facet(value="createPrecisionFacet(2)")})})
public class BHttpClientMetrics
extends BMetrics
implements BIHttpConsumer {
    @Generated
    public static final Property requestsTotal = BHttpClientMetrics.newProperty((int)73729, (BValue)BLong.DEFAULT, null);
    @Generated
    public static final Property requestsFailed = BHttpClientMetrics.newProperty((int)73729, (BValue)BLong.DEFAULT, null);
    @Generated
    public static final Property responsesReceived = BHttpClientMetrics.newProperty((int)73729, (BValue)BLong.DEFAULT, null);
    @Generated
    public static final Property result200 = BHttpClientMetrics.newProperty((int)73729, (BValue)BLong.DEFAULT, null);
    @Generated
    public static final Property result200to299 = BHttpClientMetrics.newProperty((int)73729, (BValue)BLong.DEFAULT, null);
    @Generated
    public static final Property result300to399 = BHttpClientMetrics.newProperty((int)73729, (BValue)BLong.DEFAULT, null);
    @Generated
    public static final Property result400to499 = BHttpClientMetrics.newProperty((int)73729, (BValue)BLong.DEFAULT, null);
    @Generated
    public static final Property result500plus = BHttpClientMetrics.newProperty((int)73729, (BValue)BLong.DEFAULT, null);
    @Generated
    public static final Property durationTotal = BHttpClientMetrics.newProperty((int)73729, (BValue)BLong.DEFAULT, (BFacets)BHttpClientMetrics.createMillisUnitFacet());
    @Generated
    public static final Property slowestGoodResponse = BHttpClientMetrics.newProperty((int)73729, (BValue)BLong.DEFAULT, (BFacets)BHttpClientMetrics.createMillisUnitFacet());
    @Generated
    public static final Property durationAvg = BHttpClientMetrics.newProperty((int)73729, (BValue)BDouble.DEFAULT, (BFacets)BFacets.make((BFacets)BHttpClientMetrics.createMillisUnitFacet(), (BFacets)BHttpClientMetrics.createPrecisionFacet(2)));
    @Generated
    public static final Property requestBodySize = BHttpClientMetrics.newProperty((int)73729, (BValue)BLong.DEFAULT, (BFacets)BHttpClientMetrics.createByteUnitFacet());
    @Generated
    public static final Property requestBodyBytesAvg = BHttpClientMetrics.newProperty((int)73729, (BValue)BDouble.DEFAULT, (BFacets)BFacets.make((BFacets)BHttpClientMetrics.createByteUnitFacet(), (BFacets)BHttpClientMetrics.createPrecisionFacet(2)));
    @Generated
    public static final Property responseBodySize = BHttpClientMetrics.newProperty((int)73729, (BValue)BLong.DEFAULT, (BFacets)BHttpClientMetrics.createByteUnitFacet());
    @Generated
    public static final Property responseBodySizeAvg = BHttpClientMetrics.newProperty((int)73729, (BValue)BDouble.DEFAULT, (BFacets)BFacets.make((BFacets)BHttpClientMetrics.createByteUnitFacet(), (BFacets)BHttpClientMetrics.createPrecisionFacet(2)));
    @Generated
    public static final Type TYPE = Sys.loadType(BHttpClientMetrics.class);

    @Generated
    public long getRequestsTotal() {
        return this.getLong(requestsTotal);
    }

    @Generated
    public void setRequestsTotal(long v) {
        this.setLong(requestsTotal, v, null);
    }

    @Generated
    public long getRequestsFailed() {
        return this.getLong(requestsFailed);
    }

    @Generated
    public void setRequestsFailed(long v) {
        this.setLong(requestsFailed, v, null);
    }

    @Generated
    public long getResponsesReceived() {
        return this.getLong(responsesReceived);
    }

    @Generated
    public void setResponsesReceived(long v) {
        this.setLong(responsesReceived, v, null);
    }

    @Generated
    public long getResult200() {
        return this.getLong(result200);
    }

    @Generated
    public void setResult200(long v) {
        this.setLong(result200, v, null);
    }

    @Generated
    public long getResult200to299() {
        return this.getLong(result200to299);
    }

    @Generated
    public void setResult200to299(long v) {
        this.setLong(result200to299, v, null);
    }

    @Generated
    public long getResult300to399() {
        return this.getLong(result300to399);
    }

    @Generated
    public void setResult300to399(long v) {
        this.setLong(result300to399, v, null);
    }

    @Generated
    public long getResult400to499() {
        return this.getLong(result400to499);
    }

    @Generated
    public void setResult400to499(long v) {
        this.setLong(result400to499, v, null);
    }

    @Generated
    public long getResult500plus() {
        return this.getLong(result500plus);
    }

    @Generated
    public void setResult500plus(long v) {
        this.setLong(result500plus, v, null);
    }

    @Generated
    public long getDurationTotal() {
        return this.getLong(durationTotal);
    }

    @Generated
    public void setDurationTotal(long v) {
        this.setLong(durationTotal, v, null);
    }

    @Generated
    public long getSlowestGoodResponse() {
        return this.getLong(slowestGoodResponse);
    }

    @Generated
    public void setSlowestGoodResponse(long v) {
        this.setLong(slowestGoodResponse, v, null);
    }

    @Generated
    public double getDurationAvg() {
        return this.getDouble(durationAvg);
    }

    @Generated
    public void setDurationAvg(double v) {
        this.setDouble(durationAvg, v, null);
    }

    @Generated
    public long getRequestBodySize() {
        return this.getLong(requestBodySize);
    }

    @Generated
    public void setRequestBodySize(long v) {
        this.setLong(requestBodySize, v, null);
    }

    @Generated
    public double getRequestBodyBytesAvg() {
        return this.getDouble(requestBodyBytesAvg);
    }

    @Generated
    public void setRequestBodyBytesAvg(double v) {
        this.setDouble(requestBodyBytesAvg, v, null);
    }

    @Generated
    public long getResponseBodySize() {
        return this.getLong(responseBodySize);
    }

    @Generated
    public void setResponseBodySize(long v) {
        this.setLong(responseBodySize, v, null);
    }

    @Generated
    public double getResponseBodySizeAvg() {
        return this.getDouble(responseBodySizeAvg);
    }

    @Generated
    public void setResponseBodySizeAvg(double v) {
        this.setDouble(responseBodySizeAvg, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void consume(HttpConsumable consumable) {
        if (consumable instanceof HttpRequestInstance) {
            this.incrementMetric(requestsTotal);
            this.setLastSentTime(BAbsTime.now());
        } else if (consumable instanceof HttpCommResponse) {
            this.consume((HttpCommResponse)consumable);
        }
    }

    private void consume(HttpCommResponse response) {
        if (response.failed()) {
            this.incrementMetric(requestsFailed);
        } else {
            this.incrementMetric(responsesReceived);
            this.handleResponseCode(response);
            this.updateDuration(response);
            this.updateSentBytes();
            this.handleResponseBody(response.getBody());
        }
    }

    private void handleResponseCode(HttpCommResponse response) {
        int responseCode = response.getResponseCode();
        if (response.inRange(200, 299)) {
            this.incrementMetric(result200to299);
            if (responseCode == 200) {
                this.incrementMetric(result200);
            }
        } else if (response.inRange(300, 399)) {
            this.incrementMetric(result300to399);
        } else if (response.inRange(400, 499)) {
            this.incrementMetric(result400to499);
        } else if (responseCode > 499) {
            this.incrementMetric(result500plus);
        }
    }

    private void updateDuration(HttpCommResponse response) {
        this.increaseMetric(durationTotal, response.getDurationMillis());
        this.calculateAverage(durationAvg, durationTotal, responsesReceived);
        if (response.isGood() && response.getDurationMillis() > this.getSlowestGoodResponse()) {
            this.setSlowestGoodResponse(response.getDurationMillis());
        }
    }

    private void updateSentBytes() {
        BIHttpCommClientWrite writer = HttpClientUtils.getParent((BComplex)this, BIHttpCommClientWrite.class);
        if (writer != null) {
            long requestLength = writer.getRequestBody().getSource().length();
            this.increaseMetric(requestBodySize, requestLength);
            this.calculateAverage(requestBodyBytesAvg, requestBodySize, requestsTotal);
        }
    }

    private void handleResponseBody(String result) {
        if (result != null) {
            this.increaseMetric(responseBodySize, result.getBytes(StandardCharsets.UTF_8).length);
        }
        this.calculateAverage(responseBodySizeAvg, responseBodySize, responsesReceived);
    }

    public boolean isParentLegal(BComponent parent) {
        return ParentLegal.is((BComplex)this, (BComplex)parent, BHttpResponseHealth.TYPE);
    }

    public BIcon getIcon() {
        return BIcon.std((String)"superscript.png");
    }
}

