/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.httpClient.comm.client;

import com.tridium.httpClient.datatypes.BHttpAddress;
import com.tridium.httpClient.datatypes.BHttpResponseHealth;
import com.tridium.httpClient.datatypes.BHttpTuningPolicy;
import com.tridium.httpClient.datatypes.options.BHttpHeaders;
import com.tridium.httpClient.datatypes.options.BHttpParameters;
import com.tridium.httpClient.util.HttpClientUtils;
import com.tridium.util.IPrefixLoggable;
import com.tridium.util.ModuleThreadPool;
import com.tridium.util.PrefixLogUtil;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.httpClient.IHttpClient;
import javax.baja.httpClient.IHttpResponse;
import javax.baja.httpClient.datatypes.BHttpRequestMethod;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BInterface;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public interface BIHttpCommClient
extends IHttpClient,
BInterface,
IPrefixLoggable {
    @Generated
    public static final Type TYPE = Sys.loadType(BIHttpCommClient.class);

    public BHttpResponseHealth getHealth();

    public void setHealth(BHttpResponseHealth var1);

    public BHttpRequestMethod getMethod();

    public void setMethod(BHttpRequestMethod var1);

    public BHttpAddress getAddress();

    public void setAddress(BHttpAddress var1);

    public BHttpHeaders getHeaders();

    public void setHeaders(BHttpHeaders var1);

    public BHttpParameters getParameters();

    public void setParameters(BHttpParameters var1);

    public BHttpTuningPolicy getHttpTuningPolicy();

    public boolean isDriverBasedClient();

    @Override
    default public Future<IHttpResponse> sendAsync() {
        return ModuleThreadPool.getInstance((Type)TYPE).submit(() -> {
            try {
                this.sendSync();
                return this.getHealth().getLastCommResponse();
            }
            catch (Exception e) {
                PrefixLogUtil.logWithPrefix((Logger)HttpClientUtils.MAIN_LOGGER, (Level)Level.SEVERE, (String)"Async send request failed", (Throwable)e, (Object)this);
                return null;
            }
        });
    }

    @Override
    default public Optional<IHttpResponse> getLastResult() {
        return Optional.ofNullable(this.getHealth().getLastCommResponse());
    }

    @Override
    default public boolean hasResponse() {
        return this.getLastResponseCode() != -1;
    }

    @Override
    default public String getLastResponseBody() {
        return this.getLastResult().map(result -> result.getBody()).orElse(null);
    }

    @Override
    default public int getLastResponseCode() {
        return this.getLastResult().map(result -> result.getResponseCode()).orElse(-1);
    }
}

