/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.httpClient;

import com.tridium.httpClient.comm.client.BIHttpCommClient;
import com.tridium.httpClient.datatypes.BHttpTuningPolicy;
import com.tridium.httpClient.datatypes.enums.BHttpMode;
import com.tridium.httpClient.datatypes.exception.HttpClientException;
import com.tridium.httpClient.util.BHttpClientRequestHistory;
import com.tridium.httpClient.util.BRequestThrottle;
import com.tridium.httpClient.util.BSMAExpirationMonitor;
import com.tridium.httpClient.util.HttpClientRegister;
import com.tridium.httpClient.util.HttpClientUtils;
import com.tridium.httpClient.util.LicenseUtil;
import com.tridium.util.ModuleThreadPool;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.AuditEvent;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BIRestrictedComponent;
import javax.baja.util.IFuture;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enableNonDriverClients", type="boolean", defaultValue="false", facets={@Facet(name="BFacets.SECURITY", value="BBoolean.TRUE")}), @NiagaraProperty(name="enableInsecureHttp", type="boolean", defaultValue="false", facets={@Facet(name="BFacets.SECURITY", value="BBoolean.TRUE")}), @NiagaraProperty(name="SMAExpirationMonitor", type="BSMAExpirationMonitor", defaultValue="new BSMAExpirationMonitor()"), @NiagaraProperty(name="globalRequestThrottle", type="BRequestThrottle", defaultValue="new BRequestThrottle()"), @NiagaraProperty(name="clientRequestHistory", type="BHttpClientRequestHistory", defaultValue="new BHttpClientRequestHistory()"), @NiagaraProperty(name="threadPoolSize", type="int", defaultValue="10", flags=4, facets={@Facet(name="BFacets.MIN", value="1")})})
@NiagaraActions(value={@NiagaraAction(name="enableAll", flags=400), @NiagaraAction(name="disableAll", flags=400)})
public final class BHttpClientService
extends BAbstractService
implements BIRestrictedComponent {
    @Generated
    public static final Property enableNonDriverClients = BHttpClientService.newProperty((int)0, (boolean)false, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property enableInsecureHttp = BHttpClientService.newProperty((int)0, (boolean)false, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property SMAExpirationMonitor = BHttpClientService.newProperty((int)0, (BValue)new BSMAExpirationMonitor(), null);
    @Generated
    public static final Property globalRequestThrottle = BHttpClientService.newProperty((int)0, (BValue)new BRequestThrottle(), null);
    @Generated
    public static final Property clientRequestHistory = BHttpClientService.newProperty((int)0, (BValue)new BHttpClientRequestHistory(), null);
    @Generated
    public static final Property threadPoolSize = BHttpClientService.newProperty((int)4, (int)10, (BFacets)BFacets.make((String)"min", (int)1));
    @Generated
    public static final Action enableAll = BHttpClientService.newAction((int)400, null);
    @Generated
    public static final Action disableAll = BHttpClientService.newAction((int)400, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BHttpClientService.class);
    private static final Logger LOG = HttpClientUtils.MAIN_LOGGER;
    private static final String ENABLED_PROP_NAME = "enabled";
    public static final String SYSTEM_USERNAME_DEFAULT = "system";

    @Generated
    public boolean getEnableNonDriverClients() {
        return this.getBoolean(enableNonDriverClients);
    }

    @Generated
    public void setEnableNonDriverClients(boolean v) {
        this.setBoolean(enableNonDriverClients, v, null);
    }

    @Generated
    public boolean getEnableInsecureHttp() {
        return this.getBoolean(enableInsecureHttp);
    }

    @Generated
    public void setEnableInsecureHttp(boolean v) {
        this.setBoolean(enableInsecureHttp, v, null);
    }

    @Generated
    public BSMAExpirationMonitor getSMAExpirationMonitor() {
        return (BSMAExpirationMonitor)this.get(SMAExpirationMonitor);
    }

    @Generated
    public void setSMAExpirationMonitor(BSMAExpirationMonitor v) {
        this.set(SMAExpirationMonitor, (BValue)v, null);
    }

    @Generated
    public BRequestThrottle getGlobalRequestThrottle() {
        return (BRequestThrottle)this.get(globalRequestThrottle);
    }

    @Generated
    public void setGlobalRequestThrottle(BRequestThrottle v) {
        this.set(globalRequestThrottle, (BValue)v, null);
    }

    @Generated
    public BHttpClientRequestHistory getClientRequestHistory() {
        return (BHttpClientRequestHistory)this.get(clientRequestHistory);
    }

    @Generated
    public void setClientRequestHistory(BHttpClientRequestHistory v) {
        this.set(clientRequestHistory, (BValue)v, null);
    }

    @Generated
    public int getThreadPoolSize() {
        return this.getInt(threadPoolSize);
    }

    @Generated
    public void setThreadPoolSize(int v) {
        this.setInt(threadPoolSize, v, null);
    }

    @Generated
    public void enableAll() {
        this.invoke(enableAll, null, null);
    }

    @Generated
    public void disableAll() {
        this.invoke(disableAll, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        this.initLicenseProperty();
        ModuleThreadPool.getInstance((Type)TYPE).setMaxThreadPoolSize(this.getThreadPoolSize());
    }

    public void serviceStopped() throws Exception {
        if (Sys.isStation()) {
            ModuleThreadPool.shutdown((Type)TYPE);
        }
    }

    public void changed(Property property, Context context) {
        if (this.isRunning() && property.equals(threadPoolSize)) {
            ModuleThreadPool.getInstance((Type)TYPE).setMaxThreadPoolSize(this.getThreadPoolSize());
        }
    }

    public void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        BIRestrictedComponent.checkParentForRestrictedComponent((BComponent)parent, (BIRestrictedComponent)this);
        BIRestrictedComponent.checkContextForSuperUser((BIRestrictedComponent)this, (Context)cx);
    }

    public void doEnableAll(Context cx) {
        this.setEnabledStateForAll(BBoolean.TRUE, cx);
    }

    public void doDisableAll(Context cx) {
        this.setEnabledStateForAll(BBoolean.FALSE, cx);
    }

    private void setEnabledStateForAll(BBoolean state, Context cx) {
        if (!this.isRunning() || !this.getEnabled()) {
            return;
        }
        HttpClientRegister.getClients().forEach(client -> BHttpClientService.setEnabledState(client, state, cx));
    }

    private static void setEnabledState(BIHttpCommClient client, BBoolean state, Context cx) {
        BComplex complex;
        Property enabledProp;
        if (client instanceof BComplex && (enabledProp = (complex = client.asObject().asComplex()).getProperty(ENABLED_PROP_NAME)) != null) {
            complex.set(enabledProp, (BValue)state, cx);
        }
    }

    public void initLicenseProperty() {
        try {
            LicenseUtil.licenseCheck();
            this.setStatus(BStatus.ok);
            this.setFaultCause("");
        }
        catch (FeatureNotLicensedException e) {
            this.setStatus(BStatus.fault);
            this.setFaultCause(LicenseUtil.NO_LIC_MSG);
            LOG.log(Level.WARNING, LicenseUtil.NO_LIC_MSG, LOG.isLoggable(Level.FINE) ? e : null);
        }
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        return BHttpClientService.post((BComponent)this, action, argument, cx);
    }

    public static IFuture post(BComponent instance, Action action, BValue argument, Context cx) {
        return ModuleThreadPool.getInstance((Type)TYPE).post(instance, action, argument, cx);
    }

    public static boolean permittedByService(BIHttpCommClient client, Context cx) {
        try {
            BHttpClientService service = BHttpClientService.service();
            if (service != null) {
                BHttpClientService.permittedByService(client, service);
                BHttpClientService.checkThrottlingLimit(client, service);
                BHttpClientService.auditLogRequest(client, cx, service);
                return true;
            }
        }
        catch (HttpClientException e) {
            client.getHealth().updateHealth(BStatus.fault, "Service Error", e);
        }
        return false;
    }

    private static void permittedByService(BIHttpCommClient client, BHttpClientService service) throws HttpClientException {
        if (!service.getEnableNonDriverClients() && !client.isDriverBasedClient()) {
            throw new HttpClientException("Non driver clients are disabled in the HttpClientService");
        }
        if (!service.getEnableInsecureHttp() && client.getAddress().getMode() == BHttpMode.insecure) {
            throw new HttpClientException("Insecure HTTP is disabled in the HttpClientService");
        }
    }

    private static void checkThrottlingLimit(BIHttpCommClient client, BHttpClientService service) throws HttpClientException {
        service.getGlobalRequestThrottle().checkRequestThrottleThreshold(true);
        BHttpTuningPolicy clientTuning = client.getHttpTuningPolicy();
        if (clientTuning != null) {
            clientTuning.getRequestThrottle().checkRequestThrottleThreshold(false);
        }
    }

    private static void auditLogRequest(BIHttpCommClient client, Context cx, BHttpClientService service) {
        String url = client.getAddress().buildUrlBase();
        String user = cx != null && cx.getUser() != null ? cx.getUser().getUsername() : HttpClientUtils.LEX.get("httpClient.audit.username", SYSTEM_USERNAME_DEFAULT);
        service.getClientRequestHistory().audit(new AuditEvent(client.getMethod().getDisplayTag(null), client.asObject().asComponent().getSlotPath().getBody(), client.asObject().asComponent().getDisplayName(null), "", url, user));
    }

    public static BHttpClientService service() throws HttpClientException {
        if (Sys.isStation()) {
            try {
                return (BHttpClientService)Sys.getService((Type)TYPE).as(BHttpClientService.class);
            }
            catch (ServiceNotFoundException e) {
                throw new HttpClientException("HttpClientService not found", (Exception)((Object)e));
            }
        }
        return null;
    }

    public BIcon getIcon() {
        return HttpClientUtils.HTTP_EXPORT_ICON;
    }
}

