/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nrio.types;

import com.tridium.nrio.points.BNrioCounterInputProxyExt;
import com.tridium.nrio.types.BAbstractRateType;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="interval", type="BRelTime", defaultValue="BRelTime.makeSeconds(60)", facets={@Facet(value="BFacets.make(BFacets.SHOW_MILLISECONDS, BBoolean.FALSE, BFacets.MIN, BRelTime.make(1000))")})
public class BFixedWindowRateType
extends BAbstractRateType {
    @Generated
    public static final Property interval = BFixedWindowRateType.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)60), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.FALSE, (String)"min", (BIDataValue)BRelTime.make((long)1000L)));
    @Generated
    public static final Type TYPE = Sys.loadType(BFixedWindowRateType.class);
    private long lastCount = 0L;
    private long lastTicks = 0L;
    private Clock.Ticket ticket = null;

    @Generated
    public BRelTime getInterval() {
        return (BRelTime)this.get(interval);
    }

    @Generated
    public void setInterval(BRelTime v) {
        this.set(interval, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public void descendantsStarted() throws Exception {
        super.descendantsStarted();
        this.resetRate();
        this.resetClockTicket();
    }

    public void stopped() throws Exception {
        super.stopped();
        this.resetRate();
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        this.ticket = null;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (this.isRunning() && property.equals(interval)) {
            this.resetRate();
            this.resetClockTicket();
        }
    }

    @Override
    public synchronized void resetRate() {
        this.lastCount = 0L;
        this.lastTicks = 0L;
        if (this.getCounterProxy() != null) {
            this.getCounterProxy().setStale(true, null);
        }
    }

    @Override
    public synchronized BStatusNumeric calculateRate(long count) {
        if (this.ticket == null) {
            this.resetClockTicket();
        }
        if (!this.ticket.isExpired()) {
            return new BStatusNumeric(this.getCounterProxy().getRate());
        }
        this.resetClockTicket();
        long ticks = Clock.ticks();
        if (this.lastTicks == 0L) {
            this.lastTicks = ticks;
            this.lastCount = count;
            return null;
        }
        long tickDelta = ticks - this.lastTicks;
        float rate = 1000.0f * (float)(count - this.lastCount) / (float)tickDelta;
        this.lastTicks = ticks;
        this.lastCount = count;
        BStatusNumeric srate = new BStatusNumeric((double)(rate *= this.getScale()));
        this.getCounterProxy().setRateCalcTime(BAbsTime.now());
        return srate;
    }

    private void resetClockTicket() {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        this.ticket = Clock.schedule((BComponent)this.getCounterProxy(), (BRelTime)this.getInterval(), (Action)BNrioCounterInputProxyExt.recalculateRate, null);
    }
}

