/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nrio.messages;

import com.tridium.nrio.messages.NrioInputStream;

public class NrIo16IOStatus {
    protected int activeAIs;
    protected int[] valueAIs = new int[8];
    protected int activeDIs;
    protected int valueHighSpeedDIs;
    protected int[] countHighSpeedDIs = new int[8];
    protected int valueOverrides;
    protected boolean firstReadOfInputs;

    public NrIo16IOStatus() {
    }

    public NrIo16IOStatus(byte[] data) {
        int i;
        NrioInputStream in = new NrioInputStream(data);
        this.activeAIs = in.readInt();
        for (i = 0; i < this.valueAIs.length; ++i) {
            this.valueAIs[i] = in.readInt();
        }
        this.activeDIs = in.read() & 0xFF;
        this.valueHighSpeedDIs = in.read() & 0xFF;
        for (i = 0; i < this.countHighSpeedDIs.length; ++i) {
            this.countHighSpeedDIs[i] = in.readCount();
        }
        this.valueOverrides = in.readInt();
        this.firstReadOfInputs = in.readInt() != 0;
    }

    public int getActiveAIs() {
        return this.activeAIs;
    }

    public int[] getValueAIs() {
        return this.valueAIs;
    }

    public int getActiveDIs() {
        return this.activeDIs;
    }

    public int getValueHighSpeedDIs() {
        return this.valueHighSpeedDIs;
    }

    public int[] getCountHighSpeedDIs() {
        return this.countHighSpeedDIs;
    }

    public int getValueOverrides() {
        return this.valueOverrides;
    }

    public boolean isFirstReadOfInputs() {
        return this.firstReadOfInputs;
    }

    public String toDebugString() {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("IoModuleIOStatus:");
        sb.append("\n  activeAIs         = " + Integer.toHexString(this.activeAIs));
        for (i = 0; i < this.valueAIs.length; ++i) {
            sb.append("\n  valueAIs[" + i + "] = " + this.valueAIs[i]);
        }
        sb.append("\n  activeDIs         = " + Integer.toHexString(this.activeDIs));
        sb.append("\n  valueHighSpeedDIs = " + Integer.toHexString(this.valueHighSpeedDIs));
        for (i = 0; i < this.countHighSpeedDIs.length; ++i) {
            sb.append("\n  countHighSpeedDIs[" + i + "] = " + this.countHighSpeedDIs[i]);
        }
        sb.append("\n  valueOverrides    = " + Integer.toHexString(this.valueOverrides));
        sb.append("\n  firstReadOfInputs = " + this.firstReadOfInputs);
        return sb.toString();
    }
}

