/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nrio.job;

import com.tridium.nrio.BNrio34SecModule;
import com.tridium.nrio.BNrioDevice;
import com.tridium.nrio.BNrioNetwork;
import com.tridium.nrio.components.BNrioLearnDeviceEntry;
import com.tridium.nrio.enums.BNrioDeviceTypeEnum;
import com.tridium.nrio.messages.NrioInputStream;
import com.tridium.nrio.messages.NrioMessage;
import com.tridium.nrio.messages.NrioMessageConst;
import com.tridium.nrio.messages.NrioReceivedMessage;
import com.tridium.nrio.messages.PingMessage;
import com.tridium.nrio.messages.PingResponse;
import com.tridium.nrio.messages.SetLogicalAddressMessage;
import com.tridium.nrio.messages.UnconfiguredModuleReply;
import com.tridium.nrio.util.DualModuleUtils;
import java.util.Vector;
import javax.baja.driver.BDevice;
import javax.baja.job.BSimpleJob;
import javax.baja.log.Log;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;

@NiagaraType
@NiagaraProperty(name="learnedDevices", type="BFolder", defaultValue="new BFolder()", flags=7)
public class BNrioLearnDevicesJob
extends BSimpleJob
implements NrioMessageConst {
    @Generated
    public static final Property learnedDevices = BNrioLearnDevicesJob.newProperty((int)7, (BValue)new BFolder(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BNrioLearnDevicesJob.class);
    protected static final String LEARN_NAME_PREFIX = "Device";
    final BNrioNetwork nrioNet;
    protected int learnCount = 0;

    @Generated
    public BFolder getLearnedDevices() {
        return (BFolder)this.get(learnedDevices);
    }

    @Generated
    public void setLearnedDevices(BFolder v) {
        this.set(learnedDevices, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BNrioLearnDevicesJob() {
        this.nrioNet = null;
    }

    public BNrioLearnDevicesJob(BNrioNetwork net) {
        this.nrioNet = net;
    }

    protected void addLearnedDevice(BNrioDevice existingDevice) {
        BNrioLearnDeviceEntry learnDeviceEntry = existingDevice.makeLearnDeviceEntry();
        this.addLearnedDevice(learnDeviceEntry);
    }

    public void addLearnedDevice(int address, BNrioDeviceTypeEnum type, byte[] uid, String version, String usedBy) {
        BNrioLearnDeviceEntry deviceEntry = new BNrioLearnDeviceEntry(address, type, uid, version, usedBy);
        this.addLearnedDevice(deviceEntry);
    }

    public void addLearnedDevice(int address, BNrioDeviceTypeEnum type, byte[] uid, String version, String usedBy, int secAddr) {
        BNrioLearnDeviceEntry deviceEntry = new BNrioLearnDeviceEntry(address, type, uid, version, usedBy, secAddr);
        this.addLearnedDevice(deviceEntry);
    }

    protected void addLearnedDevice(BNrioLearnDeviceEntry deviceEntry) {
        String learnName = "device_" + ByteArrayUtil.toHexString((byte[])deviceEntry.getUid().copyBytes());
        if (this.getLearnedDevices().get(learnName) == null) {
            this.getLearnedDevices().add(learnName, (BValue)deviceEntry);
            this.logMessage("found device " + learnName + " usedBy: " + deviceEntry.getUsedBy());
            ++this.learnCount;
        } else {
            this.getDiscoveryLog().trace(learnName + " already learned ???");
        }
        this.progress(this.learnCount * 100 / 16);
    }

    protected void removeLearnedDevice(byte[] uid) {
        String learnName = "device" + ByteArrayUtil.toHexString((byte[])uid);
        if (this.getLearnedDevices().get(learnName) != null) {
            this.getLearnedDevices().remove(learnName);
            --this.learnCount;
        }
    }

    public void run(Context cx) throws Exception {
        this.logMessage("starting");
        if (this.nrioNet.isDisabled() || this.nrioNet.isFault()) {
            this.logMessage("Network is disabled or configured incorrectly");
            throw new RuntimeException("Network is disabled or configured incorrectly");
        }
        try {
            NrioMessage message = new NrioMessage();
            UnconfiguredModuleReply ucmr = new UnconfiguredModuleReply();
            this.nrioNet.initLogicalAddressMap();
            Vector<Object> unconfigDevices = new Vector();
            boolean done = false;
            boolean firstRun = true;
            int exceptionCount = 0;
            while (firstRun || unconfigDevices.size() > 0 && !done && this.isAlive()) {
                firstRun = false;
                try {
                    this.getDiscoveryLog().trace("*** nrioNet.discover() called *****");
                    unconfigDevices = this.nrioNet.discover();
                    try {
                        Thread.sleep(20L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.getDiscoveryLog().trace("*** unconfigDevices.size() = " + unconfigDevices.size());
                    for (int i = 0; i < unconfigDevices.size(); ++i) {
                        byte[] data = (byte[])unconfigDevices.elementAt(i);
                        this.getDiscoveryLog().trace("NrioDiscovery byte[] = " + ByteArrayUtil.toHexString((byte[])data));
                        NrioReceivedMessage receivedMessage = new NrioReceivedMessage(data, data.length, null);
                        NrioInputStream inStream = message.readResponse(receivedMessage);
                        ucmr.readData(inStream);
                        byte[] uid = ucmr.getUid();
                        BNrioDevice stationDevice = this.nrioNet.getDevice(uid);
                        int setAddress = -1;
                        int moduleType = ucmr.getModuleType();
                        if (stationDevice == null) {
                            setAddress = this.nrioNet.getFreeAddressV2(moduleType, uid);
                            if (setAddress < 0) {
                                this.getDiscoveryLog().trace("************** no free addresses availiable ****************");
                                this.logMessage("no free address is availiable for this module!");
                                this.addLearnedDevice(setAddress, BNrioDeviceTypeEnum.makeFromRaw(moduleType), uid, "", "", -1);
                                done = true;
                                continue;
                            }
                            if (this.setAddressAndPing(setAddress, uid, moduleType) != 0) {
                                this.getDiscoveryLog().message("setAddressAndPing returned error");
                                this.nrioNet.clearAddressUsedV2(setAddress);
                                continue;
                            }
                            if (moduleType == 11 || moduleType == 12) {
                                if (!DualModuleUtils.addressDualModule(this.nrioNet, this, moduleType, uid, setAddress)) continue;
                                continue;
                            }
                            String version = this.nrioNet.readBuildInfo(setAddress);
                            this.addLearnedDevice(setAddress, BNrioDeviceTypeEnum.makeFromRaw(moduleType), uid, version, "", -1);
                            continue;
                        }
                        if (moduleType == 12 && stationDevice instanceof BNrio34SecModule) {
                            stationDevice = ((BNrio34SecModule)stationDevice).getParentModule();
                        }
                        this.getDiscoveryLog().trace(stationDevice.getSlotPath() + ":  discovered device allready in station ******");
                        stationDevice.doSetAddressAndPing();
                        stationDevice.doEnablePolling();
                        stationDevice.readBuildInfo();
                        setAddress = stationDevice.getAddress();
                    }
                }
                catch (Exception e) {
                    this.getDiscoveryLog().trace("*** caught Exception: " + e + " count = " + ++exceptionCount);
                    if (this.getDiscoveryLog().isTraceOn()) {
                        e.printStackTrace();
                    }
                    if (exceptionCount > 10) {
                        done = true;
                    } else {
                        firstRun = true;
                    }
                    try {
                        Thread.sleep(20L);
                    }
                    catch (Exception exception) {}
                }
            }
            this.addExistingDevices();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BNrioLearnDeviceEntry[] learnEntries = (BNrioLearnDeviceEntry[])this.getLearnedDevices().getChildren(BNrioLearnDeviceEntry.class);
        for (int i = 0; i < learnEntries.length; ++i) {
            if (!learnEntries[i].getUsedBy().equals("")) continue;
            int address = learnEntries[i].getAddress();
            this.nrioNet.sendReset(address);
            address = learnEntries[i].getSecAddrInt();
            if (address <= 0) continue;
            this.nrioNet.sendReset(learnEntries[i].getSecAddrInt());
        }
        this.nrioNet.initLogicalAddressMap();
        this.progress(100);
    }

    protected void addExistingDevices() {
        BDevice[] devices = this.nrioNet.getDevices();
        for (int i = 0; i < devices.length; ++i) {
            if (!(devices[i] instanceof BNrioDevice) || devices[i].isFault()) continue;
            BNrioDevice device = (BNrioDevice)devices[i];
            this.addLearnedDevice(device);
        }
    }

    protected int setAddressAndPing(int logicalAddress, byte[] uid, int type) {
        SetLogicalAddressMessage setAddrMsg = null;
        setAddrMsg = type == 11 || type == 12 ? new SetLogicalAddressMessage(logicalAddress, uid, type) : new SetLogicalAddressMessage(logicalAddress, uid);
        NrioMessage rsp = this.nrioNet.sendNrioMessage(setAddrMsg);
        if (rsp.getStatus() != 0) {
            this.getDiscoveryLog().trace("setLogicalAddress, " + logicalAddress + " returned error, " + rsp.getStatus());
        }
        try {
            Thread.sleep(500L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        PingMessage pReq = new PingMessage(logicalAddress, uid, type);
        PingResponse pRsp = (PingResponse)this.nrioNet.sendNrioMessage(pReq);
        if (pRsp.getStatus() != 0) {
            this.getDiscoveryLog().trace("ping after setLogicalAddress, " + logicalAddress + " returned error, " + pRsp.getStatus());
        }
        return pRsp.getStatus();
    }

    public Log getDiscoveryLog() {
        return Log.getLog((String)(this.nrioNet.getName() + ".discovery"));
    }

    protected void logMessage(String message) {
        this.log().message(message);
        if (this.nrioNet != null) {
            Log discLog = this.getDiscoveryLog();
            int severity = discLog.getSeverity();
            discLog.setSeverity(1);
            discLog.message("Learn Niagara Remote IO Devices Job:" + message);
            discLog.setSeverity(severity);
        }
    }
}

