/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nrio.components;

import com.tridium.nrio.BNrio16Module;
import com.tridium.nrio.BNrioDevice;
import com.tridium.nrio.BNrioNetwork;
import com.tridium.nrio.components.BIOutputDefaultValues;
import com.tridium.nrio.messages.NrioInputStream;
import com.tridium.nrio.util.DualModuleUtils;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enableCommLossDefaults", type="boolean", defaultValue="false"), @NiagaraProperty(name="enableStartupDefaults", type="boolean", defaultValue="false"), @NiagaraProperty(name="commLossTimeout", type="int", defaultValue="0", flags=3), @NiagaraProperty(name="startupTimeout", type="int", defaultValue="0", flags=3), @NiagaraProperty(name="do1", type="boolean", defaultValue="false"), @NiagaraProperty(name="do2", type="boolean", defaultValue="false"), @NiagaraProperty(name="do3", type="boolean", defaultValue="false"), @NiagaraProperty(name="do4", type="boolean", defaultValue="false"), @NiagaraProperty(name="ao1", type="float", defaultValue="0.0f"), @NiagaraProperty(name="ao2", type="float", defaultValue="0.0f"), @NiagaraProperty(name="ao3", type="float", defaultValue="0.0f"), @NiagaraProperty(name="ao4", type="float", defaultValue="0.0f")})
public class BOutputDefaultValues
extends BComponent
implements BIOutputDefaultValues {
    @Generated
    public static final Property enableCommLossDefaults = BOutputDefaultValues.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property enableStartupDefaults = BOutputDefaultValues.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property commLossTimeout = BOutputDefaultValues.newProperty((int)3, (int)0, null);
    @Generated
    public static final Property startupTimeout = BOutputDefaultValues.newProperty((int)3, (int)0, null);
    @Generated
    public static final Property do1 = BOutputDefaultValues.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property do2 = BOutputDefaultValues.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property do3 = BOutputDefaultValues.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property do4 = BOutputDefaultValues.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property ao1 = BOutputDefaultValues.newProperty((int)0, (float)0.0f, null);
    @Generated
    public static final Property ao2 = BOutputDefaultValues.newProperty((int)0, (float)0.0f, null);
    @Generated
    public static final Property ao3 = BOutputDefaultValues.newProperty((int)0, (float)0.0f, null);
    @Generated
    public static final Property ao4 = BOutputDefaultValues.newProperty((int)0, (float)0.0f, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BOutputDefaultValues.class);
    private static Property[] doProps = new Property[]{do1, do2, do3, do4};
    private static Property[] aoProps = new Property[]{ao1, ao2, ao3, ao4};

    @Override
    @Generated
    public boolean getEnableCommLossDefaults() {
        return this.getBoolean(enableCommLossDefaults);
    }

    @Generated
    public void setEnableCommLossDefaults(boolean v) {
        this.setBoolean(enableCommLossDefaults, v, null);
    }

    @Override
    @Generated
    public boolean getEnableStartupDefaults() {
        return this.getBoolean(enableStartupDefaults);
    }

    @Generated
    public void setEnableStartupDefaults(boolean v) {
        this.setBoolean(enableStartupDefaults, v, null);
    }

    @Generated
    public int getCommLossTimeout() {
        return this.getInt(commLossTimeout);
    }

    @Override
    @Generated
    public void setCommLossTimeout(int v) {
        this.setInt(commLossTimeout, v, null);
    }

    @Generated
    public int getStartupTimeout() {
        return this.getInt(startupTimeout);
    }

    @Override
    @Generated
    public void setStartupTimeout(int v) {
        this.setInt(startupTimeout, v, null);
    }

    @Generated
    public boolean getDo1() {
        return this.getBoolean(do1);
    }

    @Generated
    public void setDo1(boolean v) {
        this.setBoolean(do1, v, null);
    }

    @Generated
    public boolean getDo2() {
        return this.getBoolean(do2);
    }

    @Generated
    public void setDo2(boolean v) {
        this.setBoolean(do2, v, null);
    }

    @Generated
    public boolean getDo3() {
        return this.getBoolean(do3);
    }

    @Generated
    public void setDo3(boolean v) {
        this.setBoolean(do3, v, null);
    }

    @Generated
    public boolean getDo4() {
        return this.getBoolean(do4);
    }

    @Generated
    public void setDo4(boolean v) {
        this.setBoolean(do4, v, null);
    }

    @Generated
    public float getAo1() {
        return this.getFloat(ao1);
    }

    @Generated
    public void setAo1(float v) {
        this.setFloat(ao1, v, null);
    }

    @Generated
    public float getAo2() {
        return this.getFloat(ao2);
    }

    @Generated
    public void setAo2(float v) {
        this.setFloat(ao2, v, null);
    }

    @Generated
    public float getAo3() {
        return this.getFloat(ao3);
    }

    @Generated
    public void setAo3(float v) {
        this.setFloat(ao3, v, null);
    }

    @Generated
    public float getAo4() {
        return this.getFloat(ao4);
    }

    @Generated
    public void setAo4(float v) {
        this.setFloat(ao4, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public static BOutputDefaultValues makeFromBytes(byte[] priDefaults) {
        BOutputDefaultValues outputDefaults = new BOutputDefaultValues();
        NrioInputStream priIn = new NrioInputStream(priDefaults);
        outputDefaults.setStartupTimeout(priIn.readInt());
        outputDefaults.setCommLossTimeout(priIn.readInt());
        outputDefaults.setEnableCommLossDefaults(outputDefaults.getCommLossTimeout() != 0);
        outputDefaults.setEnableStartupDefaults(outputDefaults.getStartupTimeout() != 0);
        int doValues = priIn.read();
        block12: for (int i = 0; i < 4; ++i) {
            int mask = 1 << i;
            switch (i) {
                case 0: {
                    outputDefaults.setDo1((doValues & mask) != 0);
                    continue block12;
                }
                case 1: {
                    outputDefaults.setDo2((doValues & mask) != 0);
                    continue block12;
                }
                case 2: {
                    outputDefaults.setDo3((doValues & mask) != 0);
                    continue block12;
                }
                case 3: {
                    outputDefaults.setDo4((doValues & mask) != 0);
                }
            }
        }
        float[] priAoValues = DualModuleUtils.bytesToValues(priIn);
        block13: for (int i = 0; i < 4; ++i) {
            switch (i) {
                case 0: {
                    outputDefaults.setAo1(priAoValues[i]);
                    continue block13;
                }
                case 1: {
                    outputDefaults.setAo2(priAoValues[i]);
                    continue block13;
                }
                case 2: {
                    outputDefaults.setAo3(priAoValues[i]);
                    continue block13;
                }
                case 3: {
                    outputDefaults.setAo4(priAoValues[i]);
                }
            }
        }
        return outputDefaults;
    }

    @Override
    public boolean isDualModule() {
        return false;
    }

    public void started() throws Exception {
        super.started();
        BComplex parent = this.getParent();
        if (parent instanceof BNrioDevice) {
            BNrioNetwork network = (BNrioNetwork)((BNrioDevice)parent).getNetwork();
            this.setCommLossTimeout(network.getOutputFailsafeConfig().getCommLossTimeout());
            this.setStartupTimeout(network.getOutputFailsafeConfig().getStartupTimeout());
        }
    }

    public void changed(Property p, Context cx) {
        BComplex parent;
        super.changed(p, cx);
        if (!this.isRunning() || cx != null && cx.equals(Context.decoding)) {
            return;
        }
        if (p.isFrozen() && (this.getFlags((Slot)p) & 2) == 0 && (parent = this.getParent()) instanceof BNrio16Module) {
            ((BNrio16Module)parent).postWriteOutputDefaults();
        }
    }

    public void subscribed() {
        BDeviceNetwork net;
        if (!this.isRunning()) {
            return;
        }
        BComplex parent = this.getParent();
        if (parent instanceof BNrioDevice && (net = ((BNrioDevice)parent).getNetwork()) != null && net instanceof BNrioNetwork) {
            BNrioNetwork network = (BNrioNetwork)((BNrioDevice)parent).getNetwork();
            this.setCommLossTimeout(network.getOutputFailsafeConfig().getCommLossTimeout());
            this.setStartupTimeout(network.getOutputFailsafeConfig().getStartupTimeout());
        }
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.isProperty()) {
            BValue bValue = this.get(slot.asProperty());
            if (slot.asProperty().getDefaultValue() instanceof BFloat) {
                return aoFacets;
            }
        }
        return super.getSlotFacets(slot);
    }

    @Override
    public byte[] toMessageBytes(boolean ignore) {
        int doDefaults = 0;
        int[] aoDefaults = new int[4];
        byte[] rtnBytes = new byte[7];
        if (this.getDo1()) {
            doDefaults |= 1;
        }
        if (this.getDo2()) {
            doDefaults |= 2;
        }
        if (this.getDo3()) {
            doDefaults |= 4;
        }
        if (this.getDo4()) {
            doDefaults |= 8;
        }
        aoDefaults[0] = this.getRawValue(this.getAo1());
        aoDefaults[1] = this.getRawValue(this.getAo2());
        aoDefaults[2] = this.getRawValue(this.getAo3());
        aoDefaults[3] = this.getRawValue(this.getAo4());
        rtnBytes[0] = (byte)(doDefaults & 0xFF);
        int byteIndex = 1;
        boolean nibbleIndex = false;
        for (int i = 0; i < 4; ++i) {
            if (i % 2 == 0) {
                rtnBytes[byteIndex++] = (byte)(aoDefaults[i] >> 4 & 0xFF);
                rtnBytes[byteIndex] = (byte)((aoDefaults[i] & 0xF) << 4);
                continue;
            }
            int n = byteIndex++;
            rtnBytes[n] = (byte)(rtnBytes[n] | (byte)(aoDefaults[i] >> 8 & 0xF));
            rtnBytes[byteIndex++] = (byte)(aoDefaults[i] & 0xFF);
        }
        return rtnBytes;
    }

    @Override
    public Property[] getDoProperties() {
        return doProps;
    }

    @Override
    public Property[] getAoProperties() {
        return aoProps;
    }
}

