/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.web.authn;

import com.tridium.user.BUserPasswordConfiguration;
import com.tridium.web.authn.BHttpCallbackHandler;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BAbstractAuthenticator;
import javax.baja.security.BPassword;
import javax.baja.security.BPasswordAuthenticator;
import javax.baja.security.BPasswordCache;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.Lexicon;
import javax.servlet.http.HttpServletRequest;

@NiagaraType
public abstract class BWebCallbackHandler
extends BHttpCallbackHandler {
    @Generated
    public static final Type TYPE = Sys.loadType(BWebCallbackHandler.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public boolean containsCredentialsResetInfo(HttpServletRequest request, String username) {
        return request.getParameter("resetToken") != null;
    }

    public void handleCredentialsReset(HttpServletRequest request, String username) throws LocalizableException {
        String newPassword = new String(Base64.getDecoder().decode(request.getParameter("resetToken")), StandardCharsets.UTF_8);
        BUser user = BUserService.getService().getUser(username);
        BAbstractAuthenticator auth = user.getAuthenticator();
        if (!(auth instanceof BPasswordCache)) {
            throw new LocalizableException(Lexicon.make((String)"baja"), "user.password.reset.invalidAuthenticator");
        }
        BPasswordCache authenticator = (BPasswordCache)auth;
        if (authenticator.validate(newPassword)) {
            throw new LocalizableException(Lexicon.make((String)"baja"), "user.strongPassword.alreadyUsed");
        }
        authenticator.set(BPasswordAuthenticator.password, (BValue)BPassword.make((String)newPassword), Context.forceValidate);
        if (auth instanceof BPasswordAuthenticator) {
            BUserPasswordConfiguration userConfig = ((BPasswordAuthenticator)user.getAuthenticator()).getPasswordConfig();
            userConfig.setForceResetAtNextLogin(false);
        }
    }
}

