/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.web;

import com.tridium.crypto.core.cert.CertUtils;
import com.tridium.crypto.core.cert.KeyPurpose;
import com.tridium.crypto.core.io.ICoreKeyStore;
import com.tridium.nre.firewall.IpProtocol;
import com.tridium.nre.security.SigningPasswordPermission;
import com.tridium.nre.util.IPAddressUtil;
import com.tridium.security.BISecurityInfoSource;
import com.tridium.security.BSecurityInfo;
import com.tridium.security.BServerCertificateHealth;
import com.tridium.sys.Nre;
import com.tridium.util.ArrayUtil;
import com.tridium.util.CertAliasCasePropertyValidator;
import com.tridium.web.BAdditionalHttpsCert;
import com.tridium.web.BAdditionalHttpsCerts;
import com.tridium.web.BHostHeaderValidationSettings;
import com.tridium.web.BHostnameRedirectSettings;
import com.tridium.web.BSameSiteEnum;
import com.tridium.web.WebUtil;
import com.tridium.web.rpc.BUserDataConfig;
import com.tridium.web.servlets.UnauthenticatedCache;
import com.tridium.web.servlets.WebStartServlet;
import com.tridium.web.warmup.BWebWarmupConfig;
import java.security.AccessController;
import java.security.Permission;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.baja.data.BIDataValue;
import javax.baja.firewall.BServerPort;
import javax.baja.license.Feature;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BCertificateAliasAndPassword;
import javax.baja.security.BICertificateAliasAndPasswordContainer;
import javax.baja.security.BPassword;
import javax.baja.security.crypto.BSslTlsEnum;
import javax.baja.security.crypto.BTlsCipherSuiteGroup;
import javax.baja.security.crypto.CertManagerFactory;
import javax.baja.security.dashboard.BISecurityDashboardProvider;
import javax.baja.security.dashboard.BSecurityItemStatus;
import javax.baja.security.dashboard.LexiconFormatInfo;
import javax.baja.security.dashboard.SecurityDashboardItem;
import javax.baja.security.dashboard.SecurityDashboardItemBuilder;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.IPropertyValidator;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUserService;
import javax.baja.util.BFormat;
import javax.baja.util.BIRestrictedComponent;
import javax.baja.util.BTypeSpec;
import javax.baja.web.BAppletModuleCachingType;
import javax.baja.web.BCacheConfig;
import javax.baja.web.BClientEnvironments;
import javax.baja.web.BWebProfileConfig;
import javax.baja.web.BWebServer;
import javax.baja.web.BWebStartConfig;
import javax.baja.web.BXFrameOptionsEnum;
import javax.baja.web.IWebEnv;
import javax.baja.web.WebOp;
import javax.baja.web.http.BHttpHeaderProviders;
import javax.security.auth.x500.X500Principal;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="httpPort", type="BServerPort", defaultValue="new BServerPort(80, IpProtocol.TCP)"), @NiagaraProperty(name="httpEnabled", type="boolean", defaultValue="true", facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="httpsPort", type="BServerPort", defaultValue="new BServerPort(443, IpProtocol.TCP)"), @NiagaraProperty(name="httpsEnabled", type="boolean", defaultValue="false", facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="httpsOnly", type="boolean", defaultValue="false", facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="httpsMinProtocol", type="BSslTlsEnum", defaultValue="BSslTlsEnum.DEFAULT", facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="cipherSuiteGroup", type="BTlsCipherSuiteGroup", defaultValue="BTlsCipherSuiteGroup.recommended", facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="httpsCert", type="String", defaultValue="CertUtils.LEGACY_CERT_ALIAS", facets={@Facet(name="BFacets.FIELD_EDITOR", value="BString.make(\"workbench:CertificateAliasFE\")"), @Facet(name="BFacets.UX_FIELD_EDITOR", value="BString.make(\"webEditors:CertificateAliasEditor\")"), @Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)"), @Facet(value="BFacets.make(\"purposeId\", \"SERVER_CERT\")")}, deprecated=true), @NiagaraProperty(name="mainCertAliasAndPassword", type="BCertificateAliasAndPassword", defaultValue="BCertificateAliasAndPassword.DEFAULT", flags=4, facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="serverCertificateHealth", type="BServerCertificateHealth", defaultValue="new BServerCertificateHealth()", flags=7), @NiagaraProperty(name="requireHttpsForPasswords", type="boolean", defaultValue="true", facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="xFrameOptions", type="BXFrameOptionsEnum", defaultValue="BXFrameOptionsEnum.sameorigin", flags=5, facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="rememberUserIdCookie", type="boolean", defaultValue="true"), @NiagaraProperty(name="sameSite", type="BSameSiteEnum", defaultValue="BSameSiteEnum.lax", facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="allowUsernameAutocomplete", type="boolean", defaultValue="true"), @NiagaraProperty(name="loginTemplate", type="BTypeSpec", defaultValue="BTypeSpec.NULL", facets={@Facet(name="BFacets.ALLOW_NULL", value="BBoolean.TRUE"), @Facet(name="BFacets.TARGET_TYPE", value="BString.make(\"web:LoginTemplate\")")}), @NiagaraProperty(name="gzipEnabled", type="boolean", defaultValue="false", flags=4), @NiagaraProperty(name="logFileDirectory", type="BOrd", defaultValue="BOrd.make(\"file:^^webLogs\")", flags=1), @NiagaraProperty(name="clientEnvironments", type="BClientEnvironments", defaultValue="new BClientEnvironments()"), @NiagaraProperty(name="showStackTrace", type="boolean", defaultValue="false"), @NiagaraProperty(name="appletModuleCachingType", type="BAppletModuleCachingType", defaultValue="BAppletModuleCachingType.host", deprecated=true), @NiagaraProperty(name="webStartConfig", type="BWebStartConfig", defaultValue="new BWebStartConfig()", deprecated=true), @NiagaraProperty(name="cacheConfig", type="BCacheConfig", defaultValue="new BCacheConfig()"), @NiagaraProperty(name="warmupConfig", type="BWebWarmupConfig", defaultValue="new BWebWarmupConfig()", flags=65536), @NiagaraProperty(name="hostnameRedirectSettings", type="BHostnameRedirectSettings", defaultValue="new BHostnameRedirectSettings()"), @NiagaraProperty(name="httpHeaderProviders", type="BHttpHeaderProviders", defaultValue="new BHttpHeaderProviders()"), @NiagaraProperty(name="hostHeaderValidationSettings", type="BHostHeaderValidationSettings", defaultValue="new BHostHeaderValidationSettings()")})
@NiagaraAction(name="resetAllConnections", flags=128)
public final class BWebService
extends BAbstractService
implements BIRestrictedComponent,
BISecurityInfoSource,
BISecurityDashboardProvider,
BICertificateAliasAndPasswordContainer {
    @Generated
    public static final Property httpPort = BWebService.newProperty((int)0, (BValue)new BServerPort(80, IpProtocol.TCP), null);
    @Generated
    public static final Property httpEnabled = BWebService.newProperty((int)0, (boolean)true, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property httpsPort = BWebService.newProperty((int)0, (BValue)new BServerPort(443, IpProtocol.TCP), null);
    @Generated
    public static final Property httpsEnabled = BWebService.newProperty((int)0, (boolean)false, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property httpsOnly = BWebService.newProperty((int)0, (boolean)false, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property httpsMinProtocol = BWebService.newProperty((int)0, (BValue)BSslTlsEnum.DEFAULT, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property cipherSuiteGroup = BWebService.newProperty((int)0, (BValue)BTlsCipherSuiteGroup.recommended, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    @Deprecated
    @Generated
    public static final Property httpsCert = BWebService.newProperty((int)0, (String)"tridium", (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"workbench:CertificateAliasFE")), (BFacets)BFacets.make((String)"uxFieldEditor", (BIDataValue)BString.make((String)"webEditors:CertificateAliasEditor"))), (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE)), (BFacets)BFacets.make((String)"purposeId", (String)"SERVER_CERT")));
    @Generated
    public static final Property mainCertAliasAndPassword = BWebService.newProperty((int)4, (BValue)BCertificateAliasAndPassword.DEFAULT, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property serverCertificateHealth = BWebService.newProperty((int)7, (BValue)new BServerCertificateHealth(), null);
    @Generated
    public static final Property requireHttpsForPasswords = BWebService.newProperty((int)0, (boolean)true, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property xFrameOptions = BWebService.newProperty((int)5, (BValue)BXFrameOptionsEnum.sameorigin, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property rememberUserIdCookie = BWebService.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property sameSite = BWebService.newProperty((int)0, (BValue)BSameSiteEnum.lax, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property allowUsernameAutocomplete = BWebService.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property loginTemplate = BWebService.newProperty((int)0, (BValue)BTypeSpec.NULL, (BFacets)BFacets.make((BFacets)BFacets.make((String)"allowNull", (BIDataValue)BBoolean.TRUE), (BFacets)BFacets.make((String)"targetType", (BIDataValue)BString.make((String)"web:LoginTemplate"))));
    @Generated
    public static final Property gzipEnabled = BWebService.newProperty((int)4, (boolean)false, null);
    @Generated
    public static final Property logFileDirectory = BWebService.newProperty((int)1, (BValue)BOrd.make((String)"file:^^webLogs"), null);
    @Generated
    public static final Property clientEnvironments = BWebService.newProperty((int)0, (BValue)new BClientEnvironments(), null);
    @Generated
    public static final Property showStackTrace = BWebService.newProperty((int)0, (boolean)false, null);
    @Deprecated
    @Generated
    public static final Property appletModuleCachingType = BWebService.newProperty((int)0, (BValue)BAppletModuleCachingType.host, null);
    @Deprecated
    @Generated
    public static final Property webStartConfig = BWebService.newProperty((int)0, (BValue)new BWebStartConfig(), null);
    @Generated
    public static final Property cacheConfig = BWebService.newProperty((int)0, (BValue)new BCacheConfig(), null);
    @Generated
    public static final Property warmupConfig = BWebService.newProperty((int)65536, (BValue)new BWebWarmupConfig(), null);
    @Generated
    public static final Property hostnameRedirectSettings = BWebService.newProperty((int)0, (BValue)new BHostnameRedirectSettings(), null);
    @Generated
    public static final Property httpHeaderProviders = BWebService.newProperty((int)0, (BValue)new BHttpHeaderProviders(), null);
    @Generated
    public static final Property hostHeaderValidationSettings = BWebService.newProperty((int)0, (BValue)new BHostHeaderValidationSettings(), null);
    @Generated
    public static final Action resetAllConnections = BWebService.newAction((int)128, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BWebService.class);
    public static final Logger log = Logger.getLogger(BWebService.class.getName());
    private static final BIcon icon = BIcon.std((String)"navOnly/webService.png");
    private static final int VERSION = 4;
    private static final double MILLIS_IN_NINETY_DAYS = BRelTime.makeDays((int)90).getMillis();
    private final CertAliasCasePropertyValidator validator = new CertAliasCasePropertyValidator(mainCertAliasAndPassword.getName());
    private static final SecurityDashboardItemBuilder dashboardItemBuilder = new SecurityDashboardItemBuilder(TYPE);

    @Generated
    public BServerPort getHttpPort() {
        return (BServerPort)this.get(httpPort);
    }

    @Generated
    public void setHttpPort(BServerPort v) {
        this.set(httpPort, (BValue)v, null);
    }

    @Generated
    public boolean getHttpEnabled() {
        return this.getBoolean(httpEnabled);
    }

    @Generated
    public void setHttpEnabled(boolean v) {
        this.setBoolean(httpEnabled, v, null);
    }

    @Generated
    public BServerPort getHttpsPort() {
        return (BServerPort)this.get(httpsPort);
    }

    @Generated
    public void setHttpsPort(BServerPort v) {
        this.set(httpsPort, (BValue)v, null);
    }

    @Generated
    public boolean getHttpsEnabled() {
        return this.getBoolean(httpsEnabled);
    }

    @Generated
    public void setHttpsEnabled(boolean v) {
        this.setBoolean(httpsEnabled, v, null);
    }

    @Generated
    public boolean getHttpsOnly() {
        return this.getBoolean(httpsOnly);
    }

    @Generated
    public void setHttpsOnly(boolean v) {
        this.setBoolean(httpsOnly, v, null);
    }

    @Generated
    public BSslTlsEnum getHttpsMinProtocol() {
        return (BSslTlsEnum)this.get(httpsMinProtocol);
    }

    @Generated
    public void setHttpsMinProtocol(BSslTlsEnum v) {
        this.set(httpsMinProtocol, (BValue)v, null);
    }

    @Generated
    public BTlsCipherSuiteGroup getCipherSuiteGroup() {
        return (BTlsCipherSuiteGroup)this.get(cipherSuiteGroup);
    }

    @Generated
    public void setCipherSuiteGroup(BTlsCipherSuiteGroup v) {
        this.set(cipherSuiteGroup, (BValue)v, null);
    }

    @Deprecated
    @Generated
    public String getHttpsCert() {
        return this.getString(httpsCert);
    }

    @Deprecated
    @Generated
    public void setHttpsCert(String v) {
        this.setString(httpsCert, v, null);
    }

    @Generated
    public BCertificateAliasAndPassword getMainCertAliasAndPassword() {
        return (BCertificateAliasAndPassword)this.get(mainCertAliasAndPassword);
    }

    @Generated
    public void setMainCertAliasAndPassword(BCertificateAliasAndPassword v) {
        this.set(mainCertAliasAndPassword, (BValue)v, null);
    }

    @Generated
    public BServerCertificateHealth getServerCertificateHealth() {
        return (BServerCertificateHealth)this.get(serverCertificateHealth);
    }

    @Generated
    public void setServerCertificateHealth(BServerCertificateHealth v) {
        this.set(serverCertificateHealth, (BValue)v, null);
    }

    @Generated
    public boolean getRequireHttpsForPasswords() {
        return this.getBoolean(requireHttpsForPasswords);
    }

    @Generated
    public void setRequireHttpsForPasswords(boolean v) {
        this.setBoolean(requireHttpsForPasswords, v, null);
    }

    @Generated
    public BXFrameOptionsEnum getXFrameOptions() {
        return (BXFrameOptionsEnum)this.get(xFrameOptions);
    }

    @Generated
    public void setXFrameOptions(BXFrameOptionsEnum v) {
        this.set(xFrameOptions, (BValue)v, null);
    }

    @Generated
    public boolean getRememberUserIdCookie() {
        return this.getBoolean(rememberUserIdCookie);
    }

    @Generated
    public void setRememberUserIdCookie(boolean v) {
        this.setBoolean(rememberUserIdCookie, v, null);
    }

    @Generated
    public BSameSiteEnum getSameSite() {
        return (BSameSiteEnum)this.get(sameSite);
    }

    @Generated
    public void setSameSite(BSameSiteEnum v) {
        this.set(sameSite, (BValue)v, null);
    }

    @Generated
    public boolean getAllowUsernameAutocomplete() {
        return this.getBoolean(allowUsernameAutocomplete);
    }

    @Generated
    public void setAllowUsernameAutocomplete(boolean v) {
        this.setBoolean(allowUsernameAutocomplete, v, null);
    }

    @Generated
    public BTypeSpec getLoginTemplate() {
        return (BTypeSpec)this.get(loginTemplate);
    }

    @Generated
    public void setLoginTemplate(BTypeSpec v) {
        this.set(loginTemplate, (BValue)v, null);
    }

    @Generated
    public boolean getGzipEnabled() {
        return this.getBoolean(gzipEnabled);
    }

    @Generated
    public void setGzipEnabled(boolean v) {
        this.setBoolean(gzipEnabled, v, null);
    }

    @Generated
    public BOrd getLogFileDirectory() {
        return (BOrd)this.get(logFileDirectory);
    }

    @Generated
    public void setLogFileDirectory(BOrd v) {
        this.set(logFileDirectory, (BValue)v, null);
    }

    @Generated
    public BClientEnvironments getClientEnvironments() {
        return (BClientEnvironments)this.get(clientEnvironments);
    }

    @Generated
    public void setClientEnvironments(BClientEnvironments v) {
        this.set(clientEnvironments, (BValue)v, null);
    }

    @Generated
    public boolean getShowStackTrace() {
        return this.getBoolean(showStackTrace);
    }

    @Generated
    public void setShowStackTrace(boolean v) {
        this.setBoolean(showStackTrace, v, null);
    }

    @Deprecated
    @Generated
    public BAppletModuleCachingType getAppletModuleCachingType() {
        return (BAppletModuleCachingType)this.get(appletModuleCachingType);
    }

    @Deprecated
    @Generated
    public void setAppletModuleCachingType(BAppletModuleCachingType v) {
        this.set(appletModuleCachingType, (BValue)v, null);
    }

    @Deprecated
    @Generated
    public BWebStartConfig getWebStartConfig() {
        return (BWebStartConfig)this.get(webStartConfig);
    }

    @Deprecated
    @Generated
    public void setWebStartConfig(BWebStartConfig v) {
        this.set(webStartConfig, (BValue)v, null);
    }

    @Generated
    public BCacheConfig getCacheConfig() {
        return (BCacheConfig)this.get(cacheConfig);
    }

    @Generated
    public void setCacheConfig(BCacheConfig v) {
        this.set(cacheConfig, (BValue)v, null);
    }

    @Generated
    public BWebWarmupConfig getWarmupConfig() {
        return (BWebWarmupConfig)this.get(warmupConfig);
    }

    @Generated
    public void setWarmupConfig(BWebWarmupConfig v) {
        this.set(warmupConfig, (BValue)v, null);
    }

    @Generated
    public BHostnameRedirectSettings getHostnameRedirectSettings() {
        return (BHostnameRedirectSettings)this.get(hostnameRedirectSettings);
    }

    @Generated
    public void setHostnameRedirectSettings(BHostnameRedirectSettings v) {
        this.set(hostnameRedirectSettings, (BValue)v, null);
    }

    @Generated
    public BHttpHeaderProviders getHttpHeaderProviders() {
        return (BHttpHeaderProviders)this.get(httpHeaderProviders);
    }

    @Generated
    public void setHttpHeaderProviders(BHttpHeaderProviders v) {
        this.set(httpHeaderProviders, (BValue)v, null);
    }

    @Generated
    public BHostHeaderValidationSettings getHostHeaderValidationSettings() {
        return (BHostHeaderValidationSettings)this.get(hostHeaderValidationSettings);
    }

    @Generated
    public void setHostHeaderValidationSettings(BHostHeaderValidationSettings v) {
        this.set(hostHeaderValidationSettings, (BValue)v, null);
    }

    @Generated
    public void resetAllConnections() {
        this.invoke(resetAllConnections, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "web");
    }

    public IWebEnv getWebEnv(WebOp op) {
        return this.getClientEnvironments().getWebEnv(op);
    }

    public BWebServer getWebServer() {
        BWebServer[] servers = (BWebServer[])this.getChildren(BWebServer.class);
        return servers.length == 0 ? null : servers[0];
    }

    public static BWebService getMainService() {
        return (BWebService)Sys.getService((Type)TYPE);
    }

    public void stationStarted() throws Exception {
        super.stationStarted();
        if (this.getHostHeaderValidationSettings().getValidHostHeaders().isEmpty()) {
            this.getHostHeaderValidationSettings().autoPopulateValidHostHeaders();
        }
    }

    public void serviceStarted() throws Exception {
        super.serviceStarted();
        this.getComponentSpace().enableMixIn(BWebProfileConfig.TYPE);
        BUserService us = (BUserService)Sys.getService((Type)BUserService.TYPE);
        Property prop = us.getProperty("secureOnlyPasswordSet");
        if (prop != null && !us.get(prop).equals((Object)prop.getDefaultValue())) {
            this.setRequireHttpsForPasswords(((BIBoolean)us.get(prop)).getBoolean());
        }
        if (Sys.isStationStarted() && this.getHostHeaderValidationSettings().getValidHostHeaders().isEmpty()) {
            this.getHostHeaderValidationSettings().autoPopulateValidHostHeaders();
        }
        WebUtil.setStationTheme();
    }

    public void serviceStopped() throws Exception {
        super.serviceStopped();
        this.getComponentSpace().disableMixIn(BWebProfileConfig.TYPE);
    }

    protected void enabled() {
        super.enabled();
        this.getWebServer().scheduleRestart();
    }

    protected void disabled() {
        super.disabled();
        BWebServer server = this.getWebServer();
        server.post(() -> server.stopWebServer(null));
    }

    public void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        BIRestrictedComponent.checkParentIsServiceContainer((BComponent)parent, (BIRestrictedComponent)this);
    }

    public BSecurityInfo getSecurityInfo() {
        BSecurityInfo info = new BSecurityInfo();
        info.setSourceName(this.getDisplayName(null));
        if (this.isMounted()) {
            info.setHyperlink(this.getSlotPathOrd());
        }
        info.add("alias", (BValue)BString.make((String)this.getMainCertAliasAndPassword().getAlias()));
        return info;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (property == serverCertificateHealth) {
            return;
        }
        if (this.isRunning()) {
            BWebServer webServer;
            UnauthenticatedCache.checkForInit(property.getName());
            if ((property.isFrozen() || property.getType().is(BAdditionalHttpsCerts.TYPE)) && (webServer = this.getWebServer()) != null) {
                webServer.webServiceConfigurationChanged(property, context);
                if (httpPort == property || httpsPort == property || enabled == property || httpEnabled == property || httpsEnabled == property) {
                    this.updatePlatformSummaryFields();
                } else if (webStartConfig == property) {
                    WebStartServlet.onWebStartConfigChanged();
                }
            }
        }
        if (property.equals(xFrameOptions)) {
            this.getHttpHeaderProviders().getXFrameOptions().setXFrameOptions(this.getXFrameOptions());
        }
    }

    public void added(Property property, Context context) {
        super.added(property, context);
        if (!this.isRunning()) {
            return;
        }
        UnauthenticatedCache.checkForInit(property.getName());
        if (property.getType().is(BAdditionalHttpsCerts.TYPE)) {
            BWebServer webServer = this.getWebServer();
            BAdditionalHttpsCerts additionalHttpsCerts = (BAdditionalHttpsCerts)this.get(property);
            if (webServer != null && additionalHttpsCerts.hasNonEmptyAliases()) {
                webServer.webServiceConfigurationChanged(property, context);
            }
        }
    }

    public void removed(Property property, BValue oldValue, Context context) {
        super.removed(property, oldValue, context);
        if (!this.isRunning()) {
            return;
        }
        UnauthenticatedCache.checkForInit(property.getName());
        if (property.getType().is(BAdditionalHttpsCerts.TYPE)) {
            BWebServer webServer = this.getWebServer();
            BAdditionalHttpsCerts additionalHttpsCerts = (BAdditionalHttpsCerts)oldValue;
            if (webServer != null && additionalHttpsCerts.hasNonEmptyAliases()) {
                webServer.webServiceConfigurationChanged(property, context);
            }
        }
    }

    public void checkAdd(String name, BValue value, int flags, BFacets facets, Context context) {
        super.checkAdd(name, value, flags, facets, context);
        if (value instanceof BWebServer && this.getWebServer() != null) {
            throw new LocalizableRuntimeException("web", "thereCanOnlyBeOne");
        }
    }

    public void descendantsStarted() throws Exception {
        super.descendantsStarted();
        this.verifyWebServer();
    }

    public void childParented(Property property, BValue newChild, Context context) {
        super.childParented(property, newChild, context);
        this.verifyWebServer();
    }

    public void childUnparented(Property property, BValue oldChild, Context context) {
        super.childUnparented(property, oldChild, context);
        this.verifyWebServer();
    }

    private void verifyWebServer() {
        if (!this.isRunning()) {
            return;
        }
        if (this.getWebServer() == null) {
            this.configFail(this.getLexicon().getText("web.noWebServer"));
        } else {
            this.configOk();
        }
    }

    public Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 2: {
                Property p;
                if (!this.isRunning() || httpPort != (p = (Property)a) && httpsPort != p) break;
                this.updatePlatformSummaryFields();
                break;
            }
            case 23: {
                this.updatePlatformSummaryFields();
                break;
            }
            case 11: {
                this.fwStarted();
            }
        }
        return super.fw(x, a, b, c, d);
    }

    private void fwStarted() {
        if (((BUserDataConfig[])this.getChildren(BUserDataConfig.class)).length == 0) {
            this.add("UserDataConfig", (BValue)new BUserDataConfig());
            this.setDisplayName(this.getProperty("UserDataConfig"), BFormat.make((String)"%lexicon(web:userDataConfig)%"), null);
        }
        if (!Flags.has((BComplex)this, (Slot)xFrameOptions, (int)0x10000000)) {
            this.getHttpHeaderProviders().getXFrameOptions().setXFrameOptions(this.getXFrameOptions());
            Flags.add((BComponent)this, (Slot)xFrameOptions, null, (int[])new int[]{0x10000005});
        }
        if (!Flags.has((BComplex)this, (Slot)httpsCert, (int)0x10000000)) {
            this.getMainCertAliasAndPassword().setAlias(this.getHttpsCert());
            this.getMainCertAliasAndPassword().setPassword(BPassword.DEFAULT);
            Flags.add((BComponent)this, (Slot)httpsCert, null, (int[])new int[]{0x10000005});
        }
        if (!Flags.has((BComplex)this, (Slot)mainCertAliasAndPassword, (int)0x10000000)) {
            Flags.add((BComponent)this, (Slot)mainCertAliasAndPassword, null, (int[])new int[]{0x10000000});
            this.setFlags((Slot)mainCertAliasAndPassword, this.getFlags((Slot)mainCertAliasAndPassword) & 0xFFFFFFFB);
            this.setFlags((Slot)serverCertificateHealth, this.getFlags((Slot)serverCertificateHealth) & 0xFFFFFFFB);
            this.getMainCertAliasAndPassword().setFacets((Slot)BCertificateAliasAndPassword.alias, BFacets.make((String)"purposeId", (String)KeyPurpose.SERVER_CERT.name()));
        }
        if (!Flags.has((BComplex)this, (Slot)hostHeaderValidationSettings, (int)0x10000000)) {
            String hostNames = this.getHostHeaderValidationSettings().getValidHostHeaders();
            String updatedHostNames = Arrays.stream(hostNames.trim().split("\\s*[;,]\\s*")).map(hostName -> {
                if (IPAddressUtil.isIpv6AddressFormat((String)hostName)) {
                    return "[" + hostName + "]";
                }
                return hostName;
            }).collect(Collectors.joining(";"));
            this.getHostHeaderValidationSettings().setValidHostHeaders(updatedHostNames);
            Flags.add((BComponent)this, (Slot)hostHeaderValidationSettings, null, (int[])new int[]{0x10000000});
        }
    }

    private void updatePlatformSummaryFields() {
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        int httpPort = -1;
        int httpsPort = -1;
        if (this.getHttpEnabled() && this.getEnabled()) {
            httpPort = this.getHttpPort().getPublicServerPort();
        }
        if (this.getHttpsEnabled() && this.getEnabled()) {
            httpsPort = this.getHttpsPort().getPublicServerPort();
        }
        keys.add("httpport");
        values.add(String.valueOf(httpPort));
        keys.add("httpsport");
        values.add(String.valueOf(httpsPort));
        Nre.getPlatform().reportSummaryFields(keys.toArray(new String[0]), values.toArray(new String[0]));
    }

    public BComponent getHttpConnectionDetails(Context cx) {
        BComponent details = new BComponent();
        details.add("enabled", (BValue)BBoolean.make((boolean)this.getEnabled()));
        details.add("httpEnabled", (BValue)BBoolean.make((boolean)this.getHttpEnabled()));
        details.add("httpsEnabled", (BValue)BBoolean.make((boolean)this.getHttpsEnabled()));
        details.add("httpsPort", (BValue)BInteger.make((int)this.getHttpsPort().getPublicServerPort()));
        details.add("httpPort", (BValue)BInteger.make((int)this.getHttpPort().getPublicServerPort()));
        return details;
    }

    public void doResetAllConnections(Context context) throws Exception {
        new Thread(){

            @Override
            public void run() {
                BWebServer webServer = BWebService.this.getWebServer();
                if (webServer != null) {
                    webServer.invalidateAllSessions();
                }
            }
        }.start();
    }

    public BIcon getIcon() {
        return icon;
    }

    public LexiconFormatInfo getSecurityDashboardSectionHeader(Context cx) {
        return LexiconFormatInfo.make((Type)TYPE, (String)"securityDashboard.sectionHeader");
    }

    public BOrd getSecurityDashboardSectionHyperlinkOrd() {
        return this.getNavOrd().relativizeToSession();
    }

    public int getSecurityDashboardItemsVersion() {
        return 4;
    }

    public boolean isItemProviderEnabled() {
        return !this.getStatus().isDisabled();
    }

    public List<SecurityDashboardItem> getSecurityDashboardItems(Context cx) {
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>();
        this.addTlsItems(items);
        this.addCipherSuiteGroupItems(items);
        this.addStationCertificateItems(items);
        this.addPasswordParameters(items);
        this.addSameSiteItem(items);
        this.addHostHeaderValidationItem(items);
        return items;
    }

    private void addTlsItems(List<SecurityDashboardItem> items) {
        if (this.getHttpEnabled() && !this.getHttpsEnabled()) {
            items.add(dashboardItemBuilder.makeAlert("securityDashboard.webTlsProtocolOff.summary", "securityDashboard.webTlsProtocolOff.description"));
        }
        if (!this.getHttpEnabled() && this.getHttpsEnabled()) {
            items.add(dashboardItemBuilder.makeOk("securityDashboard.webTlsProtocolOn.summary", "securityDashboard.webTlsProtocolOn.description"));
        }
        if (this.getHttpEnabled() && this.getHttpsEnabled() && this.getHttpsOnly()) {
            items.add(dashboardItemBuilder.makeWarning("securityDashboard.webForwarding.summary", "securityDashboard.webForwarding.description"));
        }
        if (this.getHttpEnabled() && this.getHttpsEnabled() && !this.getHttpsOnly()) {
            items.add(dashboardItemBuilder.makeAlert("securityDashboard.webNonTlsProtocol.summary", "securityDashboard.webNonTlsProtocol.description"));
        }
        if (this.getHttpsEnabled()) {
            BSslTlsEnum tlsVersion = this.getHttpsMinProtocol();
            BSecurityItemStatus itemStatus = BWebService.isTlsVersionStrong(tlsVersion) ? BSecurityItemStatus.securityStatusOK : BSecurityItemStatus.securityStatusWarning;
            items.add(dashboardItemBuilder.make(itemStatus).withSummary("securityDashboard.webTlsProtocol.summary", new Object[]{tlsVersion}).withDescription("securityDashboard.webTlsProtocol.description", new Object[]{BSslTlsEnum.tlsv1_2}));
        }
    }

    private static boolean isTlsVersionStrong(BSslTlsEnum tlsVersion) {
        return tlsVersion.equals((Object)BSslTlsEnum.tlsv1_2) || tlsVersion.equals((Object)BSslTlsEnum.tlsv1_3);
    }

    private void addCipherSuiteGroupItems(List<SecurityDashboardItem> items) {
        if (this.getHttpsEnabled()) {
            BSecurityItemStatus itemStatus = this.getCipherSuiteGroup().equals((Object)BTlsCipherSuiteGroup.recommended) ? BSecurityItemStatus.securityStatusOK : BSecurityItemStatus.securityStatusWarning;
            items.add(dashboardItemBuilder.make(itemStatus).withSummary("securityDashboard.cipherSuiteGroup.summary", new Object[]{this.getCipherSuiteGroup()}).withDescription("securityDashboard.cipherSuiteGroup.description", new Object[0]));
        }
    }

    private void addStationCertificateItems(List<SecurityDashboardItem> items) {
        if (this.getHttpsEnabled()) {
            BWebService.addCertificateItems(this.getMainCertAliasAndPassword().getAlias(), items);
            for (BAdditionalHttpsCerts additionalHttpsCerts : (BAdditionalHttpsCerts[])this.getChildren(BAdditionalHttpsCerts.class)) {
                for (BAdditionalHttpsCert additionalHttpsCert : (BAdditionalHttpsCert[])additionalHttpsCerts.getChildren(BAdditionalHttpsCert.class)) {
                    if (additionalHttpsCert.getIsDuplicate()) {
                        items.add(dashboardItemBuilder.makeInfo().withSummary("securityDashboard.additionalCert.duplicate", new Object[]{additionalHttpsCert.getCertAliasAndPassword().getAlias()}).withDescription("securityDashboard.additionalCert.description", new Object[0]));
                        continue;
                    }
                    if (additionalHttpsCert.getIsRejected()) {
                        items.add(dashboardItemBuilder.makeAlert().withSummary("securityDashboard.additionalCert.rejected", new Object[]{additionalHttpsCert.getCertAliasAndPassword().getAlias()}).withDescription("securityDashboard.additionalCert.description", new Object[0]));
                        continue;
                    }
                    BWebService.addCertificateItems(additionalHttpsCert.getCertAliasAndPassword().getAlias(), items);
                }
            }
            BServerCertificateHealth health = this.getServerCertificateHealth();
            switch (health.getCertStatus().getOrdinal()) {
                case 0: {
                    items.add(dashboardItemBuilder.makeOk().withSummary("securityDashboard.certHealth.ok", new Object[]{health.getReturnedCert()}).withDescription("securityDashboard.certHealth.description", new Object[0]));
                    break;
                }
                case 1: {
                    items.add(dashboardItemBuilder.makeAlert().withSummary("securityDashboard.certHealth.badPassword", new Object[]{health.getRequestedCert(), health.getReturnedCert()}).withDescription("securityDashboard.certHealth.description", new Object[0]));
                    break;
                }
                case 2: {
                    items.add(dashboardItemBuilder.makeAlert().withSummary("securityDashboard.certHealth.badKey", new Object[]{health.getRequestedCert(), health.getReturnedCert()}).withDescription("securityDashboard.certHealth.description", new Object[0]));
                    break;
                }
                case 3: {
                    items.add(dashboardItemBuilder.makeAlert().withSummary("securityDashboard.certHealth.missingKey", new Object[]{health.getRequestedCert(), health.getReturnedCert()}).withDescription("securityDashboard.certHealth.description", new Object[0]));
                    break;
                }
                case 4: {
                    items.add(dashboardItemBuilder.makeAlert().withSummary("securityDashboard.certHealth.badDefault", new Object[]{health.getRequestedCert(), health.getReturnedCert()}).withDescription("securityDashboard.certHealth.description", new Object[0]));
                }
            }
        }
    }

    private static void addCertificateItems(String certAlias, List<SecurityDashboardItem> items) {
        try {
            X509Certificate certificate = CertManagerFactory.getInstance().getKeyStore().getCertificate(certAlias);
            BWebService.addCertificateItems(certAlias, certificate, items);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void addCertificateItems(String certAlias, X509Certificate certificate, List<SecurityDashboardItem> items) {
        try {
            certificate.checkValidity();
            Date date = new Date();
            if ((double)(certificate.getNotAfter().getTime() - date.getTime()) < MILLIS_IN_NINETY_DAYS) {
                items.add(dashboardItemBuilder.makeWarning().withSummary("securityDashboard.webCertificateNearExpiry.summary", new Object[]{certAlias, BAbsTime.make((long)certificate.getNotAfter().getTime())}).withDescription("securityDashboard.webCertificateNearExpiry.description", new Object[0]));
            } else {
                items.add(dashboardItemBuilder.makeOk().withSummary("securityDashboard.webCertificateValid.summary", new Object[]{certAlias}).withDescription("securityDashboard.webCertificateValid.description", new Object[0]));
            }
        }
        catch (CertificateExpiredException e) {
            items.add(dashboardItemBuilder.makeAlert().withSummary("securityDashboard.webCertificateExpired.summary", new Object[]{certAlias}).withDescription("securityDashboard.webCertificateExpired.description", new Object[0]));
        }
        catch (CertificateNotYetValidException e) {
            items.add(dashboardItemBuilder.makeAlert().withSummary("securityDashboard.webCertificateNotYetValidException.summary", new Object[]{certAlias, BAbsTime.make((long)certificate.getNotBefore().getTime())}).withDescription("securityDashboard.webCertificateNotYetValidException.description", new Object[0]));
        }
        if (BWebService.isSelfSigned(certificate)) {
            if ("default".equalsIgnoreCase(certAlias)) {
                items.add(dashboardItemBuilder.makeWarning().withSummary("securityDashboard.webCertificateDefault.summary", new Object[0]).withDescription("securityDashboard.webCertificateDefault.description", new Object[0]));
            } else {
                items.add(dashboardItemBuilder.makeWarning().withSummary("securityDashboard.webCertificateSelfSigned.summary", new Object[]{certAlias}).withDescription("securityDashboard.webCertificateSelfSigned.description", new Object[0]));
            }
        } else {
            items.add(dashboardItemBuilder.makeOk().withSummary("securityDashboard.webCertificateNotSelfSigned.summary", new Object[]{certAlias}).withDescription("securityDashboard.webCertificateNotSelfSigned.description", new Object[0]));
        }
        try {
            ICoreKeyStore keyStore = (ICoreKeyStore)CertManagerFactory.getInstance().getKeyStore();
            if (CertUtils.isPrivateKeyGloballyEncrypted((String)certAlias, (ICoreKeyStore)keyStore)) {
                items.add(dashboardItemBuilder.makeWarning().withSummary("securityDashboard.webCertificateGloballyEncrypted.summary", new Object[]{certAlias}).withDescription("securityDashboard.webCertificateEncrypted.description", new Object[0]));
            } else {
                items.add(dashboardItemBuilder.makeOk().withSummary("securityDashboard.webCertificateUniquelyEncrypted.summary", new Object[]{certAlias}).withDescription("securityDashboard.webCertificateEncrypted.description", new Object[0]));
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "unable to check private key for password", e);
        }
    }

    private void addPasswordParameters(List<SecurityDashboardItem> items) {
        BSecurityItemStatus itemStatus;
        String summaryKey;
        if (this.getRequireHttpsForPasswords()) {
            summaryKey = "securityDashboard.requireHttpsForPasswordTrue.summary";
            itemStatus = BSecurityItemStatus.securityStatusOK;
        } else {
            summaryKey = "securityDashboard.requireHttpsForPasswordFalse.summary";
            itemStatus = BSecurityItemStatus.securityStatusWarning;
        }
        String descriptionKey = "securityDashboard.requireHttpsForPassword.description";
        items.add(dashboardItemBuilder.make(itemStatus, summaryKey, descriptionKey));
    }

    private void addSameSiteItem(List<SecurityDashboardItem> items) {
        BSameSiteEnum sameSite = this.getSameSite();
        BSecurityItemStatus itemStatus = sameSite == BSameSiteEnum.none ? BSecurityItemStatus.securityStatusWarning : BSecurityItemStatus.securityStatusOK;
        items.add(dashboardItemBuilder.make(itemStatus).withSummary("securityDashboard.sameSite.summary", new Object[]{sameSite}).withDescription("securityDashboard.sameSite.description", new Object[0]));
    }

    private void addHostHeaderValidationItem(List<SecurityDashboardItem> items) {
        if (this.getHostHeaderValidationSettings().getValidateHostHeader()) {
            if (this.getHostHeaderValidationSettings().getValidHostHeaders().contains("*")) {
                items.add(dashboardItemBuilder.makeWarning("securityDashboard.hostHeader.wildcard.summary", "securityDashboard.hostHeader.description"));
            } else {
                items.add(dashboardItemBuilder.makeOk("securityDashboard.hostHeader.ok.summary", "securityDashboard.hostHeader.description"));
            }
        } else {
            items.add(dashboardItemBuilder.makeAlert("securityDashboard.hostHeader.validationOff.summary", "securityDashboard.hostHeader.description"));
        }
    }

    private static boolean isSelfSigned(X509Certificate certificate) {
        return CertUtils.checkDnEquality((X500Principal)certificate.getSubjectX500Principal(), (X500Principal)certificate.getIssuerX500Principal());
    }

    public IPropertyValidator getPropertyValidator(Property[] properties, Context context) {
        if (ArrayUtil.indexOf((Object[])properties, (Object)mainCertAliasAndPassword) > -1) {
            return this.validator;
        }
        return super.getPropertyValidator(properties, context);
    }

    public IPropertyValidator getPropertyValidator(Property property, Context context) {
        if (mainCertAliasAndPassword.equals(property)) {
            return this.validator;
        }
        return super.getPropertyValidator(property, context);
    }

    public Property getCertificateAliasAndPasswordProperty(Context context) {
        return mainCertAliasAndPassword;
    }

    public BPassword retrieveCertificatePassword(Property certAliasAndPasswordProperty, Context context) {
        if (!mainCertAliasAndPassword.equals(certAliasAndPasswordProperty)) {
            throw new IllegalArgumentException("Unexpected CertificateAliasAndPassword property argument: \"" + certAliasAndPasswordProperty + "\" != \"" + mainCertAliasAndPassword + '\"');
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SigningPasswordPermission(TYPE.getTypeSpec().getModuleName()));
        }
        return BPassword.make((String)AccessController.doPrivileged(() -> this.getMainCertAliasAndPassword().getPassword().getValue()));
    }

    public void certificateSigned(Property certAliasAndPasswordProperty, X509Certificate[] certificateChain, Context context) {
        if (!mainCertAliasAndPassword.equals(certAliasAndPasswordProperty)) {
            throw new IllegalArgumentException("Unexpected CertificateAliasAndPassword property argument: \"" + certAliasAndPasswordProperty + "\" != \"" + mainCertAliasAndPassword + '\"');
        }
        this.changed(mainCertAliasAndPassword, null);
    }
}

