/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.web;

import com.tridium.security.BISecurityInfoSource;
import com.tridium.security.BISecurityService;
import com.tridium.sys.Nre;
import com.tridium.sys.service.BServiceEvent;
import com.tridium.sys.service.ServiceListener;
import com.tridium.web.servlets.UnauthenticatedCache;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIService;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.ExecutorUtil;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Lexicon;
import javax.baja.web.BINiagaraWebServlet;
import javax.baja.web.BWebService;
import javax.baja.web.BWebServlet;

@NiagaraType
@NiagaraProperty(name="serverState", type="String", defaultValue="stopped", flags=3)
@NiagaraAction(name="restart", flags=16)
public abstract class BWebServer
extends BComponent
implements BIService {
    @Generated
    public static final Property serverState = BWebServer.newProperty((int)3, (String)"stopped", null);
    @Generated
    public static final Action restart = BWebServer.newAction((int)16, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BWebServer.class);
    private final ServiceListener serviceListener = new ServiceListener(){

        public void serviceEvent(BServiceEvent event) {
            if (event.getServiceType().is(BISecurityService.TYPE) && event.getId() == 0) {
                ((BISecurityService)event.getService().as(BISecurityService.class)).register((BISecurityInfoSource)BWebServer.this.getWebService());
            }
        }
    };
    private ExecutorService executorService;
    private volatile ServerState state = ServerState.stopped;
    protected volatile Clock.Ticket restartTicket = Clock.expiredTicket;
    public static final Logger log = Logger.getLogger(BWebServer.class.getName());
    private static final BIcon Icon = BIcon.std((String)"web.png");
    private static final int RESTART_DELAY_SECONDS = 5;
    private static final Lexicon lex = Lexicon.make(BWebServer.class);
    protected static final BWebServlet[] EMPTY_WEB_SERVLET_ARRAY = new BWebServlet[0];

    @Generated
    public String getServerState() {
        return this.getString(serverState);
    }

    @Generated
    public void setServerState(String v) {
        this.setString(serverState, v, null);
    }

    @Generated
    public void restart() {
        this.invoke(restart, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected final BWebService getWebService() {
        return (BWebService)this.getParent();
    }

    final void webServiceConfigurationChanged(Property property, Context context) {
        this.post(() -> {
            this.doWebServiceConfigurationChanged(property, context);
            if (this.isRestartRequired(property, context)) {
                this.scheduleRestart();
            }
        });
    }

    protected boolean isRestartRequired(Property property, Context context) {
        return true;
    }

    protected void doWebServiceConfigurationChanged(Property property, Context context) {
    }

    protected abstract void doStartWebServer() throws Exception;

    @Deprecated
    protected abstract void doStopWebServer() throws Exception;

    protected void doStopWebServer(Context context) throws Exception {
        this.doStopWebServer();
    }

    public final void register(BINiagaraWebServlet servlet) {
        this.post(() -> this.doRegister(servlet));
    }

    protected abstract void doRegister(BINiagaraWebServlet var1);

    public final void unregister(BINiagaraWebServlet servlet) {
        this.post(() -> this.doUnregister(servlet));
    }

    protected abstract void doUnregister(BINiagaraWebServlet var1);

    public BWebServlet[] getWebServlets() {
        BINiagaraWebServlet[] servlets = this.getServlets();
        ArrayList<BWebServlet> webServlets = new ArrayList<BWebServlet>(servlets.length);
        for (BINiagaraWebServlet servlet : servlets) {
            if (!(servlet instanceof BWebServlet)) continue;
            webServlets.add((BWebServlet)servlet);
        }
        return webServlets.toArray(EMPTY_WEB_SERVLET_ARRAY);
    }

    public abstract BINiagaraWebServlet[] getServlets();

    private void startWebServer() {
        BWebService service = this.getWebService();
        try {
            if (service.isDisabled()) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(lex.getText("webserver.serviceNotOperational"));
                }
                return;
            }
            if (this.getWebService().getWebServer() != this) {
                log.warning(lex.getText("webserver.notPrimary"));
                return;
            }
            if (this.isServerRunning()) {
                return;
            }
            UnauthenticatedCache.init();
            this.transitionToState(ServerState.starting);
            this.doStartWebServer();
            this.transitionToState(ServerState.started);
            service.configOk();
            Optional securityService = Sys.findService((Type)BISecurityService.TYPE);
            if (securityService.isPresent()) {
                ((BISecurityService)((BIService)securityService.get()).as(BISecurityService.class)).register((BISecurityInfoSource)service);
            } else {
                AccessController.doPrivileged(() -> {
                    Nre.getServiceManager().addServiceListener(this.serviceListener);
                    return null;
                });
            }
        }
        catch (Throwable t) {
            this.stopWebServer(null);
            this.setFailed(t);
            log.info(lex.getText("webserver.scheduleRestart", new Object[]{5}));
            this.scheduleRestart(BRelTime.makeSeconds((int)5));
        }
    }

    @Deprecated
    final void stopWebServer() {
        this.stopWebServer(null);
    }

    final void stopWebServer(Context cx) {
        try {
            if (!this.isServerRunning()) {
                return;
            }
            this.transitionToState(ServerState.stopping);
            this.doStopWebServer(cx);
            this.transitionToState(ServerState.stopped);
        }
        catch (Throwable t) {
            this.setFailed(t);
        }
        finally {
            Sys.findService((Type)BISecurityService.TYPE).ifPresent(s -> ((BISecurityService)s.as(BISecurityService.class)).unregister((BISecurityInfoSource)this.getWebService()));
            AccessController.doPrivileged(() -> {
                Nre.getServiceManager().removeServiceListener(this.serviceListener);
                return null;
            });
        }
    }

    protected final synchronized void scheduleRestart() {
        this.scheduleRestart(BRelTime.make((long)500L));
    }

    protected synchronized void scheduleRestart(BRelTime delay) {
        this.restartTicket.cancel();
        this.restartTicket = Clock.schedule((BComponent)this, (BRelTime)delay, (Action)restart, null);
    }

    public final void doRestart(Context cx) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Restarting " + this.getType());
        }
        this.stopWebServer(cx);
        if (!this.isServerRunning()) {
            this.startWebServer();
        }
    }

    private void transitionToState(ServerState newState) {
        if (newState == ServerState.failed) {
            this.setFailed(new Throwable("web server indicated unknown failure").fillInStackTrace());
        } else {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, newState.name() + " {0}", this.getType());
            }
            this.setServerState(newState.name());
            this.state = newState;
        }
    }

    private void setFailed(Throwable t) {
        log.log(Level.SEVERE, "failed: " + t, t);
        this.setServerState(ServerState.failed.name());
        this.state = ServerState.failed;
        this.getWebService().configFail(Objects.toString(t.getMessage(), ""));
    }

    private boolean isServerRunning() {
        return ServerState.started == this.state || ServerState.starting == this.state;
    }

    public final Future<?> post(Runnable r) {
        if (this.executorService == null) {
            throw new IllegalStateException("Cannot post to Web Server Config Thread. Thread not running: " + r.toString());
        }
        return this.executorService.submit(r);
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public void serviceStarted() throws Exception {
    }

    public void serviceStopped() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object fw(int x, Object a, Object b, Object c, Object d) {
        if (15 == x) {
            this.executorService = ExecutorUtil.newSingleThreadBackgroundExecutor((String)"webServerConfig", (long)1L, (TimeUnit)TimeUnit.MINUTES);
        } else if (16 == x) {
            this.post(() -> {
                this.stopWebServer(null);
                this.executorService.shutdownNow();
            });
        } else if (11 == x) {
            CountDownLatch startedLatch = new CountDownLatch(1);
            CountDownLatch postLatch = new CountDownLatch(1);
            this.post(() -> {
                try {
                    postLatch.countDown();
                    startedLatch.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            });
            try {
                postLatch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                this.startWebServer();
            }
            finally {
                startedLatch.countDown();
            }
        }
        return super.fw(x, a, b, c, d);
    }

    public final boolean isParentLegal(BComponent parent) {
        return super.isParentLegal(parent) && parent instanceof BWebService;
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        if (restart == action && this.isRunning()) {
            this.post((Runnable)new Invocation((BComponent)this, action, argument, cx));
            return null;
        }
        return super.post(action, argument, cx);
    }

    public BIcon getIcon() {
        return Icon;
    }

    public String toString(Context context) {
        return String.format("%s (%s)", super.toString(context), this.getServerState());
    }

    protected void invalidateAllSessions() {
        throw new UnsupportedOperationException("Invalidate all sessions not supported by this BWebServer");
    }

    protected static enum ServerState {
        stopped,
        starting,
        started,
        stopping,
        failed;

    }
}

