/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web.stub;

import com.tridium.web.stub.StubNiagaraWebSession;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;

public class StubHttpSession
implements HttpSession {
    private String id = "id";
    private long creationTime;
    private long lastAccessed = this.creationTime = System.currentTimeMillis();
    private boolean isNew;
    private Map<String, Object> values;
    private long maxInactive = 600000L;

    public StubHttpSession() {
        this.setAttribute("javax.baja.web.niagaraWebSession", new StubNiagaraWebSession(this));
    }

    public String getId() {
        return this.id;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public synchronized long getLastAccessedTime() {
        return this.lastAccessed;
    }

    public synchronized void setLastAccessedTime(long lastAcc) {
        this.lastAccessed = lastAcc;
    }

    @Deprecated
    public HttpSessionContext getSessionContext() {
        return null;
    }

    public ServletContext getServletContext() {
        return null;
    }

    public Enumeration<String> getAttributeNames() {
        if (this.values == null) {
            return Collections.emptyEnumeration();
        }
        return Collections.enumeration(this.values.keySet());
    }

    @Deprecated
    public synchronized String[] getValueNames() {
        String[] res = this.values == null ? new String[]{} : this.values.keySet().toArray(new String[0]);
        return res;
    }

    public Object getAttribute(String name) {
        if (this.values == null) {
            return null;
        }
        return this.values.get(name);
    }

    @Deprecated
    public synchronized Object getValue(String name) {
        if (this.values == null) {
            return null;
        }
        return this.values.get(name);
    }

    public void setAttribute(String name, Object value) {
        this.putValue(name, value);
    }

    @Deprecated
    public synchronized void putValue(String name, Object value) {
        if (value == null) {
            this.removeValue(name);
            return;
        }
        if (this.values == null) {
            this.values = new HashMap<String, Object>(3);
        }
        if (value instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)value).valueBound(new HttpSessionBindingEvent((HttpSession)this, name));
        }
        this.values.put(name, value);
    }

    public void removeAttribute(String name) {
        this.removeValue(name);
    }

    @Deprecated
    public synchronized void removeValue(String name) {
        if (this.values == null) {
            return;
        }
        Object value = this.values.remove(name);
        if (value instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)value).valueUnbound(new HttpSessionBindingEvent((HttpSession)this, name));
        }
    }

    public synchronized void invalidate() {
        if (this.values != null) {
            String[] keys;
            for (String key : keys = this.values.keySet().toArray(new String[0])) {
                this.removeValue(key);
            }
        }
    }

    public boolean isNew() {
        return this.lastAccessed == this.creationTime;
    }

    public int getMaxInactiveInterval() {
        return (int)(this.maxInactive / 1000L);
    }

    public void setMaxInactiveInterval(int max) {
        this.maxInactive = (long)max * 1000L;
    }

    public boolean isExpired() {
        if (this.maxInactive < 0L) {
            return false;
        }
        return this.lastAccessed + this.maxInactive < System.currentTimeMillis();
    }
}

