/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web.servlets;

import com.tridium.crypto.core.cert.NX509Certificate;
import com.tridium.nre.util.NiagaraFiles;
import com.tridium.session.NiagaraSession;
import com.tridium.session.SessionManager;
import com.tridium.sys.DefaultBootEnv;
import com.tridium.sys.Nre;
import com.tridium.sys.module.DefaultModulesFileManager;
import com.tridium.sys.module.ManagedFile;
import com.tridium.sys.module.ManagedModuleFile;
import com.tridium.sys.module.ModulesFileManager;
import com.tridium.sys.registry.NModuleInfo;
import com.tridium.sys.registry.NRegistry;
import com.tridium.util.EscUtil;
import com.tridium.web.CookieUtil;
import com.tridium.web.HttpHeaderUtil;
import com.tridium.web.WebUtil;
import com.tridium.web.session.NiagaraWebSession;
import com.tridium.web.session.WebSessionUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.SocketException;
import java.security.AccessController;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import javax.baja.agent.AgentInfo;
import javax.baja.firewall.BServerPort;
import javax.baja.io.HtmlWriter;
import javax.baja.license.Feature;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.naming.SyntaxException;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.nre.util.FileUtil;
import javax.baja.registry.LexiconInfo;
import javax.baja.registry.ModuleInfo;
import javax.baja.registry.TypeInfo;
import javax.baja.security.crypto.CertManagerFactory;
import javax.baja.security.crypto.IKeyStore;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BModule;
import javax.baja.sys.BSimple;
import javax.baja.sys.BStation;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.Lexicon;
import javax.baja.web.BAppletModuleCachingType;
import javax.baja.web.BWebProfileConfig;
import javax.baja.web.BWebService;
import javax.baja.web.UserAgent;
import javax.baja.web.WebOp;
import javax.baja.xml.XWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.owasp.encoder.Encode;

public class WbServlet
extends HttpServlet {
    private static String quote = "'";
    static Logger log = Logger.getLogger("web.wb");
    static final String jarMimeType = "application/java-archive";
    static final String niagaraZipMimeType = "application/x-niagara-zip";
    private boolean licenseWb;
    private boolean licenseWbAdmin;
    static final Pattern jxBrowserJarPattern = Pattern.compile("jxbrowser-([a-zA-Z0-9]+)-([0-9.]+).jar");
    static final Pattern jxBrowserCloudJnlpPattern = Pattern.compile("jxbrowser-cloud-([0-9.]+).jnlp");
    static final Pattern jxBrowserLocalJnlpPattern = Pattern.compile("jxbrowser-local-([0-9.]+).jnlp");
    private static final String[] emptyArray = new String[0];
    private static final HashMap<String, Long> crcs = new HashMap();
    public static final boolean disableJxBrowser = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.jxbrowser.disable") && !Boolean.getBoolean("niagara.webLauncher.jxbrowser.enable") && !Boolean.getBoolean("niagara.webLauncher.jxbrowser.7.31.enable"));
    public static final String xuaCompatibleContent = AccessController.doPrivileged(() -> System.getProperty("niagara.profile.X-UA-Compatible-content", "IE=edge"));
    private static final String EMBED_APPLET_SCRIPT = "/module/web/com/tridium/web/rc/embedApplet.built.min.js?snoop=false";
    private static final String EMBED_WEB_START_APPLET_SCRIPT = "/module/web/com/tridium/web/rc/embedWebStartApplet.built.min.js?snoop=false";
    private static final String MIN_JRE_VERSION = "1.8";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        BWebService service = WbServlet.getWebService();
        try {
            if (service != null) {
                Feature feature = service.getLicenseFeature();
                this.licenseWb = feature.getb("ui.wb", false);
                this.licenseWbAdmin = feature.getb("ui.wb.admin", false);
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Error initializing WbServlet", ex);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!this.licenseWb) {
            resp.sendError(403);
            return;
        }
        String uri = req.getRequestURI().toLowerCase();
        if (uri.equals("/wb/")) {
            return;
        }
        if (uri.startsWith("/wb/ext/") || uri.startsWith("/wb/bin/")) {
            this.downloadExtJar(req, resp);
            return;
        }
        if (uri.startsWith("/wb/module/baja")) {
            this.downloadModule(req, resp);
            return;
        }
        HttpHeaderUtil.neverCache(resp);
        if (uri.equals("/wb/keepalive")) {
            WbServlet.writeOneSpace(resp);
        } else if (uri.equals("/wb/module")) {
            this.downloadModule(req, resp);
        } else if (uri.equals("/wb/modulelist")) {
            this.downloadModuleList(req, resp);
        } else if (uri.startsWith("/wb/lexiconmodulelist")) {
            this.downloadLexiconModuleList(req, resp);
        } else if (uri.equals("/wb/modulecachinginfo")) {
            WbServlet.downloadModuleCachingInfo(req, resp);
        } else if (uri.startsWith("/wb/readzip/")) {
            this.downloadZip(req, resp);
        } else if (uri.startsWith("/wb/logon")) {
            this.logon(req, resp);
        } else if (uri.equals("/wb/facetkeys")) {
            this.downloadFacetKeys(req, resp);
        } else if (uri.startsWith("/wb/sysprops")) {
            this.downloadSystemPropertiesFile(req, resp);
        } else if (uri.startsWith("/wb/killntokens")) {
            WbServlet.killNTokens(req, resp);
        } else if (uri.equals("/wb/webstartextjars")) {
            WbServlet.getWebstartExtJarNames(resp);
        } else if (uri.equals("/wb/webstartlex")) {
            this.downloadWebStartLex(req, resp, req.getLocale());
        } else if (uri.equals("/wb/policy")) {
            AccessController.doPrivileged(() -> {
                try {
                    this.downloadPolicy(req, resp);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            });
        } else {
            log.severe("Unknown wb req: " + uri);
            resp.sendError(404);
        }
    }

    private static void writeOneSpace(HttpServletResponse resp) throws IOException {
        resp.setStatus(200);
        resp.setContentLength(1);
        resp.getWriter().write(32);
    }

    private static void killNTokens(HttpServletRequest request, HttpServletResponse response) throws IOException {
        NiagaraWebSession session = WebSessionUtil.getSession(request, false);
        if (session != null) {
            SessionManager.invalidateNtokens((String)session.getId());
        }
        Cookie removeNtoken = CookieUtil.createCookie("NTOKEN", "", 0);
        removeNtoken.setHttpOnly(false);
        response.addCookie(removeNtoken);
        WbServlet.writeOneSpace(response);
    }

    void downloadPolicy(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        File policyDir = NiagaraFiles.getSecurityPolicyPath();
        if (policyDir.exists() && policyDir.isDirectory()) {
            String fileName = req.getParameter("file");
            if (fileName != null) {
                for (File file : policyDir.listFiles((dir, name) -> name.equals(fileName))) {
                    this.download(req, resp, file, "text/plain", false);
                }
            } else {
                resp.sendError(404, "could not find policy file");
            }
        } else {
            resp.sendError(404, "could not find directory \"" + policyDir.getPath() + '\"');
        }
    }

    void downloadModule(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String modulePartName = req.getParameter("name");
        if (modulePartName == null && req.getRequestURI().contains("/wb/module/")) {
            modulePartName = req.getRequestURI().replace("/wb/module/", "");
            modulePartName = modulePartName.replace(".jar", "");
            modulePartName = modulePartName.substring(0, modulePartName.lastIndexOf(45));
        }
        if (modulePartName == null) {
            throw new SyntaxException("missing name param");
        }
        if (!new File(modulePartName.replace('\u0000', 'x')).getName().equals(modulePartName)) {
            throw new SyntaxException("invalid name param");
        }
        File file = Nre.bootEnv.findDependency(modulePartName);
        if (this.preDownload(req, resp, file)) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("downloadModule: " + file);
        }
        this.download(req, resp, file, jarMimeType, false);
    }

    void downloadModuleList(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.setContentType("text/plain");
        PrintWriter out = resp.getWriter();
        for (ModuleInfo module : Sys.getRegistry().getModules()) {
            WbServlet.printModuleInfo((NModuleInfo)module, out);
        }
    }

    void downloadLexiconModuleList(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String local = req.getParameter("locale");
        if (local == null) {
            throw new IOException("missing locale param");
        }
        NRegistry reg = (NRegistry)Sys.getRegistry();
        resp.setContentType("text/plain");
        PrintWriter out = resp.getWriter();
        HashSet<String> lexiconModules = new HashSet<String>();
        for (LexiconInfo info : reg.getLexicons()) {
            NModuleInfo moduleInfo;
            if (!info.getLanguage().equals(local) || lexiconModules.contains((moduleInfo = (NModuleInfo)reg.getModule(info.getContainerModuleName(), info.getContainerRuntimeProfile())).getModulePartName())) continue;
            lexiconModules.add(moduleInfo.getModulePartName());
            WbServlet.printModuleInfo(moduleInfo, out);
        }
    }

    private static void printModuleInfo(NModuleInfo moduleInfo, PrintWriter out) {
        long crc = -1L;
        BWebService webService = WbServlet.getWebService();
        if (null != webService && webService.getAppletModuleCachingType().equals((Object)BAppletModuleCachingType.user)) {
            DefaultModulesFileManager.ModuleFileSet moduleFiles = ((DefaultModulesFileManager)DefaultModulesFileManager.get().get()).init(false);
            crc = WbServlet.getCRC(moduleFiles.getByModuleName(moduleInfo.getModuleName(), moduleInfo.getRuntimeProfile()).getFile());
        }
        out.println(moduleInfo.getModulePartName() + '=' + moduleInfo.getModuleName() + ';' + moduleInfo.getRuntimeProfile().name() + ';' + moduleInfo.getVendorVersion() + ';' + moduleInfo.getBuildTime() + ';' + crc + ';');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getCRC(File file) {
        HashMap<String, Long> hashMap = crcs;
        synchronized (hashMap) {
            return crcs.computeIfAbsent(file.getName(), k -> FileUtil.getCrc((File)file));
        }
    }

    public static void downloadModuleCachingInfo(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        BWebService webService = WbServlet.getWebService();
        if (webService != null) {
            resp.getWriter().print("moduleCachingType=" + webService.getAppletModuleCachingType().getTag());
        }
    }

    void downloadExtJar(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String uri = req.getRequestURI();
        String name = uri.substring(uri.lastIndexOf("/") + 1);
        ManagedFile jar = null;
        ModulesFileManager modulesFileManager = ((DefaultBootEnv)Nre.bootEnv).getModulesFileManager();
        if (name.startsWith("nre") && name.endsWith(".jar")) {
            jar = modulesFileManager.getExtFile("bin/ext/nre.jar");
        } else if (name.startsWith("cryptoCore") && name.endsWith(".jar")) {
            jar = modulesFileManager.getExtFile("bin/ext/cryptoCore.jar");
        } else if (name.startsWith("niagarad") && name.endsWith(".jar")) {
            jar = modulesFileManager.getExtFile("bin/ext/niagarad.jar");
        } else if (name.startsWith("splash") && name.endsWith(".jar")) {
            jar = modulesFileManager.getExtFile("bin/ext/splash.jar");
        } else if (name.startsWith("daemonCrypto") && name.endsWith(".jar")) {
            jar = modulesFileManager.getExtFile("bin/ext/daemonCrypto.jar");
        } else if (uri.contains("ext/")) {
            int idx = uri.indexOf("ext/");
            jar = modulesFileManager.getExtFile("bin/" + uri.substring(idx));
        }
        if (jar != null && jar.getFile().exists()) {
            try {
                this.download(req, resp, jar.getFile(), jarMimeType, false);
            }
            catch (SocketException socketException) {}
        } else {
            resp.sendError(404);
        }
    }

    void downloadZip(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String uri = req.getRequestURI();
        String path = uri.substring("/wb/readzip".length() + 1);
        if (!path.contains("..") && (path.startsWith("registry/") || path.startsWith("lib/") || path.startsWith("etc/") || path.startsWith("defaults/"))) {
            File homeDir = path.startsWith("defaults/") ? Nre.getNiagaraHome() : Sys.getNiagaraUserHome();
            path = path.replace('/', File.separatorChar);
            File file = new File(homeDir, path);
            try {
                this.download(req, resp, file, niagaraZipMimeType, false);
            }
            catch (Exception se) {
                se.printStackTrace();
            }
            return;
        }
        resp.sendError(404);
    }

    void downloadFacetKeys(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        File file = new File(Nre.getNiagaraHome(), "defaults" + File.separator + "workbench" + File.separator + "facetKeys.properties");
        if (this.preDownload(req, resp, file)) {
            return;
        }
        try {
            this.download(req, resp, file, "text/plain", false);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    void downloadSystemPropertiesFile(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        File defaultsDir = new File(Nre.getNiagaraHome(), "defaults");
        if (defaultsDir.exists() && defaultsDir.isDirectory()) {
            String fileName = req.getParameter("file");
            if (fileName != null) {
                for (File file : defaultsDir.listFiles((dir, name) -> name.equals(fileName))) {
                    this.download(req, resp, file, "text/plain", false);
                }
            } else {
                resp.sendError(404, "could not find system properties file");
            }
        } else {
            resp.sendError(404, "could not find directory \"" + defaultsDir.getPath() + '\"');
        }
    }

    void logon(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            BUserService service = BUserService.getService();
            if (service == null) {
                resp.sendError(404);
                return;
            }
            BUser user = service.getUser(EscUtil.slot.unescape(req.getUserPrincipal().getName()));
            resp.setContentType("text/plain");
            PrintWriter out = resp.getWriter();
            out.print("username=" + user.getUsername() + '\n');
            BWebService webService = WbServlet.getWebService();
            if (webService == null) {
                resp.sendError(404);
                return;
            }
            boolean httpsEnabled = webService.getHttpsEnabled();
            boolean httpEnabled = webService.getHttpEnabled();
            boolean httpsOnly = webService.getHttpsOnly();
            BComponent foxService = Sys.getService((Type)Sys.getType((String)"fox:FoxService"));
            boolean foxEnabled = ((BBoolean)foxService.get("foxEnabled")).getBoolean();
            boolean foxsEnabled = ((BBoolean)foxService.get("foxsEnabled")).getBoolean();
            boolean secureScheme = req.getScheme().equalsIgnoreCase("https");
            boolean secureSettings = httpsEnabled && foxsEnabled;
            boolean nonSecureSettings = httpEnabled && foxEnabled;
            int foxPort = ((BServerPort)foxService.get("foxPort")).getPublicServerPort();
            int foxsPort = ((BServerPort)foxService.get("foxsPort")).getPublicServerPort();
            int n = secureScheme ? (secureSettings ? foxsPort : -1) : (nonSecureSettings ? foxPort : (foxPort = httpsOnly && secureSettings ? foxsPort : -1));
            if (secureScheme) {
                out.print("useFoxs=true\n");
                BString alias = (BString)foxService.get("foxsCert");
                IKeyStore keyStore = CertManagerFactory.getInstance().getKeyStore();
                X509Certificate cert = keyStore.getCertificate(alias.getString());
                try {
                    String fp = NX509Certificate.make((X509Certificate)cert).getSHA1Fingerprint();
                    out.print("sha1FingerPrint=" + fp + '\n');
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            out.print("foxPort=" + foxPort + '\n');
            out.print("admin=" + this.licenseWbAdmin + '\n');
            out.print("userFacets=" + user.getFacets().encodeToString() + '\n');
            NiagaraSession session = WbServlet.getNiagaraSession(req);
            if (session != null) {
                out.print("httpSuperSession=" + session.getSuperId() + '\n');
                out.print("csrfToken=" + SessionManager.getCurrentNiagaraSuperSession().getCsrfToken() + '\n');
            }
        }
        catch (Exception e) {
            if (!(e instanceof IOException)) {
                throw new IOException(e);
            }
            throw (IOException)e;
        }
    }

    private static NiagaraSession getNiagaraSession(HttpServletRequest req) {
        return WebSessionUtil.getSession(req, false);
    }

    boolean preDownload(HttpServletRequest req, HttpServletResponse resp, File file) throws IOException {
        if (file == null || !file.exists()) {
            resp.sendError(404);
            return true;
        }
        long lastMod = file.lastModified() / 1000L * 1000L;
        long ifMod = req.getDateHeader("If-Modified-Since");
        if (ifMod != -1L && lastMod <= ifMod) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("download not-modified: " + file);
            }
            resp.sendError(304);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void download(HttpServletRequest req, HttpServletResponse resp, File file, String mimeType, boolean zip) throws IOException {
        if (this.preDownload(req, resp, file)) {
            return;
        }
        int len = (int)file.length();
        resp.setContentType(mimeType);
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
            Object out = null;
            try {
                if (zip) {
                    resp.setHeader("content-encoding", "gzip");
                    out = resp.getOutputStream();
                } else if (niagaraZipMimeType.equals(mimeType)) {
                    out = new GZIPOutputStream((OutputStream)resp.getOutputStream());
                } else {
                    resp.setContentLength(len);
                    out = resp.getOutputStream();
                }
                HttpHeaderUtil.setLastModified(resp, file);
                FileUtil.pipe((InputStream)in, (long)len, (OutputStream)out);
            }
            catch (Throwable throwable) {
                WebUtil.closeOutputStream(out);
                throw throwable;
            }
            WebUtil.closeOutputStream((OutputStream)out);
        }
    }

    public static void serviceView(AgentInfo viewInfo, WebOp op) throws Exception {
        BUser user = BUser.getCurrentAuthenticatedUser();
        if (user == null) {
            op.getResponse().sendError(403);
            return;
        }
        op.setContentType("text/html");
        op.getResponse().setHeader("Cache-Control", "no-cache, no-store");
        HtmlWriter out = new HtmlWriter((Writer)op.getWriter());
        out.w((Object)"<html>");
        out.w((Object)"<head>");
        String stationDisplay = WbServlet.getStationDisplayName(op);
        String viewDisplay = WbServlet.getViewDisplayName(viewInfo, op);
        String pageTitle = stationDisplay == null ? viewDisplay : stationDisplay + " - " + viewDisplay;
        if (pageTitle != null) {
            out.w((Object)"<title>");
            out.safe((Object)pageTitle);
            out.w((Object)"</title>");
        }
        out.print("<meta http-equiv=\"X-UA-Compatible\" content=\"");
        out.print(XWriter.safeToString((String)xuaCompatibleContent, (boolean)false));
        out.println("\">");
        out.w((Object)"</head>");
        out.w((Object)"<body style='margin: 0; padding: 0; overflow: hidden;' bgcolor='#ffffff'>");
        WbServlet.writeApplet(op.getUserAgent(), op.getRequest(), op.getResponse(), out, "100%", "100%", op.getOrd().toString(), op.getLanguage(), op.getProfileConfig().getTypeSpec().toString(), user.getUsername(), (BWebService)Sys.getService((Type)BWebService.TYPE), op.getProfileConfig(), emptyArray);
        out.w((Object)"</body></html>");
    }

    public static String getStationDisplayName(WebOp op) {
        BStation station = Sys.getStation();
        String result = station.getStationDisplayName((Context)op);
        if (result == null || result.isEmpty()) {
            return station.getStationName();
        }
        return Encode.forHtml((String)result);
    }

    public static String getViewDisplayName(AgentInfo viewInfo, WebOp op) {
        return viewInfo.getDisplayName((Context)op);
    }

    public static void writeApplet(UserAgent ua, HttpServletRequest request, HttpServletResponse response, HtmlWriter out, String width, String height, String ord, String locale, String profile, String userName, BWebService service, BWebProfileConfig profileConfig, String[] extraParams) throws IOException {
        boolean licensed = false;
        try {
            Feature feature = service.getLicenseFeature();
            licensed = feature.getb("ui.wb", false);
        }
        catch (FeatureNotLicensedException feature) {
            // empty catch block
        }
        if (!licensed) {
            response.sendError(403);
            return;
        }
        if (ua != null && ua.isNiagaraWebLauncher()) {
            WbServlet.writeAppletForWebStart(out, width, height, ord, locale, profile, userName, service, profileConfig, extraParams);
        } else {
            Lexicon lex = Lexicon.make((String)"web", (String)locale);
            String text = lex.getText("webstart.webLauncherOnly");
            out.write("<div style=\"font-family: sans-serif; margin: 15px;\">" + text + "</div>");
        }
    }

    public static String embedApplet(WebOp op, String quoteCharacter, String appletDivId, String width, String height, String ord, String profile, String[] extraParams) throws IOException {
        HttpServletResponse response = op.getResponse();
        BWebService service = (BWebService)Sys.getService((Type)BWebService.TYPE);
        UserAgent userAgent = op.getUserAgent();
        boolean licensed = false;
        try {
            Feature feature = service.getLicenseFeature();
            licensed = feature.getb("ui.wb", false);
        }
        catch (FeatureNotLicensedException featureNotLicensedException) {
            // empty catch block
        }
        if (!licensed) {
            response.sendError(403);
            return "";
        }
        if (!WbServlet.isWebStartClient(userAgent)) {
            return WbServlet.embedAppletForPlugin(op, width, height, ord, profile, extraParams);
        }
        return WbServlet.embedAppletForWebStart(op, quoteCharacter, appletDivId, width, height, ord, profile, extraParams);
    }

    private static boolean isWebStartClient(UserAgent ua) {
        if (ua == null) {
            return false;
        }
        if (ua.isNiagara4WebStart() || ua.isNiagaraAxWebStart()) {
            return true;
        }
        String s = ua.toString();
        return s != null && s.toLowerCase().contains("javafx");
    }

    private static String embedAppletForPlugin(WebOp op, String width, String height, String ord, String profile, String[] extraParams) {
        BWebService service = op.getService();
        String sessionID = op.getRequest().getSession().getId();
        Cookie token = CookieUtil.createCookie("NTOKEN", SessionManager.makeNtoken((String)sessionID), -1);
        token.setHttpOnly(false);
        op.getResponse().addCookie(token);
        StringBuilder b = new StringBuilder();
        try {
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"<!--@noSnoop-->");
            String style = "";
            style = width.equals("0px") || height.equals("0px") ? "display:none;" : "'width:" + width + "; height:" + height + ";'";
            out.w((Object)"<iframe id='embedAppletFrame' ").attr("style", style).w((Object)" src='about:blank'></iframe>");
            out.w((Object)"<div style='display: none;' id='embedApplet'>");
            WbServlet.writeApplet(op.getUserAgent(), op.getRequest(), op.getResponse(), out, width, height, ord, op.getLanguage(), profile, op.getUser().getUsername(), service, op.getProfileConfig(), extraParams);
            out.w((Object)"</div>");
            b.append("var embedAppletDiv = document.getElementById('embedApplet'),");
            b.append("    iframe = document.getElementById('embedAppletFrame');");
            b.append("iframe.contentWindow.contents = embedAppletDiv.innerHTML;");
            b.append("iframe.src = 'javascript:window.contents';");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return b.toString();
    }

    protected static String quote(String str) {
        return quote + str + quote;
    }

    private static Map<String, String> getAppletParamMap(String ord, String locale, String profile, String userName, BWebService service, BWebProfileConfig profileConfig, String[] extraParams) throws IOException {
        String logo;
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("ord", ord);
        params.put("profile", profile);
        params.put("locale", locale);
        params.put("user", userName);
        if (extraParams != null) {
            Arrays.stream(extraParams).map(s -> s.split(":")).filter(array -> ((String[])array).length >= 2).forEach(array -> params.put(array[0], array[1]));
        }
        if ((logo = WebUtil.getLogo(service)) != null) {
            params.put("logo", "/ord/" + logo);
        }
        if (profileConfig != null) {
            for (Property p : profileConfig.getDynamicPropertiesArray()) {
                BValue val = profileConfig.get(p);
                if (!(val instanceof BSimple)) continue;
                params.put(p.getName(), val.asSimple().encodeToString());
            }
        }
        return params;
    }

    static boolean hasLocalJxJars() {
        Collection<ManagedFile> files = WbServlet.getExtFiles();
        return files.stream().map(extFile -> jxBrowserJarPattern.matcher(extFile.getFileName())).filter(Matcher::matches).map(matcher -> matcher.group(2)).findFirst().isPresent();
    }

    public static Collection<ManagedFile> getExtFiles() {
        return AccessController.doPrivileged(() -> ((DefaultBootEnv)Nre.bootEnv).getModulesFileManager().getExtFiles());
    }

    static List<String> getJarDependencies() {
        ArrayList<String> jars = new ArrayList<String>();
        jars.add("/wb/wbapplet-" + BModule.getClassVersion(WbServlet.class) + ".jar");
        jars.add("/wb/module/baja-" + Sys.getRegistry().getModule("baja", RuntimeProfile.rt).getVendorVersion() + ".jar");
        Collection<ManagedFile> files = WbServlet.getExtFiles();
        files.stream().filter(extFile -> !extFile.getFileName().startsWith("niagarad")).filter(extFile -> !extFile.getParentPath().endsWith("/jxbrowser")).filter(extFile -> !extFile.getParentPath().endsWith("/bcfips")).forEach(extFile -> {
            if (extFile instanceof ManagedModuleFile) {
                ManagedModuleFile moduleFile = (ManagedModuleFile)extFile;
                jars.add("/wb/" + moduleFile.getParentPath() + '/' + moduleFile.getModulePartName() + '-' + moduleFile.getVendorVersion() + ".jar");
            } else {
                jars.add("/wb/" + extFile.getParentPath() + '/' + extFile.getFileName());
            }
        });
        return jars;
    }

    private static Map<String, String> getWebStartAppletParamMap(String ord, String locale, String profile, String userName, BWebService service, BWebProfileConfig profileConfig, String[] extraParams) throws IOException {
        Map<String, String> params = WbServlet.getAppletParamMap(ord, locale, profile, userName, service, profileConfig, extraParams);
        if (profile != null) {
            TypeInfo userProfileType = profileConfig.getTypeSpec().getTypeInfo();
            params.put("webstart_user_wb_profile", String.valueOf(WbServlet.userHasWorkbenchProfile(userProfileType)));
        }
        return params;
    }

    private static void writeAppletForWebStart(HtmlWriter out, String width, String height, String ord, String locale, String profile, String userName, BWebService service, BWebProfileConfig profileConfig, String[] extraParams) throws IOException {
        Map<String, String> params = WbServlet.getWebStartAppletParamMap(ord, locale, profile, userName, service, profileConfig, extraParams);
        out.w((Object)"<div id='applet'>\n  <script type='text/javascript'>\n");
        out.w((Object)"    window.niagaraWebstart = window.niagaraWebstart || {};\n    window.niagaraWebstart.appletDesc = {      ver: 'N4',\n      code: 'WbApplet.class',\n      id: 'niagaraApplet',\n      width: '").safe((Object)width).w((Object)"',\n      height: '").safe((Object)height).w((Object)"',\n      params: {},\n    };\n");
        params.forEach((key, value) -> out.w((Object)"    window.niagaraWebstart.appletDesc.params['").safe(key).w((Object)"'] = '").safe(value).w((Object)"';\n"));
        out.w((Object)"  </script>\n</div>");
    }

    private static void getWebstartExtJarNames(HttpServletResponse resp) throws IOException {
        resp.setContentType("text/plain");
        List<String> jars = WbServlet.getJarDependencies();
        try (PrintWriter out = resp.getWriter();){
            jars.stream().filter(s -> !s.contains("wbapplet")).forEach(out::println);
        }
    }

    private static boolean userHasWorkbenchProfile(TypeInfo profileType) {
        for (TypeInfo t = profileType; t != null; t = t.getSuperType()) {
            if (!"WbWebProfile".equals(t.getTypeName())) continue;
            return true;
        }
        return false;
    }

    void downloadWebStartLex(HttpServletRequest req, HttpServletResponse resp, Locale locale) throws IOException {
        resp.setContentType("text/plain");
        resp.setCharacterEncoding("ISO-8859-1");
        Properties props = new Properties();
        Lexicon bajaui = Lexicon.make((String)"bajaui", (Locale)locale);
        Lexicon web = Lexicon.make((String)"web", (Locale)locale);
        try (ServletOutputStream out = resp.getOutputStream();){
            props.setProperty("lexCancel", bajaui.get("dialog.cancel", "Cancel"));
            props.setProperty("lexDownloadTitle", web.get("webStart.app.downloadTitle", "Download"));
            props.setProperty("lexDownloadMsg", web.get("webstart.app.downloadingFile", "Downloading file: {0}"));
            props.setProperty("lexFileReplaceMsg", bajaui.get("file.replace.one", "Replace file \"{0}\"?"));
            props.setProperty("lexFileReplaceTitle", bajaui.get("file.replace.title", "Confirm File Replace"));
            props.store((OutputStream)out, "");
        }
    }

    private static String embedAppletForWebStart(WebOp op, String quoteCharacter, String appletDivId, String width, String height, String ord, String profile, String[] extraParams) throws IOException {
        String oldQuote = quote;
        quote = quoteCharacter != null ? quoteCharacter : oldQuote;
        String locale = op.getLanguage();
        String userName = op.getUser().getUsername();
        BWebService service = op.getService();
        BWebProfileConfig profileConfig = op.getProfileConfig();
        Map<String, String> params = WbServlet.getWebStartAppletParamMap(ord, locale, profile, userName, service, profileConfig, extraParams);
        StringWriter sw = new StringWriter();
        HtmlWriter out = new HtmlWriter((Writer)sw);
        out.w((Object)("var s = document.createElement(" + WbServlet.quote("script") + ");")).w((Object)("s.type = " + WbServlet.quote("text/javascript") + ';')).w((Object)("s.src = " + WbServlet.quote(EMBED_WEB_START_APPLET_SCRIPT) + ';')).w((Object)("s.appletDivId = " + WbServlet.quote(appletDivId) + ';')).w((Object)"s.appletWidth = ").w((Object)quote).safe((Object)width).w((Object)quote).w((Object)";").w((Object)"s.appletHeight = ").w((Object)quote).safe((Object)height).w((Object)quote).w((Object)";").w((Object)"s.appletParams = {};");
        params.forEach((key, value) -> out.w((Object)"s.appletParams[").w((Object)quote).safe(key).w((Object)quote).w((Object)"] = ").w((Object)quote).safe(value).w((Object)quote).w((Object)";\n"));
        out.w((Object)("document.querySelector(" + WbServlet.quote("head") + ").appendChild(s);"));
        quote = oldQuote;
        return sw.toString();
    }

    private static BWebService getWebService() {
        try {
            return (BWebService)Sys.getService((Type)BWebService.TYPE);
        }
        catch (ServiceNotFoundException svcEx) {
            log.log(Level.SEVERE, "WebService not found", svcEx);
            return null;
        }
    }
}

