/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web.servlets;

import com.tridium.authn.BAuthenticationService;
import com.tridium.web.CookieUtil;
import com.tridium.web.servlets.LoginSupport;
import java.io.IOException;
import java.util.logging.Level;
import javax.baja.authn.BAuthenticationScheme;
import javax.baja.authn.BSSOAuthenticationScheme;
import javax.baja.web.BLoginTemplate;
import javax.baja.web.BWebService;
import javax.baja.web.servlets.UnauthenticatedServlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class LoginServlet
extends UnauthenticatedServlet {
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleLoginRequest(request, response, null);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (LoginSupport.handleSSOPost(request, response)) {
            return;
        }
        LoginSupport.handleUsernameAndSchemeCookies(request, response);
        String username = request.getParameter("j_username");
        this.handleLoginRequest(request, response, username);
    }

    private void handleLoginRequest(HttpServletRequest request, HttpServletResponse response, String username) throws IOException, ServletException {
        if (LoginSupport.hasAuthenticatedSession(request)) {
            response.sendRedirect("/");
            return;
        }
        LoginSupport.handleUsernameCookie(request, response);
        LoginSupport.handleSchemeCookie(request, response);
        if (username == null) {
            username = LoginSupport.getRequestedUsername(request);
        }
        BAuthenticationService service = BAuthenticationService.getService();
        boolean autoSSO = service.getSsoConfiguration().getAutoAttemptSingleSignOn();
        String originURI = LoginSupport.getOriginUri(request);
        boolean loginUri = LoginSupport.isLoginURI(originURI);
        boolean ignoreAutoSSO = service.getSsoConfiguration().getIgnoreAutoSSOIfUserCookiePresent();
        boolean failedAuth = false;
        String query = request.getQueryString();
        if (query != null && query.contains("auth=fail")) {
            failedAuth = true;
        }
        if (username == null && (!autoSSO || loginUri)) {
            response.sendRedirect("/prelogin" + (query != null ? '?' + query : ""));
            return;
        }
        if (!(failedAuth || !autoSSO || loginUri || username != null && ignoreAutoSSO)) {
            BAuthenticationScheme[] ssoSchemes = (BAuthenticationScheme[])service.getSupportedSchemes().stream().filter(scheme -> scheme instanceof BSSOAuthenticationScheme).toArray(BAuthenticationScheme[]::new);
            if (ssoSchemes.length != 1) {
                response.sendError(400, "Server configuration error. AutoSSO only permitted with one SSO scheme.");
                return;
            }
            response.addCookie(CookieUtil.createCookie("niagara_current_sso_scheme", ssoSchemes[0].getName(), -1));
            response.sendRedirect(((BSSOAuthenticationScheme)ssoSchemes[0]).getLoginRedirectURL());
            return;
        }
        if (LoginSupport.handleSSOCookie(request, response)) {
            return;
        }
        try {
            if (username != null) {
                if (!BWebService.getMainService().getRememberUserIdCookie()) {
                    response.addCookie(CookieUtil.createEncryptedCookie("niagara_essential_session_support", username, -1));
                }
                response.setContentType("text/html; charset=utf-8");
                BLoginTemplate.getLoginTemplate().write(request, response);
                LoginSupport.cleanup(request, response);
                return;
            }
        }
        catch (IOException e) {
            if (LoginSupport.log.isLoggable(Level.FINE)) {
                LoginSupport.log.log(Level.WARNING, "Could not create encrypted cookie", e);
            }
            LoginSupport.log.warning("Could not create encrypted cookie");
        }
        response.sendRedirect("/prelogin" + (failedAuth ? "?auth=fail" : ""));
    }
}

