/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web.servlets;

import com.tridium.file.util.LicenseGenerator;
import com.tridium.web.servlets.UnauthenticatedCache;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.baja.file.BIFile;
import javax.baja.file.BajaFileUtil;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.FileUtil;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.web.BLoginTemplate;
import javax.baja.web.servlets.UnauthenticatedServlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class LoginFileServlet
extends UnauthenticatedServlet {
    public static final String logo = "logo";
    public static final String loginCss = "loginCss";
    public static final String eula = "eula";
    public static final String thirdPartyLicenses = "thirdPartyLicenses";
    private static final String corePath = "/core";
    private static final String coreRc = "/com/tridium/nre/jetty/rc";

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String pathInfo = req.getPathInfo();
        String uri = req.getRequestURI();
        if (pathInfo == null) {
            resp.sendError(404);
            return;
        }
        try {
            if (pathInfo.equals("/")) {
                resp.sendRedirect("/login");
                return;
            }
            pathInfo = pathInfo.trim();
            UnauthenticatedCache.Content content = UnauthenticatedCache.getContent(uri);
            if (content == null) {
                try {
                    if (pathInfo.equals("/eula")) {
                        content = UnauthenticatedCache.storeContent(uri, LicenseGenerator.makeLicenseAgreement(), true);
                    } else if (pathInfo.equals("/thirdPartyLicenses")) {
                        content = UnauthenticatedCache.storeContent(uri, LicenseGenerator.makeThirdPartyLicenses(), true);
                    }
                }
                catch (Exception e) {
                    resp.sendError(403);
                    return;
                }
            }
            if (content == null && pathInfo.startsWith(corePath)) {
                try {
                    content = this.handleCoreResource(req, resp);
                    if (content == null) {
                        return;
                    }
                }
                catch (Exception e) {
                    resp.sendError(403);
                    return;
                }
            }
            if (content == null) {
                BOrd ord = BLoginTemplate.getLoginTemplate().resourceToOrd(pathInfo);
                if (!UnauthenticatedCache.allowOrd(ord)) {
                    resp.sendError(403);
                    return;
                }
                content = UnauthenticatedCache.storeContent(uri, ord);
            }
            if (content == null) {
                resp.sendError(403);
                return;
            }
            UnauthenticatedCache.send(resp, content);
        }
        catch (Exception e) {
            this.log(this.getServletName() + ": " + e.getMessage(), e);
            resp.sendError(403);
        }
    }

    private static Context getContext(HttpServletRequest req) {
        return new BasicContext(null, req.getLocale().toLanguageTag());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UnauthenticatedCache.Content handleCoreResource(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        String pathInfo = req.getPathInfo();
        String uri = req.getRequestURI();
        InputStream in = null;
        ByteArrayOutputStream out = null;
        try {
            if (pathInfo.endsWith("/")) {
                resp.sendError(403);
                UnauthenticatedCache.Content content = null;
                return content;
            }
            String resourceName = pathInfo.substring(pathInfo.lastIndexOf("/"));
            in = ((Object)((Object)this)).getClass().getResourceAsStream(coreRc + resourceName);
            if (in == null) {
                resp.sendError(403);
                UnauthenticatedCache.Content content = null;
                return content;
            }
            out = new ByteArrayOutputStream();
            TypeInfo type = Sys.getRegistry().getFileTypeForExtension(FileUtil.getExtension((String)resourceName));
            BIFile file = (BIFile)type.getInstance();
            resp.setContentType(file.getMimeType());
            BajaFileUtil.pipe((InputStream)in, (OutputStream)out);
            UnauthenticatedCache.Content content = UnauthenticatedCache.storeContent(uri, new UnauthenticatedCache.Content(out.toByteArray(), file.getMimeType()));
            return content;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
    }
}

