/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web.filters;

import java.io.IOException;
import java.util.regex.Pattern;
import javax.baja.util.Lexicon;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WebStartServletFilter
implements Filter {
    private static final Lexicon WEBLEX = Lexicon.make((String)"web");
    private static final Pattern NWL_URI_PATTERN = Pattern.compile("^/webstart/(nwl(_download|_redirect.*)?$|NiagaraWebLauncher(-x86)?.msi)$");
    private static final Pattern JXBROWSER_URI_PATTERN = Pattern.compile("^/webstart/(jxbrowser.*|webstartparams)$");
    private static final Pattern WB_URI_PATTERN = Pattern.compile("^/wb/(webstartextjars|module(cachinginfo|list|/baja.*)?$|bin.*|killntokens|policy|lexiconmodulelist|sysprops|readzip.*|logon|webstartlex)$");

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)servletRequest;
        HttpServletResponse resp = (HttpServletResponse)servletResponse;
        String uri = req.getRequestURI();
        if (uri != null && uri.startsWith("/webstart") && !NWL_URI_PATTERN.matcher(uri).matches() && !JXBROWSER_URI_PATTERN.matcher(uri).matches() || uri.startsWith("/wb") && !WB_URI_PATTERN.matcher(uri).matches()) {
            resp.sendError(403, WEBLEX.get("webstart.accessDenied.message"));
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    public void destroy() {
    }
}

