/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web.filters;

import java.io.IOException;
import java.net.URLEncoder;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.ViewQuery;
import javax.baja.sys.BObject;
import javax.baja.web.BWebServlet;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class WebServletRedirectFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        OrdTarget target = (OrdTarget)req.getAttribute("niagara.target");
        if (target == null) {
            req.getServletContext().log("No Target available");
            resp.sendError(404);
            return;
        }
        BObject obj = target.get();
        if (obj instanceof BWebServlet) {
            BWebServlet webServlet = (BWebServlet)obj;
            StringBuilder url = new StringBuilder();
            url.append("/").append(webServlet.getServletName());
            ViewQuery viewQuery = target.getViewQuery();
            if (viewQuery != null) {
                String viewId = viewQuery.getViewId();
                String[] paramNames = viewQuery.getParameterNames();
                if (paramNames.length > 0 || viewId != null) {
                    StringBuilder query = new StringBuilder();
                    if (viewId != null) {
                        query.append("viewid=").append(URLEncoder.encode(viewId, "UTF-8"));
                    }
                    for (String name : paramNames) {
                        if (query.length() > 0) {
                            query.append("&");
                        }
                        query.append(URLEncoder.encode(name, "UTF-8")).append("=").append(URLEncoder.encode(viewQuery.getParameter(name), "UTF-8"));
                    }
                    url.append("?").append((CharSequence)query);
                }
            }
            resp.sendRedirect(url.toString());
        } else {
            chain.doFilter((ServletRequest)req, (ServletResponse)resp);
        }
    }
}

