/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web.authn;

import com.tridium.authn.BDigestAuthenticationScheme;
import com.tridium.authn.ScramServerCallback;
import com.tridium.authn.UserKeyFactory;
import com.tridium.nre.auth.NiagaraStationAlgorithmBundle;
import com.tridium.nre.auth.ScramAlgorithmBundle;
import com.tridium.nre.auth.ScramServer;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.web.authn.AuthMessage;
import javax.baja.web.authn.BHttpHeaderCallbackHandler;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@NiagaraType(agent={@AgentOn(types={"baja:DigestAuthenticationScheme"})})
public class BHttpDigestCallbackHandler
extends BHttpHeaderCallbackHandler {
    @Generated
    public static final Type TYPE = Sys.loadType(BHttpDigestCallbackHandler.class);
    public static final int HELLO_STEP = 0;
    public static final int CLIENT_FIRST_STEP = 1;
    public static final int CLIENT_FINAL_STEP = 2;
    public static final int COMPLETE_STEP = 3;
    public static final String SCHEME_NAME = "SCRAM";
    public static final String HASH = "hash";
    public static final String DATA = "data";
    private final String hashAlgorithm = NiagaraStationAlgorithmBundle.getInstance().getMessageDigestAlgorithmName().toUpperCase();
    private int step = 0;
    private ScramServer.IUserKeyFactory keyFactory;
    private ScramServer scramServer;
    private String username;
    private Map<String, String> authInfoParameters = Collections.emptyMap();

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BHttpDigestCallbackHandler(ScramServer.IUserKeyFactory keyFactory) {
        this.keyFactory = keyFactory;
    }

    public BHttpDigestCallbackHandler() {
        this((ScramServer.IUserKeyFactory)new UserKeyFactory(BDigestAuthenticationScheme.TYPE));
    }

    @Override
    public int handleRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        int res;
        try {
            switch (this.step) {
                case 0: {
                    res = this.processHello(req, resp);
                    this.step = 1;
                    break;
                }
                case 1: {
                    res = this.processClientFirst(req, resp);
                    this.step = 2;
                    break;
                }
                case 2: {
                    res = this.processClientFinal(req, resp);
                    this.step = 3;
                    break;
                }
                default: {
                    res = 3;
                    break;
                }
            }
        }
        catch (IllegalArgumentException e) {
            res = 3;
        }
        return res;
    }

    private int processHello(HttpServletRequest req, HttpServletResponse resp) {
        AuthMessage message = AuthMessage.decodeFromString(req.getHeader("Authorization"));
        this.username = new String(Base64.getUrlDecoder().decode(message.getParameter("username").getBytes()), StandardCharsets.UTF_8);
        AuthMessage respMessage = new AuthMessage();
        respMessage.setScheme(SCHEME_NAME);
        respMessage.setParameter(HASH, this.hashAlgorithm);
        resp.setHeader("WWW-Authenticate", respMessage.encodeToString());
        resp.setStatus(401);
        return 1;
    }

    private int processClientFirst(HttpServletRequest req, HttpServletResponse resp) {
        this.scramServer = new ScramServer((ScramAlgorithmBundle)NiagaraStationAlgorithmBundle.getInstance(), this.keyFactory);
        AuthMessage message = AuthMessage.decodeFromString(req.getHeader("Authorization"));
        String clientFirst = new String(Base64.getUrlDecoder().decode(message.getParameter(DATA).getBytes()));
        String serverFirst = this.scramServer.createServerFirstMessage(clientFirst);
        AuthMessage respMessage = new AuthMessage();
        respMessage.setScheme(SCHEME_NAME);
        respMessage.setParameter(HASH, this.hashAlgorithm);
        respMessage.setParameter(DATA, Base64.getUrlEncoder().withoutPadding().encodeToString(serverFirst.getBytes()));
        resp.setHeader("WWW-Authenticate", respMessage.encodeToString());
        resp.setStatus(401);
        return 1;
    }

    private int processClientFinal(HttpServletRequest req, HttpServletResponse resp) {
        AuthMessage message = AuthMessage.decodeFromString(req.getHeader("Authorization"));
        String clientFinal = new String(Base64.getUrlDecoder().decode(message.getParameter(DATA).getBytes()));
        try {
            String serverFinal = this.scramServer.createServerFinalMessage(clientFinal);
            this.authInfoParameters = new HashMap<String, String>(2);
            this.authInfoParameters.put(HASH, this.hashAlgorithm);
            this.authInfoParameters.put(DATA, Base64.getUrlEncoder().withoutPadding().encodeToString(serverFinal.getBytes()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        resp.setStatus(200);
        return 0;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (!(callback instanceof ScramServerCallback)) {
                throw new UnsupportedCallbackException(callback, "Callback " + callback.getClass().getName() + " is not supported.");
            }
            ((ScramServerCallback)callback).setServer(this.scramServer);
            ((ScramServerCallback)callback).setUsername(this.username);
        }
    }

    @Override
    public Map<String, String> getAuthInfoParameters() {
        return this.authInfoParameters;
    }
}

