/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web;

import com.tridium.nre.security.NiagaraBasicPermission;
import com.tridium.nre.security.SecretChars;
import com.tridium.web.BAdditionalHttpsCert;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Permission;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BCertificateAliasAndPassword;
import javax.baja.security.BPassword;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.IllegalParentException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BIRestrictedComponent;
import javax.baja.util.LexiconModule;
import javax.baja.web.BWebService;

@NiagaraType
@NiagaraProperty(name="hasWarnings", type="boolean", defaultValue="false", flags=7)
@NiagaraAction(name="addCert")
public class BAdditionalHttpsCerts
extends BComponent
implements BIRestrictedComponent {
    @Generated
    public static final Property hasWarnings = BAdditionalHttpsCerts.newProperty((int)7, (boolean)false, null);
    @Generated
    public static final Action addCert = BAdditionalHttpsCerts.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAdditionalHttpsCerts.class);
    private static final BIcon ICON = BIcon.std((String)"objectFolder.png");
    private static final Logger LOGGER = Logger.getLogger("web");
    private static final LexiconModule LEXICON = LexiconModule.make((String)"web");

    @Generated
    public boolean getHasWarnings() {
        return this.getBoolean(hasWarnings);
    }

    @Generated
    public void setHasWarnings(boolean v) {
        this.setBoolean(hasWarnings, v, null);
    }

    @Generated
    public void addCert() {
        this.invoke(addCert, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public Map<String, SecretChars> getCertAliases() {
        NiagaraBasicPermission permission = new NiagaraBasicPermission("CERT_MANAGEMENT");
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission((Permission)permission);
        }
        HashMap<String, SecretChars> certAliases = new HashMap<String, SecretChars>();
        BCertificateAliasAndPassword aliasAndPassword = ((BWebService)this.getParent()).getMainCertAliasAndPassword();
        if (!aliasAndPassword.getAlias().isEmpty()) {
            SecretChars password = null;
            if (aliasAndPassword.getPassword() != null && !aliasAndPassword.getPassword().isDefault()) {
                password = AccessController.doPrivileged(() -> ((BPassword)aliasAndPassword.getPassword()).getSecretChars());
            }
            certAliases.put(aliasAndPassword.getAlias(), password);
        }
        for (BAdditionalHttpsCert cert : (BAdditionalHttpsCert[])this.getChildren(BAdditionalHttpsCert.class)) {
            String alias = cert.getCertAliasAndPassword().getAlias();
            SecretChars password = null;
            if (cert.getCertAliasAndPassword().getPassword() != null && !cert.getCertAliasAndPassword().getPassword().isDefault()) {
                password = AccessController.doPrivileged(() -> ((BPassword)cert.getCertAliasAndPassword().getPassword()).getSecretChars());
            }
            if (certAliases.containsKey(alias)) {
                cert.setIsDuplicate(true);
                continue;
            }
            cert.setIsDuplicate(false);
            certAliases.put(alias, password);
        }
        return certAliases;
    }

    public boolean hasNonEmptyAliases() {
        for (BAdditionalHttpsCert cert : (BAdditionalHttpsCert[])this.getChildren(BAdditionalHttpsCert.class)) {
            if (cert.getCertAliasAndPassword().getAlias().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public void updateSniStatus(KeyStore sniKeyStore) {
        List keyStoreAliases = Collections.emptyList();
        if (sniKeyStore != null) {
            try {
                keyStoreAliases = Collections.list(sniKeyStore.aliases());
            }
            catch (KeyStoreException e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.WARNING, "Could not determine status of rejected or duplicated SNI aliases (" + e.getLocalizedMessage() + ").", e);
                } else {
                    LOGGER.warning("Could not determine status of rejected or duplicated SNI aliases (" + e.getLocalizedMessage() + ").");
                }
                this.clearRejectedStatus();
                return;
            }
        }
        boolean hasWarning = false;
        BAdditionalHttpsCert[] bAdditionalHttpsCertArray = (BAdditionalHttpsCert[])this.getChildren(BAdditionalHttpsCert.class);
        int n = bAdditionalHttpsCertArray.length;
        for (int i = 0; i < n; ++i) {
            BAdditionalHttpsCert additionalCert;
            String alias = (additionalCert = bAdditionalHttpsCertArray[i]).getCertAliasAndPassword().getAlias();
            additionalCert.setIsRejected(!alias.isEmpty() && !keyStoreAliases.contains(alias));
            hasWarning |= additionalCert.getIsDuplicate() || additionalCert.getIsRejected();
        }
        this.setHasWarnings(hasWarning);
    }

    private void clearRejectedStatus() {
        boolean hasWarning = false;
        for (BAdditionalHttpsCert additionalCert : (BAdditionalHttpsCert[])this.getChildren(BAdditionalHttpsCert.class)) {
            additionalCert.setIsRejected(false);
            hasWarning |= additionalCert.getIsDuplicate();
        }
        this.setHasWarnings(hasWarning);
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BWebService;
    }

    public boolean isChildLegal(BComponent child) {
        return child instanceof BAdditionalHttpsCert;
    }

    public void added(Property property, Context context) {
        String alias;
        if (!this.isRunning()) {
            return;
        }
        if (property.getType().is(BAdditionalHttpsCert.TYPE) && !(alias = ((BAdditionalHttpsCert)this.get(property)).getCertAliasAndPassword().getAlias()).isEmpty()) {
            Map certAliases = AccessController.doPrivileged(() -> this.getCertAliases());
            ((BComponent)this.getParent()).changed(this.getPropertyInParent(), context);
            for (SecretChars certPassword : certAliases.values()) {
                if (certPassword == null) continue;
                certPassword.close();
            }
        }
    }

    public void removed(Property property, BValue oldValue, Context context) {
        String alias;
        if (!this.isRunning()) {
            return;
        }
        if (property.getType().is(BAdditionalHttpsCert.TYPE) && !(alias = ((BAdditionalHttpsCert)oldValue).getCertAliasAndPassword().getAlias()).isEmpty()) {
            Map certAliases = AccessController.doPrivileged(() -> this.getCertAliases());
            ((BComponent)this.getParent()).changed(this.getPropertyInParent(), context);
            for (SecretChars certPassword : certAliases.values()) {
                if (certPassword == null) continue;
                certPassword.close();
            }
        }
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property.getType().is(BAdditionalHttpsCert.TYPE)) {
            Map certAliases = AccessController.doPrivileged(() -> this.getCertAliases());
            ((BComponent)this.getParent()).changed(this.getPropertyInParent(), context);
            for (SecretChars certPassword : certAliases.values()) {
                if (certPassword == null) continue;
                certPassword.close();
            }
        }
    }

    public final String toString(Context context) {
        return super.toString(context) + (this.getHasWarnings() ? " (" + LEXICON.getText("webService.additionalCerts.hasWarnings", context) + ')' : "");
    }

    public BIcon getIcon() {
        return ICON;
    }

    public final void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        if (!parent.getType().is(BWebService.TYPE)) {
            throw new IllegalParentException("baja", "IllegalParentException.parentAndChild", new Object[]{parent.getType(), this.getType()});
        }
        BIRestrictedComponent.checkForDuplicates((BComponent)parent, (BIRestrictedComponent)this, (boolean)false);
    }

    public void doAddCert() {
        this.add("Cert1?", (BValue)BAdditionalHttpsCert.make(BString.DEFAULT.toString()));
    }
}

