/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.ldapDriver.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.StringTokenizer;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.IllegalNameException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public final class BObjectClassList
extends BSimple {
    public static final BObjectClassList NULL;
    public static final BObjectClassList DEFAULT;
    public static final Type TYPE;
    private String string;
    private String[] names;
    private int hashCode = -1;
    private HashSet<String> nameSet;

    public Type getType() {
        return TYPE;
    }

    public static BObjectClassList make(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Object class list cannot be empty.");
        }
        HashSet<String> nameSet = new HashSet<String>();
        nameSet.add(name);
        return BObjectClassList.make(nameSet);
    }

    public static BObjectClassList make(HashSet<String> nameSet) {
        if (nameSet == null || nameSet.size() == 0) {
            throw new IllegalArgumentException("Object class list cannot be empty.");
        }
        HashSet clonedNamedSet = (HashSet)nameSet.clone();
        return (BObjectClassList)new BObjectClassList(clonedNamedSet).intern();
    }

    public static BObjectClassList make(BObjectClassList orig, String name) {
        HashSet set = (HashSet)orig.nameSet.clone();
        set.add(name);
        return (BObjectClassList)new BObjectClassList(set).intern();
    }

    public static BObjectClassList remove(BObjectClassList orig, String name) {
        HashSet set = (HashSet)orig.nameSet.clone();
        set.remove(name);
        return (BObjectClassList)new BObjectClassList(set).intern();
    }

    private BObjectClassList(HashSet<String> nameSet) {
        this.nameSet = nameSet;
    }

    public String[] getNames() {
        return this.nameSet.toArray(new String[this.nameSet.size()]);
    }

    public boolean contains(String name) {
        return this.nameSet.contains(name);
    }

    public boolean isNull() {
        return this.nameSet.size() == 0;
    }

    public int hashCode() {
        try {
            if (this.hashCode == -1) {
                this.hashCode = this.encodeToString().hashCode();
            }
            return this.hashCode;
        }
        catch (Exception e) {
            return System.identityHashCode((Object)this);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof BObjectClassList) {
            BObjectClassList x = (BObjectClassList)((Object)obj);
            if (this.nameSet.size() != x.nameSet.size()) {
                return false;
            }
            for (String name : this.nameSet) {
                if (x.contains(name)) continue;
                return false;
            }
        }
        return true;
    }

    public String toString(Context context) {
        return this.encodeToString();
    }

    public void encode(DataOutput out) throws IOException {
        out.writeUTF(this.encodeToString());
    }

    public BObject decode(DataInput in) throws IOException {
        return this.decodeFromString(in.readUTF());
    }

    public String encodeToString() {
        if (this.string == null) {
            StringBuffer s = new StringBuffer();
            String[] namesArray = this.nameSet.toArray(new String[this.nameSet.size()]);
            for (int i = 0; i < namesArray.length; ++i) {
                if (i > 0) {
                    s.append(';');
                }
                s.append(namesArray[i]);
            }
            this.string = s.toString();
        }
        return this.string;
    }

    public BObject decodeFromString(String s) throws IOException {
        try {
            ArrayList<String> v = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(s, ";");
            while (st.hasMoreTokens()) {
                String name = st.nextToken().trim();
                SlotPath.verifyValidName((String)name);
                v.add(name);
            }
            BObjectClassList list = (BObjectClassList)new BObjectClassList(new HashSet<String>(v)).intern();
            list.string = s;
            return list;
        }
        catch (IllegalNameException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("Invalid BObjectClassList: " + s);
        }
    }

    static {
        DEFAULT = NULL = new BObjectClassList(new HashSet<String>());
        TYPE = Sys.loadType(BObjectClassList.class);
    }
}

