/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.ldapDriver.callbacks;

import com.tridiumx.ldapDriver.BLdapServer;
import com.tridiumx.ldapDriver.callbacks.LdapConnectionCallback;
import com.tridiumx.ldapDriver.callbacks.LdapServerChangeObserver;
import com.tridiumx.ldapDriver.callbacks.PersistentSearchControlObserver;
import com.tridiumx.ldapDriver.callbacks.PollingBasedObserver;
import javax.naming.NamingException;

public class LdapChangeRegistrationCallback
extends LdapConnectionCallback {
    private LdapServerChangeObserver observer;

    public LdapChangeRegistrationCallback(BLdapServer server) {
        super(server);
        server.setRegistrationCallback(this);
    }

    @Override
    public String getName() {
        return "changeRegistration";
    }

    @Override
    public void invoke() throws NamingException {
        this.observer = null;
        boolean supportsPersistentControl = false;
        this.observer = supportsPersistentControl ? PersistentSearchControlObserver.getInstance(this.server) : PollingBasedObserver.getInstance(this.server);
        this.observer.unregister();
        this.observer.setKeepRunning(true);
        this.observer.register();
    }

    @Override
    public void cleanUp() throws NamingException {
        if (this.observer != null) {
            this.observer.unregister();
        }
    }
}

