/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.ldapDriver.attributes;

import com.tridium.ndriver.discover.BINDiscoveryHost;
import com.tridium.ndriver.discover.BINDiscoveryObject;
import com.tridium.ndriver.discover.BNDiscoveryPreferences;
import com.tridiumx.ldapDriver.BLdapEntryDeviceExt;
import com.tridiumx.ldapDriver.BLdapServer;
import com.tridiumx.ldapDriver.attributes.BDiscoverableClassDefContainer;
import com.tridiumx.ldapDriver.attributes.BLdapAttribute;
import com.tridiumx.ldapDriver.attributes.BLdapAttributesDiscoveryLeaf;
import com.tridiumx.ldapDriver.attributes.BLdapAttributesDiscoveryPreferences;
import com.tridiumx.ldapDriver.attributes.BLdapAttributesFolder;
import com.tridiumx.ldapDriver.util.BObjectClassList;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.driver.BIDeviceFolder;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="discoveryPreferences", type="BNDiscoveryPreferences", defaultValue="new BLdapAttributesDiscoveryPreferences()"), @NiagaraProperty(name="objectClassList", type="BDiscoverableClassDefContainer", defaultValue="new BDiscoverableClassDefContainer()"), @NiagaraProperty(name="groupAttribute", type="String", defaultValue=""), @NiagaraProperty(name="mandatoryAttributes", type="String", defaultValue="", flags=4)})
public class BLdapAttributesDeviceExt
extends BLdapEntryDeviceExt
implements BINDiscoveryHost,
BIDeviceFolder {
    public static final Property discoveryPreferences = BLdapAttributesDeviceExt.newProperty((int)0, (BValue)new BLdapAttributesDiscoveryPreferences(), null);
    public static final Property objectClassList = BLdapAttributesDeviceExt.newProperty((int)0, (BValue)new BDiscoverableClassDefContainer(), null);
    public static final Property groupAttribute = BLdapAttributesDeviceExt.newProperty((int)0, (String)"", null);
    public static final Property mandatoryAttributes = BLdapAttributesDeviceExt.newProperty((int)4, (String)"", null);
    public static final Type TYPE = Sys.loadType(BLdapAttributesDeviceExt.class);
    private static final String CLASS_DEFINITION_CONTEXT = "ClassDefinition/";
    private static final String ATTRIBUTE_DEFINITION_CONTEXT = "AttributeDefinition/";

    public BNDiscoveryPreferences getDiscoveryPreferences() {
        return (BNDiscoveryPreferences)this.get(discoveryPreferences);
    }

    @Override
    public void setDiscoveryPreferences(BNDiscoveryPreferences v) {
        this.set(discoveryPreferences, (BValue)v, null);
    }

    public BDiscoverableClassDefContainer getObjectClassList() {
        return (BDiscoverableClassDefContainer)this.get(objectClassList);
    }

    public void setObjectClassList(BDiscoverableClassDefContainer v) {
        this.set(objectClassList, (BValue)v, null);
    }

    public String getGroupAttribute() {
        return this.getString(groupAttribute);
    }

    public void setGroupAttribute(String v) {
        this.setString(groupAttribute, v, null);
    }

    public String getMandatoryAttributes() {
        return this.getString(mandatoryAttributes);
    }

    public void setMandatoryAttributes(String v) {
        this.setString(mandatoryAttributes, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BINDiscoveryObject[] getDiscoveryObjects(BNDiscoveryPreferences prefs) throws Exception {
        BLdapAttributesDiscoveryPreferences dp = (BLdapAttributesDiscoveryPreferences)prefs;
        BLdapAttribute[] attributes = this.getAttributeList(dp);
        BLdapAttributesDiscoveryLeaf[] discoveredObjects = new BLdapAttributesDiscoveryLeaf[attributes.length];
        ArrayList<String> attrList = new ArrayList<String>();
        for (int i = 0; i < attributes.length; ++i) {
            BLdapAttributesDiscoveryLeaf discoveredObject = new BLdapAttributesDiscoveryLeaf();
            discoveredObject.setAttrName(attributes[i].getAttrName());
            discoveredObject.setIsMandatory(attributes[i].getIsMandatory());
            discoveredObject.setParentClass(attributes[i].getParentClass());
            discoveredObject.setDataType(attributes[i].getDataType());
            discoveredObject.setDescription(attributes[i].getDescription());
            discoveredObjects[i] = discoveredObject;
            if (!attributes[i].getIsMandatory()) continue;
            attrList.add(attributes[i].getAttrName());
        }
        this.setMandatoryAttributes(this.getMandatoryAttributesList(attrList));
        return discoveredObjects;
    }

    public BLdapAttribute[] getAttributeList(BLdapAttributesDiscoveryPreferences prefs) throws NamingException {
        BObjectClassList objectClassList = prefs.getObjectClassList();
        return this.getAttributeList(objectClassList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BLdapAttribute[] getAttributeList(BObjectClassList objectClassList) throws NamingException {
        BLdapServer ldapServer = (BLdapServer)this.getParent();
        ArrayList<BLdapAttribute> attributeList = new ArrayList<BLdapAttribute>();
        try (DirContext ctx = null;){
            ctx = ldapServer.connect();
            if (ctx != null) {
                DirContext schemaCtx = ctx.getSchema("");
                ArrayList<String> evaluatedClasses = new ArrayList<String>();
                String[] objList = objectClassList.getNames();
                for (int i = 0; i < objList.length; ++i) {
                    String objClassName = objList[i];
                    if (objClassName == null || objClassName.length() <= 0) continue;
                    try {
                        this.getAttributeList(schemaCtx, objClassName, attributeList, evaluatedClasses);
                        continue;
                    }
                    catch (NamingException ex) {
                        Logger.getLogger("ldapDriver.AttributeDiscovery").log(Level.WARNING, "Error retrieving attributes for Object Class : " + objClassName, ex);
                    }
                }
            }
        }
        BLdapAttribute[] list = attributeList.toArray(new BLdapAttribute[attributeList.size()]);
        return list;
    }

    private void getAttributeList(DirContext schemaCtx, String objClassName, List<BLdapAttribute> ldapAttrList, List<String> evaluatedClasses) throws NamingException {
        BLdapAttribute ldap_attr;
        NamingEnumeration<?> ne;
        if (evaluatedClasses.contains(objClassName)) {
            return;
        }
        evaluatedClasses.add(objClassName);
        DirContext objClassSchemaCtx = (DirContext)schemaCtx.lookup(CLASS_DEFINITION_CONTEXT + objClassName);
        Attributes attrList = objClassSchemaCtx.getAttributes("", new String[]{"SUP", "MUST", "MAY"});
        Attribute attr_SUP = attrList.get("SUP");
        Attribute attr_MUST = attrList.get("MUST");
        Attribute attr_MAY = attrList.get("MAY");
        if (attr_MUST != null) {
            ne = attr_MUST.getAll();
            while (ne.hasMore()) {
                ldap_attr = this.makeLdapAttribute(schemaCtx, ne, objClassName, true);
                ldapAttrList.add(ldap_attr);
            }
        }
        if (attr_MAY != null) {
            ne = attr_MAY.getAll();
            while (ne.hasMore()) {
                ldap_attr = this.makeLdapAttribute(schemaCtx, ne, objClassName, false);
                ldapAttrList.add(ldap_attr);
            }
        }
        if (this.hasSuperClass(attr_SUP)) {
            this.getAttributeList(schemaCtx, (String)attr_SUP.get(), ldapAttrList, evaluatedClasses);
        }
    }

    private boolean hasSuperClass(Attribute attr_SUP) throws NamingException {
        return attr_SUP != null && !"".equals(attr_SUP) && !"top".equalsIgnoreCase((String)attr_SUP.get());
    }

    private BLdapAttribute makeLdapAttribute(DirContext schemaCtx, NamingEnumeration<?> ne, String parentTag, boolean isMandatory) throws NamingException {
        String a = (String)ne.next();
        DirContext attrClassSchemaCtx = (DirContext)schemaCtx.lookup(ATTRIBUTE_DEFINITION_CONTEXT + a);
        Attributes attr = attrClassSchemaCtx.getAttributes("", new String[]{"NAME", "DESC"});
        BLdapAttribute ldap_attr = new BLdapAttribute();
        ldap_attr.setAttrName((String)attr.get("NAME").get());
        if (attr.get("DESC") != null) {
            ldap_attr.setDescription((String)attr.get("DESC").get());
        }
        ldap_attr.setIsMandatory(isMandatory);
        ldap_attr.setParentClass(parentTag);
        return ldap_attr;
    }

    private String getMandatoryAttributesList(ArrayList<String> attrList) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < attrList.size(); ++i) {
            if (builder.length() > 0) {
                builder.append(";");
            }
            builder.append(attrList.get(i));
        }
        return builder.toString();
    }

    public Type getDeviceType() {
        return BLdapAttribute.TYPE;
    }

    public Type getDeviceFolderType() {
        return BLdapAttributesFolder.TYPE;
    }
}

