/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.edgeIo.discover;

import com.tridium.edgeIo.BEdgeIoNetwork;
import com.tridium.edgeIo.datatypes.BEdgeIoPointDiscoverParams;
import com.tridium.edgeIo.discover.JDescriptionFileReader;
import com.tridium.edgeIo.discover.JPoints;
import com.tridium.edgeIo.enums.BEdgeIoTypeEnum;
import com.tridium.edgeIo.point.BEdgeIoPointDeviceExt;
import com.tridium.platEdgeIo.BEdgeIoPlatformService;
import java.io.ByteArrayInputStream;
import java.nio.charset.Charset;
import javax.baja.job.BJob;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUnrestrictedFolder;

@NiagaraType
public class BEdgeIoPointDiscoverJob
extends BJob {
    @Generated
    public static final Type TYPE = Sys.loadType(BEdgeIoPointDiscoverJob.class);
    static final String pointDescriptor = "{ \"points\" : [    { \"type\" : \"UI\", \"idx\" : \"1-5\", \"ids\" : \"201-205\", \"modes\" : \"voltageInput, resistanceInput, pulseInput\" },    { \"type\" : \"AO\", \"idx\" : \"1-2\", \"ids\" : \"301-302\", \"modes\" : \"voltageOutput\" },    { \"type\" : \"DO\", \"idx\" : \"1-3\", \"ids\" : \"501-503\", \"modes\" : \"dryContactOutput\" } ]}";
    BEdgeIoNetwork net = null;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BEdgeIoPointDiscoverJob() {
    }

    public BEdgeIoPointDiscoverJob(BEdgeIoNetwork n) {
        this.net = n;
    }

    public void doRun(Context cx) throws Exception {
        BEdgeIoPointDeviceExt pntExt = this.net.getLocal().getPoints();
        BUnrestrictedFolder fldr = new BUnrestrictedFolder();
        JPoints[] jpts = this.getJPointArray();
        for (int i = 0; i < jpts.length; ++i) {
            BEdgeIoTypeEnum typ = jpts[i].getIoType();
            int[] idx = jpts[i].idx;
            int[] ids = jpts[i].ids;
            String modes = jpts[i].modes;
            for (int n = 0; n < ids.length; ++n) {
                BEdgeIoPointDiscoverParams pdp = new BEdgeIoPointDiscoverParams(typ, idx[n], ids[n], modes);
                fldr.add("d?", (BValue)pdp);
            }
        }
        pntExt.fireDiscoveredPoints(fldr);
        this.success();
    }

    public void doCancel(Context cx) throws Exception {
    }

    public JPoints[] getJPointArray() throws Exception {
        byte[] incoming;
        BEdgeIoPlatformService service = (BEdgeIoPlatformService)Sys.getService((Type)BEdgeIoPlatformService.TYPE);
        try {
            incoming = service.pointDescriptionFileRead();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.net.getLocal().getLogger().warning("Failed to open point description file, open default!");
            incoming = pointDescriptor.getBytes(Charset.forName("UTF-8"));
        }
        return JDescriptionFileReader.parse(new ByteArrayInputStream(incoming));
    }
}

