/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.jx.browser;

import com.teamdev.jxbrowser.cookie.Cookie;
import com.teamdev.jxbrowser.navigation.Navigation;
import com.teamdev.jxbrowser.net.callback.InterceptUrlRequestCallback;
import com.teamdev.jxbrowser.os.Environment;
import com.tridium.jx.browser.BJxWebBrowserImpl;
import com.tridium.nre.platform.OperatingSystemEnum;
import com.tridium.web.BIWbWebFileChooserExtSupport;
import com.tridium.workbench.web.browser.BWebWidget;
import java.io.File;
import java.lang.reflect.Method;
import java.net.CookieStore;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import java.time.Duration;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.file.IFileFilter;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.registry.ModuleInfo;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.ui.BWidget;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.file.ExtFileFilter;

public final class WbJxBrowserUtil {
    private static final Pattern URL_PATTERN = Pattern.compile("((\\w+)(://))?([\\w-.]+)?(:(\\d+))?(.*)?");
    private static final Map<String, String> MODULE_NAMES = Collections.synchronizedMap(new HashMap());
    private static final String JX_BROWSER_7_17 = "7.17";
    public static final String LOADED_SCHEMA_VERSION = AccessController.doPrivileged(() -> {
        String version = System.getProperty("niagara.jxbrowser.schema.version");
        if (version == null) {
            version = "7.31";
            System.setProperty("niagara.jxbrowser.schema.version", version);
        }
        return version;
    });
    public static final String LOADED_JX_BROWSER_VERSION = AccessController.doPrivileged(() -> {
        String version = System.getProperty("niagara.jxbrowser.version");
        if (version == null) {
            version = "7.42.4";
            System.setProperty("niagara.jxbrowser.version", version);
        }
        return version;
    });
    public static final String LOADED_CHROMIUM_VERSION = AccessController.doPrivileged(() -> {
        String version = System.getProperty("niagara.jxbrowser.chromium.version");
        if (version == null) {
            version = "135.0.7049.52";
            System.setProperty("niagara.jxbrowser.chromium.version", version);
        }
        return version;
    });
    static String webLauncherLicense;
    static final String WEB_LAUNCHER_JX_BROWSER_LICENSE;

    private WbJxBrowserUtil() {
    }

    /*
     * Exception decompiling
     */
    public static InterceptUrlRequestCallback.Response loadModuleResource(InterceptUrlRequestCallback.Params params) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void removeCookie(Cookie cookie, com.teamdev.jxbrowser.cookie.CookieStore cookieStore) {
        if (BWebWidget.IS_WEB_LAUNCHER && JX_BROWSER_7_17.equals(LOADED_JX_BROWSER_VERSION)) {
            WbJxBrowserUtil.removeCookie_7_17(cookie, cookieStore);
        } else {
            WbJxBrowserUtil.removeCookie_7_18(cookie, cookieStore);
        }
    }

    private static void removeCookie_7_17(Cookie cookie, com.teamdev.jxbrowser.cookie.CookieStore cookieStore) {
        try {
            Method deleteMethod = CookieStore.class.getMethod("delete", Cookie.class);
            deleteMethod.invoke((Object)cookieStore, cookie);
        }
        catch (Exception e) {
            BJxWebBrowserImpl.log.log(Level.SEVERE, "Problem removing cookie via JxBrowser 7.17 api", e);
        }
    }

    private static void removeCookie_7_18(Cookie cookie, com.teamdev.jxbrowser.cookie.CookieStore cookieStore) {
        cookieStore.delete(cookie);
    }

    public static void addCookie(URI uri, String name, String value, String path, com.teamdev.jxbrowser.cookie.CookieStore cookieStore) {
        if (BWebWidget.IS_WEB_LAUNCHER && JX_BROWSER_7_17.equals(LOADED_JX_BROWSER_VERSION)) {
            WbJxBrowserUtil.addCookie_7_17(uri, name, value, path, cookieStore);
        } else {
            WbJxBrowserUtil.addCookie_7_18(uri, name, value, path, cookieStore);
        }
    }

    private static void addCookie_7_17(URI uri, String name, String value, String path, com.teamdev.jxbrowser.cookie.CookieStore cookieStore) {
        String uriStr = uri.toASCIIString();
        String domain = uri.getHost();
        try {
            Method putMethod = com.teamdev.jxbrowser.cookie.CookieStore.class.getMethod("put", String.class, Cookie.class);
            Method newBuilderMethod = Cookie.class.getMethod("newBuilder", new Class[0]);
            Cookie.Builder builder = (Cookie.Builder)newBuilderMethod.invoke(null, new Object[0]);
            Method domainMethod = Cookie.Builder.class.getMethod("domain", String.class);
            builder = (Cookie.Builder)domainMethod.invoke((Object)builder, domain);
            Cookie cookie = builder.name(name).value(value).path(path).secure(false).httpOnly(true).build();
            putMethod.invoke((Object)cookieStore, uriStr, cookie);
        }
        catch (Exception e) {
            BJxWebBrowserImpl.log.log(Level.SEVERE, "Problem adding cookie via JxBrowser 7.17 api", e);
        }
    }

    private static void addCookie_7_18(URI uri, String name, String value, String path, com.teamdev.jxbrowser.cookie.CookieStore cookieStore) {
        String domain = uri.getHost();
        cookieStore.set(Cookie.newBuilder((String)domain).name(name).value(value).path(path).secure(false).httpOnly(true).build());
    }

    public static BOrd getModuleOrd(String url) {
        OrdQuery[] ordQueries;
        String path = WbJxBrowserUtil.getUriPath(url);
        BOrd ord = path != null && path.startsWith("/module/") ? BOrd.make((String)path.replaceFirst("/module/", "module://")) : BOrd.make((String)url);
        for (OrdQuery ordQuery : ordQueries = ord.parse()) {
            FilePath filePath;
            String lowercaseModuleName;
            String moduleName;
            if (!"module".equals(ordQuery.getScheme()) || (moduleName = WbJxBrowserUtil.getModuleName(lowercaseModuleName = (filePath = (FilePath)ordQuery).getAuthority())).equals(lowercaseModuleName)) continue;
            url = url.replaceFirst(lowercaseModuleName, moduleName);
            ord = BOrd.make((String)url);
        }
        return ord;
    }

    private static String getModuleName(String lowercaseModuleName) {
        String result = MODULE_NAMES.get(lowercaseModuleName);
        if (result != null) {
            return result;
        }
        ModuleInfo[] moduleInfos = Sys.getRegistry().getModules();
        if (moduleInfos.length == MODULE_NAMES.size()) {
            return lowercaseModuleName;
        }
        for (ModuleInfo info : moduleInfos) {
            String moduleName = info.getModuleName();
            MODULE_NAMES.put(moduleName.toLowerCase(Locale.US), moduleName);
        }
        result = MODULE_NAMES.get(lowercaseModuleName);
        if (result != null) {
            return result;
        }
        return lowercaseModuleName;
    }

    private static String getUriPath(String uri) {
        Matcher m = URL_PATTERN.matcher(uri);
        if (!m.matches()) {
            return null;
        }
        String path = m.group(7);
        return path;
    }

    static synchronized String getLicenseKey() {
        if (WEB_LAUNCHER_JX_BROWSER_LICENSE == null) {
            return "4UNGTNAE2D0G7EKZXHH8SMCQ5D4IGPK01JFBY2GPIUOUOQ1O2U5G5979DM37UHPSUHO4S8PIM7Z0041EVDV5KN9NTWCBY3RKFNMKQ9PF2D4FE38Y88JW17G6BYBFG45TUODH276HAE7JD6LYKXS";
        }
        if (webLauncherLicense != null) {
            return webLauncherLicense;
        }
        byte[] data = Base64.getDecoder().decode(WEB_LAUNCHER_JX_BROWSER_LICENSE);
        webLauncherLicense = new String(data, StandardCharsets.UTF_8);
        return webLauncherLicense;
    }

    public static Path[] openFiles(BWidget owner, List<String> acceptableExtensions, String description, boolean multiple, Context cx) {
        BFileChooser chooser = BFileChooser.makeOpen((BWidget)owner);
        BIWbWebFileChooserExtSupport extSupport = BIWbWebFileChooserExtSupport.makeFor(acceptableExtensions);
        if (extSupport != null) {
            BOrd defaultDirectory;
            String filterDescription = extSupport.getFilterDescription(cx);
            if (filterDescription != null) {
                description = filterDescription;
            }
            if ((defaultDirectory = extSupport.getDefaultDirectory()) != null) {
                chooser.setCurrentDirectory(defaultDirectory);
            }
        }
        chooser.addFilter((IFileFilter)new ExtFileFilter(description, String.join((CharSequence)",", acceptableExtensions)));
        return (Path[])Arrays.stream(chooser.show(multiple)).filter(Objects::nonNull).filter(ord -> !ord.isNull()).map(ord -> (BIFile)ord.get()).map(bfile -> BFileSystem.INSTANCE.pathToLocalFile(bfile.getFilePath())).filter(File::exists).map(File::toPath).toArray(Path[]::new);
    }

    public static synchronized Path getCrashDirectory() {
        try {
            Path crashReports;
            String customCrashDirectory = AccessController.doPrivileged(() -> System.getProperty("jxbrowser.crash.dump.dir"));
            if (customCrashDirectory != null) {
                crashReports = Paths.get(customCrashDirectory, new String[0]);
            } else {
                if (OperatingSystemEnum.isOS((OperatingSystemEnum)OperatingSystemEnum.linux)) {
                    String userHome = AccessController.doPrivileged(() -> System.getProperty("user.home"));
                    Path path = new File(userHome).toPath();
                    return path.resolve(".config/jxbrowser/7.42.4/crash-reports/");
                }
                crashReports = Environment.defaultChromiumDir().resolve("CrashReports");
            }
            return crashReports.resolve("reports");
        }
        catch (Exception e) {
            BJxWebBrowserImpl.log.log(Level.SEVERE, "Problem getting Crash Directory", e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized String getCrashSummary() {
        Path reports = WbJxBrowserUtil.getCrashDirectory();
        if (reports == null) return "Unknown";
        try (Stream<Path> walk = Files.walk(reports, new FileVisitOption[0]);){
            String string = "" + walk.filter(p -> !Files.isDirectory(p, new LinkOption[0])).map(p -> p.toString().toLowerCase()).filter(f -> f.endsWith("dmp")).count();
            return string;
        }
        catch (Exception e) {
            BJxWebBrowserImpl.log.log(Level.SEVERE, "Problem collecting Crash files", e);
        }
        return "Unknown";
    }

    public static long getDefaultTimeout() {
        try {
            return Navigation.defaultTimeout().getSeconds();
        }
        catch (Throwable throwable) {
            if (BWebWidget.IS_WEB_LAUNCHER) {
                try {
                    Method defaultTimeoutMethod = Navigation.class.getMethod("defaultTimeoutInSeconds", new Class[0]);
                    Duration duration = (Duration)defaultTimeoutMethod.invoke(null, new Object[0]);
                    return duration.getSeconds();
                }
                catch (Throwable t) {
                    BJxWebBrowserImpl.log.log(Level.SEVERE, "Problem getting default timeout via JxBrowser 7.30.2 api", t);
                }
            }
            return 45000L;
        }
    }

    static {
        WEB_LAUNCHER_JX_BROWSER_LICENSE = AccessController.doPrivileged(() -> System.getProperty("niagara.jxbrowser.licenseKey"));
    }
}

