/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.jx.browser;

import com.teamdev.jxbrowser.browser.Browser;
import com.teamdev.jxbrowser.browser.callback.SavePasswordCallback;
import com.teamdev.jxbrowser.browser.callback.UpdatePasswordCallback;
import com.teamdev.jxbrowser.callback.Callback;
import com.teamdev.jxbrowser.engine.EngineOptions;
import com.teamdev.jxbrowser.net.HttpHeader;
import com.teamdev.jxbrowser.net.HttpStatus;
import com.teamdev.jxbrowser.net.Network;
import com.teamdev.jxbrowser.net.UrlRequestJob;
import com.teamdev.jxbrowser.net.callback.InterceptUrlRequestCallback;
import com.teamdev.jxbrowser.net.callback.ReceiveHeadersCallback;
import java.io.IOException;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class JxBrowserUtil {
    public static final String WORKBENCH_HOST = "https://workbench";
    private static final String NUMBER_REGEX = "\\d+";
    private static final Pattern NUMBER_PATTERN = Pattern.compile("\\d+");
    private static final Logger log = Logger.getLogger("webBrowser");
    static final boolean ENABLE_HSTS = AccessController.doPrivileged(() -> System.getProperty("niagara.jxbrowser.enableHsts", "true")).equals("true");
    static final String REMOTE_DEBUGGING_HOST = "127.0.0.1";
    static int REMOTE_DEBUGGING_PORT = AccessController.doPrivileged(() -> Integer.getInteger("niagara.jxbrowser.remoteDebuggingPort", 9223));
    static boolean lookedForDynamicPort = false;
    static final boolean DYNAMIC_DEBUG_PORT = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.jxbrowser.dynamicDebuggingPort"));

    private JxBrowserUtil() {
    }

    public static InterceptUrlRequestCallback.Response sendContent(byte[] bytes, String mimeType, InterceptUrlRequestCallback.Params params) {
        UrlRequestJob job = params.newUrlRequestJob(UrlRequestJob.Options.newBuilder((HttpStatus)HttpStatus.OK).addHttpHeader(HttpHeader.of((String)"Content-Type", (String)mimeType)).build());
        job.write(bytes);
        job.complete();
        return InterceptUrlRequestCallback.Response.intercept((UrlRequestJob)job);
    }

    public static InterceptUrlRequestCallback.Response sendHtml(String content, InterceptUrlRequestCallback.Params params) {
        return JxBrowserUtil.sendContent(content.getBytes(StandardCharsets.UTF_8), "text/html", params);
    }

    public static InterceptUrlRequestCallback.Response sendStatus(HttpStatus status, InterceptUrlRequestCallback.Params params) {
        UrlRequestJob job = params.newUrlRequestJob(UrlRequestJob.Options.newBuilder((HttpStatus)status).build());
        job.complete();
        return InterceptUrlRequestCallback.Response.intercept((UrlRequestJob)job);
    }

    public static boolean isEmptyLocation(String location) {
        return location == null || location.isEmpty() || "about:blank".equals(location) || location.startsWith(WORKBENCH_HOST);
    }

    public static void configureStoredPasswordSupport(Browser browser) {
        browser.profile().passwordStore().clear();
        browser.set(SavePasswordCallback.class, (Callback)((SavePasswordCallback)(params, tell) -> tell.neverSave()));
        browser.set(UpdatePasswordCallback.class, (Callback)((UpdatePasswordCallback)(params, tell) -> tell.ignore()));
    }

    public static void registerReceiveHeadersCallback(Network network) {
        if (ENABLE_HSTS) {
            return;
        }
        network.set(ReceiveHeadersCallback.class, (Callback)((ReceiveHeadersCallback)params -> {
            List<HttpHeader> httpHeaders = JxBrowserUtil.getOverriddenHeaders(params.httpHeaders());
            if (httpHeaders == null) {
                return ReceiveHeadersCallback.Response.proceed();
            }
            return ReceiveHeadersCallback.Response.override(httpHeaders);
        }));
    }

    public static List<HttpHeader> getOverriddenHeaders(List<HttpHeader> httpHeaderList) {
        try {
            boolean strictTransportAlteration = false;
            ArrayList<HttpHeader> httpHeaders = new ArrayList<HttpHeader>();
            for (HttpHeader httpHeader : httpHeaderList) {
                if (!httpHeader.name().equalsIgnoreCase("Strict-Transport-Security")) {
                    httpHeaders.add(httpHeader);
                    continue;
                }
                long existingMaxAge = 0L;
                Matcher m = NUMBER_PATTERN.matcher(httpHeader.value());
                if (m.find()) {
                    existingMaxAge = Long.parseLong(m.group());
                }
                if (existingMaxAge == 0L) continue;
                long newMaxAge = 0L;
                String newValue = httpHeader.value().replaceFirst(NUMBER_REGEX, String.valueOf(newMaxAge));
                httpHeaders.add(HttpHeader.of((String)"Strict-Transport-Security", (String)newValue));
                strictTransportAlteration = true;
            }
            if (strictTransportAlteration) {
                return httpHeaders;
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Problem with attempting to override received HttpHeaders", e);
        }
        return null;
    }

    static void enableDebug(EngineOptions.Builder engineOptionsBuilder) {
        if (DYNAMIC_DEBUG_PORT) {
            JxBrowserUtil.findDynamicDebugPort();
        }
        engineOptionsBuilder.remoteDebuggingPort(REMOTE_DEBUGGING_PORT);
        engineOptionsBuilder.addSwitch("--remote-allow-origins=http://127.0.0.1:" + REMOTE_DEBUGGING_PORT);
    }

    static String getRemoteDebuggingUrl(Browser jx) {
        String url = AccessController.doPrivileged(() -> jx.devTools().remoteDebuggingUrl().orElse(""));
        return url.replace("localhost", REMOTE_DEBUGGING_HOST);
    }

    static synchronized void findDynamicDebugPort() {
        if (lookedForDynamicPort) {
            return;
        }
        lookedForDynamicPort = true;
        for (int i = 0; i < 30; ++i) {
            int port = REMOTE_DEBUGGING_PORT + i;
            if (!JxBrowserUtil.available(port)) continue;
            REMOTE_DEBUGGING_PORT = port;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean available(int port) {
        Socket s = null;
        try {
            s = new Socket(REMOTE_DEBUGGING_HOST, port);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            boolean bl = true;
            return bl;
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (IOException e) {
                    log.log(Level.WARNING, "Problem with attempting to detect dynamic port for JxBrowser debugger", e);
                }
            }
        }
    }
}

