/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tagdictionary.relation;

import com.tridium.util.CompUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.baja.control.BControlPoint;
import javax.baja.control.ext.BNullProxyExt;
import javax.baja.driver.BDevice;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.BasicRelation;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.Relation;
import javax.baja.tagdictionary.BRelationInfo;

@NiagaraType
public class BParentDeviceRelation
extends BRelationInfo {
    @Generated
    public static final Type TYPE = Sys.loadType(BParentDeviceRelation.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public Optional<Relation> getRelation(Entity entity) {
        BDevice device;
        if (entity instanceof BDevice) {
            BControlPoint[] points = BParentDeviceRelation.getAllDescendantPoints((BDevice)entity);
            if (points.length > 0) {
                return Optional.of(new BasicRelation(this.getRelationId(), (Entity)points[0], true));
            }
        } else if (entity instanceof BControlPoint && (device = BParentDeviceRelation.getParentDevice((BControlPoint)entity)) != null) {
            return Optional.of(new BasicRelation(this.getRelationId(), (Entity)device, false));
        }
        return Optional.empty();
    }

    public void addRelations(Entity entity, Collection<Relation> relations) {
        BDevice device;
        if (entity instanceof BDevice) {
            Id relationId = this.getRelationId();
            for (BControlPoint point : BParentDeviceRelation.getAllDescendantPoints((BDevice)entity)) {
                relations.add((Relation)new BasicRelation(relationId, (Entity)point, true));
            }
        } else if (entity instanceof BControlPoint && (device = BParentDeviceRelation.getParentDevice((BControlPoint)entity)) != null) {
            relations.add((Relation)new BasicRelation(this.getRelationId(), (Entity)device, false));
        }
    }

    static BControlPoint[] getAllDescendantPoints(BDevice device) {
        return (BControlPoint[])CompUtil.getDescendants((BComponent)device, BControlPoint.class);
    }

    static List<BControlPoint> getDescendantPoints(BDevice device, boolean hasNullProxy) {
        BControlPoint[] allPoints = BParentDeviceRelation.getAllDescendantPoints(device);
        ArrayList<BControlPoint> points = new ArrayList<BControlPoint>(allPoints.length);
        for (BControlPoint point : allPoints) {
            if (hasNullProxy != point.getProxyExt() instanceof BNullProxyExt) continue;
            points.add(point);
        }
        return points;
    }

    static BDevice getParentDevice(BControlPoint point) {
        return CompUtil.closestAncestor((BComplex)point.getParent(), BDevice.class).orElse(null);
    }

    static boolean isPoint(Entity entity, boolean hasNullProxy) {
        return entity instanceof BControlPoint && hasNullProxy == ((BControlPoint)entity).getProxyExt() instanceof BNullProxyExt;
    }
}

