/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tagdictionary;

import com.tridium.tagdictionary.util.ExportUtil;
import com.tridium.tagdictionary.util.ImportUtil;
import java.util.ArrayList;
import javax.baja.gx.BColor;
import javax.baja.job.BSimpleJob;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tagdictionary.BTagDictionary;

@NiagaraType
public class BTagDictionaryExportJob
extends BSimpleJob {
    @Generated
    public static final Type TYPE = Sys.loadType(BTagDictionaryExportJob.class);
    private final BOrd fileOrd;
    private final BTagDictionary dict;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BTagDictionaryExportJob() {
        this.fileOrd = BOrd.NULL;
        this.dict = null;
    }

    public BTagDictionaryExportJob(BTagDictionary dictionary, BOrd file) {
        this.fileOrd = file;
        this.dict = dictionary;
    }

    public void run(Context cx) throws Exception {
        this.log().start("tagdictionary", "tagDictionaryExportJob.start", new String[]{this.dict.getName(), this.fileOrd.toString()});
        ArrayList<ImportUtil.ResultInfo> results = ExportUtil.ExportTagDictionary(this.dict, this.fileOrd, cx);
        boolean hasFailed = false;
        for (ImportUtil.ResultInfo result : results) {
            if (result.getForeground().equals((Object)BColor.red)) {
                hasFailed = true;
                this.log().failed(result.getInfo());
                continue;
            }
            this.log().message(result.getInfo());
        }
        if (hasFailed) {
            throw new LocalizableRuntimeException("tagdictionary", "tagDictionaryExortJob.failed");
        }
    }
}

