/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.systemDb;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.systemDb.BSystemDb;
import com.tridium.systemDb.BSystemDbService;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdScheme;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdQueryList;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.BComponentSpace;
import javax.baja.space.BSpace;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(ordScheme="sys")
@NiagaraSingleton
public class BSystemDbScheme
extends BOrdScheme {
    @Generated
    public static final BSystemDbScheme INSTANCE = new BSystemDbScheme();
    @Generated
    public static final Type TYPE = Sys.loadType(BSystemDbScheme.class);
    static final SystemDbQuery QUERY = new SystemDbQuery();

    @Generated
    public Type getType() {
        return TYPE;
    }

    private BSystemDbScheme() {
        super("sys");
    }

    public OrdQuery parse(String queryBody) {
        return QUERY;
    }

    public OrdTarget resolve(OrdTarget base, OrdQuery query) throws SyntaxException, UnresolvedException {
        BSystemDbService service;
        BFacets facets = null;
        BObject baseObj = base.get();
        if (baseObj.isComponent()) {
            if (!baseObj.getType().is(BSystemDb.TYPE) && !(baseObj.asComponent().getSession() instanceof BFoxSession)) {
                facets = BFacets.make((String)"alternateQueryScope", (String)baseObj.asComponent().getNavOrd().toString());
            }
        } else {
            BSpace space = base.getSpace();
            for (OrdTarget baseTarget = base; space == null && baseTarget != null; baseTarget = baseTarget.getBaseOrdTarget()) {
                BINavNode navChild;
                BISession session = BOrd.toSession((BObject)baseTarget.get());
                if (session == null || !((navChild = session.getNavChild("station")) instanceof BComponentSpace)) continue;
                space = navChild.asObject();
                break;
            }
            baseObj = space;
        }
        if (!(service = (BSystemDbService)BOrd.make((String)"service:systemDb:SystemDbService").get(baseObj)).isRunning()) {
            service.lease();
        }
        OrdTarget result = OrdTarget.makeWithFacets((OrdTarget)base, (BObject)service.getSystemDatabase(), (BFacets)facets);
        return result;
    }

    static class SystemDbQuery
    implements OrdQuery {
        SystemDbQuery() {
        }

        public boolean isHost() {
            return false;
        }

        public boolean isSession() {
            return false;
        }

        public void normalize(OrdQueryList list, int index) {
            if (list.isSameScheme(index, index + 1)) {
                list.remove(index);
            }
        }

        public String getScheme() {
            return "sys";
        }

        public String getBody() {
            return "";
        }

        public String toString() {
            return "sys:";
        }
    }
}

