/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nvideo.dvr;

import com.tridium.ndriver.datatypes.BAddress;
import com.tridium.ndriver.util.SfUtil;
import com.tridium.nvideo.BVideoDevice;
import com.tridium.nvideo.BVideoNetwork;
import com.tridium.nvideo.camera.BCameraDeviceExt;
import com.tridium.nvideo.camera.BVideoCamera;
import com.tridium.nvideo.camera.BVideoSourcePreferences;
import com.tridium.nvideo.datatypes.BDvrId;
import com.tridium.nvideo.datatypes.BVideoDeviceId;
import com.tridium.nvideo.display.BDisplayDeviceExt;
import com.tridium.nvideo.display.BNullVideoDisplay;
import com.tridium.nvideo.dvr.BVideoDvrPingMonitor;
import com.tridium.nvideo.recordingServer.BNullVideoRecordingServer;
import com.tridium.videoDriver.BIVideoNetwork;
import com.tridium.videoDriver.camera.BIVideoCameraDeviceExt;
import com.tridium.videoDriver.display.BIVideoDisplayDeviceExt;
import com.tridium.videoDriver.dvr.BIVideoDvr;
import com.tridium.videoDriver.enums.BFoxVideoStreamEnum;
import com.tridium.videoDriver.enums.BVideoAspectRatioEnum;
import com.tridium.videoDriver.enums.BVideoCompressionEnum;
import com.tridium.videoDriver.enums.BVideoFrameRateEnum;
import com.tridium.videoDriver.enums.BVideoResolutionEnum;
import com.tridium.videoDriver.videoStream.BIVideoMultistreamServer;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import com.tridium.videoDriver.videoStream.IVideoDestination;
import javax.baja.driver.ping.BPingMonitor;
import javax.baja.gx.BColor;
import javax.baja.license.LicenseException;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="videoDeviceId", type="BVideoDeviceId", defaultValue="new BDvrId()", facets={@Facet(value="SfUtil.incl(SfUtil.MGR_EDIT)")}, override=true), @NiagaraProperty(name="monitor", type="BPingMonitor", defaultValue="new BVideoDvrPingMonitor()"), @NiagaraProperty(name="address", type="BAddress", defaultValue="new BAddress()"), @NiagaraProperty(name="foxVideoStreamPreferred", type="BFoxVideoStreamEnum", defaultValue="BFoxVideoStreamEnum.inherit", facets={@Facet(value="SfUtil.incl(SfUtil.MGR_EDIT_UNSEEN)")}), @NiagaraProperty(name="multistreamPreferences", type="BVideoSourcePreferences", defaultValue="new BVideoSourcePreferences()"), @NiagaraProperty(name="displays", type="BDisplayDeviceExt", defaultValue="new BDisplayDeviceExt()"), @NiagaraProperty(name="cameras", type="BCameraDeviceExt", defaultValue="new BCameraDeviceExt()")})
public abstract class BVideoDvr
extends BVideoDevice
implements BIVideoDvr,
BIVideoMultistreamServer {
    @Generated
    public static final Property videoDeviceId = BVideoDvr.newProperty((int)0, (BValue)new BDvrId(), (BFacets)SfUtil.incl((String)"ed"));
    @Generated
    public static final Property monitor = BVideoDvr.newProperty((int)0, (BValue)new BVideoDvrPingMonitor(), null);
    @Generated
    public static final Property address = BVideoDvr.newProperty((int)0, (BValue)new BAddress(), null);
    @Generated
    public static final Property foxVideoStreamPreferred = BVideoDvr.newProperty((int)0, (BValue)BFoxVideoStreamEnum.inherit, (BFacets)SfUtil.incl((String)"ed.un"));
    @Generated
    public static final Property multistreamPreferences = BVideoDvr.newProperty((int)0, (BValue)new BVideoSourcePreferences(), null);
    @Generated
    public static final Property displays = BVideoDvr.newProperty((int)0, (BValue)new BDisplayDeviceExt(), null);
    @Generated
    public static final Property cameras = BVideoDvr.newProperty((int)0, (BValue)new BCameraDeviceExt(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BVideoDvr.class);

    @Generated
    public BPingMonitor getMonitor() {
        return (BPingMonitor)this.get(monitor);
    }

    @Generated
    public void setMonitor(BPingMonitor v) {
        this.set(monitor, (BValue)v, null);
    }

    @Generated
    public BAddress getAddress() {
        return (BAddress)this.get(address);
    }

    @Generated
    public void setAddress(BAddress v) {
        this.set(address, (BValue)v, null);
    }

    @Generated
    public BFoxVideoStreamEnum getFoxVideoStreamPreferred() {
        return (BFoxVideoStreamEnum)this.get(foxVideoStreamPreferred);
    }

    @Generated
    public void setFoxVideoStreamPreferred(BFoxVideoStreamEnum v) {
        this.set(foxVideoStreamPreferred, (BValue)v, null);
    }

    @Generated
    public BVideoSourcePreferences getMultistreamPreferences() {
        return (BVideoSourcePreferences)this.get(multistreamPreferences);
    }

    @Generated
    public void setMultistreamPreferences(BVideoSourcePreferences v) {
        this.set(multistreamPreferences, (BValue)v, null);
    }

    @Generated
    public BDisplayDeviceExt getDisplays() {
        return (BDisplayDeviceExt)this.get(displays);
    }

    @Generated
    public void setDisplays(BDisplayDeviceExt v) {
        this.set(displays, (BValue)v, null);
    }

    @Generated
    public BCameraDeviceExt getCameras() {
        return (BCameraDeviceExt)this.get(cameras);
    }

    @Generated
    public void setCameras(BCameraDeviceExt v) {
        this.set(cameras, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public void changed(Property p, Context c) {
        if (p.equals(faultCause)) {
            this.getDisplays().updateStatus();
            this.getCameras().updateStatus();
        }
        super.changed(p, c);
    }

    public final void started() throws Exception {
        try {
            Sys.getLicenseManager().checkFeature("tridium", "videoDriver");
            this.videoDvrStarted();
        }
        catch (LicenseException fnle) {
            this.configFatal(fnle.toString());
        }
        super.started();
    }

    public void videoDvrStarted() throws Exception {
    }

    public Type getVideoDisplayType() {
        return BNullVideoDisplay.TYPE;
    }

    public Type getVideoRecordingServerType() {
        return BNullVideoRecordingServer.TYPE;
    }

    public BIVideoCameraDeviceExt getCameraExt() {
        return this.getCameras();
    }

    public BIVideoDisplayDeviceExt getDisplayExt() {
        return this.getDisplays();
    }

    public String getDvrDescription() {
        BVideoDeviceId deviceId = this.getVideoDeviceId();
        if (deviceId instanceof BDvrId) {
            return ((BDvrId)deviceId).getDescription();
        }
        return this.getDisplayName(null);
    }

    public boolean supportsPlaybackControl() {
        return false;
    }

    public boolean isTimestampPreferred() {
        return this.getMultistreamPreferences().getTimestampPreferred();
    }

    public BRelTime getInterframeTimeout() {
        if (this.isDown()) {
            return BVideoCamera.ONE_SECOND;
        }
        return this.getMultistreamPreferences().getInterframeTimeout();
    }

    public BIVideoNetwork getVideoNetwork() {
        return this.vnetwork();
    }

    protected boolean recurseFoxVideoStreamPreferredToNet() {
        BIVideoNetwork net = this.getVideoNetwork();
        if (net != null && net instanceof BVideoNetwork) {
            if (net instanceof BComponent) {
                ((BComponent)net).lease();
                try {
                    ((BComponent)net).getComponentSpace().sync();
                }
                catch (Exception e) {
                    return false;
                }
            }
            return ((BVideoNetwork)net).getFoxVideoStreamPreferred();
        }
        return false;
    }

    public boolean isFoxVideoStreamPreferred() {
        BFoxVideoStreamEnum foxStreamEnum = this.getMultistreamPreferences().getPreferredVideoStreamFox();
        if (foxStreamEnum == BFoxVideoStreamEnum.inherit) {
            return this.recurseFoxVideoStreamPreferredToNet();
        }
        if (foxStreamEnum == BFoxVideoStreamEnum.no) {
            return false;
        }
        if (foxStreamEnum == BFoxVideoStreamEnum.yes) {
            return true;
        }
        throw new IllegalStateException("Unrecognized foxStreamEnum: " + foxStreamEnum);
    }

    public BFoxVideoStreamEnum getFoxVideoStreamSetting() {
        return this.getMultistreamPreferences().getPreferredVideoStreamFox();
    }

    public BVideoResolutionEnum getPreferredResolution() {
        return this.getMultistreamPreferences().getPreferredResolution();
    }

    public BVideoFrameRateEnum getPreferredFrameRate() {
        return this.getMultistreamPreferences().getPreferredFrameRate();
    }

    public BVideoCompressionEnum getPreferredCompression() {
        return this.getMultistreamPreferences().getPreferredCompression();
    }

    public abstract void streamToDestination(BPlaybackParams var1, IVideoDestination var2);

    public BColor getPreferredBackgroundColor() {
        return this.getMultistreamPreferences().getPreferredBackgroundColor();
    }

    public BVideoAspectRatioEnum getPreferredAspectRatio() {
        return this.getMultistreamPreferences().getPreferredAspectRatio();
    }
}

