/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nvideo.camera;

import com.tridium.driver.util.DrUtil;
import com.tridium.ndriver.discover.BINDiscoveryHost;
import com.tridium.ndriver.discover.BINDiscoveryObject;
import com.tridium.ndriver.discover.BNDiscoveryJob;
import com.tridium.ndriver.discover.BNDiscoveryPreferences;
import com.tridium.nvideo.camera.BCameraFolder;
import com.tridium.videoDriver.BIVideoDeviceSystem;
import com.tridium.videoDriver.camera.BIVideoCamera;
import com.tridium.videoDriver.camera.BIVideoCameraDeviceExt;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceExt;
import javax.baja.driver.BIDeviceFolder;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;

@NiagaraType
@NiagaraProperty(name="discoveryPreferences", type="BNDiscoveryPreferences", defaultValue="new BNDiscoveryPreferences()")
@NiagaraAction(name="submitDiscoveryJob", parameterType="BNDiscoveryPreferences", defaultValue="new BNDiscoveryPreferences()", returnType="BOrd", flags=4)
public class BCameraDeviceExt
extends BDeviceExt
implements BIVideoCameraDeviceExt,
BIDeviceFolder,
BINDiscoveryHost {
    @Generated
    public static final Property discoveryPreferences = BCameraDeviceExt.newProperty((int)0, (BValue)new BNDiscoveryPreferences(), null);
    @Generated
    public static final Action submitDiscoveryJob = BCameraDeviceExt.newAction((int)4, (BValue)new BNDiscoveryPreferences(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BCameraDeviceExt.class);
    private static final BIcon icon = BIcon.make((String)"module://videoDriver/icons/cameraExt.png");

    @Generated
    public BNDiscoveryPreferences getDiscoveryPreferences() {
        return (BNDiscoveryPreferences)this.get(discoveryPreferences);
    }

    @Generated
    public void setDiscoveryPreferences(BNDiscoveryPreferences v) {
        this.set(discoveryPreferences, (BValue)v, null);
    }

    @Generated
    public BOrd submitDiscoveryJob(BNDiscoveryPreferences parameter) {
        return (BOrd)this.invoke(submitDiscoveryJob, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BIVideoDeviceSystem getVideoSystem() {
        return (BIVideoDeviceSystem)this.getDevice();
    }

    protected Type getCameraFolderType() {
        return BCameraFolder.TYPE;
    }

    protected Type getCameraType() {
        return this.getVideoSystem().getVideoCameraType();
    }

    public BIVideoCamera[] getAllCameras() {
        return (BIVideoCamera[])DrUtil.getDecendantsByClass((BComponent)this, BIVideoCamera.class);
    }

    protected void mergeDvrStatusToCamera(BDevice camera) {
        BIVideoDeviceSystem videoSystem = this.getVideoSystem();
        BDevice dvr = null;
        if (videoSystem instanceof BDevice) {
            dvr = (BDevice)videoSystem;
        }
        int oldCameraStatus = camera.getStatus().getBits();
        int newCameraStatus = camera.getStatus().getBits();
        newCameraStatus = !camera.getEnabled() || dvr.isDisabled() ? (newCameraStatus |= 1) : (newCameraStatus &= 0xFFFFFFFE);
        newCameraStatus = camera.getHealth().getDown() || dvr.isDown() ? (newCameraStatus |= 4) : (newCameraStatus &= 0xFFFFFFFB);
        if (camera.isFatalFault() || camera.isFault() || dvr.isFault() || dvr.isFatalFault()) {
            newCameraStatus |= 2;
            String cameraFaultCause = camera.getFaultCause();
            String dvrFaultCause = dvr.getFaultCause();
            if (cameraFaultCause.trim().length() == 0 && dvrFaultCause.trim().length() > 0) {
                camera.setFaultCause(dvrFaultCause);
            }
        } else {
            camera.setFaultCause("");
            newCameraStatus &= 0xFFFFFFFD;
        }
        if (oldCameraStatus == newCameraStatus) {
            return;
        }
        camera.setStatus(BStatus.make((int)newCameraStatus));
    }

    public void updateStatus() {
        BIVideoCamera[] cameras = this.getAllCameras();
        for (int i = 0; i < cameras.length; ++i) {
            if (!(cameras[i] instanceof BDevice)) continue;
            ((BDevice)cameras[i]).updateStatus();
            this.mergeDvrStatusToCamera((BDevice)cameras[i]);
        }
    }

    public Type getDeviceType() {
        return this.getCameraType();
    }

    public final Type getDeviceFolderType() {
        return this.getCameraFolderType();
    }

    public BFolder getDiscoveryFolder() {
        return null;
    }

    public boolean isDisabled() {
        return this.getDevice().isDisabled();
    }

    public boolean isFault() {
        return this.getDevice().isFault();
    }

    public BOrd doSubmitDiscoveryJob(BNDiscoveryPreferences preferences) {
        this.setDiscoveryPreferences((BNDiscoveryPreferences)preferences.newCopy());
        BNDiscoveryJob discoveryJob = new BNDiscoveryJob((BINDiscoveryHost)this);
        discoveryJob.setDiscoveryPreferences((BNDiscoveryPreferences)preferences.newCopy());
        return discoveryJob.submit(null);
    }

    public BINDiscoveryObject[] getDiscoveryObjects(BNDiscoveryPreferences prefs) throws Exception {
        throw new BajaRuntimeException("Not Implemented");
    }

    public BIcon getIcon() {
        return icon;
    }
}

