/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platEdgeIo;

import com.tridium.nre.platform.OperatingSystemEnum;
import com.tridium.nre.platform.PlatformUtil;
import com.tridium.platEdgeIo.BEdgeIoPlatformService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.logging.Level;
import javax.baja.io.BajaIOException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BajaException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BEdgeIoPlatformServiceQnx
extends BEdgeIoPlatformService {
    @Generated
    public static final Type TYPE = Sys.loadType(BEdgeIoPlatformServiceQnx.class);
    private static final String POINT_DESCRIPTORS = "/sys/images/io/pntDscr";
    private static final String DEV_EDGE_IO = "/dev/edgeIo";
    private static final String IO_DEFAULTS = Sys.getProtectedStationHome() + "/export/ioDefaults";
    private static final String IO_DEFAULTS_DEFAULT = "/sys/images/io/ioDefaults";
    private FileInputStream in;
    private FileOutputStream out;
    private static final String DEV_ACE = "/dev/ace";
    private static final String ACE_ENABLE = Sys.getProtectedStationHome() + "/ace/enableAce";
    private static final String DEV_NULL = "/dev/null";

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public boolean isValidPlatform() {
        return PlatformUtil.isTridiumPlatform() && OperatingSystemEnum.isOS((OperatingSystemEnum)OperatingSystemEnum.qnx) && new File(DEV_EDGE_IO).exists();
    }

    @Override
    public void driverInit() throws Exception {
        File driver = new File(DEV_EDGE_IO);
        if (driver == null) {
            throw new BajaException("Could not access /dev/edgeIo");
        }
        try {
            AccessController.doPrivileged(() -> {
                if (!driver.exists()) {
                    ProcessBuilder builder = new ProcessBuilder("/proc/boot/edgeGpiod");
                    File nullFile = new File(DEV_NULL);
                    if (!nullFile.exists()) {
                        throw new Exception("Failed to redirect ace output as DEV_NULL does not exist");
                    }
                    builder.redirectErrorStream(true);
                    builder.redirectOutput(nullFile);
                    builder.start();
                }
                int cnt = 5;
                while (!driver.exists() && cnt-- > 0) {
                    try {
                        Thread.sleep(400L);
                    }
                    catch (Exception exception) {}
                }
                this.in = new FileInputStream(driver);
                this.out = new FileOutputStream(driver);
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            log.log(Level.SEVERE, "driverInit() failed");
            throw new BajaException("driverInit() failed - ", (Throwable)e);
        }
    }

    @Override
    public void write(byte[] netBytes, int msgLen) throws Exception {
        this.out.write(netBytes, 0, msgLen);
    }

    @Override
    public int read(byte[] buf) throws Exception {
        return this.in.read(buf);
    }

    @Override
    public void close() throws Exception {
        this.in.close();
        this.out.close();
    }

    @Override
    public byte[] pointDescriptionFileRead() throws Exception {
        byte[] buf;
        int len;
        FileInputStream in = null;
        File pntDscr = new File(POINT_DESCRIPTORS);
        try {
            in = AccessController.doPrivileged(() -> new FileInputStream(pntDscr));
        }
        catch (PrivilegedActionException e) {
            this.pointDescriptionFileError(e.getLocalizedMessage());
        }
        if (in == null) {
            this.pointDescriptionFileError("unable to access file input stream");
        }
        if ((len = in.read(buf = new byte[in.available()])) != buf.length) {
            throw new BajaIOException("Read " + len + " bytes from " + POINT_DESCRIPTORS + " which is different from buffer length " + buf.length);
        }
        in.close();
        return buf;
    }

    private void pointDescriptionFileError(String errMsg) throws BajaException {
        String s = "Could not access /sys/images/io/pntDscr - " + errMsg;
        log.log(Level.SEVERE, s);
        throw new BajaException(s);
    }

    @Override
    public byte[] ioDefaultsFileRead() throws Exception {
        byte[] buf;
        int len;
        FileInputStream in = null;
        try {
            in = AccessController.doPrivileged(() -> {
                File f = new File(IO_DEFAULTS);
                if (!f.exists()) {
                    f = new File(IO_DEFAULTS_DEFAULT);
                }
                return new FileInputStream(f);
            });
        }
        catch (Exception e) {
            this.ioDefaultsFileError(e.getLocalizedMessage());
        }
        if (in == null) {
            this.ioDefaultsFileError("unable to access file input stream");
        }
        if ((len = in.read(buf = new byte[in.available()])) != buf.length) {
            throw new BajaIOException("Read " + len + " bytes from " + IO_DEFAULTS + " which is different from buffer length " + buf.length);
        }
        in.close();
        return buf;
    }

    private void ioDefaultsFileError(String errMsg) throws BajaException {
        String s = "Could not access ioDefaults - " + errMsg;
        log.log(Level.SEVERE, s);
        throw new BajaException(s);
    }

    @Override
    public void ioDefaultsFileWrite(byte[] buf) throws Exception {
        try {
            BEdgeIoPlatformServiceQnx.powerSafeSave((byte[])buf, (String)IO_DEFAULTS);
            log.info("Saved ioDefaults");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Failure to export data to file: " + IO_DEFAULTS, e);
        }
    }

    @Override
    public boolean isAceRunning() throws Exception {
        File ace = new File(DEV_ACE);
        boolean br = AccessController.doPrivileged(() -> {
            if (!ace.exists()) {
                return false;
            }
            File aceEnable = new File(ACE_ENABLE);
            if (aceEnable.exists() && !aceEnable.delete()) {
                log.severe("Failed to delete " + aceEnable);
            }
            return true;
        });
        return br;
    }
}

