/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platNdio;

import com.tridium.platNdio.BNdioPlatformService;
import com.tridium.platNdio.NdioPlatformServiceConstants;
import com.tridium.platNdio.NdioProcessorStatusPage;
import java.io.PrintWriter;
import javax.baja.spy.SpyDir;
import javax.baja.spy.SpyWriter;

public class NdioNetworkStatusPage
extends SpyDir
implements NdioPlatformServiceConstants {
    private BNdioPlatformService service;

    public NdioNetworkStatusPage(BNdioPlatformService service) {
        this.service = service;
        for (int i = 0; i < 8; ++i) {
            this.add("processor" + i, new NdioProcessorStatusPage(service, i));
        }
    }

    public void write(SpyWriter out) throws Exception {
        block10: {
            try {
                if (this.service.isDaemonOk()) {
                    out.startProps();
                    out.trTitle((Object)"network", 2);
                    out.prop((Object)"running", (Object)"true");
                    out.prop((Object)"initTicks", (Object)String.valueOf(this.service.getInitTicks()));
                    out.prop((Object)"heartbeatTicks", (Object)String.valueOf(this.service.getHeartbeatTicks()));
                    out.endProps();
                    out.w((Object)"<ul>");
                    String[] list = this.list();
                    for (int i = 0; i < list.length; ++i) {
                        String title;
                        String name;
                        int ioType = 0;
                        int ioConfigState = 0;
                        try {
                            ioType = this.service.readIoType(i);
                            ioConfigState = this.service.readIoConfigState(i);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (ioType != 0 && ioConfigState != 0 && ioConfigState != 1) {
                            name = list[i];
                            title = this.find(name).getTitle();
                            if (title == null) {
                                title = name;
                            }
                            if (this.service.isProcessorCalibrated(i)) {
                                out.w((Object)"<li>").a(list[i], (Object)title).w((Object)" - <b>ok</b></li>\n");
                                continue;
                            }
                            out.w((Object)"<li>").a(list[i], (Object)title).w((Object)" - <i>not calibrated</i></li>\n");
                            continue;
                        }
                        name = list[i];
                        title = this.find(name).getTitle();
                        if (title == null) {
                            title = name;
                        }
                        out.w((Object)"<li>").w((Object)title).w((Object)" - <i>not found</i></li>\n");
                    }
                    out.w((Object)"</ul>");
                    break block10;
                }
                out.startProps();
                out.trTitle((Object)"network", 2);
                out.prop((Object)"running", (Object)"false");
                out.endProps();
            }
            catch (Exception e) {
                out.endProps();
                out.println("error getting ndio network status:<br>");
                e.printStackTrace((PrintWriter)out);
            }
        }
    }
}

